/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.print;

import edu.mit.irb.irbnamespace.MinutesDocument;
import edu.mit.irb.irbnamespace.PersonDocument;
import edu.mit.irb.irbnamespace.ProtocolDocument;
import edu.mit.irb.irbnamespace.ProtocolSubmissionDocument;
import edu.mit.irb.irbnamespace.ScheduleDocument;
import edu.mit.irb.irbnamespace.SubmissionDetailsDocument;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.print.IrbPrintXmlUtilService;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.irb.actions.submit.ProtocolExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolPersonRolodex;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IrbPrintXmlUtilServiceImpl
implements IrbPrintXmlUtilService {
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private ReviewCommentsService reviewCommentsService;

    @Override
    public void setPersonXml(KcPerson person, PersonDocument.Person personType) {
        personType.setPersonID(person.getPersonId());
        personType.setFullname(person.getFullName());
        personType.setLastName(person.getLastName());
        personType.setFirstname(person.getFirstName());
        personType.setDegree(person.getDegree() != null ? person.getDegree() : null);
        personType.setSalutation(person.getSaluation() != null ? person.getSaluation() : null);
        personType.setEmail(person.getEmailAddress() != null ? person.getEmailAddress() : null);
        personType.setOfficeLocation(person.getOfficeLocation() != null ? person.getOfficeLocation() : null);
        personType.setOfficePhone(person.getOfficePhone() != null ? person.getOfficePhone() : null);
        personType.setDirectoryTitle(person.getDirectoryTitle() != null ? person.getDirectoryTitle() : null);
        personType.setAddressLine1(person.getAddressLine1() != null ? person.getAddressLine1() : null);
        personType.setAddressLine2(person.getAddressLine2() != null ? person.getAddressLine2() : null);
        personType.setAddressLine3(person.getAddressLine3() != null ? person.getAddressLine3() : null);
        personType.setCity(person.getCity() != null ? person.getCity() : null);
        personType.setState(person.getState() != null ? person.getState() : null);
        personType.setCountry(person.getCountryCode() != null ? person.getCountryCode() : null);
        personType.setCountryCode(person.getCountryCode() != null ? person.getCountryCode() : null);
        personType.setPostalCode(person.getPostalCode() != null ? person.getPostalCode() : null);
        personType.setFaxNumber(person.getFaxNumber() != null ? person.getFaxNumber() : null);
        personType.setPagerNumber(person.getPagerNumber() != null ? person.getPagerNumber() : null);
        personType.setMobilePhoneNumber(person.getMobilePhoneNumber() != null ? person.getMobilePhoneNumber() : null);
        personType.setDepartmentOrganization(person.getDirectoryDepartment() != null ? person.getDirectoryDepartment() : null);
    }

    @Override
    public void setPersonRolodexType(ProtocolPerson protocolPerson, PersonDocument.Person personType) {
        if (protocolPerson.getPerson() == null) {
            ProtocolPersonRolodex rolodex = (ProtocolPersonRolodex)this.getBusinessObjectService().findBySinglePrimaryKey(ProtocolPersonRolodex.class, (Object)protocolPerson.getRolodexId());
            this.setPersonXml(rolodex, personType);
        } else {
            KcPerson kcPerson = protocolPerson.getPerson();
            this.setPersonXml(kcPerson, personType);
        }
    }

    @Override
    public void setPersonXml(ProtocolPersonRolodex rolodex, PersonDocument.Person personType) {
        personType.setPersonID(rolodex.getRolodexId().toString());
        String fullName = rolodex.getMiddleName() != null ? rolodex.getLastName() + "," + rolodex.getFirstName() + rolodex.getMiddleName() : rolodex.getLastName() + "," + rolodex.getFirstName();
        personType.setFullname(fullName);
        personType.setLastName(rolodex.getLastName());
        personType.setFirstname(rolodex.getFirstName());
        personType.setEmail(rolodex.getEmailAddress() != null ? rolodex.getEmailAddress() : null);
        personType.setAddressLine1(rolodex.getAddressLine1() != null ? rolodex.getAddressLine1() : null);
        personType.setAddressLine2(rolodex.getAddressLine2() != null ? rolodex.getAddressLine2() : null);
        personType.setAddressLine3(rolodex.getAddressLine3() != null ? rolodex.getAddressLine3() : null);
        personType.setCity(rolodex.getCity() != null ? rolodex.getCity() : null);
        personType.setState(rolodex.getState() != null ? rolodex.getState() : null);
        personType.setCountryCode(rolodex.getCountryCode() != null ? rolodex.getCountryCode() : null);
        personType.setPostalCode(rolodex.getPostalCode() != null ? rolodex.getPostalCode() : null);
        personType.setFaxNumber(rolodex.getFaxNumber() != null ? rolodex.getFaxNumber() : null);
        personType.setMobilePhoneNumber(rolodex.getPhoneNumber() != null ? rolodex.getPhoneNumber() : null);
        personType.setDepartmentOrganization(rolodex.getOrganization() != null ? rolodex.getOrganization() : null);
    }

    @Override
    public void setProtocolSubmissionAction(ProtocolSubmission protocolSubmission, SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail) {
        ProtocolAction protcolAction = this.findProtocolActionForSubmission(protocolSubmission);
        if (protcolAction != null) {
            protcolAction.refreshNonUpdateableReferences();
            SubmissionDetailsDocument.SubmissionDetails.ActionType actionTypeInfo = protocolSubmissionDetail.addNewActionType();
            actionTypeInfo.setActionId(BigInteger.valueOf(protcolAction.getActionId().intValue()));
            if (protcolAction.getProtocolActionTypeCode() != null) {
                actionTypeInfo.setActionTypeCode(new BigInteger(protcolAction.getProtocolActionTypeCode()));
                actionTypeInfo.setActionTypeDescription(protcolAction.getProtocolActionType().getDescription());
            }
            if (protcolAction.getActionDate() != null) {
                actionTypeInfo.setActionDate(this.getDateTimeService().getCalendar((Date)protcolAction.getActionDate()));
            }
            actionTypeInfo.setActionComments(protcolAction.getComments());
        }
    }

    protected ProtocolAction findProtocolActionForSubmission(ProtocolSubmission protocolSubmission) {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("submissionIdFk", protocolSubmission.getSubmissionId());
        List actions = (List)this.getBusinessObjectService().findMatchingOrderBy(ProtocolAction.class, param, "actionId", true);
        return actions.isEmpty() ? null : (ProtocolAction)actions.get(0);
    }

    @Override
    public void setSubmissionCheckListinfo(ProtocolSubmission protocolSubmission, SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail) {
        SubmissionDetailsDocument.SubmissionDetails.SubmissionChecklistInfo submissionChecklistInfo = protocolSubmissionDetail.addNewSubmissionChecklistInfo();
        String formattedCode = new String();
        List<ProtocolExemptStudiesCheckListItem> protocolExemptCheckList = protocolSubmission.getExemptStudiesCheckList();
        for (ProtocolExemptStudiesCheckListItem protocolExemptStudiesCheckListBean : protocolExemptCheckList) {
            SubmissionDetailsDocument.SubmissionDetails.SubmissionChecklistInfo.Checklists checkListItem = submissionChecklistInfo.addNewChecklists();
            checkListItem.setChecklistCode(protocolExemptStudiesCheckListBean.getExemptStudiesCheckListCode());
            checkListItem.setChecklistDescription(protocolExemptStudiesCheckListBean.getExemptStudiesCheckListItem().getDescription());
            formattedCode = formattedCode + "(" + protocolExemptStudiesCheckListBean.getExemptStudiesCheckListCode() + ") ";
        }
        if (formattedCode.length() > 0) {
            submissionChecklistInfo.setChecklistCodesFormatted(formattedCode);
        }
        List<ProtocolExpeditedReviewCheckListItem> vecExpeditedCheckList = protocolSubmission.getExpeditedReviewCheckList();
        for (ProtocolExpeditedReviewCheckListItem protocolReviewTypeCheckListBean : vecExpeditedCheckList) {
            SubmissionDetailsDocument.SubmissionDetails.SubmissionChecklistInfo.Checklists checkListItem = submissionChecklistInfo.addNewChecklists();
            checkListItem.setChecklistCode(protocolReviewTypeCheckListBean.getExpeditedReviewCheckListCode());
            checkListItem.setChecklistDescription(protocolReviewTypeCheckListBean.getExpeditedReviewCheckListItem().getDescription());
            formattedCode = formattedCode + "(" + protocolReviewTypeCheckListBean.getExpeditedReviewCheckListCode() + ") ";
        }
        if (formattedCode.length() > 0) {
            submissionChecklistInfo.setChecklistCodesFormatted(formattedCode);
        }
    }

    @Override
    public void setMinutes(CommitteeSchedule scheduleDetailsBean, ScheduleDocument.Schedule schedule) {
        List vecMinutes = scheduleDetailsBean.getCommitteeScheduleMinutes();
        if (!vecMinutes.isEmpty()) {
            for (CommitteeScheduleMinute minuteEntryInfoBean : vecMinutes) {
                if (minuteEntryInfoBean.getMinuteEntryTypeCode().equals("3") || minuteEntryInfoBean.getPrivateCommentFlag() || !this.reviewCommentsService.getReviewerCommentsView(minuteEntryInfoBean) || minuteEntryInfoBean.getPrivateCommentFlag() || !minuteEntryInfoBean.isFinalFlag()) continue;
                this.addMinute(scheduleDetailsBean, minuteEntryInfoBean, schedule.addNewMinutes());
            }
        }
    }

    protected void addMinute(CommitteeSchedule committeeSchedule, CommitteeScheduleMinute committeeScheduleMinute, MinutesDocument.Minutes minutesType) {
        committeeScheduleMinute.refreshNonUpdateableReferences();
        minutesType.setScheduleId(committeeScheduleMinute.getScheduleIdFk().toString());
        minutesType.setEntryNumber(new BigInteger(String.valueOf(committeeScheduleMinute.getEntryNumber())));
        minutesType.setEntryTypeCode(new BigInteger(String.valueOf(committeeScheduleMinute.getMinuteEntryTypeCode())));
        minutesType.setEntryTypeDesc(committeeScheduleMinute.getMinuteEntryType().getDescription());
        minutesType.setProtocolContingencyCode(committeeScheduleMinute.getProtocolContingencyCode() != null ? committeeScheduleMinute.getProtocolContingencyCode() : null);
        minutesType.setMinuteEntry(committeeScheduleMinute.getMinuteEntry());
        minutesType.setPrivateCommentFlag(committeeScheduleMinute.getPrivateCommentFlag());
        committeeScheduleMinute.refreshReferenceObject("protocol");
        if (committeeScheduleMinute.getProtocol() != null && committeeScheduleMinute.getProtocol().getProtocolNumber() != null) {
            String otherItemDescription = this.getOtherItemDescription(committeeSchedule, committeeScheduleMinute);
            if (otherItemDescription != null) {
                minutesType.setProtocolNumber(otherItemDescription);
            } else {
                minutesType.setProtocolNumber(committeeScheduleMinute.getProtocol().getProtocolNumber());
            }
        }
        minutesType.setEntrySortCode(BigInteger.valueOf(committeeScheduleMinute.getMinuteEntryType().getSortId().intValue()));
    }

    protected String getOtherItemDescription(CommitteeSchedule committeeSchedule, CommitteeScheduleMinute committeeScheduleMinute) {
        List<CommScheduleActItemBase> actionItems = committeeSchedule.getCommScheduleActItems();
        for (CommScheduleActItemBase commScheduleActItem : actionItems) {
            if (!committeeScheduleMinute.getMinuteEntryTypeCode().equals("4") || !committeeScheduleMinute.getProtocol().getProtocolNumber().equals(commScheduleActItem.getActionItemNumber())) continue;
            return commScheduleActItem.getItemDescription();
        }
        return committeeScheduleMinute.getProtocol().getProtocolNumber();
    }

    @Override
    public void setProcotolMinutes(CommitteeSchedule committeeSchedule, ProtocolSubmission protocolSubmission, ProtocolSubmissionDocument.ProtocolSubmission protocolSubmissionType) {
        List minutes = committeeSchedule.getCommitteeScheduleMinutes();
        for (CommitteeScheduleMinute minuteEntryInfoBean : minutes) {
            ProtocolBase protocol = minuteEntryInfoBean.getProtocol();
            if (protocol == null || protocol.getProtocolNumber() == null || !protocol.getProtocolNumber().equals(protocolSubmission.getProtocolNumber()) || protocol.getProtocolSubmission() == null || !protocol.getProtocolSubmission().getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber()) || !this.reviewCommentsService.getReviewerCommentsView(minuteEntryInfoBean) || minuteEntryInfoBean.getPrivateCommentFlag() || !minuteEntryInfoBean.isFinalFlag()) continue;
            this.addMinute(committeeSchedule, minuteEntryInfoBean, protocolSubmissionType.addNewMinutes());
        }
    }

    @Override
    public void setProcotolSubmissionMinutes(CommitteeSchedule committeeSchedule, ProtocolSubmission protocolSubmission, ProtocolDocument.Protocol.Submissions submissionsType) {
        List minutes = committeeSchedule.getCommitteeScheduleMinutes();
        for (CommitteeScheduleMinute minuteEntryInfoBean : minutes) {
            ProtocolBase protocol = minuteEntryInfoBean.getProtocol();
            if (protocol == null || protocol.getProtocolNumber() == null || !protocol.getProtocolNumber().equals(protocolSubmission.getProtocolNumber()) || protocol.getProtocolSubmission() == null || !protocol.getProtocolSubmission().getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber()) || !this.reviewCommentsService.getReviewerCommentsView(minuteEntryInfoBean)) continue;
            this.addMinute(committeeSchedule, minuteEntryInfoBean, submissionsType.addNewMinutes());
        }
    }

    @Override
    public void setProtocolReviewMinutes(CommitteeSchedule committeeSchedule, ProtocolSubmission protocolSubmission, ProtocolDocument.Protocol.Submissions submissionsType) {
        List minutes = committeeSchedule.getCommitteeScheduleMinutes();
        for (CommitteeScheduleMinute minuteEntryInfoBean : minutes) {
            ProtocolBase protocol = minuteEntryInfoBean.getProtocol();
            if (protocol == null || protocol.getProtocolNumber() == null || !protocol.getProtocolNumber().equals(protocolSubmission.getProtocolNumber()) || protocol.getProtocolSubmission() == null || !protocol.getProtocolSubmission().getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber()) || !this.reviewCommentsService.getReviewerCommentsView(minuteEntryInfoBean)) continue;
            this.addMinute(committeeSchedule, minuteEntryInfoBean, submissionsType.addNewMinutes());
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setReviewCommentsService(ReviewCommentsService reviewCommentsService) {
        this.reviewCommentsService = reviewCommentsService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }
}

