/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.print;

import edu.mit.irb.irbnamespace.InvestigatorDocument;
import edu.mit.irb.irbnamespace.PersonDocument;
import edu.mit.irb.irbnamespace.ProtocolMasterDataDocument;
import edu.mit.irb.irbnamespace.ProtocolReviewerDocument;
import edu.mit.irb.irbnamespace.ProtocolSubmissionDocument;
import edu.mit.irb.irbnamespace.ProtocolSummaryDocument;
import edu.mit.irb.irbnamespace.ScheduleDocument;
import edu.mit.irb.irbnamespace.ScheduleMasterDataDocument;
import edu.mit.irb.irbnamespace.SubmissionDetailsDocument;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.print.IrbPrintXmlUtilService;
import org.kuali.kra.committee.service.CommitteeMembershipService;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.submit.ProtocolExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolPersonRolodex;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.printing.xmlstream.PrintBaseXmlStream;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.service.KcPersonService;

public class ScheduleXmlStream
extends PrintBaseXmlStream {
    private CommitteeMembershipService committeeMembershipService;
    private KcPersonService kcPersonService;
    private IrbPrintXmlUtilService irbPrintXmlUtilService;
    private String EXPEDIT_ACTION_TYPE_CODE = "205";
    private String EXEMPT_ACTION_TYPE_CODE = "206";
    private String FOLLOW_UP_ACTION_CODE = "109";

    @Override
    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        Committee committee = (Committee)printableBusinessObject;
        String scheduleId = (String)reportParameters.get("scheduleId");
        CommitteeSchedule committeeSchedule = this.findCommitteeSchedule(committee, scheduleId);
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        ScheduleDocument scheduleDocument = ScheduleDocument.Factory.newInstance();
        scheduleDocument.setSchedule(this.getSchedule(committeeSchedule));
        xmlObjectList.put("Schedule", (XmlObject)scheduleDocument);
        return xmlObjectList;
    }

    private CommitteeSchedule findCommitteeSchedule(Committee committee, String scheduleId) {
        List committeeSchedules = committee.getCommitteeSchedules();
        for (CommitteeSchedule committeeSchedule : committeeSchedules) {
            if (!committeeSchedule.getScheduleId().equals(scheduleId)) continue;
            return committeeSchedule;
        }
        return null;
    }

    public ScheduleDocument.Schedule getSchedule(CommitteeSchedule committeeSchedule) {
        ScheduleDocument.Schedule schedule = ScheduleDocument.Schedule.Factory.newInstance();
        this.setScheduleMasterData(committeeSchedule, schedule.addNewScheduleMasterData());
        ScheduleDocument.Schedule.PreviousSchedule prevSchedule = schedule.addNewPreviousSchedule();
        this.setPreviousSchedule(committeeSchedule, prevSchedule.addNewScheduleMasterData());
        ScheduleDocument.Schedule.NextSchedule nextScheduleType = schedule.addNewNextSchedule();
        this.setNextSchedule(committeeSchedule, nextScheduleType.addNewScheduleMasterData());
        this.getIrbPrintXmlUtilService().setMinutes(committeeSchedule, schedule);
        this.setAttendance(committeeSchedule, schedule);
        committeeSchedule.refreshReferenceObject("protocolSubmissions");
        List submissions = committeeSchedule.getLatestProtocolSubmissions();
        for (ProtocolSubmission protocolSubmission : submissions) {
            ProtocolSubmissionDocument.ProtocolSubmission protocolSubmissionType = schedule.addNewProtocolSubmission();
            SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail = protocolSubmissionType.addNewSubmissionDetails();
            ProtocolSummaryDocument.ProtocolSummary protocolSummary = protocolSubmissionType.addNewProtocolSummary();
            ProtocolMasterDataDocument.ProtocolMasterData protocolMaster = protocolSummary.addNewProtocolMasterData();
            String followUpAction = null;
            String actionTypeCode = null;
            Protocol protocol = (Protocol)protocolSubmission.getProtocol();
            String submissionStatus = protocol.getProtocolSubmission().getSubmissionStatusCode();
            List<ProtocolActionBase> protocolActions = protocolSubmission.getProtocol().getProtocolActions();
            for (ProtocolActionBase protocolAction : protocolActions) {
                actionTypeCode = protocolAction.getProtocolActionTypeCode();
                if (!actionTypeCode.equals(this.EXPEDIT_ACTION_TYPE_CODE) && !actionTypeCode.equals(this.EXEMPT_ACTION_TYPE_CODE)) continue;
                if (protocolAction.getFollowupActionCode() == null || !protocolAction.getFollowupActionCode().equals(this.FOLLOW_UP_ACTION_CODE)) break;
                followUpAction = protocolAction.getFollowupActionCode();
                break;
            }
            if ((actionTypeCode.equals(this.EXPEDIT_ACTION_TYPE_CODE) || actionTypeCode.equals(this.EXEMPT_ACTION_TYPE_CODE)) && followUpAction == null) continue;
            protocolMaster.setProtocolNumber(protocol.getProtocolNumber());
            protocolMaster.setSequenceNumber(new BigInteger(String.valueOf(protocol.getSequenceNumber())));
            protocolMaster.setProtocolTitle(protocol.getTitle());
            protocolMaster.setProtocolStatusCode(new BigInteger(String.valueOf(protocol.getProtocolStatusCode())));
            protocolMaster.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
            protocolMaster.setProtocolTypeCode(new BigInteger(String.valueOf(protocol.getProtocolTypeCode())));
            protocolMaster.setProtocolTypeDesc(protocol.getProtocolType().getDescription());
            if (protocol.getDescription() != null) {
                protocolMaster.setProtocolDescription(protocol.getDescription());
            }
            if (protocol.getApprovalDate() != null) {
                protocolMaster.setApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getApprovalDate()));
            }
            if (protocol.getExpirationDate() != null) {
                protocolMaster.setExpirationDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getExpirationDate()));
            }
            if (protocol.getFdaApplicationNumber() != null) {
                protocolMaster.setFdaApplicationNumber(protocol.getFdaApplicationNumber());
            }
            if (protocol.getReferenceNumber1() != null) {
                protocolMaster.setRefNumber1(protocol.getReferenceNumber1());
            }
            if (protocol.getReferenceNumber2() != null) {
                protocolMaster.setRefNumber2(protocol.getReferenceNumber2());
            }
            protocolSubmissionDetail.setProtocolNumber(protocolSubmission.getProtocolNumber());
            if (protocolSubmission.getProtocolSubmissionType() != null) {
                protocolSubmissionDetail.setSubmissionTypeDesc(protocolSubmission.getProtocolSubmissionType().getDescription());
            }
            if (protocolSubmission.getProtocolReviewTypeCode() != null) {
                protocolSubmissionDetail.setProtocolReviewTypeCode(new BigInteger(protocolSubmission.getProtocolReviewTypeCode()));
            }
            if (protocolSubmission.getProtocolReviewType() != null) {
                protocolSubmissionDetail.setProtocolReviewTypeDesc(protocolSubmission.getProtocolReviewType().getDescription());
            }
            if (protocolSubmission.getSubmissionTypeCode() != null) {
                protocolSubmissionDetail.setSubmissionTypeCode(new BigInteger(String.valueOf(protocolSubmission.getSubmissionTypeCode())));
            }
            if (protocolSubmission.getProtocolSubmissionType() != null) {
                protocolSubmissionDetail.setSubmissionTypeDesc(protocolSubmission.getProtocolSubmissionType().getDescription());
            }
            if (protocolSubmission.getSubmissionNumber() != null) {
                protocolSubmissionDetail.setSubmissionNumber(new BigInteger(String.valueOf(protocolSubmission.getSubmissionNumber())));
            }
            if (protocolSubmission.getSubmissionStatusCode() != null) {
                protocolSubmissionDetail.setSubmissionStatusCode(new BigInteger(String.valueOf(protocolSubmission.getSubmissionStatusCode())));
            }
            if (protocolSubmission.getSubmissionStatus() != null) {
                protocolSubmissionDetail.setSubmissionStatusDesc(protocolSubmission.getSubmissionStatus().getDescription());
            }
            if (protocolSubmission.getSubmissionTypeQualifierCode() != null) {
                protocolSubmissionDetail.setSubmissionTypeQualifierCode(new BigInteger(protocolSubmission.getSubmissionTypeQualifierCode()));
            }
            if (protocolSubmission.getProtocolSubmissionQualifierType() != null) {
                protocolSubmissionDetail.setSubmissionTypeQualifierDesc(protocolSubmission.getProtocolSubmissionQualifierType().getDescription());
            }
            if (protocolSubmission.getYesVoteCount() != null) {
                protocolSubmissionDetail.setYesVote(BigInteger.valueOf(protocolSubmission.getYesVoteCount().intValue()));
            } else {
                protocolSubmissionDetail.setYesVote(BigInteger.ZERO);
            }
            if (protocolSubmission.getNoVoteCount() != null) {
                protocolSubmissionDetail.setNoVote(BigInteger.valueOf(protocolSubmission.getNoVoteCount().intValue()));
            } else {
                protocolSubmissionDetail.setNoVote(BigInteger.ZERO);
            }
            if (protocolSubmission.getAbstainerCount() != null) {
                protocolSubmissionDetail.setAbstainerCount(BigInteger.valueOf(protocolSubmission.getAbstainerCount().intValue()));
            } else {
                protocolSubmissionDetail.setAbstainerCount(BigInteger.ZERO);
            }
            protocolSubmissionDetail.setVotingComments(protocolSubmission.getVotingComments());
            this.setProtocolSubmissionAction(protocolSubmission, protocolSubmissionDetail);
            if (protocolSubmission.getSubmissionDate() != null) {
                protocolSubmissionDetail.setSubmissionDate(this.getDateTimeService().getCalendar((java.util.Date)protocolSubmission.getSubmissionDate()));
            }
            this.setSubmissionCheckListinfo(protocolSubmission, protocolSubmissionDetail);
            this.setProtocolSubmissionReviewers(protocolSubmission, protocolSubmissionDetail);
            List<ProtocolPersonBase> protocolPersons = protocolSubmission.getProtocol().getProtocolPersons();
            for (ProtocolPersonBase protocolPerson : protocolPersons) {
                if (!protocolPerson.getProtocolPersonRoleId().equals("PI") && !protocolPerson.getProtocolPersonRoleId().equals("COI")) continue;
                InvestigatorDocument.Investigator investigator = protocolSummary.addNewInvestigator();
                this.getIrbPrintXmlUtilService().setPersonRolodexType((ProtocolPerson)protocolPerson, investigator.addNewPerson());
                if (!protocolPerson.getProtocolPersonRoleId().equals("PI")) continue;
                investigator.setPIFlag(true);
            }
            List<ProtocolRiskLevel> cvRiskLevels = protocol.getProtocolRiskLevels();
            for (ProtocolRiskLevel protocolRiskLevelBean : cvRiskLevels) {
                ProtocolSummaryDocument.ProtocolSummary.RiskLevels riskLevelType = protocolSummary.addNewRiskLevels();
                riskLevelType.setRiskLevelDescription(protocolRiskLevelBean.getRiskLevel().getDescription());
                riskLevelType.setComments(protocolRiskLevelBean.getComments());
            }
            List<ProtocolFundingSourceBase> vecFundingSource = protocol.getProtocolFundingSources();
            for (ProtocolFundingSource protocolFundingSource : vecFundingSource) {
                protocolFundingSource.refreshNonUpdateableReferences();
                ProtocolSummaryDocument.ProtocolSummary.FundingSource fundingSource = protocolSummary.addNewFundingSource();
                String fundingSourceCode = protocolFundingSource.getFundingSourceNumber();
                int fundingSourceTypeCode = Integer.valueOf(protocolFundingSource.getFundingSourceTypeCode());
                String fundingSourceName = this.getFundingSourceNameForType(fundingSourceTypeCode, fundingSourceCode);
                fundingSource.setFundingSourceName(fundingSourceName);
                if (protocolFundingSource.getFundingSourceType() == null) continue;
                fundingSource.setTypeOfFundingSource(protocolFundingSource.getFundingSourceType().getDescription());
            }
            this.getIrbPrintXmlUtilService().setProcotolMinutes(committeeSchedule, protocolSubmission, protocolSubmissionType);
        }
        this.setOtherActionItems(committeeSchedule, schedule);
        return schedule;
    }

    private void setProtocolSubmissionAction(ProtocolSubmission protocolSubmission, SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail) {
        ProtocolAction protcolAction = this.findProtocolActionForSubmission(protocolSubmission);
        if (protcolAction != null) {
            protcolAction.refreshNonUpdateableReferences();
            SubmissionDetailsDocument.SubmissionDetails.ActionType actionTypeInfo = protocolSubmissionDetail.addNewActionType();
            actionTypeInfo.setActionId(BigInteger.valueOf(protcolAction.getActionId().intValue()));
            if (protcolAction.getProtocolActionTypeCode() != null) {
                actionTypeInfo.setActionTypeCode(new BigInteger(protcolAction.getProtocolActionTypeCode()));
                actionTypeInfo.setActionTypeDescription(protcolAction.getProtocolActionType().getDescription());
            }
            if (protcolAction.getActionDate() != null) {
                actionTypeInfo.setActionDate(this.getDateTimeService().getCalendar((java.util.Date)protcolAction.getActionDate()));
            }
            actionTypeInfo.setActionComments(protcolAction.getComments());
        }
    }

    private void setOtherActionItems(CommitteeSchedule committeeSchedule, ScheduleDocument.Schedule schedule) {
        List<CommScheduleActItemBase> otherActions = committeeSchedule.getCommScheduleActItems();
        for (CommScheduleActItemBase otherActionInfoBean : otherActions) {
            otherActionInfoBean.refreshNonUpdateableReferences();
            ScheduleDocument.Schedule.OtherBusiness otherBusinessType = schedule.addNewOtherBusiness();
            otherBusinessType.setActionItemNumber(BigInteger.valueOf(otherActionInfoBean.getActionItemNumber().intValue()));
            otherBusinessType.setActionItemDesc(otherActionInfoBean.getItemDescription());
            if (otherActionInfoBean.getScheduleActItemType() == null) continue;
            otherBusinessType.setActionItemCode(new BigInteger(otherActionInfoBean.getScheduleActItemTypeCode()));
            otherBusinessType.setActionItemCodeDesc(otherActionInfoBean.getScheduleActItemType().getDescription());
        }
    }

    private String getFundingSourceNameForType(int sourceType, String sourceCode) {
        String name = null;
        if (sourceType == 1) {
            Sponsor sponsor = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)sourceCode);
            if (sponsor != null) {
                name = sponsor.getSponsorName();
            }
        } else if (sourceType == 2) {
            Unit unit = (Unit)this.getBusinessObjectService().findBySinglePrimaryKey(Unit.class, (Object)sourceCode);
            if (unit != null) {
                name = unit.getUnitName();
            }
        } else {
            name = sourceCode;
        }
        return name;
    }

    private void setProtocolSubmissionReviewers(ProtocolSubmission protocolSubmission, SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail) {
        List<ProtocolReviewer> vecReviewers = protocolSubmission.getProtocolReviewers();
        for (ProtocolReviewer protocolReviewer : vecReviewers) {
            protocolReviewer.refreshNonUpdateableReferences();
            ProtocolReviewerDocument.ProtocolReviewer protocolReviewerType = protocolSubmissionDetail.addNewProtocolReviewer();
            this.setPerson((org.kuali.kra.irb.actions.submit.ProtocolReviewer)protocolReviewer, protocolReviewerType);
            protocolReviewerType.setReviewerTypeDesc(protocolReviewer.getProtocolReviewerType().getDescription());
            protocolReviewerType.setReviewerTypeCode(new BigInteger(String.valueOf(protocolReviewer.getReviewerTypeCode())));
        }
    }

    private void setPerson(org.kuali.kra.irb.actions.submit.ProtocolReviewer protocolReviewer, ProtocolReviewerDocument.ProtocolReviewer protocolReviewerType) {
        PersonDocument.Person personType = protocolReviewerType.addNewPerson();
        boolean nonEmployeeFlag = protocolReviewer.getNonEmployeeFlag();
        if (!nonEmployeeFlag) {
            String personId = protocolReviewer.getPersonId();
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(personId);
            this.getIrbPrintXmlUtilService().setPersonXml(person, personType);
        } else {
            Rolodex rolodex = protocolReviewer.getRolodex();
            ProtocolPersonRolodex protocolRolodex = (ProtocolPersonRolodex)this.getBusinessObjectService().findBySinglePrimaryKey(ProtocolPersonRolodex.class, (Object)rolodex.getRolodexId());
            this.getIrbPrintXmlUtilService().setPersonXml(protocolRolodex, personType);
        }
    }

    private void setSubmissionCheckListinfo(ProtocolSubmission protocolSubmission, SubmissionDetailsDocument.SubmissionDetails protocolSubmissionDetail) {
        SubmissionDetailsDocument.SubmissionDetails.SubmissionChecklistInfo submissionChecklistInfo = protocolSubmissionDetail.addNewSubmissionChecklistInfo();
        String formattedCode = new String();
        List<ProtocolExemptStudiesCheckListItem> protocolExemptCheckList = protocolSubmission.getExemptStudiesCheckList();
        for (ProtocolExemptStudiesCheckListItem protocolExemptStudiesCheckListBean : protocolExemptCheckList) {
            SubmissionDetailsDocument.SubmissionDetails.SubmissionChecklistInfo.Checklists checkListItem = submissionChecklistInfo.addNewChecklists();
            checkListItem.setChecklistCode(protocolExemptStudiesCheckListBean.getExemptStudiesCheckListCode());
            checkListItem.setChecklistDescription(protocolExemptStudiesCheckListBean.getExemptStudiesCheckListItem().getDescription());
            formattedCode = formattedCode + "(" + protocolExemptStudiesCheckListBean.getExemptStudiesCheckListCode() + ") ";
        }
        if (formattedCode.length() > 0) {
            submissionChecklistInfo.setChecklistCodesFormatted(formattedCode);
        }
        List<ProtocolExpeditedReviewCheckListItem> vecExpeditedCheckList = protocolSubmission.getExpeditedReviewCheckList();
        for (ProtocolExpeditedReviewCheckListItem protocolReviewTypeCheckListBean : vecExpeditedCheckList) {
            SubmissionDetailsDocument.SubmissionDetails.SubmissionChecklistInfo.Checklists checkListItem = submissionChecklistInfo.addNewChecklists();
            checkListItem.setChecklistCode(protocolReviewTypeCheckListBean.getExpeditedReviewCheckListCode());
            checkListItem.setChecklistDescription(protocolReviewTypeCheckListBean.getExpeditedReviewCheckListItem().getDescription());
            formattedCode = formattedCode + "(" + protocolReviewTypeCheckListBean.getExpeditedReviewCheckListCode() + ") ";
        }
        if (formattedCode.length() > 0) {
            submissionChecklistInfo.setChecklistCodesFormatted(formattedCode);
        }
    }

    private ProtocolAction findProtocolActionForSubmission(ProtocolSubmission protocolSubmission) {
        List<ProtocolActionBase> protocolActions = protocolSubmission.getProtocol().getProtocolActions();
        for (ProtocolActionBase protocolAction : protocolActions) {
            if (protocolAction.getSubmissionNumber() == null || !protocolAction.getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber())) continue;
            return (ProtocolAction)protocolAction;
        }
        return null;
    }

    private void setAttendance(CommitteeSchedule committeeSchedule, ScheduleDocument.Schedule schedule) {
        List<CommitteeScheduleAttendanceBase> attendenceList = committeeSchedule.getCommitteeScheduleAttendances();
        for (CommitteeScheduleAttendanceBase attendanceInfoBean : attendenceList) {
            ScheduleDocument.Schedule.Attendents attendents = schedule.addNewAttendents();
            attendents.setAttendentName(attendanceInfoBean.getPersonName());
            attendents.setAlternateFlag(attendanceInfoBean.getAlternateFlag());
            attendents.setGuestFlag(attendanceInfoBean.getGuestFlag());
            attendents.setAlternateFor(attendanceInfoBean.getAlternateFor());
            attendents.setPresentFlag(true);
        }
        List<CommitteeMembershipBase> committeeMemberships = committeeSchedule.getParentCommittee().getCommitteeMemberships();
        for (CommitteeMembershipBase committeeMembership : committeeMemberships) {
            if (this.getCommitteeMembershipService().isMemberAttendedMeeting(committeeMembership, committeeSchedule.getParentCommittee().getCommitteeId())) continue;
            ScheduleDocument.Schedule.Attendents attendents = schedule.addNewAttendents();
            attendents.setAttendentName(committeeMembership.getPersonName());
            attendents.setAlternateFlag(false);
            attendents.setGuestFlag(false);
            attendents.setPresentFlag(false);
        }
    }

    public ScheduleMasterDataDocument.ScheduleMasterData setScheduleMasterData(CommitteeSchedule scheduleDetailsBean, ScheduleMasterDataDocument.ScheduleMasterData currentSchedule) {
        scheduleDetailsBean.refreshNonUpdateableReferences();
        String committeeId = scheduleDetailsBean.getParentCommittee().getCommitteeId();
        currentSchedule.setScheduleId(scheduleDetailsBean.getScheduleId());
        currentSchedule.setCommitteeId(committeeId);
        currentSchedule.setCommitteeName(scheduleDetailsBean.getParentCommittee().getCommitteeName());
        currentSchedule.setScheduleStatusCode(BigInteger.valueOf(scheduleDetailsBean.getScheduleStatusCode().intValue()));
        currentSchedule.setScheduleStatusDesc(scheduleDetailsBean.getScheduleStatus().getDescription());
        if (scheduleDetailsBean.getScheduledDate() != null) {
            currentSchedule.setScheduledDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getScheduledDate()));
        } else {
            currentSchedule.setScheduledDate(this.getDateTimeService().getCurrentCalendar());
        }
        try {
            if (scheduleDetailsBean.getTime() != null) {
                Date date = this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getTime());
                currentSchedule.setScheduledTime(this.getDateTimeService().getCalendar((java.util.Date)date));
            }
            currentSchedule.setPlace(scheduleDetailsBean.getPlace());
            if (scheduleDetailsBean.getProtocolSubDeadline() != null) {
                currentSchedule.setProtocolSubDeadline(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getProtocolSubDeadline()));
            }
            if (scheduleDetailsBean.getMeetingDate() != null) {
                currentSchedule.setMeetingDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getMeetingDate()));
            }
            if (scheduleDetailsBean.getStartTime() != null) {
                currentSchedule.setStartTime(this.getDateTimeService().getCalendar((java.util.Date)this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getStartTime())));
            }
            if (scheduleDetailsBean.getEndTime() != null) {
                currentSchedule.setEndTime(this.getDateTimeService().getCalendar((java.util.Date)this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getEndTime())));
            }
            if (scheduleDetailsBean.getAgendaProdRevDate() != null) {
                currentSchedule.setAgendaProdRevDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getAgendaProdRevDate()));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        currentSchedule.setMaxProtocols(new BigInteger(String.valueOf(scheduleDetailsBean.getMaxProtocols())));
        if (scheduleDetailsBean.getComments() != null) {
            currentSchedule.setComments(scheduleDetailsBean.getComments());
        }
        return currentSchedule;
    }

    public void setNextSchedule(CommitteeSchedule scheduleDetailsBean, ScheduleMasterDataDocument.ScheduleMasterData scheduleMasterData) {
        CommitteeSchedule nextSchedule = this.getNextOrPreviousSchedule(scheduleDetailsBean, true);
        if (nextSchedule != null) {
            this.setScheduleMasterData(nextSchedule, scheduleMasterData);
        }
    }

    public void setPreviousSchedule(CommitteeSchedule scheduleDetailsBean, ScheduleMasterDataDocument.ScheduleMasterData scheduleMasterDataType) {
        CommitteeSchedule prevSchedule = this.getNextOrPreviousSchedule(scheduleDetailsBean, true);
        if (prevSchedule != null) {
            this.setScheduleMasterData(prevSchedule, scheduleMasterDataType);
        }
    }

    private CommitteeSchedule getNextOrPreviousSchedule(CommitteeSchedule scheduleDetailsBean, boolean nextFlag) {
        HashMap<String, String> scheduleParam = new HashMap<String, String>();
        scheduleParam.put("committeeIdFk", scheduleDetailsBean.getParentCommittee().getId().toString());
        List schedules = (List)this.getBusinessObjectService().findMatchingOrderBy(CommitteeSchedule.class, scheduleParam, "scheduledDate", false);
        if (!schedules.isEmpty()) {
            int size = schedules.size();
            for (int i = 0; i < size; ++i) {
                CommitteeSchedule schedule = (CommitteeSchedule)schedules.get(i);
                if (!schedule.getScheduleId().equals(scheduleDetailsBean.getScheduleId())) continue;
                if (nextFlag && i < size - 1) {
                    return (CommitteeSchedule)schedules.get(i + 1);
                }
                if (!nextFlag && i > 0) {
                    return (CommitteeSchedule)schedules.get(i - 1);
                }
                return null;
            }
        }
        return null;
    }

    public void setCommitteeMembershipService(CommitteeMembershipService committeeMembershipService) {
        this.committeeMembershipService = committeeMembershipService;
    }

    public CommitteeMembershipService getCommitteeMembershipService() {
        return this.committeeMembershipService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public IrbPrintXmlUtilService getIrbPrintXmlUtilService() {
        return this.irbPrintXmlUtilService;
    }

    public void setIrbPrintXmlUtilService(IrbPrintXmlUtilService irbPrintXmlUtilService) {
        this.irbPrintXmlUtilService = irbPrintXmlUtilService;
    }
}

