/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.rules;

import java.sql.Date;
import java.util.List;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.rule.event.CommitteeScheduleDeadlineEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class CommitteeScheduleDeadlineDateRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<CommitteeScheduleDeadlineEvent> {
    public static final String ID = "document.committeeList[0].committeeSchedules[%1$s].protocolSubDeadline";

    @Override
    public boolean processRules(CommitteeScheduleDeadlineEvent deadlineCommitteeScheduleEvent) {
        boolean rulePassed = true;
        List<CommitteeSchedule> committeeSchedules = deadlineCommitteeScheduleEvent.getCommitteeSchedules();
        int count = 0;
        for (CommitteeSchedule committeeSchedule : committeeSchedules) {
            Date deadline = committeeSchedule.getProtocolSubDeadline();
            Date schedule = committeeSchedule.getScheduledDate();
            if (schedule != null && deadline != null && schedule.before(deadline)) {
                this.reportError(String.format(ID, count), "error.committeeSchedule.dealine", deadline.toString(), schedule.toString());
                rulePassed = false;
            }
            ++count;
        }
        return rulePassed;
    }
}

