/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.service.impl;

import java.sql.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.bo.CommitteeBatchCorrespondence;
import org.kuali.kra.committee.bo.CommitteeBatchCorrespondenceDetail;
import org.kuali.kra.committee.service.CommitteeBatchCorrespondenceService;
import org.kuali.kra.committee.service.CommitteePrintingService;
import org.kuali.kra.common.committee.bo.CommitteeBatchCorrespondenceBase;
import org.kuali.kra.common.committee.bo.CommitteeBatchCorrespondenceDetailBase;
import org.kuali.kra.common.committee.service.impl.CommitteeBatchCorrespondenceServiceImplBase;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.irb.actions.notification.BatchCorrespondenceNotificationRenderer;
import org.kuali.kra.irb.correspondence.BatchCorrespondence;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceType;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class CommitteeBatchCorrespondenceServiceImpl
extends CommitteeBatchCorrespondenceServiceImplBase
implements CommitteeBatchCorrespondenceService {
    @Override
    public CommitteeBatchCorrespondenceBase generateBatchCorrespondence(String batchCorrespondenceTypeCode, String committeeId, Date startDate, Date endDate) throws Exception {
        String protocolActionTypeCode;
        BatchCorrespondence batchCorrespondence = null;
        List<Object> protocols = null;
        this.finalActionCounter = 0;
        CommitteeBatchCorrespondence committeeBatchCorrespondence = new CommitteeBatchCorrespondence(batchCorrespondenceTypeCode, committeeId, startDate, endDate);
        if (StringUtils.equals((String)batchCorrespondenceTypeCode, (String)"1")) {
            protocols = this.protocolDao.getExpiringProtocols(committeeId, startDate, endDate);
            protocolActionTypeCode = "111";
        } else if (StringUtils.equals((String)batchCorrespondenceTypeCode, (String)"2")) {
            protocols = this.protocolDao.getNotifiedProtocols(committeeId, startDate, endDate);
            protocolActionTypeCode = "112";
        } else {
            throw new IllegalArgumentException(batchCorrespondenceTypeCode);
        }
        batchCorrespondence = (BatchCorrespondence)this.lookupBatchCorrespondence(batchCorrespondenceTypeCode);
        for (ProtocolBase protocolBase : protocols) {
            ProtocolCorrespondenceType protocolCorrespondenceType = (ProtocolCorrespondenceType)this.getProtocolCorrespondenceTypeToGenerate(protocolBase, batchCorrespondence);
            if (protocolCorrespondenceType == null) continue;
            if (this.protocolCorrespondenceTemplateService.getProtocolCorrespondenceTemplate(committeeId, protocolCorrespondenceType.getProtoCorrespTypeCode()) == null) {
                LOG.warn((Object)("Correspondence template \"" + protocolCorrespondenceType.getDescription() + "\" is missing.  Correspondence for protocol " + protocolBase.getProtocolNumber() + " has not been generated.  Add the missing template and regenerate correspondence."));
                continue;
            }
            CommitteeBatchCorrespondenceDetail batchCorrespondenceDetail = (CommitteeBatchCorrespondenceDetail)this.createBatchCorrespondenceDetail(committeeId, protocolBase, protocolCorrespondenceType, committeeBatchCorrespondence.getCommitteeBatchCorrespondenceId(), protocolActionTypeCode);
            committeeBatchCorrespondence.getCommitteeBatchCorrespondenceDetails().add(batchCorrespondenceDetail);
            Long detailId = batchCorrespondenceDetail.getCommitteeBatchCorrespondenceDetailId();
            String description = protocolCorrespondenceType.getDescription();
            String userFullName = "";
            BatchCorrespondenceNotificationRenderer renderer = new BatchCorrespondenceNotificationRenderer((Protocol)protocolBase, detailId, description, userFullName);
            IRBNotificationContext context = new IRBNotificationContext((Protocol)protocolBase, "111", "Renewal Reminder Generated", (NotificationRenderer)renderer);
            context.setEmailAttachments(this.getEmailAttachments(batchCorrespondenceDetail.getProtocolCorrespondence()));
            this.kcNotificationService.sendNotification(context);
        }
        this.businessObjectService.save((PersistableBusinessObject)committeeBatchCorrespondence);
        committeeBatchCorrespondence.setFinalActionCounter(this.finalActionCounter);
        return committeeBatchCorrespondence;
    }

    @Override
    protected void applyFinalAction(ProtocolBase protocol, BatchCorrespondenceBase batchCorrespondence) throws Exception {
        ProtocolGenericActionBean actionBean = new ProtocolGenericActionBean(null, "");
        actionBean.setComments("Final action of batch Correspondence: " + batchCorrespondence.getDescription());
        if (StringUtils.equals((String)"302", (String)batchCorrespondence.getFinalActionTypeCode())) {
            try {
                protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                protocol.setProtocolDocument((ProtocolDocument)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber()));
            }
            this.protocolGenericActionService.suspend((Protocol)protocol, actionBean);
            ++this.finalActionCounter;
        }
        if (StringUtils.equals((String)"300", (String)batchCorrespondence.getFinalActionTypeCode())) {
            try {
                protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                protocol.setProtocolDocument((ProtocolDocument)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber()));
            }
            ((ProtocolGenericActionService)this.protocolGenericActionService).close((Protocol)protocol, actionBean);
            ++this.finalActionCounter;
        }
    }

    @Override
    protected CommitteePrintingService getCommitteePrintingService() {
        return KraServiceLocator.getService(CommitteePrintingService.class);
    }

    public void setProtocolGenericActionService(ProtocolGenericActionService protocolGenericActionService) {
        this.protocolGenericActionService = protocolGenericActionService;
    }

    @Override
    protected Class<? extends ProtocolCorrespondence> getProtocolCorrespondenceBOClassHook() {
        return org.kuali.kra.irb.correspondence.ProtocolCorrespondence.class;
    }

    @Override
    protected CommitteeBatchCorrespondenceDetailBase getNewCommitteeBatchCorrespondenceDetailInstanceHook() {
        return new CommitteeBatchCorrespondenceDetail();
    }

    @Override
    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, Object object, String protocolActionTypeCode) {
        return new ProtocolAction((Protocol)protocol, null, protocolActionTypeCode);
    }

    @Override
    protected ProtocolCorrespondence getNewProtocolCorrespondenceInstanceHook() {
        return new org.kuali.kra.irb.correspondence.ProtocolCorrespondence();
    }

    @Override
    protected Class<? extends BatchCorrespondenceBase> getBatchCorrespondenceBOClassHook() {
        return BatchCorrespondence.class;
    }
}

