/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.committee.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.kuali.kra.committee.print.CommitteeFutureScheduledMeetingsPrint;
import org.kuali.kra.committee.print.CommitteeRosterPrint;
import org.kuali.kra.committee.print.CommitteeTemplatePrint;
import org.kuali.kra.committee.print.ProtocolBatchCorrespondencePrint;
import org.kuali.kra.committee.print.ProtocolCorrespondenceTemplatePrint;
import org.kuali.kra.committee.print.ScheduleTemplatePrint;
import org.kuali.kra.committee.service.CommitteePrintingService;
import org.kuali.kra.common.committee.print.CommitteeReportType;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.service.impl.PrintingServiceImpl;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;

public class CommitteePrintingServiceImpl
extends PrintingServiceImpl
implements CommitteePrintingService {
    private static final String ERROR_MESSAGE = "Unknown report type specified";
    private CommitteeTemplatePrint committeeTemplatePrint;
    private ScheduleTemplatePrint scheduleTemplatePrint;
    private ProtocolCorrespondenceTemplatePrint protocolCorrespondenceTemplatePrint;
    private ProtocolBatchCorrespondencePrint protocolBatchCorrespondencePrint;
    private CommitteeRosterPrint committeeRosterPrint;
    private CommitteeFutureScheduledMeetingsPrint committeeFutureScheduledMeetingsPrint;

    @Override
    public AbstractPrint getCommitteePrintable(CommitteeReportType reportType) {
        AbstractPrint printable = null;
        switch (reportType) {
            case COMMITTEE_TEMPLATE: {
                printable = this.getCommitteeTemplatePrint();
                break;
            }
            case SCHEDULE_TEMPLATE: {
                printable = this.getScheduleTemplatePrint();
                break;
            }
            case PROTOCOL_CORRESPONDENCE_TEMPLATE: {
                printable = this.getProtocolCorrespondenceTemplatePrint();
                break;
            }
            case ROSTER: {
                printable = this.getCommitteeRosterPrint();
                break;
            }
            case FUTURE_SCHEDULED_MEETINGS: {
                printable = this.getCommitteeFutureScheduledMeetingsPrint();
                break;
            }
            case PROTOCOL_BATCH_CORRESPONDENCE: {
                printable = this.getProtocolBatchCorrespondencePrint();
                break;
            }
            default: {
                throw new IllegalArgumentException(ERROR_MESSAGE);
            }
        }
        return printable;
    }

    @Override
    public AttachmentDataSource print(List<Printable> printableArtifactList) throws PrintingException {
        AttachmentDataSource attachmentDataSource = super.print(printableArtifactList);
        String fileName = "CommitteeReport.pdf";
        try {
            attachmentDataSource.setFileName(URLEncoder.encode(fileName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            attachmentDataSource.setFileName(fileName);
        }
        attachmentDataSource.setContentType("application/pdf");
        return attachmentDataSource;
    }

    public AttachmentDataSource printRenewalReminder(List<Printable> printableArtifactList) throws PrintingException {
        AttachmentDataSource attachmentDataSource = super.print(printableArtifactList);
        String fileName = "RenewalReminder.pdf";
        try {
            attachmentDataSource.setFileName(URLEncoder.encode(fileName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            attachmentDataSource.setFileName(fileName);
        }
        attachmentDataSource.setContentType("application/pdf");
        return attachmentDataSource;
    }

    public CommitteeTemplatePrint getCommitteeTemplatePrint() {
        return this.committeeTemplatePrint;
    }

    public void setCommitteeTemplatePrint(CommitteeTemplatePrint committeeTemplatePrint) {
        this.committeeTemplatePrint = committeeTemplatePrint;
    }

    public ScheduleTemplatePrint getScheduleTemplatePrint() {
        return this.scheduleTemplatePrint;
    }

    public void setScheduleTemplatePrint(ScheduleTemplatePrint scheduleTemplatePrint) {
        this.scheduleTemplatePrint = scheduleTemplatePrint;
    }

    public ProtocolCorrespondenceTemplatePrint getProtocolCorrespondenceTemplatePrint() {
        return this.protocolCorrespondenceTemplatePrint;
    }

    public void setProtocolCorrespondenceTemplatePrint(ProtocolCorrespondenceTemplatePrint protocolCorrespondenceTemplatePrint) {
        this.protocolCorrespondenceTemplatePrint = protocolCorrespondenceTemplatePrint;
    }

    public CommitteeRosterPrint getCommitteeRosterPrint() {
        return this.committeeRosterPrint;
    }

    public void setCommitteeRosterPrint(CommitteeRosterPrint committeeRosterPrint) {
        this.committeeRosterPrint = committeeRosterPrint;
    }

    public CommitteeFutureScheduledMeetingsPrint getCommitteeFutureScheduledMeetingsPrint() {
        return this.committeeFutureScheduledMeetingsPrint;
    }

    public void setCommitteeFutureScheduledMeetingsPrint(CommitteeFutureScheduledMeetingsPrint committeeFutureScheduledMeetingsPrint) {
        this.committeeFutureScheduledMeetingsPrint = committeeFutureScheduledMeetingsPrint;
    }

    public void setProtocolBatchCorrespondencePrint(ProtocolBatchCorrespondencePrint protocolBatchCorrespondencePrint) {
        this.protocolBatchCorrespondencePrint = protocolBatchCorrespondencePrint;
    }

    public ProtocolBatchCorrespondencePrint getProtocolBatchCorrespondencePrint() {
        return this.protocolBatchCorrespondencePrint;
    }
}

