/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.bo;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.coi.CoiReviewType;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeResearchAreaBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.bo.CommitteeType;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewTypeBase;
import org.kuali.kra.util.DateUtils;

public abstract class CommitteeBase<CMT extends CommitteeBase<CMT, CD, CS>, CD extends CommitteeDocumentBase<CD, CMT, CS>, CS extends CommitteeScheduleBase<CS, CMT, ?, ?>>
extends KraPersistableBusinessObjectBase
implements Comparable<CMT>,
SequenceOwner<CMT>,
Permissionable {
    private Long id;
    private String committeeId;
    private Integer sequenceNumber;
    private String committeeName;
    private String homeUnitNumber;
    private String committeeDescription;
    private String scheduleDescription;
    private String committeeTypeCode;
    private Integer minimumMembersRequired;
    private Integer maxProtocols;
    private Integer advancedSubmissionDaysRequired;
    private String reviewTypeCode;
    private String coiReviewTypeCode;
    private Unit homeUnit;
    private CommitteeType committeeType;
    private ProtocolReviewTypeBase reviewType;
    private CoiReviewType coiReviewType;
    private CD committeeDocument;
    private List<CommitteeMembershipBase> committeeMemberships;
    private List<CS> committeeSchedules;
    private List<CommitteeResearchAreaBase> committeeResearchAreas;
    private static final String CHAIR_MEMBERSHIP_ROLE_CODE = "1";
    private String committeeChair;
    private String unitName;
    private Boolean printRooster;

    public CommitteeBase() {
        this.setSequenceNumber(1);
        this.setCommitteeResearchAreas(new ArrayList<CommitteeResearchAreaBase>());
        this.setCommitteeMemberships(new ArrayList<CommitteeMembershipBase>());
        this.setCommitteeSchedules(new ArrayList());
        this.setCommitteeTypeCode(this.getProtocolCommitteeTypeCodehook());
    }

    protected abstract String getProtocolCommitteeTypeCodehook();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCommitteeId() {
        return this.committeeId;
    }

    public void setCommitteeId(String committeeId) {
        this.committeeId = committeeId;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getCommitteeName() {
        return this.committeeName;
    }

    public void setCommitteeName(String committeeName) {
        this.committeeName = committeeName;
    }

    public String getHomeUnitNumber() {
        return this.homeUnitNumber;
    }

    public void setHomeUnitNumber(String homeUnitNumber) {
        this.homeUnitNumber = homeUnitNumber;
    }

    public String getCommitteeDescription() {
        return this.committeeDescription;
    }

    public void setCommitteeDescription(String committeeDescription) {
        this.committeeDescription = committeeDescription;
    }

    public String getScheduleDescription() {
        return this.scheduleDescription;
    }

    public void setScheduleDescription(String scheduleDescription) {
        this.scheduleDescription = scheduleDescription;
    }

    public String getCommitteeTypeCode() {
        return this.committeeTypeCode;
    }

    public void setCommitteeTypeCode(String committeeTypeCode) {
        this.committeeTypeCode = committeeTypeCode;
    }

    public Integer getMinimumMembersRequired() {
        return this.minimumMembersRequired;
    }

    public void setMinimumMembersRequired(Integer minimumMembersRequired) {
        this.minimumMembersRequired = minimumMembersRequired;
    }

    public Integer getMaxProtocols() {
        return this.maxProtocols;
    }

    public void setMaxProtocols(Integer maxProtocols) {
        this.maxProtocols = maxProtocols;
    }

    public Integer getAdvancedSubmissionDaysRequired() {
        return this.advancedSubmissionDaysRequired;
    }

    public void setAdvancedSubmissionDaysRequired(Integer advancedSubmissionDaysRequired) {
        this.advancedSubmissionDaysRequired = advancedSubmissionDaysRequired;
    }

    public String getReviewTypeCode() {
        return this.reviewTypeCode;
    }

    public void setReviewTypeCode(String reviewTypeCode) {
        this.reviewTypeCode = reviewTypeCode;
    }

    public String getCoiReviewTypeCode() {
        return this.coiReviewTypeCode;
    }

    public void setCoiReviewTypeCode(String coiReviewTypeCode) {
        this.coiReviewTypeCode = coiReviewTypeCode;
    }

    public Unit getHomeUnit() {
        return this.homeUnit;
    }

    public void setHomeUnit(Unit homeUnit) {
        this.homeUnit = homeUnit;
    }

    public CommitteeType getCommitteeType() {
        if (null == this.committeeType) {
            this.refreshReferenceObject("committeeType");
        }
        return this.committeeType;
    }

    public void setCommitteeType(CommitteeType committeeType) {
        this.committeeType = committeeType;
    }

    public ProtocolReviewTypeBase getReviewType() {
        return this.reviewType;
    }

    public void setReviewType(ProtocolReviewTypeBase reviewType) {
        this.reviewType = reviewType;
    }

    public CoiReviewType getCoiReviewType() {
        return this.coiReviewType;
    }

    public void setCoiReviewType(CoiReviewType coiReviewType) {
        this.coiReviewType = coiReviewType;
    }

    public CD getCommitteeDocument() {
        return this.committeeDocument;
    }

    public void setCommitteeDocument(CD committeeDocument) {
        this.committeeDocument = committeeDocument;
    }

    public List<CommitteeMembershipBase> getCommitteeMemberships() {
        return this.committeeMemberships;
    }

    public void setCommitteeMemberships(List<CommitteeMembershipBase> committeeMemberships) {
        this.committeeMemberships = committeeMemberships;
    }

    public void setCommitteeSchedules(List<CS> committeeSchedules) {
        this.committeeSchedules = committeeSchedules;
    }

    public List<CS> getCommitteeSchedules() {
        return this.committeeSchedules;
    }

    public List<CommitteeResearchAreaBase> getCommitteeResearchAreas() {
        return this.committeeResearchAreas;
    }

    public void setCommitteeResearchAreas(List<CommitteeResearchAreaBase> committeeResearchAreas) {
        this.committeeResearchAreas = committeeResearchAreas;
    }

    public Boolean getPrintRooster() {
        return this.printRooster;
    }

    public void setPrintRooster(Boolean printRooster) {
        this.printRooster = printRooster;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getCommitteeResearchAreas());
        managedLists.add(this.committeeSchedules);
        return managedLists;
    }

    public String getCommitteeChair() {
        if (StringUtils.isBlank((String)this.committeeChair) && CollectionUtils.isNotEmpty(this.getCommitteeMemberships())) {
            ArrayList<String> committeeChairs = new ArrayList<String>();
            for (CommitteeMembershipBase committeeMembership : this.getCommitteeMemberships()) {
                if (this.isChairPerson(committeeMembership)) {
                    committeeChairs.add(committeeMembership.getPersonName());
                }
                this.setCommitteeChair(((Object)committeeChairs).toString());
            }
        }
        return this.committeeChair;
    }

    private boolean isChairPerson(CommitteeMembershipBase committeeMembership) {
        boolean isChairRoleFound = false;
        Date currentDate = DateUtils.clearTimeFields(new Date(System.currentTimeMillis()));
        for (CommitteeMembershipRole committeeMembershipRole : committeeMembership.getMembershipRoles()) {
            if (!committeeMembershipRole.getMembershipRoleCode().equals(CHAIR_MEMBERSHIP_ROLE_CODE) || committeeMembershipRole.getStartDate() == null || committeeMembershipRole.getEndDate() == null || currentDate.before(committeeMembershipRole.getStartDate()) || currentDate.after(committeeMembershipRole.getEndDate())) continue;
            isChairRoleFound = true;
            break;
        }
        return isChairRoleFound;
    }

    public void setCommitteeChair(String committeeChair) {
        this.committeeChair = committeeChair;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    @Override
    public Integer getOwnerSequenceNumber() {
        return null;
    }

    @Override
    public void incrementSequenceNumber() {
        Integer n = this.sequenceNumber;
        Integer n2 = this.sequenceNumber = Integer.valueOf(this.sequenceNumber + 1);
    }

    @Override
    public CMT getSequenceOwner() {
        return this.getThisHook();
    }

    protected abstract CMT getThisHook();

    @Override
    public void setSequenceOwner(CMT newOwner) {
    }

    @Override
    public void resetPersistenceState() {
        this.setId(null);
    }

    @Override
    public int compareTo(CMT committee) {
        if (StringUtils.equals((String)this.getCommitteeId(), (String)((CommitteeBase)committee).getCommitteeId())) {
            return this.getSequenceNumber().compareTo(((CommitteeBase)committee).getSequenceNumber());
        }
        return this.getCommitteeId().compareTo(((CommitteeBase)committee).getCommitteeId());
    }

    @Override
    public String getVersionNameField() {
        return "committeeName";
    }

    @Override
    public String getDocumentKey() {
        return "committee";
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        qualifiedRoleAttributes.put("committee", this.getCommitteeId());
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.committeeId;
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.add(this.getAdminRoleHook());
        roleNames.add(this.getProtocolReviewerRoleHook());
        return roleNames;
    }

    protected abstract String getProtocolReviewerRoleHook();

    protected abstract String getAdminRoleHook();

    @Override
    public String getNamespace() {
        return this.getModuleNamespaceCodeHook();
    }

    protected abstract String getModuleNamespaceCodeHook();

    @Override
    public String getLeadUnitNumber() {
        return this.getHomeUnitNumber();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return null;
    }

    public CommitteeMembershipBase getCommitteeMembershipFor(String personId) {
        CommitteeMembershipBase retVal = null;
        for (CommitteeMembershipBase member : this.getCommitteeMemberships()) {
            if (!member.isRepresentingPerson(personId)) continue;
            retVal = member;
            break;
        }
        return retVal;
    }
}

