/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class CommitteeDocumentBase<CD extends CommitteeDocumentBase<CD, CMT, CS>, CMT extends CommitteeBase<CMT, CD, CS>, CS extends CommitteeScheduleBase<CS, CMT, ?, ?>>
extends ResearchDocumentBase
implements Copyable,
SessionDocument {
    private static final long serialVersionUID = 1L;
    private static final String DOCUMENT_TYPE_CODE = "COMT";
    private String committeeId;
    private String docStatusCode;
    private List<CMT> committeeList = new ArrayList<CMT>();

    public CommitteeDocumentBase() {
        CMT committee = this.getNewCommitteeInstanceHook();
        this.committeeList.add(committee);
        ((CommitteeBase)committee).setCommitteeDocument(this.getThisHook());
    }

    protected abstract CD getThisHook();

    protected abstract CMT getNewCommitteeInstanceHook();

    @Override
    public void initialize() {
    }

    public CMT getCommittee() {
        return (CMT)((CommitteeBase)this.committeeList.get(0));
    }

    public void setCommittee(CMT committee) {
        this.committeeList.set(0, committee);
    }

    public List<CMT> getCommitteeList() {
        return this.committeeList;
    }

    public void setCommitteeList(List<CMT> committeeList) {
        this.committeeList = committeeList;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        return managedLists;
    }

    @Override
    protected List<RolePersons> getAllRolePersons() {
        return new ArrayList<RolePersons>();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    @Override
    public void prepareForSave() {
        String routeStatusCode;
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
        if (this.getCommittee() != null) {
            this.setCommitteeId(((CommitteeBase)this.getCommittee()).getCommitteeId());
        }
        if (StringUtils.isNotBlank((String)(routeStatusCode = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) && routeStatusCode.equals("I")) {
            this.setDocStatusCode("S");
        } else {
            this.setDocStatusCode(routeStatusCode);
        }
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        this.setDocStatusCode(statusChangeEvent.getNewRouteStatus());
        if (this.isFinal(statusChangeEvent) && ((CommitteeBase)this.getCommittee()).getSequenceNumber() > 1) {
            List schedules = ((CommitteeBase)this.getCommittee()).getCommitteeSchedules();
            ((CommitteeBase)this.getCommittee()).setCommitteeSchedules(this.getCommitteeService().mergeCommitteeSchedule(((CommitteeBase)this.getCommittee()).getCommitteeId()));
            this.getBusinessObjectService().delete(schedules);
            this.getBusinessObjectService().save((PersistableBusinessObject)this);
        }
    }

    protected abstract CommitteeServiceBase<CMT, CS> getCommitteeService();

    private BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    private boolean isFinal(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((String)"F", (String)statusChangeEvent.getNewRouteStatus());
    }

    public String getCommitteeId() {
        return this.committeeId;
    }

    public void setCommitteeId(String committeeId) {
        this.committeeId = committeeId;
    }

    public String getDocStatusCode() {
        return this.docStatusCode;
    }

    public void setDocStatusCode(String docStatusCode) {
        this.docStatusCode = docStatusCode;
    }

    @Override
    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && "F".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) {
            isComplete = true;
        }
        return isComplete;
    }
}

