/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;

public abstract class CommitteeDocumentAuthorizerBase
extends KcTransactionalDocumentAuthorizerBase {
    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        String userId = user.getPrincipalId();
        CommitteeDocumentBase committeeDocument = (CommitteeDocumentBase)document;
        if (((CommitteeBase)committeeDocument.getCommittee()).getCommitteeId() == null) {
            if (this.canCreateCommittee(user)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else if (this.canExecuteCommitteeTask(userId, committeeDocument, "modifyCommittee")) {
            editModes.add("fullEntry");
        } else if (this.canExecuteCommitteeTask(userId, committeeDocument, "viewCommittee")) {
            editModes.add("viewOnly");
        } else {
            editModes.add("unviewable");
        }
        return editModes;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateCommittee(user);
    }

    public boolean canOpen(Document document, Person user) {
        CommitteeDocumentBase committeeDocument = (CommitteeDocumentBase)document;
        if (((CommitteeBase)committeeDocument.getCommittee()).getCommitteeId() == null) {
            return this.canCreateCommittee(user);
        }
        return this.canExecuteCommitteeTask(user.getPrincipalId(), (CommitteeDocumentBase)document, "viewCommittee");
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return !this.isFinal(document) && this.canExecuteCommitteeTask(user.getPrincipalId(), (CommitteeDocumentBase)document, "modifyCommittee");
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return !this.isFinal(document) && super.canRoute(document, user);
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return !this.isFinal(document) && super.canBlanketApprove(document, user);
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return !this.isFinal(document) && super.canCancel(document, user);
    }

    @Override
    public boolean canAcknowledge(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canReload(Document document, Person user) {
        return this.isFinal(document);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    private boolean canCreateCommittee(Person user) {
        ApplicationTask task = new ApplicationTask(this.getAddCommitteeTaskNameHook());
        return this.getTaskAuthorizationService().isAuthorized(user.getPrincipalId(), task);
    }

    protected abstract String getAddCommitteeTaskNameHook();

    private boolean canExecuteCommitteeTask(String userId, CommitteeDocumentBase doc, String taskName) {
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook(taskName, (CommitteeBase)doc.getCommittee());
        return this.getTaskAuthorizationService().isAuthorized(userId, task);
    }

    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }
}

