/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.meeting;

import java.sql.Timestamp;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.common.committee.meeting.MinuteEntryType;
import org.kuali.kra.common.committee.meeting.ProtocolContingencyBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewableBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeScheduleMinuteBase<CSM extends CommitteeScheduleMinuteBase<CSM, CS>, CS extends CommitteeScheduleBase<CS, ?, ?, CSM>>
extends ProtocolReviewableBase<CS>
implements Cloneable {
    private static final long serialVersionUID = -2294619582524055884L;
    private static final String PERSON_NOT_FOUND_FORMAT_STRING = "%s (not found)";
    private static final Logger LOG = Logger.getLogger(CommitteeScheduleMinuteBase.class);
    private Long commScheduleMinutesId;
    private Long scheduleIdFk;
    private Integer entryNumber;
    private String minuteEntryTypeCode;
    private String protocolContingencyCode;
    private Long protocolIdFk;
    private Long commScheduleActItemsIdFk;
    private Long submissionIdFk;
    private boolean privateCommentFlag;
    private boolean finalFlag;
    private Long protocolReviewerIdFk;
    private Long protocolOnlineReviewIdFk;
    private ProtocolContingencyBase protocolContingency;
    private MinuteEntryType minuteEntryType;
    private CommScheduleActItemBase commScheduleActItem;
    private CS committeeSchedule;
    private ProtocolReviewer protocolReviewer;
    private String createUser;
    private Timestamp createTimestamp;
    @SkipVersioning
    private transient ProtocolOnlineReviewBase protocolOnlineReview;
    private String minuteEntry;
    @SkipVersioning
    private List<ProtocolBase> protocols;
    @SkipVersioning
    private ProtocolBase protocol;
    private boolean generateAttendance = false;
    @SkipVersioning
    private transient String createUserFullName;
    @SkipVersioning
    private transient String updateUserFullName;
    private transient boolean displayReviewerName;
    private transient boolean readOnly = true;
    public static final Comparator<CommitteeScheduleMinuteBase> entryTypeComparator = new Comparator<CommitteeScheduleMinuteBase>(){

        @Override
        public int compare(CommitteeScheduleMinuteBase csm1, CommitteeScheduleMinuteBase csm2) {
            int retVal = 0;
            if (csm1.getProtocolIdFk() != null && csm2.getProtocolIdFk() != null) {
                retVal = csm1.getProtocol().getProtocolNumber().compareTo(csm2.getProtocol().getProtocolNumber());
            } else if (csm1.getProtocolIdFk() == null && csm2.getProtocolIdFk() != null) {
                retVal = -1;
            } else if (csm1.getProtocolIdFk() != null && csm2.getProtocolIdFk() == null) {
                retVal = 1;
            }
            if (retVal == 0 && (retVal = csm1.getMinuteEntryType().compareTo(csm2.getMinuteEntryType())) == 0 && csm1.getUpdateTimestamp() != null && csm2.getUpdateTimestamp() != null) {
                retVal = csm1.getUpdateTimestamp().compareTo(csm2.getUpdateTimestamp());
            }
            return retVal;
        }
    };

    public CommitteeScheduleMinuteBase() {
    }

    public CommitteeScheduleMinuteBase(String minuteEntryTypeCode) {
        this.minuteEntryTypeCode = minuteEntryTypeCode;
    }

    public Long getScheduleIdFk() {
        return this.scheduleIdFk;
    }

    public void setScheduleIdFk(Long scheduleIdFk) {
        this.scheduleIdFk = scheduleIdFk;
    }

    public Integer getEntryNumber() {
        return this.entryNumber;
    }

    public void setEntryNumber(Integer entryNumber) {
        this.entryNumber = entryNumber;
    }

    public String getMinuteEntryTypeCode() {
        return this.minuteEntryTypeCode;
    }

    public void setMinuteEntryTypeCode(String minuteEntryTypeCode) {
        this.minuteEntryTypeCode = minuteEntryTypeCode;
    }

    public Long getProtocolIdFk() {
        return this.protocolIdFk;
    }

    public void setProtocolIdFk(Long protocolIdFk) {
        this.protocolIdFk = protocolIdFk;
    }

    public Long getCommScheduleActItemsIdFk() {
        return this.commScheduleActItemsIdFk;
    }

    public void setCommScheduleActItemsIdFk(Long commScheduleActItemsIdFk) {
        this.commScheduleActItemsIdFk = commScheduleActItemsIdFk;
    }

    public Long getSubmissionIdFk() {
        return this.submissionIdFk;
    }

    public void setSubmissionIdFk(Long submissionIdFk) {
        this.submissionIdFk = submissionIdFk;
    }

    public boolean getPrivateCommentFlag() {
        return this.privateCommentFlag;
    }

    public void setPrivateCommentFlag(boolean privateCommentFlag) {
        this.privateCommentFlag = privateCommentFlag;
    }

    public String getProtocolContingencyCode() {
        return this.protocolContingencyCode;
    }

    public void setProtocolContingencyCode(String protocolContingencyCode) {
        this.protocolContingencyCode = protocolContingencyCode;
        if (!StringUtils.isBlank((String)protocolContingencyCode) && this.getProtocolContingency() != null) {
            this.setMinuteEntry(this.getProtocolContingency().getDescription());
        }
    }

    public String getMinuteEntry() {
        return this.minuteEntry;
    }

    public void setMinuteEntry(String minuteEntry) {
        this.minuteEntry = minuteEntry;
    }

    public Long getCommScheduleMinutesId() {
        return this.commScheduleMinutesId;
    }

    public void setCommScheduleMinutesId(Long commScheduleMinutesId) {
        this.commScheduleMinutesId = commScheduleMinutesId;
    }

    public ProtocolContingencyBase getProtocolContingency() {
        if (StringUtils.isBlank((String)this.protocolContingencyCode)) {
            this.protocolContingency = null;
        } else if (this.protocolContingency == null || !StringUtils.equals((String)this.protocolContingencyCode, (String)this.protocolContingency.getProtocolContingencyCode())) {
            this.refreshReferenceObject("protocolContingency");
        }
        return this.protocolContingency;
    }

    public void setProtocolContingency(ProtocolContingencyBase protocolContingency) {
        this.protocolContingency = protocolContingency;
    }

    public MinuteEntryType getMinuteEntryType() {
        return this.minuteEntryType;
    }

    public void setMinuteEntryType(MinuteEntryType minuteEntryType) {
        this.minuteEntryType = minuteEntryType;
    }

    public CommScheduleActItemBase getCommScheduleActItem() {
        return this.commScheduleActItem;
    }

    public void setCommScheduleActItem(CommScheduleActItemBase commScheduleActItem) {
        this.commScheduleActItem = commScheduleActItem;
    }

    public List<ProtocolBase> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<ProtocolBase> protocols) {
        this.protocols = protocols;
    }

    public boolean isGenerateAttendance() {
        return this.generateAttendance;
    }

    public void setGenerateAttendance(boolean generateAttendance) {
        this.generateAttendance = generateAttendance;
    }

    public boolean isFinalFlag() {
        return this.finalFlag;
    }

    public void setFinalFlag(boolean finalFlag) {
        this.finalFlag = finalFlag;
    }

    @Override
    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    public Long getProtocolReviewerIdFk() {
        return this.protocolReviewerIdFk;
    }

    public void setProtocolReviewerIdFk(Long protocolReviewerIdFk) {
        this.protocolReviewerIdFk = protocolReviewerIdFk;
    }

    public ProtocolReviewer getProtocolReviewer() {
        return this.protocolReviewer;
    }

    public void setProtocolReviewer(ProtocolReviewer protocolReviewer) {
        this.protocolReviewer = protocolReviewer;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    @Override
    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    @Override
    public Long getProtocolOnlineReviewIdFk() {
        return this.protocolOnlineReviewIdFk;
    }

    public void setProtocolOnlineReviewIdFk(Long protocolOnlineReviewIdFk) {
        this.protocolOnlineReviewIdFk = protocolOnlineReviewIdFk;
    }

    public ProtocolOnlineReviewBase getProtocolOnlineReview() {
        return this.protocolOnlineReview;
    }

    public void setProtocolOnlineReview(ProtocolOnlineReviewBase protocolReview) {
        this.protocolOnlineReview = protocolReview;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            CommitteeScheduleMinuteBase csm = (CommitteeScheduleMinuteBase)o;
            return this.getCommScheduleMinutesId().equals(csm.getCommScheduleMinutesId()) && StringUtils.equals((String)this.getMinuteEntry(), (String)csm.getMinuteEntry()) && this.getEntryNumber().equals(csm.getEntryNumber()) && this.getPrivateCommentFlag() == csm.getPrivateCommentFlag() && this.isFinalFlag() == csm.isFinalFlag();
        }
        return false;
    }

    @Override
    protected void preUpdate() {
        if (this.setUpdateIfModified()) {
            super.preUpdate();
        }
    }

    public CSM getPristineInstance() {
        CommitteeScheduleMinuteBase retVal = null;
        Long primaryKey = this.getCommScheduleMinutesId();
        if (primaryKey != null) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("commScheduleMinutesId", primaryKey.toString());
            retVal = (CommitteeScheduleMinuteBase)KraServiceLocator.getService(BusinessObjectService.class).findByPrimaryKey(this.getClass(), pkMap);
        }
        return (CSM)retVal;
    }

    public boolean isUpdateUserToBeRecorded(CSM pristineInstance) {
        boolean retVal = false;
        if (pristineInstance != null && this.getCommScheduleMinutesId().equals(((CommitteeScheduleMinuteBase)pristineInstance).getCommScheduleMinutesId()) && (!StringUtils.equals((String)this.getMinuteEntry(), (String)((CommitteeScheduleMinuteBase)pristineInstance).getMinuteEntry()) || this.getPrivateCommentFlag() != ((CommitteeScheduleMinuteBase)pristineInstance).getPrivateCommentFlag() || this.isFinalFlag() != ((CommitteeScheduleMinuteBase)pristineInstance).isFinalFlag() || this.isProtocolFieldChanged(pristineInstance))) {
            retVal = true;
        }
        return retVal;
    }

    private boolean setUpdateIfModified() {
        boolean result = false;
        String updateUser = GlobalVariables.getUserSession().getPrincipalName();
        if (this.getCommScheduleMinutesId() != null) {
            if (this.isUpdateUserToBeRecorded(this.getPristineInstance())) {
                this.setUpdateUser(updateUser);
                result = true;
            }
        } else {
            this.setUpdateUser(updateUser);
            result = true;
        }
        this.setUpdateUserSet(true);
        return result;
    }

    private boolean isProtocolFieldChanged(CSM committeeScheduleMinute) {
        boolean isChanged = false;
        if (this.protocolIdFk != ((CommitteeScheduleMinuteBase)committeeScheduleMinute).getProtocolIdFk()) {
            isChanged = this.protocolIdFk != null ? (isChanged &= !this.protocolIdFk.equals(((CommitteeScheduleMinuteBase)committeeScheduleMinute).getProtocolIdFk())) : (isChanged &= !((CommitteeScheduleMinuteBase)committeeScheduleMinute).getProtocolIdFk().equals(this.protocolIdFk));
        }
        if (this.protocolContingencyCode != ((CommitteeScheduleMinuteBase)committeeScheduleMinute).getProtocolContingencyCode()) {
            isChanged = this.protocolContingencyCode != null ? (isChanged &= !this.protocolContingencyCode.equals(((CommitteeScheduleMinuteBase)committeeScheduleMinute).getProtocolContingencyCode())) : (isChanged &= !((CommitteeScheduleMinuteBase)committeeScheduleMinute).getProtocolContingencyCode().equals(this.protocolContingencyCode));
        }
        return isChanged;
    }

    public boolean isPersisted() {
        return this.commScheduleMinutesId != null;
    }

    @Override
    public Long getProtocolId() {
        Long protocolId = null;
        if (this.protocol != null) {
            protocolId = this.protocol.getProtocolId();
        } else {
            if (this.protocolIdFk != null) {
                this.refreshReferenceObject("protocol");
            }
            if (this.protocol != null) {
                protocolId = this.protocol.getProtocolId();
            }
        }
        return protocolId;
    }

    public String getCreateUserFullName() {
        if (this.createUserFullName == null && this.getCreateUser() != null) {
            KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.getCreateUser());
            this.createUserFullName = person == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, this.getCreateUser()) : person.getFullName();
        }
        return this.createUserFullName;
    }

    public void setCreateUserFullName(String createUserFullName) {
        this.createUserFullName = createUserFullName;
    }

    public String getUpdateUserFullName() {
        if (this.updateUserFullName == null && this.getUpdateUser() != null) {
            KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.getUpdateUser());
            this.updateUserFullName = person == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, this.getUpdateUser()) : person.getFullName();
        }
        return this.updateUserFullName;
    }

    public void setUpdateUserFullName(String updateUserFullName) {
        this.updateUserFullName = updateUserFullName;
    }

    @Override
    public CS getCommitteeSchedule() {
        return this.committeeSchedule;
    }

    public void setCommitteeSchedule(CS committeeSchedule) {
        this.committeeSchedule = committeeSchedule;
    }

    public boolean getCanView() {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        String principalName = GlobalVariables.getUserSession().getPrincipalName();
        return this.isAdministrator(principalId) || StringUtils.equals((String)principalName, (String)this.createUser) || !this.getPrivateCommentFlag() && this.isFinalFlag();
    }

    protected abstract boolean isAdministrator(String var1);

    public CSM getCopy() {
        CommitteeScheduleMinuteBase copy = null;
        try {
            copy = (CommitteeScheduleMinuteBase)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return (CSM)copy;
    }

    public boolean isDisplayReviewerName() {
        return this.displayReviewerName;
    }

    @Override
    public void setDisplayReviewerName(boolean displayReviewerName) {
        this.displayReviewerName = displayReviewerName;
    }

    @Override
    public boolean isReviewComment() {
        return true;
    }

    @Override
    public boolean isFinal() {
        return this.isFinalFlag();
    }

    @Override
    public boolean isPrivate() {
        return this.getPrivateCommentFlag();
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

