/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.meeting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProtocolValuesFinderBase
extends KeyValuesBase {
    private static final long serialVersionUID = 5144171874415568112L;
    private String scheduleId;

    public List<KeyValue> getKeyValues() {
        TreeMap<String, ConcreteKeyValue> valuesMap = new TreeMap<String, ConcreteKeyValue>();
        for (ProtocolSubmissionBase protocolSubmissionBase : this.getProtocols()) {
            ConcreteKeyValue keyValue = new ConcreteKeyValue(protocolSubmissionBase.getProtocolId().toString(), protocolSubmissionBase.getProtocolNumber());
            valuesMap.put(protocolSubmissionBase.getProtocolNumber(), keyValue);
        }
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(valuesMap.values());
        keyValues.add(0, (KeyValue)new ConcreteKeyValue("", "select"));
        return keyValues;
    }

    private List<? extends ProtocolSubmissionBase> getProtocols() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("scheduleIdFk", this.scheduleId);
        return (List)this.getBusinessObjectService().findMatching(this.getProtocolSubmissionBOClassHook(), fieldValues);
    }

    protected abstract Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook();

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }
}

