/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.rules;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.rule.event.CommitteeActionGenerateBatchCorrespondenceEventBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceBase;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceDetailBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateService;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTypeBase;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public abstract class CommitteeActionGenerateBatchCorrespondenceRuleBase
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<CommitteeActionGenerateBatchCorrespondenceEventBase> {
    private static final String BATCH_CORRESPONDENCE_TYPE_FIELD = "committeeHelper.generateBatchCorrespondenceTypeCode";
    private static final String START_DATE_FIELD = "committeeHelper.generateStartDate";
    private static final String END_DATE_FIELD = "committeeHelper.generateEndDate";
    private static final String PROTO_CORRESP_TYPE_CODE = "protoCorrespTypeCode";
    private static final String BATCH_CORRESPONDENCE_TYPE_CODE = "batchCorrespondenceTypeCode";
    ProtocolCorrespondenceTemplateService protocolCorrespondenceTemplateService;

    @Override
    public boolean processRules(CommitteeActionGenerateBatchCorrespondenceEventBase event) {
        boolean rulePassed = true;
        boolean dateNull = false;
        if (StringUtils.isEmpty((String)event.getBatchCorrespondenceTypeCode())) {
            this.reportError(BATCH_CORRESPONDENCE_TYPE_FIELD, "error.committee.action.generate.batch.correspondence.type.code.not.specified", new String[0]);
            rulePassed = false;
        }
        if (event.getStartDate() == null) {
            this.reportError(START_DATE_FIELD, "error.committee.action.generate.start.date.not.specified", new String[0]);
            dateNull = true;
            rulePassed = false;
        }
        if (event.getEndDate() == null) {
            this.reportError(END_DATE_FIELD, "error.committee.action.generate.end.date.not.specified", new String[0]);
            dateNull = true;
            rulePassed = false;
        }
        if (!dateNull && event.getEndDate().before(event.getStartDate())) {
            this.reportError(END_DATE_FIELD, "error.committee.action.generate.end.date.before.start.date", new String[0]);
            rulePassed = false;
        }
        if (rulePassed) {
            this.missingTemplates(event.getBatchCorrespondenceTypeCode(), event.getCommitteeId());
        }
        return rulePassed;
    }

    private boolean missingTemplates(String batchCorrespondenceTypeCode, String committeeId) {
        ArrayList<String> missingTemplates = new ArrayList<String>();
        BatchCorrespondenceBase batchCorrespondence = this.lookupBatchCorrespondence(batchCorrespondenceTypeCode);
        for (BatchCorrespondenceDetailBase batchCorrespondenceDetail : batchCorrespondence.getBatchCorrespondenceDetails()) {
            if (this.getProtocolCorrespondenceTemplateService().getProtocolCorrespondenceTemplate(committeeId, batchCorrespondenceDetail.getProtoCorrespTypeCode()) != null) continue;
            missingTemplates.add(this.getProtocolCorrespondenceDescription(batchCorrespondenceDetail.getProtoCorrespTypeCode()));
        }
        if (!StringUtils.isBlank((String)batchCorrespondence.getFinalActionCorrespType()) && this.getProtocolCorrespondenceTemplateService().getProtocolCorrespondenceTemplate(committeeId, batchCorrespondence.getFinalActionCorrespType()) == null) {
            missingTemplates.add(this.getProtocolCorrespondenceDescription(batchCorrespondence.getFinalActionCorrespType()));
        }
        if (missingTemplates.isEmpty()) {
            return false;
        }
        this.reportSoftError(BATCH_CORRESPONDENCE_TYPE_FIELD, "error.committee.action.generate.missing.templates", ((Object)missingTemplates).toString());
        return true;
    }

    private BatchCorrespondenceBase lookupBatchCorrespondence(String batchCorrespondenceTypeCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(BATCH_CORRESPONDENCE_TYPE_CODE, batchCorrespondenceTypeCode);
        return (BatchCorrespondenceBase)this.getBusinessObjectService().findByPrimaryKey(this.getBatchCorrespondenceBOClassHook(), fieldValues);
    }

    protected abstract Class<? extends BatchCorrespondenceBase> getBatchCorrespondenceBOClassHook();

    private ProtocolCorrespondenceTemplateService getProtocolCorrespondenceTemplateService() {
        if (this.protocolCorrespondenceTemplateService == null) {
            this.protocolCorrespondenceTemplateService = KraServiceLocator.getService(this.getProtocolCorrespondenceTemplateServiceClassHook());
        }
        return this.protocolCorrespondenceTemplateService;
    }

    protected abstract Class<? extends ProtocolCorrespondenceTemplateService> getProtocolCorrespondenceTemplateServiceClassHook();

    private String getProtocolCorrespondenceDescription(String protocolCorrespondenceTypeCode) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put(PROTO_CORRESP_TYPE_CODE, protocolCorrespondenceTypeCode);
        return ((ProtocolCorrespondenceTypeBase)this.getBusinessObjectService().findByPrimaryKey(this.getProtocolCorrespondenceTypeBOClassHook(), primaryKeys)).getDescription();
    }

    protected abstract Class<? extends ProtocolCorrespondenceTypeBase> getProtocolCorrespondenceTypeBOClassHook();
}

