/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.rules;

import java.sql.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDateConflictEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleEventBase;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.util.DateUtils;

public class CommitteeScheduleDateConflictRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<CommitteeScheduleDateConflictEvent> {
    private static final Log LOG = LogFactory.getLog(CommitteeScheduleDateConflictRule.class);
    public static final String ID = "document.committeeList[0].committeeSchedules[%1$s].scheduledDate";
    public static final String DATES_IN_CONFLICT_ERROR_KEY = "datesInConflict";

    @Override
    public boolean processRules(CommitteeScheduleDateConflictEvent addCommitteeScheduleEvent) {
        boolean rulePassed = true;
        CommitteeScheduleEventBase.ErrorType type = addCommitteeScheduleEvent.getType();
        switch (type) {
            case HARDERROR: {
                rulePassed = this.processHardErrors(addCommitteeScheduleEvent);
                break;
            }
            case SOFTERROR: {
                rulePassed = this.processSoftErrors(addCommitteeScheduleEvent);
            }
        }
        return rulePassed;
    }

    private boolean processHardErrors(CommitteeScheduleDateConflictEvent addCommitteeScheduleEvent) {
        LinkedList<Date> conflictDates;
        boolean rulePassed = true;
        List<CommitteeScheduleBase> committeeSchedules = addCommitteeScheduleEvent.getCommitteeSchedules();
        rulePassed = this.parseUniqueDateSet(committeeSchedules, conflictDates = new LinkedList<Date>());
        if (!rulePassed) {
            this.identifyPotentialConflicts(committeeSchedules, conflictDates);
        }
        return rulePassed;
    }

    private boolean parseUniqueDateSet(List<CommitteeScheduleBase> committeeSchedules, List<Date> conflictDates) {
        boolean retVal = true;
        boolean flag = true;
        LinkedHashSet<Date> set = new LinkedHashSet<Date>();
        for (CommitteeScheduleBase committeeSchedule : committeeSchedules) {
            flag = true;
            flag = set.add(committeeSchedule.getScheduledDate());
            if (flag) continue;
            conflictDates.add(committeeSchedule.getScheduledDate());
        }
        if (conflictDates.size() > 0) {
            retVal = false;
        }
        return retVal;
    }

    private void identifyPotentialConflicts(List<CommitteeScheduleBase> committeeSchedules, List<Date> conflictDates) {
        Date scheduleDate = null;
        int count = 0;
        for (Date date : conflictDates) {
            count = 0;
            for (CommitteeScheduleBase committeeSchedule : committeeSchedules) {
                scheduleDate = committeeSchedule.getScheduledDate();
                if (DateUtils.isSameDay(date, scheduleDate)) {
                    this.reportError(String.format(ID, count), "error.committeeSchedule.date.conflict", scheduleDate.toString());
                }
                ++count;
            }
        }
    }

    private boolean processSoftErrors(CommitteeScheduleDateConflictEvent addCommitteeScheduleEvent) {
        boolean rulePassed = true;
        List<Date> datesInConflict = addCommitteeScheduleEvent.getScheduleData().getDatesInConflict();
        for (Date date : datesInConflict) {
            this.reportSoftError(DATES_IN_CONFLICT_ERROR_KEY, "error.committeeSchedule.dates.skipped", date.toString());
        }
        return rulePassed;
    }
}

