/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.rules;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDayEvent;
import org.kuali.kra.common.committee.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.common.committee.web.struts.form.schedule.StyleKey;
import org.kuali.kra.common.committee.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class CommitteeScheduleDayRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<CommitteeScheduleDayEvent> {
    public static final String SCHEDULEDATA_MONTHLY_DAY = "committeeHelper.scheduleData.monthlySchedule.day";
    public static final String SCHEDULEDATA_YEARLY_DAY = "committeeHelper.scheduleData.yearlySchedule.day";

    @Override
    public boolean processRules(CommitteeScheduleDayEvent event) {
        boolean rulePassed = true;
        ScheduleData scheduleData = event.getScheduleData();
        StyleKey key = StyleKey.valueOf(scheduleData.getRecurrenceType());
        switch (key) {
            case MONTHLY: {
                MonthlyScheduleDetails.optionValues monthOption = MonthlyScheduleDetails.optionValues.valueOf(scheduleData.getMonthlySchedule().getMonthOption());
                switch (monthOption) {
                    case XDAYANDXMONTH: {
                        rulePassed = this.validateDay(scheduleData.getMonthlySchedule().getDay(), SCHEDULEDATA_MONTHLY_DAY);
                    }
                }
                break;
            }
            case YEARLY: {
                YearlyScheduleDetails.yearOptionValues yearOption = YearlyScheduleDetails.yearOptionValues.valueOf(scheduleData.getYearlySchedule().getYearOption());
                switch (yearOption) {
                    case XDAY: {
                        rulePassed = this.validateDay(scheduleData.getYearlySchedule().getDay(), scheduleData.getYearlySchedule().getSelectedOption1Month(), SCHEDULEDATA_YEARLY_DAY);
                    }
                }
            }
        }
        return rulePassed;
    }

    private boolean validateDay(Integer day, String key) {
        boolean rulePassed = true;
        if (day != null && day.compareTo(31) > 0) {
            rulePassed = false;
            this.reportError(key, "error.committeeSchedule.day", "31");
        }
        return rulePassed;
    }

    private boolean validateDay(Integer day, String month, String key) {
        boolean rulePassed = true;
        int maxDay = StringUtils.equalsIgnoreCase((String)month, (String)"FEBRUARY") ? 29 : (StringUtils.equalsIgnoreCase((String)month, (String)"APRIL") || StringUtils.equalsIgnoreCase((String)month, (String)"JUNE") || StringUtils.equalsIgnoreCase((String)month, (String)"SEPTEMBER") || StringUtils.equalsIgnoreCase((String)month, (String)"NOVEMBER") ? 30 : 31);
        if (day != null && day.compareTo(maxDay) > 0) {
            rulePassed = false;
            this.reportError(key, "error.committeeSchedule.day", "31");
        }
        return rulePassed;
    }
}

