/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.rules;

import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.rule.event.DeleteCommitteeMemberEventBase;
import org.kuali.kra.common.committee.service.CommitteeMembershipServiceBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public abstract class DeleteCommitteeMemberRuleBase
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<DeleteCommitteeMemberEventBase> {
    private static final String ID = "document.committeeList[0].committeeMemberships[";
    private static final String AS_REVIEWER = "as the person is a reviewer of the protocol";
    private static final String AS_ATTENDANCE = "as the person has attended a schedule meeting";
    private CommitteeMembershipServiceBase committeeMembershipService;

    @Override
    public boolean processRules(DeleteCommitteeMemberEventBase event) {
        boolean rulePassed = true;
        int i = 0;
        for (CommitteeMembershipBase member : event.getCommitteeMemberships()) {
            if (member.isDelete() && this.getCommitteeMembershipService().isMemberAssignedToReviewer(member, ((CommitteeBase)((CommitteeDocumentBase)event.getDocument()).getCommittee()).getCommitteeId())) {
                this.reportError(ID + i + "].delete", "error.committeeMember.delete", AS_REVIEWER);
                rulePassed = false;
            }
            if (member.isDelete() && this.getCommitteeMembershipService().isMemberAttendedMeeting(member, ((CommitteeBase)((CommitteeDocumentBase)event.getDocument()).getCommittee()).getCommitteeId())) {
                this.reportError(ID + i + "].delete", "error.committeeMember.delete", AS_ATTENDANCE);
                rulePassed = false;
            }
            ++i;
        }
        return rulePassed;
    }

    private CommitteeMembershipServiceBase getCommitteeMembershipService() {
        if (this.committeeMembershipService == null) {
            this.committeeMembershipService = KraServiceLocator.getService(this.getCommitteeMembershipServiceClassHook());
        }
        return this.committeeMembershipService;
    }

    protected abstract Class<? extends CommitteeMembershipServiceBase> getCommitteeMembershipServiceClassHook();
}

