/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.rules;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.rule.event.DeleteCommitteeScheduleEventBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public abstract class DeleteCommitteeScheduleRuleBase
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<DeleteCommitteeScheduleEventBase> {
    private static final String ID = "document.committeeList[0].committeeSchedules[";

    @Override
    public boolean processRules(DeleteCommitteeScheduleEventBase deleteCommitteeScheduleEvent) {
        boolean rulePassed = true;
        List<CommitteeScheduleBase> schedules = deleteCommitteeScheduleEvent.getCommitteeSchedules();
        Object activeCommittee = this.getCommitteeService().getCommitteeById(((CommitteeBase)((CommitteeDocumentBase)deleteCommitteeScheduleEvent.getDocument()).getCommittee()).getCommitteeId());
        if (activeCommittee != null) {
            int i = 0;
            for (CommitteeScheduleBase schedule : schedules) {
                if (schedule.isSelected() && this.canNotDelete(((CommitteeBase)activeCommittee).getCommitteeSchedules(), schedule.getScheduleId())) {
                    this.reportError(ID + i + "].selected", "error.committeeSchedule.delete", new String[0]);
                    rulePassed = false;
                }
                ++i;
            }
        }
        return rulePassed;
    }

    private boolean canNotDelete(List<CommitteeScheduleBase> schedules, String scheduleId) {
        for (CommitteeScheduleBase committeeSchedule : schedules) {
            if (!StringUtils.equals((String)committeeSchedule.getScheduleId(), (String)scheduleId)) continue;
            return this.isNotEmptyData(committeeSchedule);
        }
        return false;
    }

    private CommitteeServiceBase getCommitteeService() {
        return KraServiceLocator.getService(this.getCommitteeServiceClassHook());
    }

    protected abstract Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook();

    private boolean isNotEmptyData(CommitteeScheduleBase schedule) {
        return CollectionUtils.isNotEmpty(schedule.getCommitteeScheduleAttendances()) || CollectionUtils.isNotEmpty(schedule.getCommitteeScheduleMinutes()) || CollectionUtils.isNotEmpty(schedule.getCommScheduleActItems()) || CollectionUtils.isNotEmpty(schedule.getMinuteDocs()) || CollectionUtils.isNotEmpty(schedule.getScheduleAgendas()) || CollectionUtils.isNotEmpty(schedule.getLatestProtocolSubmissions());
    }
}

