/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipExpertiseBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.service.CommitteeMembershipServiceBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.common.committee.service.impl.CommitteeScheduleServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class CommitteeMembershipServiceImplBase<CMT extends CommitteeBase<CMT, ?, ?>, CSRV extends CommitteeServiceBase<CMT, ?>>
implements CommitteeMembershipServiceBase<CMT> {
    private static final Log LOG = LogFactory.getLog(CommitteeScheduleServiceImplBase.class);
    private static final String REFERENCE_ROLODEX = "rolodex";
    private static final String REFERENCE_MEMBERSHIP_TYPE = "membershipType";
    private static final String REFERENCE_MEMBERSHIP_ROLE = "membershipRole";
    private static final String REFERENCE_RESEARCH_AREA = "researchArea";
    private BusinessObjectService businessObjectService;
    private CSRV committeeService;

    @Override
    public void addCommitteeMembership(CMT committee, CommitteeMembershipBase committeeMembership) {
        committeeMembership.setCommitteeIdFk(((CommitteeBase)committee).getId());
        committeeMembership.setMembershipId("0");
        if (StringUtils.isBlank((String)committeeMembership.getPersonId())) {
            committeeMembership.refreshReferenceObject(REFERENCE_ROLODEX);
        }
        committeeMembership.refreshReferenceObject(REFERENCE_MEMBERSHIP_TYPE);
        ((CommitteeBase)committee).getCommitteeMemberships().add(committeeMembership);
    }

    @Override
    public void deleteCommitteeMembership(CMT committee) {
        ArrayList<CommitteeMembershipBase> deletedCommitteememberships = new ArrayList<CommitteeMembershipBase>();
        for (CommitteeMembershipBase committeeMembership : ((CommitteeBase)committee).getCommitteeMemberships()) {
            if (!committeeMembership.isDelete()) continue;
            deletedCommitteememberships.add(committeeMembership);
        }
        ((CommitteeBase)committee).getCommitteeMemberships().removeAll(deletedCommitteememberships);
    }

    @Override
    public void addCommitteeMembershipRole(CMT committee, int selectedMembershipIndex, CommitteeMembershipRole committeeMembershipRole) {
        CommitteeMembershipBase committeeMembership = ((CommitteeBase)committee).getCommitteeMemberships().get(selectedMembershipIndex);
        committeeMembershipRole.setCommitteeMembershipIdFk(committeeMembership.getCommitteeMembershipId());
        committeeMembershipRole.refreshReferenceObject(REFERENCE_MEMBERSHIP_ROLE);
        committeeMembership.getMembershipRoles().add(committeeMembershipRole);
    }

    @Override
    public void deleteCommitteeMembershipRole(CMT committee, int selectedMembershipIndex, int lineNumber) {
        CommitteeMembershipBase committeeMembership = ((CommitteeBase)committee).getCommitteeMemberships().get(selectedMembershipIndex);
        CommitteeMembershipRole membershipRole = committeeMembership.getMembershipRoles().get(lineNumber);
        committeeMembership.getMembershipRoles().remove(membershipRole);
    }

    @Override
    public void addCommitteeMembershipExpertise(CommitteeMembershipBase committeeMembership, Collection<ResearchAreaBase> researchAreas) {
        for (ResearchAreaBase researchArea : researchAreas) {
            if (this.isDuplicateResearchArea(committeeMembership, researchArea)) continue;
            CommitteeMembershipExpertiseBase membershipExpertise = this.getNewCommitteeMembershipExpertiseInstanceHook();
            membershipExpertise.setResearchAreaCode(researchArea.getResearchAreaCode());
            membershipExpertise.setCommitteeMembershipIdFk(committeeMembership.getCommitteeMembershipId());
            membershipExpertise.refreshReferenceObject(REFERENCE_RESEARCH_AREA);
            committeeMembership.getMembershipExpertise().add(membershipExpertise);
        }
    }

    protected abstract CommitteeMembershipExpertiseBase getNewCommitteeMembershipExpertiseInstanceHook();

    private boolean isDuplicateResearchArea(CommitteeMembershipBase committeeMembership, ResearchAreaBase researchArea) {
        for (CommitteeMembershipExpertiseBase cme : committeeMembership.getMembershipExpertise()) {
            if (!researchArea.equals((Object)cme.getResearchArea())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteCommitteeMembershipExpertise(CMT committee, int selectedMembershipIndex, int lineNumber) {
        CommitteeMembershipBase committeeMembership = ((CommitteeBase)committee).getCommitteeMemberships().get(selectedMembershipIndex);
        CommitteeMembershipExpertiseBase committeeMembershipExpertise = committeeMembership.getMembershipExpertise().get(lineNumber);
        committeeMembership.getMembershipExpertise().remove(committeeMembershipExpertise);
    }

    @Override
    public boolean isMemberAssignedToReviewer(CommitteeMembershipBase member, String committeeId) {
        boolean isReviewer = false;
        for (ProtocolSubmissionBase submission : this.getProtocolSubmissionsForCommittee(committeeId)) {
            for (ProtocolReviewer reviewer : submission.getProtocolReviewers()) {
                if ((member.getPersonId() == null || !StringUtils.equals((String)reviewer.getPersonId(), (String)member.getPersonId())) && (member.getRolodexId() == null || !member.getRolodexId().equals(reviewer.getRolodexId()))) continue;
                isReviewer = true;
            }
        }
        return isReviewer;
    }

    @Override
    public boolean isMemberAttendedMeeting(CommitteeMembershipBase member, String committeeId) {
        boolean isAttendance = false;
        Object committee = this.committeeService.getCommitteeById(committeeId);
        if (committee != null) {
            for (CommitteeScheduleBase committeeSchedule : ((CommitteeBase)committee).getCommitteeSchedules()) {
                for (CommitteeScheduleAttendanceBase attendance : committeeSchedule.getCommitteeScheduleAttendances()) {
                    if (!StringUtils.equals((String)attendance.getPersonId(), (String)member.getPersonId()) && (member.getRolodexId() == null || !StringUtils.equals((String)attendance.getPersonId(), (String)member.getRolodexId().toString()))) continue;
                    isAttendance = true;
                }
            }
        }
        return isAttendance;
    }

    protected List<ProtocolSubmissionBase> getProtocolSubmissionsForCommittee(String committeeId) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("committeeId", committeeId);
        return (List)this.businessObjectService.findMatching(this.getProtocolSubmissionBOClassHook(), fieldMap);
    }

    protected abstract Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook();

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setCommitteeService(CSRV committeeService) {
        this.committeeService = committeeService;
    }
}

