/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.service.impl;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeResearchAreaBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.common.committee.meeting.CommScheduleMinuteDocBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.meeting.ScheduleAgendaBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class CommitteeServiceImplBase<CMT extends CommitteeBase<CMT, ?, CS>, CS extends CommitteeScheduleBase<CS, CMT, PS, CSM>, PS extends ProtocolSubmissionBase, CSM extends CommitteeScheduleMinuteBase<CSM, CS>>
implements CommitteeServiceBase<CMT, CS> {
    private static final String COMMITTEE_ID = "committeeId";
    private static final String NO_PLACE = "[no location]";
    private BusinessObjectService businessObjectService;
    private SequenceAccessorService sequenceAccessorService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public CMT getCommitteeById(String committeeId) {
        CommitteeBase committee = null;
        if (!StringUtils.isBlank((String)committeeId)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(COMMITTEE_ID, committeeId);
            Collection committees = this.businessObjectService.findMatching(this.getCommitteeBOClassHook(), fieldValues);
            if (committees.size() > 0) {
                committee = (CommitteeBase)Collections.max(committees);
            }
        }
        return (CMT)committee;
    }

    protected abstract Class<CMT> getCommitteeBOClassHook();

    @Override
    public void addResearchAreas(CMT committee, Collection<ResearchAreaBase> researchAreas) {
        for (ResearchAreaBase researchArea : researchAreas) {
            if (this.hasResearchArea(committee, researchArea)) continue;
            this.addCommitteeResearchArea(committee, researchArea);
        }
    }

    protected boolean hasResearchArea(CMT committee, ResearchAreaBase researchArea) {
        for (CommitteeResearchAreaBase committeeResearchArea : ((CommitteeBase)committee).getCommitteeResearchAreas()) {
            if (!StringUtils.equals((String)committeeResearchArea.getResearchAreaCode(), (String)researchArea.getResearchAreaCode())) continue;
            return true;
        }
        return false;
    }

    protected void addCommitteeResearchArea(CMT committee, ResearchAreaBase researchArea) {
        CommitteeResearchAreaBase committeeResearchArea = this.getNewCommitteeResearchAreaInstanceHook();
        committeeResearchArea.setCommittee((CommitteeBase)committee);
        committeeResearchArea.setCommitteeIdFk(((CommitteeBase)committee).getId());
        committeeResearchArea.setResearchArea(researchArea);
        committeeResearchArea.setResearchAreaCode(researchArea.getResearchAreaCode());
        ((CommitteeBase)committee).getCommitteeResearchAreas().add(committeeResearchArea);
    }

    protected abstract CommitteeResearchAreaBase getNewCommitteeResearchAreaInstanceHook();

    @Override
    public List<KeyValue> getAvailableCommitteeDates(String committeeId) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        CMT committee = this.getCommitteeById(committeeId);
        if (committee != null) {
            List schedules = ((CommitteeBase)committee).getCommitteeSchedules();
            Collections.sort(schedules);
            for (CommitteeScheduleBase schedule : schedules) {
                if (!this.isOkayToScheduleReview(committee, schedule)) continue;
                keyValues.add((KeyValue)new ConcreteKeyValue(schedule.getScheduleId(), this.getDescription(schedule)));
            }
        }
        return keyValues;
    }

    protected boolean isOkayToScheduleReview(CMT committee, CS schedule) {
        Calendar now = this.getCalendar(new java.util.Date());
        Calendar scheduleCalendar = this.getCalendar(((CommitteeScheduleBase)schedule).getScheduledDate());
        boolean dateRangeOK = now.compareTo(this.getCalendar(((CommitteeScheduleBase)schedule).getProtocolSubDeadline())) <= 0;
        boolean statusOK = "Scheduled".equals(((CommitteeScheduleBase)schedule).getScheduleStatus().getDescription());
        return dateRangeOK && statusOK;
    }

    protected Calendar getCalendar(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    protected String getDescription(CS schedule) {
        Date date = ((CommitteeScheduleBase)schedule).getScheduledDate();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm a");
        StringBuffer sb = new StringBuffer(dateFormat.format(date));
        sb.append(", ");
        if (((CommitteeScheduleBase)schedule).getPlace() == null) {
            sb.append(NO_PLACE);
        } else {
            sb.append(((CommitteeScheduleBase)schedule).getPlace());
        }
        sb.append(", ").append(timeFormat.format(((CommitteeScheduleBase)schedule).getActualTime()));
        return sb.toString();
    }

    @Override
    public List<CommitteeMembershipBase> getAvailableMembers(String committeeId, String scheduleId) {
        CS schedule;
        if (StringUtils.isBlank((String)scheduleId)) {
            return this.getAvailableMembersNow(committeeId);
        }
        ArrayList<CommitteeMembershipBase> availableMembers = new ArrayList<CommitteeMembershipBase>();
        CMT committee = this.getCommitteeById(committeeId);
        if (committee != null && (schedule = this.getCommitteeSchedule(committee, scheduleId)) != null) {
            List<CommitteeMembershipBase> members = ((CommitteeBase)committee).getCommitteeMemberships();
            for (CommitteeMembershipBase member : members) {
                if (!this.isMemberAvailable(member, ((CommitteeScheduleBase)schedule).getScheduledDate())) continue;
                availableMembers.add(member);
            }
        }
        return availableMembers;
    }

    @Override
    public List<CommitteeMembershipBase> getAvailableMembersNow(String committeeId) {
        ArrayList<CommitteeMembershipBase> availableMembers = new ArrayList<CommitteeMembershipBase>();
        CMT committee = this.getCommitteeById(committeeId);
        if (committee != null) {
            List<CommitteeMembershipBase> members = ((CommitteeBase)committee).getCommitteeMemberships();
            java.util.Date currentDate = new java.util.Date();
            for (CommitteeMembershipBase member : members) {
                if (!this.isMemberAvailable(member, currentDate)) continue;
                availableMembers.add(member);
            }
        }
        return availableMembers;
    }

    protected boolean isMemberAvailable(CommitteeMembershipBase member, java.util.Date scheduledDate) {
        Date sqlDate = new Date(scheduledDate.getTime());
        if (member.isActive(sqlDate)) {
            Calendar scheduleCalendar = this.getCalendar(scheduledDate);
            List<CommitteeMembershipRole> roles = member.getMembershipRoles();
            for (CommitteeMembershipRole role : roles) {
                Calendar startCalendar = this.getCalendar(role.getStartDate());
                Calendar endCalendar = this.getCalendar(role.getEndDate());
                if (scheduleCalendar.compareTo(startCalendar) < 0 || scheduleCalendar.compareTo(endCalendar) > 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public CS getCommitteeSchedule(CMT committee, String scheduleId) {
        List schedules = ((CommitteeBase)committee).getCommitteeSchedules();
        for (CommitteeScheduleBase schedule : schedules) {
            if (!StringUtils.equals((String)schedule.getScheduleId(), (String)scheduleId)) continue;
            return (CS)schedule;
        }
        return null;
    }

    @Override
    public List<CS> mergeCommitteeSchedule(String committeeId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(COMMITTEE_ID, committeeId);
        List committees = (List)this.businessObjectService.findMatching(this.getCommitteeBOClassHook(), fieldValues);
        Collections.sort(committees);
        CommitteeBase newCommittee = (CommitteeBase)committees.get(committees.size() - 1);
        CommitteeBase oldCommittee = (CommitteeBase)committees.get(committees.size() - 2);
        List<Object> copiedSchedules = new ArrayList();
        if (CollectionUtils.isNotEmpty(newCommittee.getCommitteeSchedules()) || CollectionUtils.isNotEmpty(oldCommittee.getCommitteeSchedules())) {
            copiedSchedules = this.copySchedules(newCommittee.getCommitteeSchedules(), oldCommittee.getCommitteeSchedules());
        }
        return copiedSchedules;
    }

    protected List<CS> copySchedules(List<CS> newSchedules, List<CS> oldSchedules) {
        ArrayList<CommitteeScheduleBase> copiedSchedules = new ArrayList<CommitteeScheduleBase>();
        for (CommitteeScheduleBase schedule : oldSchedules) {
            if (!this.isNotEmptyData(schedule) && !this.isInNewCommittee(schedule, newSchedules)) continue;
            CommitteeScheduleBase copiedSchedule = this.getCopiedSchedule(schedule);
            if (this.isInNewCommittee(schedule, newSchedules)) {
                CommitteeScheduleBase newSchedule = this.getNewCommitteeSchedule(schedule, newSchedules);
                copiedSchedule.setScheduleStatusCode(newSchedule.getScheduleStatusCode());
                copiedSchedule.setPlace(newSchedule.getPlace());
                copiedSchedule.setTime(newSchedule.getTime());
                copiedSchedule.setScheduledDate(newSchedule.getScheduledDate());
                copiedSchedule.setProtocolSubDeadline(newSchedule.getProtocolSubDeadline());
            }
            copiedSchedules.add(copiedSchedule);
        }
        for (CommitteeScheduleBase schedule : newSchedules) {
            if (this.isScheduleDateMatched(schedule, copiedSchedules)) continue;
            copiedSchedules.add(schedule);
        }
        return copiedSchedules;
    }

    protected boolean isNotEmptyData(CS schedule) {
        return CollectionUtils.isNotEmpty(((CommitteeScheduleBase)schedule).getCommitteeScheduleAttendances()) || CollectionUtils.isNotEmpty(((CommitteeScheduleBase)schedule).getCommitteeScheduleMinutes()) || CollectionUtils.isNotEmpty(((CommitteeScheduleBase)schedule).getCommScheduleActItems()) || CollectionUtils.isNotEmpty(((CommitteeScheduleBase)schedule).getMinuteDocs()) || CollectionUtils.isNotEmpty(((CommitteeScheduleBase)schedule).getScheduleAgendas()) || CollectionUtils.isNotEmpty(((CommitteeScheduleBase)schedule).getLatestProtocolSubmissions());
    }

    protected CS getCopiedSchedule(CS schedule) {
        CommitteeScheduleBase copiedSchedule = (CommitteeScheduleBase)ObjectUtils.deepCopy(schedule);
        copiedSchedule.setId(null);
        ((CommitteeScheduleBase)schedule).getCommScheduleActItems().size();
        copiedSchedule.setScheduleAgendas(((CommitteeScheduleBase)schedule).getScheduleAgendas());
        copiedSchedule.setMinuteDocs(((CommitteeScheduleBase)schedule).getMinuteDocs());
        copiedSchedule.setCommitteeScheduleAttendances(((CommitteeScheduleBase)schedule).getCommitteeScheduleAttendances());
        copiedSchedule.setCommitteeScheduleMinutes(((CommitteeScheduleBase)schedule).getCommitteeScheduleMinutes());
        copiedSchedule.setCommScheduleActItems(((CommitteeScheduleBase)schedule).getCommScheduleActItems());
        copiedSchedule.setProtocolSubmissions(((CommitteeScheduleBase)schedule).getLatestProtocolSubmissions());
        for (CommitteeScheduleAttendanceBase attendance : copiedSchedule.getCommitteeScheduleAttendances()) {
            attendance.setCommScheduleAttendanceId(null);
        }
        for (CommitteeScheduleMinuteBase minute : copiedSchedule.getCommitteeScheduleMinutes()) {
            minute.setCommScheduleMinutesId(null);
        }
        for (CommScheduleActItemBase actItem : copiedSchedule.getCommScheduleActItems()) {
            this.setActItemId(actItem, copiedSchedule.getCommitteeScheduleMinutes());
        }
        for (CommScheduleMinuteDocBase minuteDoc : copiedSchedule.getMinuteDocs()) {
            minuteDoc.setCommScheduleMinuteDocId(null);
        }
        for (ScheduleAgendaBase agenda : copiedSchedule.getScheduleAgendas()) {
            agenda.setScheduleAgendaId(null);
        }
        return (CS)copiedSchedule;
    }

    protected void setActItemId(CommScheduleActItemBase actItem, List<CSM> minutes) {
        Long nextCommScheduleActItemId = this.sequenceAccessorService.getNextAvailableSequenceNumber("SEQ_MEETING_ID");
        for (CommitteeScheduleMinuteBase minute : minutes) {
            if (minute.getCommScheduleActItemsIdFk() == null || !actItem.getCommScheduleActItemsId().equals(minute.getCommScheduleActItemsIdFk())) continue;
            minute.setCommScheduleActItemsIdFk(nextCommScheduleActItemId);
        }
        actItem.setCommScheduleActItemsId(nextCommScheduleActItemId);
    }

    protected boolean isScheduleDateMatched(CS schedule, List<CS> schedules) {
        for (CommitteeScheduleBase copiedSchedule : schedules) {
            if (!((CommitteeScheduleBase)schedule).getScheduledDate().equals(copiedSchedule.getScheduledDate())) continue;
            return true;
        }
        return false;
    }

    protected boolean isInNewCommittee(CS schedule, List<CS> schedules) {
        for (CommitteeScheduleBase newSchedule : schedules) {
            if (!StringUtils.equals((String)newSchedule.getScheduleId(), (String)((CommitteeScheduleBase)schedule).getScheduleId())) continue;
            return true;
        }
        return false;
    }

    protected CS getNewCommitteeSchedule(CS schedule, List<CS> schedules) {
        for (CommitteeScheduleBase newSchedule : schedules) {
            if (!StringUtils.equals((String)newSchedule.getScheduleId(), (String)((CommitteeScheduleBase)schedule).getScheduleId())) continue;
            return (CS)newSchedule;
        }
        return null;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

