/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.web.struts.action;

import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.common.committee.web.struts.form.CommitteeFormBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.impl.KraDocumentServiceImpl;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeActionBase
extends KraTransactionalDocumentActionBase {
    private static final Log LOG = LogFactory.getLog(CommitteeActionBase.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        return actionForward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeDocumentBase doc = committeeForm.getCommitteeDocument();
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("modifyCommittee", (CommitteeBase)doc.getCommittee());
        if (this.isAuthorized(task) && this.isValidSave(committeeForm)) {
            actionForward = super.save(mapping, form, request, response);
        }
        return actionForward;
    }

    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    protected boolean isValidSave(CommitteeFormBase committeeForm) {
        return true;
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        this.doProcessingAfterPost((KualiForm)committeeForm, request);
        return super.close(mapping, (ActionForm)committeeForm, request, response);
    }

    private KraDocumentServiceImpl getKraDocumentService() {
        return (KraDocumentServiceImpl)((Object)KraServiceLocator.getService("kraDocumentService"));
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String lookupResultsSequenceNumber;
        super.refresh(mapping, form, request, response);
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        if ("multipleValues".equals(committeeForm.getRefreshCaller()) && StringUtils.isNotBlank((String)(lookupResultsSequenceNumber = committeeForm.getLookupResultsSequenceNumber()))) {
            Class<?> lookupResultsBOClass = Class.forName(committeeForm.getLookupResultsBOClassName());
            String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            LookupResultsService service = KraServiceLocator.getService(LookupResultsService.class);
            Collection selectedBOs = service.retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, principalId);
            this.processMultipleLookupResults(committeeForm, lookupResultsBOClass, selectedBOs);
        }
        return mapping.findForward("basic");
    }

    protected void processMultipleLookupResults(CommitteeFormBase committeeForm, Class lookupResultsBOClass, Collection<PersistableBusinessObject> selectedBOs) {
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        String command = committeeForm.getCommand();
        if ("displayActionListInlineView".equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            committeeForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
            forward = mapping.findForward("basic");
            forward = new ActionForward(forward.getPath() + "?" + "docId" + "=" + docIdRequestParameter);
        } else if ("committeeActions".equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            committeeForm.setDocument(retrievedDocument);
            this.loadDocument((KualiDocumentFormBase)committeeForm);
            request.setAttribute("docId", (Object)docIdRequestParameter);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        if ("initiate".equals(committeeForm.getCommand())) {
            committeeForm.getCommitteeDocument().initialize();
        } else {
            committeeForm.initialize();
        }
        if ("committeeActions".equals(command)) {
            forward = this.committeeActions(mapping, (ActionForm)committeeForm, request, response);
        }
        return forward;
    }

    public ActionForward committee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        return mapping.findForward("committee");
    }

    public ActionForward committeeMembership(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        ((CommitteeFormBase)form).getCommitteeHelper().flagInactiveMembers();
        return mapping.findForward("committeeMembership");
    }

    public ActionForward committeeSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        WorkflowDocument workflowDocument = ((CommitteeFormBase)form).getCommitteeDocument().getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isEnroute() || workflowDocument.isFinal()) {
            ((CommitteeFormBase)form).getCommitteeDocument().getCommittee().refreshReferenceObject("committeeSchedules");
        }
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        return mapping.findForward("committeeSchedule");
    }

    public ActionForward committeeActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        return mapping.findForward("committeeActions");
    }

    protected KualiRuleService getKualiRuleService() {
        return KraServiceLocator.getService(KualiRuleService.class);
    }

    protected final boolean applyRules(KualiDocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.route(mapping, form, request, response);
        String routeHeaderId = ((CommitteeFormBase)form).getCommitteeDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "committeeActions", this.getCommitteeDocumentTypeSimpleNameHook());
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(forward, forward, holdingPageForward, returnLocation);
    }

    protected abstract String getCommitteeDocumentTypeSimpleNameHook();

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.blanketApprove(mapping, form, request, response);
        String routeHeaderId = ((CommitteeFormBase)form).getCommitteeDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "committeeActions", this.getCommitteeDocumentTypeSimpleNameHook());
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(forward, forward, holdingPageForward, returnLocation);
    }

    @Override
    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        super.populateAuthorizationFields(formBase);
        CommitteeFormBase committeeForm = (CommitteeFormBase)formBase;
        String command = committeeForm.getCommand();
        Map documentActions = formBase.getDocumentActions();
        if ("displayDocSearchView".equals(command) && documentActions.containsKey("canReload")) {
            documentActions.remove("canReload");
        }
    }
}

