/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.web.struts.action;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeBatchCorrespondenceBase;
import org.kuali.kra.common.committee.bo.CommitteeBatchCorrespondenceDetailBase;
import org.kuali.kra.common.committee.dao.CommitteeBatchCorrespondenceDao;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.common.committee.print.CommitteeReportType;
import org.kuali.kra.common.committee.print.service.CommitteePrintingServiceBase;
import org.kuali.kra.common.committee.rule.event.CommitteeActionFilterBatchCorrespondenceHistoryEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeActionGenerateBatchCorrespondenceEventBase;
import org.kuali.kra.common.committee.rule.event.CommitteeActionPrintCommitteeDocumentEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeActionViewBatchCorrespondenceEvent;
import org.kuali.kra.common.committee.service.CommitteeBatchCorrespondenceServiceBase;
import org.kuali.kra.common.committee.web.struts.action.CommitteeActionBase;
import org.kuali.kra.common.committee.web.struts.form.CommitteeFormBase;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

public abstract class CommitteeActionsActionBase
extends CommitteeActionBase {
    private static final Log LOG = LogFactory.getLog(CommitteeActionsActionBase.class);
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;

    public ActionForward generateBatchCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeDocumentBase committeeDocument = committeeForm.getCommitteeDocument();
        String committeeId = ((CommitteeBase)committeeDocument.getCommittee()).getCommitteeId();
        String batchCorrespondenceTypeCode = committeeForm.getCommitteeHelper().getGenerateBatchCorrespondenceTypeCode();
        Date startDate = committeeForm.getCommitteeHelper().getGenerateStartDate();
        Date endDate = committeeForm.getCommitteeHelper().getGenerateEndDate();
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("performCommitteeActions", (CommitteeBase)committeeDocument.getCommittee());
        if (this.isAuthorized(task) && this.applyRules((KualiDocumentEvent)this.getNewCommitteeActionGenerateBatchCorrespondenceEventInstanceHook("", committeeForm.getDocument(), batchCorrespondenceTypeCode, startDate, endDate, committeeId))) {
            committeeForm.getCommitteeHelper().getGenerateBatchCorrespondence().clear();
            committeeForm.getCommitteeHelper().getGenerateBatchCorrespondence().add(this.getCommitteeBatchCorrespondenceService().generateBatchCorrespondence(batchCorrespondenceTypeCode, committeeId, startDate, endDate));
        }
        return mapping.findForward("basic");
    }

    @Override
    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    protected abstract CommitteeActionGenerateBatchCorrespondenceEventBase getNewCommitteeActionGenerateBatchCorrespondenceEventInstanceHook(String var1, org.kuali.rice.krad.document.Document var2, String var3, Date var4, Date var5, String var6);

    public ActionForward filterBatchCorrespondenceHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        String batchCorrespondenceTypeCode = committeeForm.getCommitteeHelper().getHistoryBatchCorrespondenceTypeCode();
        Date startDate = committeeForm.getCommitteeHelper().getHistoryStartDate();
        Date endDate = committeeForm.getCommitteeHelper().getHistoryEndDate();
        committeeForm.getCommitteeHelper().resetBatchCorrespondenceHistory(committeeForm);
        if (this.applyRules((KualiDocumentEvent)new CommitteeActionFilterBatchCorrespondenceHistoryEvent("", committeeForm.getDocument(), batchCorrespondenceTypeCode, startDate, endDate))) {
            committeeForm.getCommitteeHelper().setBatchCorrespondenceHistory(this.getCommitteeBatchCorrespondenceDao().getCommitteeBatchCorrespondence(batchCorrespondenceTypeCode, startDate, endDate));
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewBatchCorrespondenceGenerated(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        List<CommitteeBatchCorrespondenceBase> committeeBatchCorrespondences = committeeForm.getCommitteeHelper().getGenerateBatchCorrespondence();
        return this.viewBatchCorrespondence(mapping, committeeForm, committeeBatchCorrespondences, true, response);
    }

    public ActionForward viewBatchCorrespondenceHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        List<CommitteeBatchCorrespondenceBase> committeeBatchCorrespondences = committeeForm.getCommitteeHelper().getBatchCorrespondenceHistory();
        return this.viewBatchCorrespondence(mapping, committeeForm, committeeBatchCorrespondences, false, response);
    }

    private ActionForward viewBatchCorrespondence(ActionMapping mapping, CommitteeFormBase committeeForm, List<CommitteeBatchCorrespondenceBase> committeeBatchCorrespondences, boolean viewBatch, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        ArrayList<String> bookmarksList = new ArrayList<String>();
        ArrayList<byte[]> pdfBaosList = new ArrayList<byte[]>();
        if (this.applyRules((KualiDocumentEvent)new CommitteeActionViewBatchCorrespondenceEvent("", committeeForm.getDocument(), committeeBatchCorrespondences, viewBatch))) {
            for (CommitteeBatchCorrespondenceBase committeeBatchCorrespondence : committeeBatchCorrespondences) {
                for (CommitteeBatchCorrespondenceDetailBase committeeBatchCorrespondenceDetail : committeeBatchCorrespondence.getCommitteeBatchCorrespondenceDetails()) {
                    if (!committeeBatchCorrespondenceDetail.getSelected()) continue;
                    bookmarksList.add("Protocol " + committeeBatchCorrespondenceDetail.getProtocolCorrespondence().getProtocolNumber() + ": " + committeeBatchCorrespondenceDetail.getProtocolAction().getComments());
                    pdfBaosList.add(committeeBatchCorrespondenceDetail.getProtocolCorrespondence().getCorrespondence());
                }
            }
            byte[] mergedPdfBytes = this.mergePdfBytes(pdfBaosList, bookmarksList);
            if (mergedPdfBytes == null) {
                mergedPdfBytes = new byte[]{};
            }
            this.streamToResponse(mergedPdfBytes, "correspondence.pdf", "application/pdf", response);
            actionForward = RESPONSE_ALREADY_HANDLED;
        }
        return actionForward;
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.reload(mapping, form, request, response);
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        return actionForward;
    }

    private byte[] mergePdfBytes(List<byte[]> pdfBytesList, List<String> bookmarksList) throws PrintingException {
        Document document = null;
        PdfWriter writer = null;
        ByteArrayOutputStream mergedPdfReport = new ByteArrayOutputStream();
        for (int count = 0; count < pdfBytesList.size(); ++count) {
            PdfReader reader;
            try {
                reader = new PdfReader(pdfBytesList.get(count));
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                break;
            }
            if (reader == null) {
                LOG.debug((Object)("Empty PDF bytes found for " + bookmarksList.get(count)));
                continue;
            }
            int nop = reader.getNumberOfPages();
            if (count == 0) {
                document = nop > 0 ? new Document(reader.getPageSizeWithRotation(1)) : new Document();
                try {
                    writer = PdfWriter.getInstance((Document)document, (OutputStream)mergedPdfReport);
                }
                catch (DocumentException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    throw new PrintingException(e.getMessage(), e);
                }
                document.open();
            }
            PdfContentByte cb = writer.getDirectContent();
            int pageCount = 0;
            while (pageCount < nop) {
                document.setPageSize(reader.getPageSize(++pageCount));
                document.newPage();
                PdfImportedPage page = writer.getImportedPage(reader, pageCount);
                cb.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                PdfOutline root = cb.getRootOutline();
                if (pageCount != 1) continue;
                String pageName = bookmarksList.get(count);
                cb.addOutline(new PdfOutline(root, new PdfDestination(2), pageName), pageName);
            }
        }
        if (document != null) {
            document.close();
            return mergedPdfReport.toByteArray();
        }
        return null;
    }

    public ActionForward printCommitteeDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeDocumentBase committeeDocument = committeeForm.getCommitteeDocument();
        Boolean printRooster = committeeForm.getCommitteeHelper().getPrintRooster();
        Boolean printFutureScheduledMeeting = committeeForm.getCommitteeHelper().getPrintFutureScheduledMeeting();
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("performCommitteeActions", (CommitteeBase)committeeDocument.getCommittee());
        if (this.isAuthorized(task) && this.applyRules((KualiDocumentEvent)new CommitteeActionPrintCommitteeDocumentEvent("", committeeForm.getDocument(), printRooster, printFutureScheduledMeeting))) {
            AttachmentDataSource dataStream;
            AbstractPrint printable;
            ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
            if (printRooster.booleanValue()) {
                printable = this.getCommitteePrintingService().getCommitteePrintable(CommitteeReportType.ROSTER);
                printable.setPrintableBusinessObject((KraPersistableBusinessObjectBase)((Object)committeeForm.getCommitteeDocument().getCommittee()));
                ((CommitteeBase)committeeForm.getCommitteeDocument().getCommittee()).setPrintRooster(true);
                printableArtifactList.add(printable);
            }
            if (printFutureScheduledMeeting.booleanValue()) {
                printable = this.getCommitteePrintingService().getCommitteePrintable(CommitteeReportType.FUTURE_SCHEDULED_MEETINGS);
                printable.setPrintableBusinessObject((KraPersistableBusinessObjectBase)((Object)committeeForm.getCommitteeDocument().getCommittee()));
                ((CommitteeBase)committeeForm.getCommitteeDocument().getCommittee()).setPrintRooster(false);
                printableArtifactList.add(printable);
            }
            if ((dataStream = this.getCommitteePrintingService().print(printableArtifactList)).getContent() != null) {
                this.streamToResponse(dataStream, response);
                actionForward = RESPONSE_ALREADY_HANDLED;
            }
        }
        return actionForward;
    }

    protected abstract CommitteeBatchCorrespondenceServiceBase getCommitteeBatchCorrespondenceService();

    protected abstract CommitteePrintingServiceBase getCommitteePrintingService();

    protected abstract CommitteeBatchCorrespondenceDao getCommitteeBatchCorrespondenceDao();
}

