/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.web.struts.action;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.common.committee.rules.CommitteeDocumentRuleBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.common.committee.web.struts.action.CommitteeActionBase;
import org.kuali.kra.common.committee.web.struts.form.CommitteeFormBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.impl.VersioningServiceImpl;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public abstract class CommitteeCommitteeActionBase
extends CommitteeActionBase {
    private static final String COMMITTEE_ID = "committeeId";
    private static final Log LOG = LogFactory.getLog(CommitteeCommitteeActionBase.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        String commandParam = request.getParameter("command");
        if (StringUtils.isNotBlank((String)commandParam) && commandParam.equals("initiate") && StringUtils.isNotBlank((String)request.getParameter(COMMITTEE_ID))) {
            Object committee = this.getCommitteeService().getCommitteeById(request.getParameter(COMMITTEE_ID));
            ((CommitteeBase)committee).setCommitteeDocument(null);
            committeeForm.getCommitteeDocument().setCommittee(committee);
            VersioningServiceImpl versionService = new VersioningServiceImpl();
            committeeForm.getCommitteeDocument().setCommittee((CommitteeBase)versionService.createNewVersion(committee));
            ((CommitteeBase)committeeForm.getCommitteeDocument().getCommittee()).setCommitteeDocument((CommitteeDocumentBase)committeeForm.getCommitteeDocument());
        }
        committeeForm.getCommitteeHelper().prepareView();
        return actionForward;
    }

    @Override
    protected void processMultipleLookupResults(CommitteeFormBase committeeForm, Class lookupResultsBOClass, Collection<PersistableBusinessObject> selectedBOs) {
        if (lookupResultsBOClass.isAssignableFrom(this.getResearchAreaBOClassHook())) {
            Object committee = committeeForm.getCommitteeDocument().getCommittee();
            this.getCommitteeService().addResearchAreas(committee, selectedBOs);
            this.getNewCommitteeDocumentRuleInstanceHook().validateCommitteeResearchAreas((CommitteeBase)committee);
        }
    }

    protected abstract Class<? extends ResearchAreaBase> getResearchAreaBOClassHook();

    protected abstract CommitteeDocumentRuleBase getNewCommitteeDocumentRuleInstanceHook();

    public ActionForward deleteResearchArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeDocumentBase committeeDocument = committeeForm.getCommitteeDocument();
        Object committee = committeeDocument.getCommittee();
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("modifyCommittee", (CommitteeBase)committee);
        if (this.isAuthorized(task)) {
            ((CommitteeBase)committee).getCommitteeResearchAreas().remove(this.getLineToDelete(request));
        }
        this.getNewCommitteeDocumentRuleInstanceHook().validateCommitteeResearchAreas((CommitteeBase)committee);
        return mapping.findForward("basic");
    }

    @Override
    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    private CommitteeServiceBase getCommitteeService() {
        return KraServiceLocator.getService(this.getCommitteeServiceBOClassHook());
    }

    protected abstract Class<? extends CommitteeServiceBase> getCommitteeServiceBOClassHook();
}

