/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.rule.event.AddCommitteeMembershipEvent;
import org.kuali.kra.common.committee.rule.event.AddCommitteeMembershipRoleEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeMemberEventBase;
import org.kuali.kra.common.committee.rule.event.DeleteCommitteeMemberEventBase;
import org.kuali.kra.common.committee.rules.CommitteeDocumentRuleBase;
import org.kuali.kra.common.committee.service.CommitteeMembershipServiceBase;
import org.kuali.kra.common.committee.web.struts.action.CommitteeActionBase;
import org.kuali.kra.common.committee.web.struts.form.CommitteeFormBase;
import org.kuali.kra.common.committee.web.struts.form.CommitteeHelperBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

public abstract class CommitteeMembershipActionBase
extends CommitteeActionBase {
    private static final Log LOG = LogFactory.getLog(CommitteeMembershipActionBase.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        if (!StringUtils.equals((String)((String)request.getAttribute("methodToCallAttribute")), (String)"methodToCall.refresh.x") && !StringUtils.startsWith((String)((String)request.getAttribute("methodToCallAttribute")), (String)"methodToCall.performLookup.")) {
            ((CommitteeFormBase)form).getCommitteeHelper().setMemberIndex(-1);
        }
        return actionForward;
    }

    public ActionForward addCommitteeMembership(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeMembershipBase newCommitteeMembership = committeeForm.getCommitteeHelper().getNewCommitteeMembership();
        boolean rulePassed = this.applyRules(new AddCommitteeMembershipEvent("", committeeForm.getCommitteeDocument(), newCommitteeMembership));
        if (rulePassed) {
            this.getCommitteeMembershipService().addCommitteeMembership(committeeForm.getCommitteeDocument().getCommittee(), newCommitteeMembership);
            committeeForm.getCommitteeHelper().setNewCommitteeMembership(this.getNewCommitteeMembershipInstanceHook());
        }
        return mapping.findForward("basic");
    }

    protected abstract CommitteeMembershipBase getNewCommitteeMembershipInstanceHook();

    public ActionForward deleteCommitteeMembership(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeDocumentBase committeeDocument = committeeForm.getCommitteeDocument();
        if (this.applyRules((KualiDocumentEvent)this.getNewDeleteCommitteeMemberEventInstanceHook("", committeeForm.getDocument(), ((CommitteeBase)committeeForm.getCommitteeDocument().getCommittee()).getCommitteeMemberships(), CommitteeMemberEventBase.ErrorType.HARDERROR))) {
            this.getCommitteeMembershipService().deleteCommitteeMembership(committeeDocument.getCommittee());
        }
        return mapping.findForward("basic");
    }

    protected abstract DeleteCommitteeMemberEventBase getNewDeleteCommitteeMemberEventInstanceHook(String var1, Document var2, List<CommitteeMembershipBase> var3, CommitteeMemberEventBase.ErrorType var4);

    public ActionForward clearCommitteeMembership(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeHelperBase committeeHelper = committeeForm.getCommitteeHelper();
        committeeHelper.setNewCommitteeMembership(this.getNewCommitteeMembershipInstanceHook());
        return mapping.findForward("basic");
    }

    public ActionForward addCommitteeMembershipRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        Object committee = committeeForm.getCommitteeDocument().getCommittee();
        int selectedMembershipIndex = this.getSelectedMembershipIndex(request);
        CommitteeMembershipRole newCommitteeMembershipRole = committeeForm.getCommitteeHelper().getNewCommitteeMembershipRoles().get(selectedMembershipIndex);
        boolean rulePassed = this.applyRules(new AddCommitteeMembershipRoleEvent("", committeeForm.getCommitteeDocument(), newCommitteeMembershipRole, selectedMembershipIndex));
        if (rulePassed) {
            this.getCommitteeMembershipService().addCommitteeMembershipRole(committee, selectedMembershipIndex, newCommitteeMembershipRole);
            committeeForm.getCommitteeHelper().setNewCommitteeMembershipRoles(new ArrayList<CommitteeMembershipRole>());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteCommitteeMembershipRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        Object committee = committeeForm.getCommitteeDocument().getCommittee();
        this.getCommitteeMembershipService().deleteCommitteeMembershipRole(committee, this.getSelectedMembershipIndex(request), this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String memberIndex = StringUtils.substringBetween((String)parameterName, (String)"memberIndex", (String)".");
        if (StringUtils.isNotBlank((String)memberIndex)) {
            ((CommitteeFormBase)form).getCommitteeHelper().setMemberIndex(Integer.parseInt(memberIndex));
        }
        return super.performLookup(mapping, form, request, response);
    }

    @Override
    protected void processMultipleLookupResults(CommitteeFormBase committeeForm, Class lookupResultsBOClass, Collection<PersistableBusinessObject> selectedBOs) {
        int membershipIndex = committeeForm.getCommitteeHelper().getMemberIndex();
        CommitteeMembershipBase committeeMembership = ((CommitteeBase)committeeForm.getCommitteeDocument().getCommittee()).getCommitteeMemberships().get(membershipIndex);
        if (lookupResultsBOClass.isAssignableFrom(this.getResearchAreaBOClassHook())) {
            this.getCommitteeMembershipService().addCommitteeMembershipExpertise(committeeMembership, selectedBOs);
            this.getNewCommitteeDocumentRuleInstanceHook().checkResearchAreasForCommitteeMember(committeeMembership, membershipIndex);
        }
    }

    protected abstract Class<? extends ResearchAreaBase> getResearchAreaBOClassHook();

    protected abstract CommitteeDocumentRuleBase getNewCommitteeDocumentRuleInstanceHook();

    public ActionForward deleteCommitteeMembershipExpertise(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        Object committee = committeeForm.getCommitteeDocument().getCommittee();
        int membershipIndex = this.getSelectedMembershipIndex(request);
        this.getCommitteeMembershipService().deleteCommitteeMembershipExpertise(committee, membershipIndex, this.getSelectedLine(request));
        this.getNewCommitteeDocumentRuleInstanceHook().checkResearchAreasForCommitteeMember(((CommitteeBase)committee).getCommitteeMemberships().get(membershipIndex), membershipIndex);
        return mapping.findForward("basic");
    }

    private CommitteeMembershipServiceBase getCommitteeMembershipService() {
        return KraServiceLocator.getService(this.getCommitteeMembershipServiceClassHook());
    }

    protected abstract Class<? extends CommitteeMembershipServiceBase> getCommitteeMembershipServiceClassHook();

    protected int getSelectedMembershipIndex(HttpServletRequest request) {
        int selectedMembershipIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            selectedMembershipIndex = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"committeeMemberships[", (String)"]."));
        }
        return selectedMembershipIndex;
    }

    public ActionForward showAllMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((CommitteeFormBase)form).getCommitteeHelper().setShowActiveMembersOnly(false);
        ((CommitteeFormBase)form).setTabStates(new HashMap());
        return mapping.findForward("basic");
    }

    public ActionForward showActiveMembersOnly(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((CommitteeFormBase)form).getCommitteeHelper().setShowActiveMembersOnly(true);
        ((CommitteeFormBase)form).setTabStates(new HashMap());
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.save(mapping, form, request, response);
        ((CommitteeFormBase)form).getCommitteeHelper().flagInactiveMembers();
        return actionForward;
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.route(mapping, form, request, response);
        ((CommitteeFormBase)form).getCommitteeHelper().flagInactiveMembers();
        return actionForward;
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.reload(mapping, form, request, response);
        ((CommitteeFormBase)form).getCommitteeHelper().flagInactiveMembers();
        return actionForward;
    }
}

