/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.web.struts.action;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDateConflictEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleDayEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleEventBase;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleFilterEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleStartAndEndDateEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleTimeEvent;
import org.kuali.kra.common.committee.rule.event.CommitteeScheduleWeekDayEvent;
import org.kuali.kra.common.committee.rule.event.DeleteCommitteeScheduleEventBase;
import org.kuali.kra.common.committee.rules.CommitteeScheduleDataDictionaryValidationRule;
import org.kuali.kra.common.committee.service.CommitteeScheduleServiceBase;
import org.kuali.kra.common.committee.web.struts.action.CommitteeActionBase;
import org.kuali.kra.common.committee.web.struts.form.CommitteeFormBase;
import org.kuali.kra.common.committee.web.struts.form.schedule.ScheduleData;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

public abstract class CommitteeScheduleActionBase
extends CommitteeActionBase {
    private static final Log LOG = LogFactory.getLog(CommitteeScheduleActionBase.class);
    private static final String DELETE_QUESTION = "Are you sure you want to delete?";
    private static final String DELETE_QUESTION_ID = "committeeSchedule.delete.question";
    public static final boolean FALSE = false;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        ((CommitteeFormBase)form).getCommitteeHelper().prepareView();
        return actionForward;
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        ScheduleData scheduleData = committeeForm.getCommitteeHelper().getScheduleData();
        ActionForward actionForward = super.save(mapping, form, request, response);
        scheduleData.populateStyleClass();
        return actionForward;
    }

    public ActionForward addEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        ScheduleData scheduleData = committeeForm.getCommitteeHelper().getScheduleData();
        boolean flag = false;
        flag = new CommitteeScheduleDataDictionaryValidationRule().applyRules(scheduleData);
        flag &= this.applyRules((KualiDocumentEvent)new CommitteeScheduleWeekDayEvent("", committeeForm.getDocument(), scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR));
        flag &= this.applyRules((KualiDocumentEvent)new CommitteeScheduleDayEvent("", committeeForm.getDocument(), scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR));
        flag &= this.applyRules((KualiDocumentEvent)new CommitteeScheduleTimeEvent("", committeeForm.getDocument(), scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR));
        if (flag &= this.applyRules((KualiDocumentEvent)new CommitteeScheduleStartAndEndDateEvent("", committeeForm.getDocument(), scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR))) {
            CommitteeScheduleServiceBase service = this.getCommitteeScheduleService();
            service.addSchedule(scheduleData, committeeForm.getCommitteeDocument().getCommittee());
            this.applyRules((KualiDocumentEvent)new CommitteeScheduleDateConflictEvent("", committeeForm.getDocument(), scheduleData, null, CommitteeScheduleEventBase.ErrorType.SOFTERROR));
            committeeForm.getCommitteeHelper().prepareView();
        }
        scheduleData.populateStyleClass();
        return mapping.findForward("basic");
    }

    public ActionForward deleteCommitteeSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        String question = request.getParameter("questionIndex");
        String methodToCall = committeeForm.getMethodToCall();
        if (question == null) {
            if (this.applyRules((KualiDocumentEvent)this.getNewDeleteCommitteeScheduleEventInstanceHook("", committeeForm.getDocument(), null, ((CommitteeBase)committeeForm.getCommitteeDocument().getCommittee()).getCommitteeSchedules(), CommitteeScheduleEventBase.ErrorType.HARDERROR))) {
                return this.performQuestionWithoutInput(mapping, form, request, response, DELETE_QUESTION_ID, DELETE_QUESTION, "confirmationQuestion", methodToCall, "");
            }
        } else {
            String buttonClicked = request.getParameter("buttonClicked");
            if (DELETE_QUESTION_ID.equals(question) && "0".equals(buttonClicked)) {
                List list = ((CommitteeBase)committeeForm.getCommitteeDocument().getCommittee()).getCommitteeSchedules();
                ArrayList updatedlist = new ArrayList(list);
                Collections.copy(updatedlist, list);
                for (CommitteeScheduleBase schedule : list) {
                    if (!schedule.isSelected()) continue;
                    updatedlist.remove(schedule);
                }
                ((CommitteeBase)committeeForm.getCommitteeDocument().getCommittee()).setCommitteeSchedules(updatedlist);
            }
        }
        return mapping.findForward("basic");
    }

    protected abstract DeleteCommitteeScheduleEventBase getNewDeleteCommitteeScheduleEventInstanceHook(String var1, Document var2, ScheduleData var3, List<CommitteeScheduleBase> var4, CommitteeScheduleEventBase.ErrorType var5);

    public ActionForward filterCommitteeScheduleDates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        ScheduleData scheduleData = committeeForm.getCommitteeHelper().getScheduleData();
        if (this.applyRules((KualiDocumentEvent)new CommitteeScheduleFilterEvent("", committeeForm.getDocument(), scheduleData, null, CommitteeScheduleEventBase.ErrorType.HARDERROR))) {
            Date startDate = scheduleData.getFilterStartDate();
            Date endDate = scheduleData.getFilerEndDate();
            committeeForm.getCommitteeHelper().prepareFilterDatesView(startDate, endDate);
        }
        return mapping.findForward("basic");
    }

    public ActionForward resetCommitteeScheduleDates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        committeeForm.getCommitteeHelper().resetFilterDatesView();
        return mapping.findForward("basic");
    }

    public ActionForward loadRecurrence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        committeeForm.getCommitteeHelper().getScheduleData().populateStyleClass();
        return mapping.findForward("basic");
    }

    private CommitteeScheduleServiceBase getCommitteeScheduleService() {
        return KraServiceLocator.getService(this.getCommitteeScheduleServiceClassHook());
    }

    protected abstract Class<? extends CommitteeScheduleServiceBase> getCommitteeScheduleServiceClassHook();

    public ActionForward maintainSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeScheduleBase commSchedule = (CommitteeScheduleBase)((CommitteeBase)((CommitteeDocumentBase)committeeForm.getDocument()).getCommittee()).getCommitteeSchedules().get(this.getLineToDelete(request));
        return new ActionRedirect(this.getMeetingManagementActionIdHook() + ".do?methodToCall=start&scheduleId=" + commSchedule.getId() + "&lineNum=" + (this.getLineToDelete(request) + 1) + "&readOnly=" + !committeeForm.getCommitteeHelper().canModifySchedule());
    }

    protected abstract String getMeetingManagementActionIdHook();
}

