/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.committee.web.struts.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.web.struts.form.CommitteeHelperBase;
import org.kuali.kra.web.struts.form.KraTransactionalDocumentFormBase;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.CollectionUtils;

public abstract class CommitteeFormBase
extends KraTransactionalDocumentFormBase {
    private CommitteeHelperBase committeeHelper;
    private static final Log LOG = LogFactory.getLog(CommitteeFormBase.class);
    private String lookupResultsSequenceNumber;
    private String lookupResultsBOClassName;

    public CommitteeFormBase() {
        this.initialize();
    }

    @Override
    protected abstract String getDefaultDocumentTypeName();

    public void initialize() {
        this.setCommitteeHelper(this.getNewCommitteeHelperInstanceHook(this));
    }

    protected abstract CommitteeHelperBase getNewCommitteeHelperInstanceHook(CommitteeFormBase var1);

    public CommitteeDocumentBase getCommitteeDocument() {
        return (CommitteeDocumentBase)this.getDocument();
    }

    @Override
    public void populate(HttpServletRequest request) {
        super.populate(request);
    }

    protected String getCommitteeNameForHeaderDisplay(CommitteeDocumentBase committeeDoc) {
        String trimmedCommitteeName = null;
        if (committeeDoc != null && !CollectionUtils.isEmpty(committeeDoc.getCommitteeList()) && StringUtils.isNotEmpty((String)(trimmedCommitteeName = ((CommitteeBase)committeeDoc.getCommittee()).getCommitteeName())) && trimmedCommitteeName.length() > 60) {
            trimmedCommitteeName = trimmedCommitteeName.substring(0, 60);
        }
        return trimmedCommitteeName;
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        CommitteeDocumentBase committeeDoc = this.getCommitteeDocument();
        HeaderField documentNumber = (HeaderField)this.getDocInfo().get(0);
        documentNumber.setDdAttributeEntryName("DataDictionary.CommitteeDocument.attributes.documentNumber");
        if (CollectionUtils.isEmpty(committeeDoc.getCommitteeList())) {
            ObjectUtils.materializeObjects(committeeDoc.getCommitteeList());
        }
        String lastUpdatedDateStr = null;
        if (committeeDoc != null && committeeDoc.getUpdateTimestamp() != null) {
            lastUpdatedDateStr = CoreApiServiceLocator.getDateTimeService().toString((Date)committeeDoc.getUpdateTimestamp(), "hh:mm a MM/dd/yyyy");
        }
        HeaderField lastUpdatedDate = new HeaderField("DataDictionary.CommitteeDocument.attributes.updateTimestamp", lastUpdatedDateStr);
        this.getDocInfo().set(3, lastUpdatedDate);
        this.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.committeeId", committeeDoc == null || CollectionUtils.isEmpty(committeeDoc.getCommitteeList()) ? null : ((CommitteeBase)committeeDoc.getCommittee()).getCommitteeId()));
        this.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.committeeName", this.getCommitteeNameForHeaderDisplay(committeeDoc)));
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.setLookupResultsSequenceNumber(null);
        this.setLookupResultsBOClassName(null);
    }

    public String getLookupResultsSequenceNumber() {
        return this.lookupResultsSequenceNumber;
    }

    public void setLookupResultsSequenceNumber(String lookupResultsSequenceNumber) {
        this.lookupResultsSequenceNumber = lookupResultsSequenceNumber;
    }

    public String getLookupResultsBOClassName() {
        return this.lookupResultsBOClassName;
    }

    public void setLookupResultsBOClassName(String lookupResultsBOClassName) {
        this.lookupResultsBOClassName = lookupResultsBOClassName;
    }

    @Override
    protected void setSaveDocumentControl(Map editMode) {
        this.getDocumentActions().put("canSave", "true");
    }

    @Override
    protected String getLockRegion() {
        return "COMMITTEE";
    }

    public CommitteeHelperBase getCommitteeHelper() {
        return this.committeeHelper;
    }

    public void setCommitteeHelper(CommitteeHelperBase committeeHelper) {
        this.committeeHelper = committeeHelper;
    }

    public boolean isPropertyEditable(String propertyName) {
        if (propertyName.startsWith("document.committeeList[0].committeeMemberships[")) {
            return true;
        }
        return super.isPropertyEditable(propertyName);
    }

    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] navigation = super.getHeaderNavigationTabs();
        ArrayList<HeaderNavigation> resultList = new ArrayList<HeaderNavigation>();
        for (int i = 0; i < navigation.length; ++i) {
            if (!StringUtils.equals((String)"Actions", (String)navigation[i].getHeaderTabDisplayName())) {
                resultList.add(navigation[i]);
                continue;
            }
            if (StringUtils.equals((String)"initiate", (String)this.getCommand())) continue;
            resultList.add(navigation[i]);
        }
        HeaderNavigation[] result = new HeaderNavigation[resultList.size()];
        resultList.toArray(result);
        return result;
    }
}

