/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.customattributes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cxf.common.util.StringUtils;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.CustomAttributeService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CustomDataHelperBase<T extends DocumentCustomData>
implements Serializable {
    private SortedMap<String, List> customAttributeGroups = new TreeMap<String, List>();
    private boolean modifyCustomData = false;

    public void buildCustomDataCollectionsOnExistingDocument(SortedMap<String, List> customAttributeGroups) {
        for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : this.getCustomAttributeDocuments().entrySet()) {
            DocumentCustomData loopAwardCustomData = null;
            for (DocumentCustomData awardCustomData : this.getCustomDataList()) {
                if (awardCustomData.getCustomAttributeId() != (long)customAttributeDocumentEntry.getValue().getCustomAttribute().getId().intValue()) continue;
                loopAwardCustomData = awardCustomData;
                break;
            }
            if (loopAwardCustomData == null) continue;
            String groupName = this.getCustomAttributeDocuments().get(loopAwardCustomData.getCustomAttributeId().toString()).getCustomAttribute().getGroupName();
            ArrayList<CustomAttributeDocument> customAttributeDocumentList = (ArrayList<CustomAttributeDocument>)customAttributeGroups.get(groupName);
            if (customAttributeDocumentList == null) {
                customAttributeDocumentList = new ArrayList<CustomAttributeDocument>();
                customAttributeGroups.put(groupName, customAttributeDocumentList);
            }
            customAttributeDocumentList.add(this.getCustomAttributeDocuments().get(loopAwardCustomData.getCustomAttributeId().toString()));
            Collections.sort(customAttributeDocumentList, new LabelComparator());
        }
    }

    public void buildCustomDataCollectionsOnNewDocument(SortedMap<String, List> customAttributeGroups) {
        for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : this.getCustomAttributeDocuments().entrySet()) {
            ArrayList<CustomAttributeDocument> customAttributeDocumentList;
            String temp = customAttributeDocumentEntry.getValue().getCustomAttribute().getValue();
            String groupName = customAttributeDocumentEntry.getValue().getCustomAttribute().getGroupName();
            T newCustomData = this.getNewCustomData();
            newCustomData.setCustomAttribute(customAttributeDocumentEntry.getValue().getCustomAttribute());
            newCustomData.setCustomAttributeId(customAttributeDocumentEntry.getValue().getCustomAttributeId().longValue());
            newCustomData.setValue(customAttributeDocumentEntry.getValue().getCustomAttribute().getDefaultValue());
            this.getCustomDataList().add(newCustomData);
            if (StringUtils.isEmpty((String)groupName)) {
                groupName = "No Group";
            }
            if ((customAttributeDocumentList = (ArrayList<CustomAttributeDocument>)customAttributeGroups.get(groupName)) == null) {
                customAttributeDocumentList = new ArrayList<CustomAttributeDocument>();
                customAttributeGroups.put(groupName, customAttributeDocumentList);
            }
            customAttributeDocumentList.add(this.getCustomAttributeDocuments().get(customAttributeDocumentEntry.getValue().getCustomAttributeId().toString()));
            Collections.sort(customAttributeDocumentList, new LabelComparator());
        }
    }

    public void prepareCustomData() {
        this.initializePermissions();
        TreeMap<String, List> customAttributeGroups = new TreeMap<String, List>();
        if (this.getCustomDataList().size() > 0) {
            this.buildCustomDataCollectionsOnExistingDocument(customAttributeGroups);
        } else {
            this.buildCustomDataCollectionsOnNewDocument(customAttributeGroups);
        }
        this.setCustomAttributeGroups(customAttributeGroups);
    }

    protected abstract T getNewCustomData();

    public abstract List<T> getCustomDataList();

    public abstract Map<String, CustomAttributeDocument> getCustomAttributeDocuments();

    public String getValidCustomAttributeGroupName(String groupName) {
        return groupName != null ? groupName : "Custom Data Group";
    }

    public void initializePermissions() {
        this.modifyCustomData = this.canModifyCustomData();
    }

    public boolean canModifyCustomData() {
        return this.modifyCustomData;
    }

    public boolean getModifyCustomData() {
        return this.modifyCustomData;
    }

    public void setCustomAttributeGroups(SortedMap<String, List> customAttributeGroups) {
        this.customAttributeGroups = customAttributeGroups;
    }

    public Map<String, List> getCustomAttributeGroups() {
        return this.customAttributeGroups;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public void setCustomAttributeContent(String documentNumber, String attributeName) {
        this.getCustomAttributeService().setCustomAttributeKeyValue(documentNumber, this.getCustomAttributeDocuments(), attributeName, this.getUserIdentifier());
    }

    protected CustomAttributeService getCustomAttributeService() {
        return KraServiceLocator.getService(CustomAttributeService.class);
    }

    public class LabelComparator
    implements Comparator {
        public int compare(Object cad1, Object cad2) {
            try {
                String label1 = ((CustomAttributeDocument)((Object)cad1)).getCustomAttribute().getLabel();
                String label2 = ((CustomAttributeDocument)((Object)cad2)).getCustomAttribute().getLabel();
                if (label1 == null) {
                    label1 = "";
                }
                if (label2 == null) {
                    label2 = "";
                }
                return label1.compareTo(label2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

