/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.NotificationModuleRole;
import org.kuali.kra.common.notification.bo.NotificationModuleRoleQualifier;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.exception.UnknownRoleException;
import org.kuali.kra.common.notification.service.KcNotificationModuleRoleService;
import org.kuali.kra.common.notification.service.KcNotificationRoleQualifierService;
import org.kuali.kra.common.notification.service.KcNotificationService;

public abstract class NotificationContextBase
implements NotificationContext,
Serializable {
    private static final long serialVersionUID = -6135354658158890714L;
    private transient NotificationRenderer renderer;
    private transient KcNotificationService notificationService;
    private transient KcNotificationModuleRoleService notificationModuleRoleService;
    private transient KcNotificationRoleQualifierService notificationRoleQualifierService;

    public NotificationContextBase(NotificationRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public String replaceContextVariables(String text) {
        return this.renderer.render(text);
    }

    @Override
    public void populateRoleQualifiers(NotificationTypeRecipient notificationRecipient) throws UnknownRoleException {
        List<NotificationModuleRole> moduleRoles = this.getNotificationModuleRoleService().getNotificationModuleRolesForKimRole(this.getModuleCode(), notificationRecipient.getRoleName());
        if (CollectionUtils.isNotEmpty(moduleRoles)) {
            if (notificationRecipient.getRoleQualifiers() == null) {
                notificationRecipient.setRoleQualifiers(new HashMap<String, String>());
            }
            for (NotificationModuleRole mRole : moduleRoles) {
                List<NotificationModuleRoleQualifier> moduleQualifiers = mRole.getRoleQualifiers();
                if (!CollectionUtils.isNotEmpty(moduleQualifiers)) continue;
                for (NotificationModuleRoleQualifier mQualifier : moduleQualifiers) {
                    notificationRecipient.getRoleQualifiers().put(mQualifier.getQualifier(), this.getNotificationRoleQualifierService().getRoleQualifierValue(mQualifier));
                }
            }
            if (StringUtils.isNotBlank((String)notificationRecipient.getRoleSubQualifier())) {
                notificationRecipient.getRoleQualifiers().put("subQualifier", notificationRecipient.getRoleSubQualifier());
            }
        } else {
            throw new UnknownRoleException(notificationRecipient.getRoleName(), this.getContextName());
        }
    }

    public KcNotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public KcNotificationModuleRoleService getNotificationModuleRoleService() {
        return this.notificationModuleRoleService;
    }

    public void setNotificationModuleRoleService(KcNotificationModuleRoleService notificationModuleRoleService) {
        this.notificationModuleRoleService = notificationModuleRoleService;
    }

    public KcNotificationRoleQualifierService getNotificationRoleQualifierService() {
        return this.notificationRoleQualifierService;
    }

    public void setNotificationRoleQualifierService(KcNotificationRoleQualifierService notificationRoleQualifierService) {
        this.notificationRoleQualifierService = notificationRoleQualifierService;
    }

    public NotificationRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(NotificationRenderer renderer) {
        this.renderer = renderer;
    }
}

