/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.bo;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.notification.bo.NotificationType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class NotificationTypeMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = 5816092888763754328L;
    private static final String NOTIFICATION_TYPE_ID_SEQUENCE_NAME = "SEQ_NOTIFICATION_TYPE_ID";
    private static final String NOTIFICATION_TYPE_SECTION_ID = "Edit Notification Types";
    private static final String NOTIFICATION_TYPE_ID_NAME = "notificationTypeId";
    private transient SequenceAccessorService sequenceAccessorService;

    public void setGenerateDefaultValues(String docTypeName) {
        super.setGenerateDefaultValues(docTypeName);
        NotificationType notificationType = (NotificationType)this.getBusinessObject();
        Long nextNotificationTypeId = this.getSequenceAccessorService().getNextAvailableSequenceNumber(NOTIFICATION_TYPE_ID_SEQUENCE_NAME, NotificationType.class);
        notificationType.setNotificationTypeId(nextNotificationTypeId);
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        for (Section section : sections) {
            if (!StringUtils.equals((String)section.getSectionId(), (String)NOTIFICATION_TYPE_SECTION_ID)) continue;
            for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (!StringUtils.equals((String)field.getPropertyName(), (String)NOTIFICATION_TYPE_ID_NAME)) continue;
                    field.setReadOnly(true);
                }
            }
        }
        return sections;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KraServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

