/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.common.notification.bo.NotificationModuleRole;
import org.kuali.kra.common.notification.bo.NotificationType;
import org.kuali.kra.common.notification.lookup.keyvalue.KeyLabelSortByValue;
import org.kuali.kra.common.notification.service.KcNotificationModuleRoleService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class NotificationTypeRecipientRoleNameValuesFinder
extends KeyValuesBase {
    private KeyValuesService keyValuesService;

    public List<KeyValue> getKeyValues() {
        List<NotificationModuleRole> moduleRoles;
        NotificationType notificationType;
        Document doc;
        String moduleCode = null;
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form != null && form instanceof KualiDocumentFormBase && (doc = ((KualiDocumentFormBase)form).getDocument()) != null && (notificationType = (NotificationType)doc.getNoteTarget()) != null) {
            moduleCode = notificationType.getModuleCode();
        }
        ArrayList<KeyLabelSortByValue> keyValues = new ArrayList<KeyLabelSortByValue>();
        keyValues.add(new KeyLabelSortByValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        if (moduleCode != null && CollectionUtils.isNotEmpty(moduleRoles = this.getKcNotificationModuleRoleService().getNotificationModuleRoles(moduleCode))) {
            for (NotificationModuleRole moduleRole : moduleRoles) {
                keyValues.add(new KeyLabelSortByValue(moduleRole.getRoleName(), moduleRole.getRoleName()));
            }
        }
        Collections.sort(keyValues);
        ArrayList<KeyValue> returnKeyValues = new ArrayList<KeyValue>();
        returnKeyValues.addAll(keyValues);
        return returnKeyValues;
    }

    public KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = KraServiceLocator.getService(KeyValuesService.class);
        }
        return this.keyValuesService;
    }

    public void setKeyValuesService(KeyValuesService keyValuesService) {
        this.keyValuesService = keyValuesService;
    }

    public KcNotificationModuleRoleService getKcNotificationModuleRoleService() {
        return KraServiceLocator.getService(KcNotificationModuleRoleService.class);
    }
}

