/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.rule;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.rule.event.AddNotificationRecipientEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class AddNotificationRecipientRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<AddNotificationRecipientEvent> {
    private static final String FULL_NAME_FIELD = "fullName";

    @Override
    public boolean processRules(AddNotificationRecipientEvent addNotificationRecipientEvent) {
        boolean rulePassed = true;
        NotificationTypeRecipient notificationTypeRecipient = addNotificationRecipientEvent.getNotificationTypeRecipient();
        List<NotificationTypeRecipient> notificationTypeRecipients = addNotificationRecipientEvent.getNotificationTypeRecipients();
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)notificationTypeRecipient);
        rulePassed &= GlobalVariables.getMessageMap().hasNoErrors();
        rulePassed &= this.validateRecipient(notificationTypeRecipient);
        return rulePassed &= this.validateUniqueRecipients(notificationTypeRecipient, notificationTypeRecipients);
    }

    private boolean validateRecipient(NotificationTypeRecipient notificationTypeRecipient) {
        boolean isValid = true;
        if (StringUtils.isBlank((String)notificationTypeRecipient.getRoleName()) && StringUtils.isBlank((String)notificationTypeRecipient.getPersonId()) && StringUtils.isBlank((String)notificationTypeRecipient.getRolodexId())) {
            isValid = false;
            this.reportError(FULL_NAME_FIELD, "error.notification.empty.notifcation.recipient", new String[0]);
        }
        return isValid;
    }

    private boolean validateUniqueRecipients(NotificationTypeRecipient newNotificationTypeRecipient, List<NotificationTypeRecipient> existingNotificationTypeRecipients) {
        boolean isValid = true;
        for (NotificationTypeRecipient existingNotificationTypeRecipient : existingNotificationTypeRecipients) {
            if (!AddNotificationRecipientRule.isIdentifierEqual(newNotificationTypeRecipient.getRoleName(), existingNotificationTypeRecipient.getRoleName()) && !AddNotificationRecipientRule.isIdentifierEqual(newNotificationTypeRecipient.getPersonId(), existingNotificationTypeRecipient.getPersonId()) && !AddNotificationRecipientRule.isIdentifierEqual(newNotificationTypeRecipient.getRolodexId(), existingNotificationTypeRecipient.getRolodexId())) continue;
            isValid = false;
            this.reportError(FULL_NAME_FIELD, "error.notification.duplicate.notification.recipient", new String[0]);
        }
        return isValid;
    }

    private static boolean isIdentifierEqual(String newIdentifier, String existingIdentifier) {
        return (StringUtils.isNotBlank((String)newIdentifier) || StringUtils.isNotBlank((String)existingIdentifier)) && StringUtils.equals((String)newIdentifier, (String)existingIdentifier);
    }
}

