/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.service.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.common.notification.bo.NotificationModuleRole;
import org.kuali.kra.common.notification.service.KcNotificationModuleRoleService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class KcNotificationModuleRoleServiceImpl
implements KcNotificationModuleRoleService {
    private BusinessObjectService businessObjectService;

    @Override
    public NotificationModuleRole addNotificationModuleRole(String moduleCode, String roleName) {
        NotificationModuleRole moduleRole = new NotificationModuleRole();
        moduleRole.setModuleCode(moduleCode);
        moduleRole.setRoleName(roleName);
        this.getBusinessObjectService().save((PersistableBusinessObject)moduleRole);
        return moduleRole;
    }

    @Override
    public List<NotificationModuleRole> getNotificationModuleRoles(String moduleCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleCode", moduleCode);
        List moduleRoles = (List)this.getBusinessObjectService().findMatching(NotificationModuleRole.class, fieldValues);
        return moduleRoles;
    }

    @Override
    public String getNotificationModuleRolesString(String moduleCode) {
        String resultStr = "";
        List<NotificationModuleRole> moduleRoles = this.getNotificationModuleRoles(moduleCode);
        if (CollectionUtils.isNotEmpty(moduleRoles)) {
            for (NotificationModuleRole moduleRole : moduleRoles) {
                resultStr = resultStr + moduleRole.getRoleName() + ",";
            }
        }
        return resultStr;
    }

    @Override
    public List<NotificationModuleRole> getNotificationModuleRolesForKimRole(String moduleCode, String roleName) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleCode", moduleCode);
        fieldValues.put("roleName", roleName);
        List moduleRoles = (List)this.getBusinessObjectService().findMatching(NotificationModuleRole.class, fieldValues);
        return moduleRoles;
    }

    @Override
    public void saveNotificationModuleRoles(List<NotificationModuleRole> notificationModuleRoles) {
        this.getBusinessObjectService().save(notificationModuleRoles);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

