/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.notification.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.bo.NotificationType;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.exception.UnknownRoleException;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.service.KcEmailService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.RolodexService;
import org.kuali.kra.util.EmailAttachment;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.ken.api.notification.Notification;
import org.kuali.rice.ken.api.notification.NotificationChannel;
import org.kuali.rice.ken.api.notification.NotificationChannelContract;
import org.kuali.rice.ken.api.notification.NotificationContentType;
import org.kuali.rice.ken.api.notification.NotificationPriority;
import org.kuali.rice.ken.api.notification.NotificationProducer;
import org.kuali.rice.ken.api.notification.NotificationProducerContract;
import org.kuali.rice.ken.api.notification.NotificationRecipient;
import org.kuali.rice.ken.api.notification.NotificationSender;
import org.kuali.rice.ken.api.service.SendNotificationService;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class KcNotificationServiceImpl
implements KcNotificationService {
    private static final String MODULE_CODE = "moduleCode";
    private static final String ACTION_CODE = "actionCode";
    private static final String NOTIFICATION_TYPE_ID = "notificationTypeId";
    private static final String DOCUMENT_NUMBER = "documentNumber";
    private static final Log LOG = LogFactory.getLog(KcNotificationServiceImpl.class);
    protected NotificationChannel kcNotificationChannel;
    protected NotificationProducer systemNotificationProducer;
    private BusinessObjectService businessObjectService;
    private SendNotificationService sendNotificationService;
    private RoleService roleManagementService;
    private KcPersonService kcPersonService;
    private RolodexService rolodexService;
    private ParameterService parameterService;
    private IdentityService identityService;
    private KcEmailService kcEmailService;

    @Override
    public NotificationType getNotificationType(NotificationContext context) {
        return this.getNotificationType(context.getModuleCode(), context.getActionTypeCode());
    }

    @Override
    public NotificationType getNotificationType(String moduleCode, String actionTypeCode) {
        NotificationType notificationType = null;
        ArrayList notificationTypes = new ArrayList();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_CODE, moduleCode);
        fieldValues.put(ACTION_CODE, actionTypeCode);
        notificationTypes.addAll(this.getBusinessObjectService().findMatching(NotificationType.class, fieldValues));
        if (!notificationTypes.isEmpty()) {
            notificationType = (NotificationType)((Object)notificationTypes.get(0));
        }
        return notificationType;
    }

    @Override
    public KcNotification createNotificationObject(NotificationContext context) {
        KcNotification notification = new KcNotification();
        NotificationType notificationType = this.getNotificationType(context);
        if (notificationType != null) {
            notification.setNotificationTypeId(notificationType.getNotificationTypeId());
            notification.setDocumentNumber(context.getDocumentNumber());
            String instanceSubject = context.replaceContextVariables(notificationType.getSubject());
            notification.setSubject(instanceSubject);
            String instanceMessage = context.replaceContextVariables(notificationType.getMessage());
            notification.setMessage(instanceMessage);
            notification.setNotificationType(notificationType);
        }
        return notification;
    }

    @Override
    public void saveNotification(KcNotification notification) {
        this.getBusinessObjectService().save((PersistableBusinessObject)notification);
    }

    @Override
    public List<KcNotification> getNotifications(String documentNumber, String moduleCode, Set<String> actionCodes) {
        ArrayList<KcNotification> notifications = new ArrayList<KcNotification>();
        for (String actionCode : actionCodes) {
            NotificationType notificationType = this.getNotificationType(moduleCode, actionCode);
            HashMap<String, String> notificationFieldValues = new HashMap<String, String>();
            notificationFieldValues.put(NOTIFICATION_TYPE_ID, notificationType.getNotificationTypeId().toString());
            notificationFieldValues.put(DOCUMENT_NUMBER, documentNumber);
            notifications.addAll(this.getBusinessObjectService().findMatching(KcNotification.class, notificationFieldValues));
        }
        return notifications;
    }

    @Override
    public void sendNotification(NotificationContext context) {
        KcNotification notification = this.createNotificationObject(context);
        if (notification.getNotificationType() != null && notification.getNotificationType().isActive()) {
            String contextName = context.getContextName();
            String subject = notification.getSubject();
            String message = notification.getMessage();
            Set<NotificationRecipient.Builder> notificationRecipients = this.getNotificationRecipients(context);
            this.sendNotification(contextName, subject, message, notificationRecipients);
            this.sendEmailNotification(subject, message, notificationRecipients, context.getEmailAttachments());
        }
    }

    @Override
    public void sendNotification(NotificationContext context, KcNotification notification, List<NotificationTypeRecipient> notificationTypeRecipients) {
        String contextName = context.getContextName();
        String subject = notification.getSubject();
        String message = notification.getMessage();
        Set<NotificationRecipient.Builder> notificationRecipients = this.getNotificationRecipients(notificationTypeRecipients, context);
        Set<String> emailRecipients = this.getEmailRecipients(notificationTypeRecipients);
        this.sendNotification(contextName, subject, message, notificationRecipients);
        this.sendEmailNotification(subject, message, notificationRecipients, context.getEmailAttachments());
        this.sendEmailNotification(this.getKcEmailService().getDefaultFromAddress(), emailRecipients, subject, message, context.getEmailAttachments());
    }

    @Override
    public void sendNotification(String contextName, String subject, String message, List<String> principalNames) {
        Set<NotificationRecipient.Builder> notificationRecipients = this.getNotificationRecipients(principalNames);
        this.sendNotification(contextName, subject, message, notificationRecipients);
        this.sendEmailNotification(subject, message, notificationRecipients, Collections.<EmailAttachment>emptyList());
    }

    @Override
    public void sendEmailNotification(NotificationContext context) {
        KcNotification notification;
        if (this.isEmailEnabled() && (notification = this.createNotificationObject(context)).getNotificationType() != null && notification.getNotificationType().isActive()) {
            String subject = notification.getSubject();
            String message = notification.getMessage();
            Set<NotificationRecipient.Builder> notificationRecipients = this.getNotificationRecipients(context);
            Set<String> toAddresses = this.getRecipientEmailAddresses(notificationRecipients);
            String fromAddress = this.getKcEmailService().getDefaultFromAddress();
            this.sendEmailNotification(fromAddress, toAddresses, subject, message, context.getEmailAttachments());
        }
    }

    @Override
    public void sendNotification(String contextName, String subject, String message, Collection<NotificationRecipient.Builder> notificationRecipients) {
        LOG.info((Object)("Sending Notification [" + contextName + "]"));
        Notification.Builder notification = this.getNotification();
        notification.setTitle(subject);
        notification.setContent("<content xmlns=\"ns:notification/ContentTypeSimple\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"ns:notification/ContentTypeSimple resource:notification/ContentTypeSimple\"><message><![CDATA[" + message + "]]></message>" + "</content>");
        notification.setRecipients(new ArrayList<NotificationRecipient.Builder>(notificationRecipients));
        this.sendNotificationService.sendNotification(notification.build());
    }

    private Notification.Builder getNotification() {
        Notification.Builder notification = Notification.Builder.create();
        NotificationPriority.Builder priority = NotificationPriority.Builder.create();
        priority.setId(this.getNotificationParameter("NORMAL_NOTIFICATION_PRIORITY_ID"));
        notification.setPriority(priority);
        NotificationContentType.Builder contentType = NotificationContentType.Builder.create();
        contentType.setId(this.getNotificationParameter("SIMPLE_NOTIFICATION_CONTENT_TYPE_ID"));
        notification.setContentType(contentType);
        notification.setDeliveryType("FYI");
        notification.setProducer(this.getSystemNotificationProducer());
        notification.setChannel(this.getKcNotificationChannel());
        notification.setSenders(this.getNotificationSenders());
        return notification;
    }

    private NotificationProducer.Builder getSystemNotificationProducer() {
        if (this.systemNotificationProducer == null) {
            NotificationProducer.Builder np = NotificationProducer.Builder.create();
            np.setName("Notification System");
            np.setDescription("This producer represents messages sent from the general message sending form.");
            np.setContactInfo("admins-notsys@cornell.edu");
            np.setId(this.getNotificationParameter("SYSTEM_NOTIFICATION_PRODUCER_ID"));
            ArrayList<Long> notificationChannels = new ArrayList<Long>();
            notificationChannels.add(this.getKcNotificationChannel().getId());
            np.setChannelIds(notificationChannels);
            this.systemNotificationProducer = np.build();
        }
        return NotificationProducer.Builder.create((NotificationProducerContract)this.systemNotificationProducer);
    }

    private NotificationChannel.Builder getKcNotificationChannel() {
        if (this.kcNotificationChannel == null) {
            NotificationChannel.Builder nc = NotificationChannel.Builder.create();
            nc.setId(this.getNotificationParameter("KC_NOTIFICATION_CHANNEL_ID"));
            this.kcNotificationChannel = nc.build();
        }
        return NotificationChannel.Builder.create((NotificationChannelContract)this.kcNotificationChannel);
    }

    private List<NotificationSender.Builder> getNotificationSenders() {
        ArrayList<NotificationSender.Builder> senders = new ArrayList<NotificationSender.Builder>();
        NotificationSender.Builder sender = NotificationSender.Builder.create();
        sender.setSenderName(this.getConfiguredSender());
        senders.add(sender);
        return senders;
    }

    private String getConfiguredSender() {
        String senderName = this.parameterService.getParameterValueAsString("KC-GEN", "All", "ACTION_LIST_DEFAULT_FROM_USER");
        if (StringUtils.isBlank((String)senderName)) {
            senderName = "admin";
        }
        return senderName;
    }

    private Long getNotificationParameter(String parameterName) {
        String parameterValue = this.parameterService.getParameterValueAsString("KC-GEN", "All", parameterName);
        return new Long(parameterValue);
    }

    @Override
    public Set<NotificationRecipient.Builder> getNotificationRecipients(NotificationContext context) {
        TreeSet<NotificationRecipient.Builder> uniqueRecipients = new TreeSet<NotificationRecipient.Builder>(new Comparator<NotificationRecipient.Builder>(){

            @Override
            public int compare(NotificationRecipient.Builder o1, NotificationRecipient.Builder o2) {
                return o1.getRecipientId().compareTo(o2.getRecipientId());
            }
        });
        List<NotificationTypeRecipient> notificationRecipients = this.getNotificationType(context).getNotificationTypeRecipients();
        uniqueRecipients.addAll(this.getRoleRecipients(notificationRecipients, context));
        return uniqueRecipients;
    }

    private Set<NotificationRecipient.Builder> getNotificationRecipients(List<NotificationTypeRecipient> notificationRecipients, NotificationContext context) {
        TreeSet<NotificationRecipient.Builder> uniqueRecipients = new TreeSet<NotificationRecipient.Builder>(new Comparator<NotificationRecipient.Builder>(){

            @Override
            public int compare(NotificationRecipient.Builder o1, NotificationRecipient.Builder o2) {
                return o1.getRecipientId().compareTo(o2.getRecipientId());
            }
        });
        ArrayList<NotificationTypeRecipient> roleRecipients = new ArrayList<NotificationTypeRecipient>();
        ArrayList<NotificationTypeRecipient> personRecipients = new ArrayList<NotificationTypeRecipient>();
        for (NotificationTypeRecipient notificationRecipient : notificationRecipients) {
            if (StringUtils.isNotBlank((String)notificationRecipient.getRoleName())) {
                roleRecipients.add(notificationRecipient);
                continue;
            }
            if (!StringUtils.isNotBlank((String)notificationRecipient.getPersonId())) continue;
            personRecipients.add(notificationRecipient);
        }
        uniqueRecipients.addAll(this.getRoleRecipients(roleRecipients, context));
        uniqueRecipients.addAll(this.getPersonRecipients(personRecipients));
        return uniqueRecipients;
    }

    private Set<String> getEmailRecipients(List<NotificationTypeRecipient> notificationRecipients) {
        TreeSet<String> uniqueEmailAddresses = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        ArrayList<NotificationTypeRecipient> rolodexRecipients = new ArrayList<NotificationTypeRecipient>();
        for (NotificationTypeRecipient notificationRecipient : notificationRecipients) {
            if (!StringUtils.isNotBlank((String)notificationRecipient.getRolodexId())) continue;
            rolodexRecipients.add(notificationRecipient);
        }
        uniqueEmailAddresses.addAll(this.getRolodexRecipients(rolodexRecipients));
        return uniqueEmailAddresses;
    }

    private Set<NotificationRecipient.Builder> getNotificationRecipients(List<String> principalNames) {
        TreeSet<NotificationRecipient.Builder> uniqueRecipients = new TreeSet<NotificationRecipient.Builder>(new Comparator<NotificationRecipient.Builder>(){

            @Override
            public int compare(NotificationRecipient.Builder o1, NotificationRecipient.Builder o2) {
                return o1.getRecipientId().compareTo(o2.getRecipientId());
            }
        });
        for (String principalName : principalNames) {
            LOG.info((Object)("Processing recipient: " + principalName + "."));
            NotificationRecipient.Builder recipient = NotificationRecipient.Builder.create();
            recipient.setRecipientId(principalName);
            recipient.setRecipientType(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
            uniqueRecipients.add(recipient);
        }
        return uniqueRecipients;
    }

    private List<NotificationRecipient.Builder> getRoleRecipients(List<NotificationTypeRecipient> notificationRecipients, NotificationContext context) {
        ArrayList<NotificationRecipient.Builder> roleRecipients = new ArrayList<NotificationRecipient.Builder>();
        ArrayList<NotificationTypeRecipient> recipients = new ArrayList<NotificationTypeRecipient>();
        Collections.sort(notificationRecipients, new Comparator<NotificationTypeRecipient>(){

            @Override
            public int compare(NotificationTypeRecipient roleRecipeient1, NotificationTypeRecipient roleRecipeient2) {
                return roleRecipeient2.getRoleName().compareTo(roleRecipeient1.getRoleName());
            }
        });
        String roleName = null;
        for (NotificationTypeRecipient roleRecipient : notificationRecipients) {
            try {
                if (StringUtils.isBlank(roleName) || roleName.equals(roleRecipient.getRoleName())) {
                    context.populateRoleQualifiers(roleRecipient);
                    recipients.add(roleRecipient);
                    if (!StringUtils.isBlank((String)roleName)) continue;
                    roleName = roleRecipient.getRoleName();
                    continue;
                }
                roleRecipients.addAll(this.createRoleRecipients(recipients));
                recipients = new ArrayList();
                context.populateRoleQualifiers(roleRecipient);
                recipients.add(roleRecipient);
                roleName = roleRecipient.getRoleName();
            }
            catch (UnknownRoleException e) {
                LOG.error((Object)("Role id " + e.getRoleId() + " not recognized for context " + e.getContext() + ". " + "Notification will not be sent for notificationTypeRecipient" + roleRecipient.toString()));
                e.printStackTrace();
            }
        }
        roleRecipients.addAll(this.createRoleRecipients(recipients));
        return roleRecipients;
    }

    private List<NotificationRecipient.Builder> createRoleRecipients(List<NotificationTypeRecipient> roleRecipients) {
        ArrayList<NotificationRecipient.Builder> recipients = new ArrayList<NotificationRecipient.Builder>();
        for (NotificationTypeRecipient roleRecipient : roleRecipients) {
            LOG.info((Object)("Processing recipient: " + roleRecipient.getRoleName() + " with " + roleRecipient.getRoleQualifiers().size() + " qualifiers."));
            String roleNamespace = StringUtils.substringBefore((String)roleRecipient.getRoleName(), (String)":");
            String roleName = StringUtils.substringAfter((String)roleRecipient.getRoleName(), (String)":");
            Collection roleMembers = this.roleManagementService.getRoleMemberPrincipalIds(roleNamespace, roleName, roleRecipient.getRoleQualifiers());
            for (String roleMember : roleMembers) {
                NotificationRecipient.Builder recipient = NotificationRecipient.Builder.create();
                recipient.setRecipientId(this.getKcPersonService().getKcPersonByPersonId(roleMember).getUserName());
                recipient.setRecipientType(MemberType.PRINCIPAL.getCode());
                recipients.add(recipient);
            }
        }
        return recipients;
    }

    private List<NotificationRecipient.Builder> getPersonRecipients(List<NotificationTypeRecipient> notificationRecipients) {
        ArrayList<NotificationRecipient.Builder> recipients = new ArrayList<NotificationRecipient.Builder>();
        for (NotificationTypeRecipient notificationRecipient : notificationRecipients) {
            LOG.info((Object)("Processing recipient: " + notificationRecipient.getPersonId() + "."));
            NotificationRecipient.Builder recipient = NotificationRecipient.Builder.create();
            recipient.setRecipientId(this.getKcPersonService().getKcPersonByPersonId(notificationRecipient.getPersonId()).getUserName());
            recipient.setRecipientType(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode());
            recipients.add(recipient);
        }
        return recipients;
    }

    private List<String> getRolodexRecipients(List<NotificationTypeRecipient> notificationRecipients) {
        ArrayList<String> recipients = new ArrayList<String>();
        for (NotificationTypeRecipient notificationRecipient : notificationRecipients) {
            LOG.info((Object)("Processing recipient: " + notificationRecipient.getRolodexId() + "."));
            Rolodex rolodex = this.getRolodexService().getRolodex(Integer.parseInt(notificationRecipient.getRolodexId()));
            if (!StringUtils.isNotBlank((String)rolodex.getEmailAddress())) continue;
            recipients.add(rolodex.getEmailAddress());
        }
        return recipients;
    }

    private void sendEmailNotification(String subject, String message, Collection<NotificationRecipient.Builder> notificationRecipients, List<EmailAttachment> attachments) {
        if (this.isEmailEnabled()) {
            Set<String> toAddresses = this.getRecipientEmailAddresses(notificationRecipients);
            this.sendEmailNotification(this.getKcEmailService().getDefaultFromAddress(), toAddresses, subject, message, attachments);
        }
    }

    private void sendEmailNotification(String fromAddress, Set<String> toAddresses, String subject, String message, List<EmailAttachment> attachments) {
        if (this.isEmailEnabled()) {
            this.getKcEmailService().sendEmailWithAttachments(fromAddress, toAddresses, subject, null, null, message, true, attachments);
        }
    }

    private Set<String> getRecipientEmailAddresses(Collection<NotificationRecipient.Builder> recipients) {
        HashSet<String> emailAddresses = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(recipients)) {
            for (NotificationRecipient.Builder recipient : recipients) {
                Entity entityInfo = this.getIdentityService().getEntityByPrincipalName(recipient.getRecipientId());
                List entityTypes = entityInfo.getEntityTypeContactInfos();
                if (!CollectionUtils.isNotEmpty((Collection)entityTypes)) continue;
                for (EntityTypeContactInfo entityType : entityTypes) {
                    if (!StringUtils.equals((String)"PERSON", (String)entityType.getEntityTypeCode()) || entityType.getDefaultEmailAddress() == null || !StringUtils.isNotBlank((String)entityType.getDefaultEmailAddress().getEmailAddress())) continue;
                    emailAddresses.add(entityType.getDefaultEmailAddress().getEmailAddress());
                    LOG.info((Object)("Added recipient email: " + entityType.getDefaultEmailAddress().getEmailAddress() + " for KIM user: " + recipient.getRecipientId()));
                }
            }
        }
        return emailAddresses;
    }

    private boolean isEmailEnabled() {
        boolean emailEnabled = false;
        try {
            emailEnabled = this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "EMAIL_NOTIFICATIONS_ENABLED");
        }
        catch (Exception e) {
            LOG.warn((Object)"Email Notifications parameter not configured, defaulting to disabled.");
        }
        return emailEnabled;
    }

    private void fillinNotificationObject(KcNotification notification, NotificationContext context, List<NotificationTypeRecipient> notificationTypeRecipients) {
        this.fillinNotificationObject(notification, context);
        String resultList = notification.getRecipients();
        for (NotificationTypeRecipient recipient : notificationTypeRecipients) {
            KcPerson person;
            if (recipient.getPersonId() == null || (person = this.getKcPersonService().getKcPersonByPersonId(recipient.getPersonId())) == null) continue;
            if (resultList != null) {
                resultList = resultList + ", " + person.getUserName();
                continue;
            }
            resultList = person.getUserName();
        }
        notification.setRecipients(resultList);
    }

    private void fillinNotificationObject(KcNotification notification, NotificationContext context) {
        NotificationType notificationType = this.getNotificationType(context);
        if (notificationType != null) {
            if (notification.getNotificationType() == null) {
                notification.setNotificationTypeId(notificationType.getNotificationTypeId());
                notification.setSubject(context.replaceContextVariables(StringUtils.isEmpty((String)notification.getSubject()) ? notificationType.getSubject() : notification.getSubject()));
                notification.setMessage(context.replaceContextVariables(StringUtils.isEmpty((String)notification.getMessage()) ? notificationType.getMessage() : notification.getMessage()));
                notification.setNotificationType(notificationType);
            }
            notification.setDocumentNumber(context.getDocumentNumber());
            Set<NotificationRecipient.Builder> notificationRecipients = this.getNotificationRecipients(context);
            String resultList = "";
            for (NotificationRecipient.Builder recipient : notificationRecipients) {
                resultList = resultList + ", " + recipient.getRecipientId();
            }
            if (resultList != "") {
                notification.setRecipients(resultList.substring(2));
            }
        }
    }

    @Override
    public void sendNotificationAndPersist(NotificationContext context, KcNotification notification, KraPersistableBusinessObjectBase object) {
        this.fillinNotificationObject(notification, context);
        if (notification.getNotificationType() != null && notification.getNotificationType().isActive()) {
            this.sendNotification(context);
            notification.persistOwningObject(object);
        }
    }

    @Override
    public void sendNotificationAndPersist(NotificationContext context, KcNotification notification, List<NotificationTypeRecipient> notificationTypeRecipients, KraPersistableBusinessObjectBase object) {
        this.fillinNotificationObject(notification, context, notificationTypeRecipients);
        if (notification.getNotificationType() != null && notification.getNotificationType().isActive()) {
            this.sendNotification(context, notification, notificationTypeRecipients);
            notification.persistOwningObject(object);
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public SendNotificationService getSendNotificationService() {
        return this.sendNotificationService;
    }

    public void setSendNotificationService(SendNotificationService sendNotificationService) {
        this.sendNotificationService = sendNotificationService;
    }

    public RoleService getRoleManagementService() {
        return this.roleManagementService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public KcEmailService getKcEmailService() {
        return this.kcEmailService;
    }

    public void setKcEmailService(KcEmailService kcEmailService) {
        this.kcEmailService = kcEmailService;
    }

    @Override
    public KcNotification copy(KcNotification oldNotification) {
        KcNotification newNotification = new KcNotification();
        newNotification.setNotificationId(oldNotification.getNotificationId());
        newNotification.setNotificationTypeId(oldNotification.getNotificationTypeId());
        newNotification.setDocumentNumber(oldNotification.getDocumentNumber());
        newNotification.setRecipients(oldNotification.getRecipients());
        newNotification.setSubject(oldNotification.getSubject());
        newNotification.setMessage(oldNotification.getMessage());
        newNotification.setNotificationType(oldNotification.getNotificationType());
        return newNotification;
    }
}

