/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.permissions.rules;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.permissions.bo.PermissionsRoleState;
import org.kuali.kra.common.permissions.bo.PermissionsUser;
import org.kuali.kra.common.permissions.bo.PermissionsUserEditRoles;
import org.kuali.kra.common.permissions.rule.PermissionsRule;
import org.kuali.kra.common.permissions.web.bean.Role;
import org.kuali.kra.common.permissions.web.bean.User;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.document.Document;

public abstract class PermissionsRuleBase
extends ResearchDocumentRuleBase
implements PermissionsRule {
    private static final String USERNAME_FIELD_NAME = "userName";
    private transient KcPersonService kcPersonService;

    @Override
    public boolean processAddPermissionsUserBusinessRules(Document document, List<User> users, PermissionsUser newUser) {
        boolean isValid = true;
        if (!this.isValidUser(newUser.getUserName())) {
            isValid = false;
            this.reportError("newPermissionsUser.userName", "error.unknown.username", new String[0]);
        } else if (this.isDuplicate(newUser.getUserName(), users)) {
            isValid = false;
            this.reportError("newPermissionsUser.userName", "error.duplicate.permissionsUser", new String[0]);
        }
        return isValid;
    }

    @Override
    public boolean processDeletePermissionsUserBusinessRules(Document document, List<User> users, int index) {
        User user;
        boolean isValid = true;
        String adminRoleName = this.getAdministratorRoleName();
        if (adminRoleName != null && this.isLastAdministrator((user = users.get(index)).getPerson().getUserName(), users, adminRoleName)) {
            isValid = false;
            this.reportError("newPermissionsUser", "error.permissions.last.administrator", adminRoleName);
        }
        return isValid;
    }

    @Override
    public boolean processEditPermissionsUserRolesBusinessRules(Document document, List<User> users, PermissionsUserEditRoles editRoles) {
        boolean isValid = true;
        String adminRoleName = this.getAdministratorRoleName();
        if (adminRoleName != null) {
            if (this.hasAdministrator(editRoles, adminRoleName) && this.hasNonAdministrator(editRoles, adminRoleName)) {
                isValid = false;
                this.reportError("permissionsUserEditRole", "error.permissions.administrator.inclusive", adminRoleName);
            } else if (!this.hasAdministrator(editRoles, adminRoleName) && this.isLastAdministrator(editRoles.getUserName(), users, adminRoleName)) {
                isValid = false;
                this.reportError("permissionsUserEditRole", "error.permissions.last.administrator", adminRoleName);
            }
        }
        return isValid;
    }

    protected abstract String getAdministratorRoleName();

    private boolean hasAdministrator(PermissionsUserEditRoles editRoles, String adminRoleName) {
        List<PermissionsRoleState> roleStates = editRoles.getRoleStates();
        for (PermissionsRoleState roleState : roleStates) {
            String roleName;
            if (!roleState.getState().booleanValue() || !StringUtils.equals((String)(roleName = roleState.getRole().getName()), (String)adminRoleName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonAdministrator(PermissionsUserEditRoles editRoles, String adminRoleName) {
        List<PermissionsRoleState> roleStates = editRoles.getRoleStates();
        for (PermissionsRoleState roleState : roleStates) {
            String roleName;
            if (!roleState.getState().booleanValue() || StringUtils.equals((String)(roleName = roleState.getRole().getName()), (String)adminRoleName)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidUser(String userName) {
        return StringUtils.isNotBlank((String)userName) && this.getKcPersonService().getKcPersonByUserName(userName) != null;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    private boolean isDuplicate(String userName, List<User> users) {
        for (User user : users) {
            if (!StringUtils.equals((String)userName, (String)user.getPerson().getUserName())) continue;
            return true;
        }
        return false;
    }

    private boolean isLastAdministrator(String userName, List<User> users, String adminRoleName) {
        for (User user : users) {
            if (StringUtils.equals((String)userName, (String)user.getPerson().getUserName())) continue;
            List<Role> roles = user.getRoles();
            for (Role role : roles) {
                if (!StringUtils.equals((String)role.getName(), (String)adminRoleName)) continue;
                return false;
            }
        }
        return true;
    }
}

