/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.permissions.web.struts.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.permissions.bo.PermissionsUser;
import org.kuali.kra.common.permissions.bo.PermissionsUserEditRoles;
import org.kuali.kra.common.permissions.web.bean.AssignedRole;
import org.kuali.kra.common.permissions.web.bean.RoleState;
import org.kuali.kra.common.permissions.web.bean.User;
import org.kuali.kra.common.permissions.web.bean.UserState;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.permission.PermissionQueryResults;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class PermissionsHelperBase
implements Serializable {
    private transient KcPersonService kcPersonService;
    private PermissionsUser newUser;
    private List<org.kuali.kra.common.permissions.web.bean.Role> roles = null;
    private List<UserState> userStates = new ArrayList<UserState>();
    private PermissionsUserEditRoles editRoles;
    private boolean modifyPermissions = false;

    public PermissionsHelperBase() {
        this.initialize(null);
    }

    public PermissionsHelperBase(String roleType) {
        this.initialize(roleType);
    }

    private void initialize(String roleType) {
        this.clearNewUser();
        this.buildRoles(roleType);
    }

    public void prepareView() {
        if (this.userStates.size() == 0) {
            this.buildUserStates();
        }
        this.initializePermissions();
    }

    public void resetUserStates() {
        this.userStates = new ArrayList<UserState>();
    }

    private void initializePermissions() {
        this.modifyPermissions = this.canModifyPermissions();
    }

    public abstract boolean canModifyPermissions();

    public boolean getModifyPermissions() {
        return this.modifyPermissions;
    }

    public List<org.kuali.kra.common.permissions.web.bean.Role> getRoles() {
        return this.roles;
    }

    protected void setRoles(List<org.kuali.kra.common.permissions.web.bean.Role> roles) {
        this.roles = roles;
    }

    public PermissionsUserEditRoles getEditRoles() {
        return this.editRoles;
    }

    public List<org.kuali.kra.common.permissions.web.bean.Role> getNormalRoles() {
        ArrayList<org.kuali.kra.common.permissions.web.bean.Role> normalRoles = new ArrayList<org.kuali.kra.common.permissions.web.bean.Role>();
        for (org.kuali.kra.common.permissions.web.bean.Role role : this.roles) {
            if (this.isUnassignedRoleName(role.getName())) continue;
            normalRoles.add(role);
        }
        return normalRoles;
    }

    public List<UserState> getUserStates() {
        return this.userStates;
    }

    public UserState getUserState(String userName) {
        for (UserState userState : this.userStates) {
            if (!StringUtils.equals((String)userState.getPerson().getUserName(), (String)userName)) continue;
            return userState;
        }
        return null;
    }

    public String getUnassignedRoleName() {
        return null;
    }

    public String getUnassignedRoleDisplayName() {
        String unassignedRoleName = this.getUnassignedRoleName();
        if (unassignedRoleName != null) {
            return this.getRoleDisplayName(unassignedRoleName);
        }
        return null;
    }

    private boolean isUnassignedRoleName(String roleName) {
        return StringUtils.equals((String)this.getUnassignedRoleName(), (String)roleName);
    }

    protected abstract boolean isStandardRoleName(String var1);

    protected String getRoleDisplayName(String roleName) {
        return roleName;
    }

    private void buildUserStates() {
        for (org.kuali.kra.common.permissions.web.bean.Role role : this.roles) {
            String roleName = role.getName();
            List<KcPerson> persons = this.getPersonsInRole(roleName);
            for (KcPerson person : persons) {
                UserState userState = this.getUserState(person);
                userState.setSaved(roleName, true);
            }
        }
    }

    private UserState getUserState(KcPerson person) {
        for (UserState userState : this.userStates) {
            if (!StringUtils.equals((String)userState.getPerson().getUserName(), (String)person.getUserName())) continue;
            return userState;
        }
        return this.createUserState(person);
    }

    private UserState createUserState(KcPerson person) {
        UserState userState = new UserState(person, this.roles);
        this.userStates.add(userState);
        return userState;
    }

    protected abstract List<KcPerson> getPersonsInRole(String var1);

    protected void buildRoles(String roleType) {
        this.roles = new ArrayList<org.kuali.kra.common.permissions.web.bean.Role>();
        List<Role> kimRoles = this.getSortedKimRoles(roleType);
        QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        PermissionQueryResults permissionResults = null;
        for (Role kimRole : kimRoles) {
            predicates.add(PredicateFactory.equal((String)"rolePermissions.roleId", (Object)kimRole.getId()));
            queryBuilder.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[0]))});
            permissionResults = this.getKimPermissionService().findPermissions(queryBuilder.build());
            if (permissionResults != null && permissionResults.getTotalRowCount() != null && permissionResults.getTotalRowCount() > 0) {
                org.kuali.kra.common.permissions.web.bean.Role role = new org.kuali.kra.common.permissions.web.bean.Role(kimRole.getName(), this.getRoleDisplayName(kimRole.getName()), permissionResults.getResults());
                this.roles.add(role);
            }
            predicates.clear();
            queryBuilder = QueryByCriteria.Builder.create();
            permissionResults = null;
        }
    }

    protected List<Role> getSortedKimRoles(String roleType) {
        ArrayList<Role> sortedKimRoles = new ArrayList<Role>();
        List<Role> kimRoles = this.getKimRoles(roleType);
        for (Role kimRole : kimRoles) {
            if (this.isUnassignedRoleName(kimRole.getName())) {
                sortedKimRoles.add(0, kimRole);
                continue;
            }
            if (!this.isStandardRoleName(kimRole.getName())) continue;
            sortedKimRoles.add(kimRole);
        }
        for (Role kimRole : kimRoles) {
            if (sortedKimRoles.contains(kimRole)) continue;
            sortedKimRoles.add(kimRole);
        }
        return sortedKimRoles;
    }

    protected List<Role> getKimRoles(String roleType) {
        SystemAuthorizationService systemAuthorizationService = KraServiceLocator.getService(SystemAuthorizationService.class);
        return systemAuthorizationService.getRoles(roleType);
    }

    public org.kuali.kra.common.permissions.web.bean.Role getRole(String roleName) {
        for (org.kuali.kra.common.permissions.web.bean.Role role : this.roles) {
            if (!StringUtils.equals((String)roleName, (String)role.getName())) continue;
            return role;
        }
        return null;
    }

    public List<AssignedRole> getAssignedRoles() {
        ArrayList<AssignedRole> assignedRoles = new ArrayList<AssignedRole>();
        for (org.kuali.kra.common.permissions.web.bean.Role role : this.roles) {
            if (this.isUnassignedRoleName(role.getName())) continue;
            AssignedRole assignedRole = new AssignedRole(role);
            for (UserState userState : this.userStates) {
                if (!userState.isRoleAssigned(role.getName())) continue;
                assignedRole.add(new User(userState.getPerson()));
            }
            assignedRoles.add(assignedRole);
        }
        return assignedRoles;
    }

    public List<User> getUsers() {
        ArrayList<User> users = new ArrayList<User>();
        for (UserState userState : this.userStates) {
            User user = new User(userState.getPerson());
            for (RoleState roleState : userState.getRoleStates()) {
                if (!roleState.isAssigned()) continue;
                user.addRole(roleState.getRole());
            }
            if (user.getRoles().size() <= 0) continue;
            users.add(user);
        }
        this.sortUsers(users);
        return users;
    }

    private void sortUsers(List<User> users) {
        Collections.sort(users, new Comparator(){

            public int compare(Object o1, Object o2) {
                User user1 = (User)o1;
                User user2 = (User)o2;
                return user1.getPerson().getLastName().compareTo(user2.getPerson().getLastName());
            }
        });
    }

    public PermissionsUser getNewUser() {
        return this.newUser;
    }

    private void clearNewUser() {
        this.newUser = new PermissionsUser();
    }

    public void addNewUser() {
        KcPerson person = this.findPerson(this.newUser.getUserName());
        UserState userState = new UserState(person, this.roles);
        userState.setAssigned(this.newUser.getRoleName(), true);
        this.userStates.add(userState);
        this.clearNewUser();
    }

    public List<KeyValue> getRoleSelection() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (org.kuali.kra.common.permissions.web.bean.Role role : this.roles) {
            ConcreteKeyValue pair = new ConcreteKeyValue(role.getName(), role.getDisplayName());
            keyValues.add((KeyValue)pair);
        }
        return keyValues;
    }

    public void setUserEditRoles(PermissionsUserEditRoles editRoles) {
        this.editRoles = editRoles;
    }

    private KcPerson findPerson(String userName) {
        return this.getKcPersonService().getKcPersonByUserName(userName);
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected PermissionService getKimPermissionService() {
        return (PermissionService)KraServiceLocator.getService("kimPermissionService");
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }
}

