/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.specialreview.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.SpecialReviewType;
import org.kuali.kra.bo.SpecialReviewUsage;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class SpecialReviewTypeValuesFinder
extends KeyValuesBase {
    private static final String MODULE_CODE_NAME = "moduleCode";
    private static final String PERMISSION_NAME = "View Active Special Review Types";
    private KeyValuesService keyValuesService;
    private BusinessObjectService businessObjectService;
    private IdentityService identityManagementService;
    private PermissionService permissionService;

    public List<KeyValue> getKeyValues() {
        List<KeyValue> keyValues = this.filterActiveSpecialReviewUsageTypes(this.createKeyValues());
        keyValues.add(0, (KeyValue)new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        return keyValues;
    }

    private List<KeyValue> createKeyValues() {
        Collection specialReviewTypes = this.getKeyValuesService().findAllOrderBy(SpecialReviewType.class, "sortId", true);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (SpecialReviewType specialReviewType : specialReviewTypes) {
            keyValues.add((KeyValue)new ConcreteKeyValue(specialReviewType.getSpecialReviewTypeCode(), specialReviewType.getDescription()));
        }
        return keyValues;
    }

    private List<KeyValue> filterActiveSpecialReviewUsageTypes(List<KeyValue> unfilteredKeyValues) {
        ArrayList<KeyValue> filteredKeyValues = new ArrayList<KeyValue>();
        boolean canViewNonGlobalSpecialReviewTypes = this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", PERMISSION_NAME);
        Collection<SpecialReviewUsage> specialReviewUsages = this.getSpecialReviewUsages();
        for (KeyValue item : unfilteredKeyValues) {
            SpecialReviewUsage itemSpecialReviewUsage = null;
            for (SpecialReviewUsage specialReviewUsage : specialReviewUsages) {
                if (!StringUtils.equals((String)specialReviewUsage.getSpecialReviewTypeCode(), (String)String.valueOf(item.getKey()))) continue;
                itemSpecialReviewUsage = specialReviewUsage;
                break;
            }
            if (itemSpecialReviewUsage == null || !itemSpecialReviewUsage.isActive() || !itemSpecialReviewUsage.isGlobal() && !canViewNonGlobalSpecialReviewTypes) continue;
            filteredKeyValues.add(item);
        }
        return filteredKeyValues;
    }

    public abstract String getModuleCode();

    private Collection<SpecialReviewUsage> getSpecialReviewUsages() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_CODE_NAME, this.getModuleCode());
        return this.getBusinessObjectService().findMatching(SpecialReviewUsage.class, fieldValues);
    }

    public KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = KraServiceLocator.getService(KeyValuesService.class);
        }
        return this.keyValuesService;
    }

    public void setKeyValuesService(KeyValuesService keyValuesService) {
        this.keyValuesService = keyValuesService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public IdentityService getIdentityService() {
        if (this.identityManagementService == null) {
            this.identityManagementService = KraServiceLocator.getService(IdentityService.class);
        }
        return this.identityManagementService;
    }

    public void setIdentityManagementService(IdentityService identityManagementService) {
        this.identityManagementService = identityManagementService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

