/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.specialreview.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.specialreview.AwardSpecialReviewExemption;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.common.specialreview.service.SpecialReviewService;
import org.kuali.kra.iacuc.IacucProtocolFinderDao;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReviewExemption;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class SpecialReviewServiceImpl
implements SpecialReviewService {
    private static final String PROTOCOL_NUMBER = ".protocolNumber";
    public static final String NEW_SPECIAL_REVIEW_COMMENT = "A Special Review has been inserted.";
    private AwardService awardService;
    private InstitutionalProposalService institutionalProposalService;
    private ProtocolFinderDao protocolFinderDao;
    private IacucProtocolFinderDao iacucProtocolFinderDao;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;

    @Override
    public String getProtocolSaveLocationPrefix(Map<String, String[]> parameters) {
        String prefix = null;
        for (String parameterName : parameters.keySet()) {
            if (!parameterName.endsWith(PROTOCOL_NUMBER)) continue;
            prefix = StringUtils.removeEnd((String)parameterName, (String)PROTOCOL_NUMBER);
            break;
        }
        return prefix;
    }

    @Override
    public int getProtocolIndex(String prefix) {
        String lineNumber;
        int index = -1;
        int lastLeftBracketIndex = StringUtils.lastIndexOf((String)prefix, (char)'[');
        int lastRightBracketIndex = StringUtils.lastIndexOf((String)prefix, (char)']');
        if (lastLeftBracketIndex != -1 && lastRightBracketIndex != -1 && NumberUtils.isDigits((String)(lineNumber = prefix.substring(lastLeftBracketIndex + 1, lastRightBracketIndex)))) {
            index = Integer.parseInt(lineNumber);
        }
        return index;
    }

    @Override
    public String getViewSpecialReviewProtocolRouteHeaderId(String protocolNumber) throws Exception {
        Protocol protocol;
        String routeHeaderId = null;
        if (StringUtils.isNotBlank((String)protocolNumber) && (protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber)) != null) {
            Document document = this.getDocumentService().getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
            routeHeaderId = document.getDocumentHeader().getWorkflowDocument().getDocumentId();
        }
        return routeHeaderId;
    }

    @Override
    public String getViewSpecialReviewProtocolRouteHeaderId(String protocolNumber, String specialReviewTypeCode) throws Exception {
        String routeHeaderId = null;
        if (StringUtils.isNotBlank((String)protocolNumber)) {
            ProtocolBase protocol;
            if ("1".equals(specialReviewTypeCode)) {
                Protocol protocol2 = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
                if (protocol2 != null) {
                    Document document = this.getDocumentService().getByDocumentHeaderId(protocol2.getProtocolDocument().getDocumentNumber());
                    routeHeaderId = document.getDocumentHeader().getWorkflowDocument().getDocumentId();
                }
            } else if ("2".equals(specialReviewTypeCode) && (protocol = this.getIacucProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber)) != null) {
                Document document = this.getDocumentService().getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
                routeHeaderId = document.getDocumentHeader().getWorkflowDocument().getDocumentId();
            }
        }
        return routeHeaderId;
    }

    @Override
    public boolean isLinkedToProtocolFundingSource(String protocolNumber, String fundingSourceNumber, String fundingSourceTypeCode) {
        Protocol protocol;
        boolean isLinkedToProtocolFundingSource = false;
        if (StringUtils.isNotBlank((String)protocolNumber) && (protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber)) != null) {
            List<ProtocolFundingSourceBase> protocolFundingSources = protocol.getProtocolFundingSources();
            for (ProtocolFundingSource protocolFundingSource : protocolFundingSources) {
                if (!StringUtils.equals((String)protocolFundingSource.getFundingSourceNumber(), (String)fundingSourceNumber) || !StringUtils.equals((String)protocolFundingSource.getFundingSourceTypeCode(), (String)fundingSourceTypeCode)) continue;
                isLinkedToProtocolFundingSource = true;
                break;
            }
        }
        return isLinkedToProtocolFundingSource;
    }

    @Override
    public boolean isLinkedToSpecialReview(String fundingSourceNumber, String fundingSourceTypeCode, String protocolNumber) {
        InstitutionalProposal institutionalProposal;
        boolean isLinkedToSpecialReview = false;
        if (StringUtils.equals((String)"6", (String)fundingSourceTypeCode)) {
            Award award = this.getAward(fundingSourceNumber);
            if (award != null) {
                isLinkedToSpecialReview = this.isLinkedToSpecialReviews(award.getSpecialReviews(), protocolNumber);
            }
        } else if (StringUtils.equals((String)"5", (String)fundingSourceTypeCode) && (institutionalProposal = this.getInstitutionalProposal(fundingSourceNumber)) != null) {
            isLinkedToSpecialReview = this.isLinkedToSpecialReviews(institutionalProposal.getSpecialReviews(), protocolNumber);
        }
        return isLinkedToSpecialReview;
    }

    private boolean isLinkedToSpecialReviews(List<? extends SpecialReview<?>> specialReviews, String protocolNumber) {
        boolean isLinkedToSpecialReviews = false;
        for (SpecialReview<?> specialReview : specialReviews) {
            if (!"1".equals(specialReview.getSpecialReviewTypeCode()) || !StringUtils.equals((String)specialReview.getProtocolNumber(), (String)protocolNumber)) continue;
            isLinkedToSpecialReviews = true;
            break;
        }
        return isLinkedToSpecialReviews;
    }

    @Override
    public void addProtocolFundingSourceForSpecialReview(String protocolNumber, String fundingSourceNumber, String fundingSourceTypeCode, String fundingSourceName, String fundingSourceTitle) {
        Protocol protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
        if (protocol != null && StringUtils.isNotBlank((String)fundingSourceNumber) && NumberUtils.isNumber((String)fundingSourceTypeCode)) {
            ProtocolFundingSource protocolFundingSource = new ProtocolFundingSource();
            protocolFundingSource.setProtocolNumber(protocolNumber);
            protocolFundingSource.setFundingSourceNumber(fundingSourceNumber);
            protocolFundingSource.setFundingSourceTypeCode(fundingSourceTypeCode);
            protocolFundingSource.setFundingSourceName(fundingSourceName);
            protocolFundingSource.setFundingSourceTitle(fundingSourceTitle);
            protocol.getProtocolFundingSources().add(protocolFundingSource);
            this.getBusinessObjectService().save((PersistableBusinessObject)protocol);
        }
    }

    @Override
    public void deleteProtocolFundingSourceForSpecialReview(String protocolNumber, String fundingSourceNumber, String fundingSourceTypeCode) {
        Protocol protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
        if (protocol != null) {
            ArrayList<ProtocolFundingSource> deletedProtocolFundingSources = new ArrayList<ProtocolFundingSource>();
            List<ProtocolFundingSourceBase> protocolFundingSources = protocol.getProtocolFundingSources();
            for (ProtocolFundingSource protocolFundingSource : protocolFundingSources) {
                if (!StringUtils.equals((String)protocolFundingSource.getFundingSourceNumber(), (String)fundingSourceNumber) || !StringUtils.equals((String)protocolFundingSource.getFundingSourceTypeCode(), (String)fundingSourceTypeCode)) continue;
                deletedProtocolFundingSources.add(protocolFundingSource);
            }
            this.getBusinessObjectService().delete(deletedProtocolFundingSources);
        }
    }

    @Override
    public void addSpecialReviewForProtocolFundingSource(String fundingSourceNumber, String fundingSourceTypeCode, String protocolNumber, Date applicationDate, Date approvalDate, Date expirationDate, List<String> exemptionTypeCodes) {
        if (StringUtils.equals((String)"6", (String)fundingSourceTypeCode)) {
            Award award = this.getAward(fundingSourceNumber);
            this.addAwardSpecialReview(award, protocolNumber, applicationDate, approvalDate, expirationDate, exemptionTypeCodes);
        } else if (StringUtils.equals((String)"5", (String)fundingSourceTypeCode)) {
            InstitutionalProposal institutionalProposal = this.getInstitutionalProposal(fundingSourceNumber);
            this.addInstitutionalProposalSpecialReview(institutionalProposal, protocolNumber, applicationDate, approvalDate, expirationDate, exemptionTypeCodes);
        }
    }

    private void addAwardSpecialReview(Award award, String protocolNumber, Date applicationDate, Date approvalDate, Date expirationDate, List<String> exemptionTypeCodes) {
        if (award != null) {
            Integer specialReviewNumber = award.getAwardDocument().getDocumentNextValue("SPECIAL_REVIEW_NUMBER");
            AwardSpecialReview specialReview = new AwardSpecialReview();
            specialReview.setSpecialReviewNumber(specialReviewNumber);
            specialReview.setSpecialReviewTypeCode("1");
            specialReview.setApprovalTypeCode("5");
            specialReview.setProtocolNumber(protocolNumber);
            specialReview.setApplicationDate(applicationDate);
            specialReview.setApprovalDate(approvalDate);
            specialReview.setExpirationDate(expirationDate);
            for (String exemptionTypeCode : exemptionTypeCodes) {
                AwardSpecialReviewExemption specialReviewExemption = new AwardSpecialReviewExemption();
                specialReviewExemption.setAwardSpecialReview(specialReview);
                specialReviewExemption.setExemptionTypeCode(exemptionTypeCode);
                specialReview.getSpecialReviewExemptions().add(specialReviewExemption);
            }
            specialReview.setComments(NEW_SPECIAL_REVIEW_COMMENT);
            award.getSpecialReviews().add(specialReview);
            this.getBusinessObjectService().save((PersistableBusinessObject)award);
        }
    }

    private void addInstitutionalProposalSpecialReview(InstitutionalProposal institutionalProposal, String protocolNumber, Date applicationDate, Date approvalDate, Date expirationDate, List<String> exemptionTypeCodes) {
        if (institutionalProposal != null) {
            Integer specialReviewNumber = institutionalProposal.getInstitutionalProposalDocument().getDocumentNextValue("SPECIAL_REVIEW_NUMBER");
            InstitutionalProposalSpecialReview specialReview = new InstitutionalProposalSpecialReview();
            specialReview.setSpecialReviewNumber(specialReviewNumber);
            specialReview.setSpecialReviewTypeCode("1");
            specialReview.setApprovalTypeCode("5");
            specialReview.setProtocolNumber(protocolNumber);
            specialReview.setApplicationDate(applicationDate);
            specialReview.setApprovalDate(approvalDate);
            specialReview.setExpirationDate(expirationDate);
            for (String exemptionTypeCode : exemptionTypeCodes) {
                InstitutionalProposalSpecialReviewExemption specialReviewExemption = new InstitutionalProposalSpecialReviewExemption();
                specialReviewExemption.setInstitutionalProposalSpecialReview(specialReview);
                specialReviewExemption.setExemptionTypeCode(exemptionTypeCode);
                specialReview.getSpecialReviewExemptions().add(specialReviewExemption);
            }
            specialReview.setComments(NEW_SPECIAL_REVIEW_COMMENT);
            institutionalProposal.getSpecialReviews().add(specialReview);
            this.getBusinessObjectService().save((PersistableBusinessObject)institutionalProposal);
        }
    }

    @Override
    public void deleteSpecialReviewForProtocolFundingSource(String fundingSourceNumber, String fundingSourceTypeCode, String protocolNumber) {
        if (StringUtils.equals((String)"6", (String)fundingSourceTypeCode)) {
            Award award = this.getAward(fundingSourceNumber);
            this.deleteAwardSpecialReview(award, protocolNumber);
        } else if (StringUtils.equals((String)"5", (String)fundingSourceTypeCode)) {
            InstitutionalProposal institutionalProposal = this.getInstitutionalProposal(fundingSourceNumber);
            this.deleteInstitutionalProposalSpecialReview(institutionalProposal, protocolNumber);
        }
    }

    private void deleteAwardSpecialReview(Award award, String protocolNumber) {
        if (award != null) {
            ArrayList<AwardSpecialReview> deletedSpecialReviews = new ArrayList<AwardSpecialReview>();
            for (AwardSpecialReview specialReview : award.getSpecialReviews()) {
                if (!StringUtils.equals((String)specialReview.getProtocolNumber(), (String)protocolNumber)) continue;
                deletedSpecialReviews.add(specialReview);
            }
            this.getBusinessObjectService().delete(deletedSpecialReviews);
        }
    }

    private void deleteInstitutionalProposalSpecialReview(InstitutionalProposal institutionalProposal, String protocolNumber) {
        if (institutionalProposal != null) {
            ArrayList<InstitutionalProposalSpecialReview> deletedSpecialReviews = new ArrayList<InstitutionalProposalSpecialReview>();
            institutionalProposal.refreshReferenceObject("specialReviews");
            for (InstitutionalProposalSpecialReview specialReview : institutionalProposal.getSpecialReviews()) {
                if (!StringUtils.equals((String)specialReview.getProtocolNumber(), (String)protocolNumber)) continue;
                deletedSpecialReviews.add(specialReview);
            }
            this.getBusinessObjectService().delete(deletedSpecialReviews);
        }
    }

    private Award getAward(String fundingSourceNumber) {
        Award award = null;
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(fundingSourceNumber);
        if (!awards.isEmpty()) {
            award = awards.get(awards.size() - 1);
        }
        return award;
    }

    private InstitutionalProposal getInstitutionalProposal(String fundingSourceNumber) {
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(fundingSourceNumber);
        if (institutionalProposal == null) {
            institutionalProposal = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(fundingSourceNumber);
        }
        return institutionalProposal;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public IacucProtocolFinderDao getIacucProtocolFinderDao() {
        return this.iacucProtocolFinderDao;
    }

    public void setIacucProtocolFinderDao(IacucProtocolFinderDao iacucProtocolFinderDao) {
        this.iacucProtocolFinderDao = iacucProtocolFinderDao;
    }

    public ProtocolFinderDao getProtocolFinderDao() {
        return this.protocolFinderDao;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

