/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.web.struts.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.printing.CurrentReportBean;
import org.kuali.kra.common.printing.PendingReportBean;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.printing.service.CurrentAndPendingReportService;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ReportHelperBean
implements Serializable {
    private KualiDocumentFormBase form;
    private String personId;
    private KcPerson targetPerson;
    private boolean institutionalProposalExists;
    private String proposalNumber;
    private static final String DEV_PROPOSAL_NUMBER_FIELD_NAME = "devProposalNumber";
    private static final String PROP_SEQ_STATUS = "ACTIVE";
    private static final String PROP_NUMBER = "proposalNumber";
    private static final int PROP_TYPE_CONTINUATION = 4;
    private static final int PROP_TYPE_TASK_ORDER = 6;
    private static final int PROP_PENDING_STATUS = 1;

    public ReportHelperBean(KualiDocumentFormBase form) {
        this.form = form;
        this.setTargetPerson(new KcPerson());
        if (form.getDocument() instanceof InstitutionalProposalDocument) {
            this.institutionalProposalExists = true;
            this.proposalNumber = this.findProposalNumberFromInstitutionalProposal();
        } else if (form.getDocument() instanceof ProposalDevelopmentDocument) {
            this.institutionalProposalExists = this.doesInstitutionalProposalExistForProposalNumber();
            this.proposalNumber = this.findProposalNumberFromDevelopmentProposal();
        }
    }

    public ReportHelperBean() {
        this.setTargetPerson(new KcPerson());
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public KcPerson getTargetPerson() {
        return this.targetPerson;
    }

    public boolean isInstituteProposalAvailable() {
        return this.institutionalProposalExists;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
        if (personId != null) {
            this.targetPerson = this.getKcPersonService().getKcPersonByPersonId(personId);
        }
    }

    public void setTargetPerson(KcPerson targetPerson) {
        this.targetPerson = targetPerson;
    }

    public List<ResultRow> prepareCurrentReport() {
        return new CurrentReportHelperBean().prepareCurrentReport();
    }

    public List<ResultRow> preparePendingReport() {
        return new PendingReportHelperBean().preparePendingReport();
    }

    public String getTargetPersonName() {
        return this.targetPerson.getFullName();
    }

    protected boolean doesInstitutionalProposalExistForProposalNumber() {
        return this.findProposalAdminDetails() != null;
    }

    protected ProposalAdminDetails findProposalAdminDetails() {
        Map<String, String> map = Collections.singletonMap(DEV_PROPOSAL_NUMBER_FIELD_NAME, this.findProposalNumberFromDevelopmentProposal());
        Collection proposalAdminDetailses = this.getBusinessObjectService().findMatching(ProposalAdminDetails.class, map);
        return proposalAdminDetailses.size() > 0 ? (ProposalAdminDetails)((Object)proposalAdminDetailses.iterator().next()) : null;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected KcPersonService getKcPersonService() {
        return KraServiceLocator.getService(KcPersonService.class);
    }

    protected CurrentAndPendingReportService getCurrentAndPendingReportService() {
        return KraServiceLocator.getService(CurrentAndPendingReportService.class);
    }

    private String findProposalNumberFromDevelopmentProposal() {
        return ((ProposalDevelopmentDocument)this.form.getDocument()).getDevelopmentProposal().getProposalNumber();
    }

    private String findProposalNumberFromInstitutionalProposal() {
        return ((InstitutionalProposalDocument)this.form.getDocument()).getInstitutionalProposal().getProposalNumber();
    }

    private class CurrentReportHelperBean
    implements Serializable {
        private CurrentReportHelperBean() {
        }

        public List<ResultRow> prepareCurrentReport() {
            ArrayList<ResultRow> resultRows = new ArrayList<ResultRow>();
            for (CurrentReportBean bean : this.loadReportData()) {
                resultRows.add(bean.createResultRow());
            }
            return resultRows;
        }

        private List<CurrentReportBean> loadReportData() {
            return ReportHelperBean.this.getCurrentAndPendingReportService().loadCurrentReportData(ReportHelperBean.this.personId);
        }
    }

    private class PendingReportHelperBean
    implements Serializable {
        private PendingReportHelperBean() {
        }

        public List<ResultRow> preparePendingReport() {
            ArrayList<ResultRow> resultRows = new ArrayList<ResultRow>();
            HashMap<String, String> proposalNumberMap = new HashMap<String, String>();
            List institutionalProposalList = null;
            for (PendingReportBean bean : this.loadReportData()) {
                proposalNumberMap.put(ReportHelperBean.PROP_NUMBER, String.valueOf(bean.getProposalNumber()));
                institutionalProposalList = (List)ReportHelperBean.this.getBusinessObjectService().findMatching(InstitutionalProposal.class, proposalNumberMap);
                for (InstitutionalProposal institutionalProposal : institutionalProposalList) {
                    if (!institutionalProposal.getProposalSequenceStatus().equals(ReportHelperBean.PROP_SEQ_STATUS) || institutionalProposal.getStatusCode() != 1 || institutionalProposal.getProposalTypeCode() == 4 || institutionalProposal.getProposalTypeCode() == 6) continue;
                    resultRows.add(bean.createResultRow());
                }
            }
            return resultRows;
        }

        private List<PendingReportBean> loadReportData() {
            return ReportHelperBean.this.getCurrentAndPendingReportService().loadPendingReportData(ReportHelperBean.this.personId);
        }
    }
}

