/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.dao.ojb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.common.printing.PendingReportBean;
import org.kuali.kra.dao.PendingReportDao;
import org.kuali.kra.dao.ojb.BaseReportDaoOjb;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.DocumentBase;

public class PendingReportDaoOjb
extends BaseReportDaoOjb
implements PendingReportDao {
    @Override
    public List<PendingReportBean> queryForPendingSupport(String personId) throws WorkflowException {
        ArrayList<PendingReportBean> data = new ArrayList<PendingReportBean>();
        for (InstitutionalProposalPerson ipPerson : this.executePendingSupportQuery(personId)) {
            this.lazyLoadProposal(ipPerson);
            PendingReportBean bean = this.buildPendingReportBean(ipPerson);
            if (bean == null) continue;
            data.add(bean);
        }
        return data;
    }

    private PendingReportBean buildPendingReportBean(InstitutionalProposalPerson ipPerson) throws WorkflowException {
        InstitutionalProposal proposal = ipPerson.getInstitutionalProposal();
        PendingReportBean bean = null;
        if (this.shouldDataBeIncluded((DocumentBase)proposal.getInstitutionalProposalDocument()) && proposal.isActiveVersion()) {
            bean = new PendingReportBean(ipPerson);
        }
        return bean;
    }

    private Collection<InstitutionalProposalPerson> executePendingSupportQuery(String personId) {
        return this.getBusinessObjectService().findMatching(InstitutionalProposalPerson.class, Collections.singletonMap("personId", personId));
    }

    private void lazyLoadProposal(InstitutionalProposalPerson ipPerson) {
        if (ipPerson.getInstitutionalProposal() == null) {
            ServiceHelper svcHelper = ServiceHelper.getInstance();
            HashMap<String, Object> searchParams = new HashMap<String, Object>();
            searchParams.put("proposalNumber", ipPerson.getProposalNumber());
            searchParams.put("sequenceNumber", ipPerson.getSequenceNumber());
            InstitutionalProposal proposal = (InstitutionalProposal)this.getBusinessObjectService().findMatching(InstitutionalProposal.class, searchParams).iterator().next();
            ipPerson.setInstitutionalProposal(proposal);
        }
    }
}

