/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.dao.ojb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.kra.dao.VersionHistoryLookupDao;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.dao.LookupDao;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.lookup.CollectionIncomplete;

public class VersionHistoryLookupDaoOjb
extends LookupDaoOjb
implements VersionHistoryLookupDao {
    private static final Log LOG = LogFactory.getLog(VersionHistoryLookupDaoOjb.class);

    @Override
    public List<? extends BusinessObject> getSequenceOwnerSearchResults(Class sequenceOwnerClass, Map fieldValues, boolean usePrimaryKeys) {
        Collection searchResults = new ArrayList();
        Long matchingResultsCount = null;
        Criteria criteria = this.getActiveOrPendingVersionCriteria(sequenceOwnerClass, fieldValues, usePrimaryKeys);
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit((Class)sequenceOwnerClass);
        if (searchResultsLimit != null) {
            matchingResultsCount = new Long(this.getPersistenceBrokerTemplate().getCount((Query)QueryFactory.newQuery((Class)sequenceOwnerClass, (Criteria)criteria)));
            LookupUtils.applySearchResultsLimit((Class)sequenceOwnerClass, (Criteria)criteria, (DatabasePlatform)this.getDbPlatform());
        }
        if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
            matchingResultsCount = new Long(0L);
        }
        searchResults = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)sequenceOwnerClass, (Criteria)criteria));
        return new CollectionIncomplete(searchResults, matchingResultsCount);
    }

    private Criteria getActiveOrPendingVersionCriteria(Class sequenceOwnerClass, Map fieldValues, boolean usePrimaryKeys) {
        Criteria retval = usePrimaryKeys ? this.getCollectionCriteriaFromMapUsingPrimaryKeysOnly(sequenceOwnerClass, fieldValues) : this.getCollectionCriteriaFromMap(this.checkBusinessObjectClass(sequenceOwnerClass), fieldValues);
        retval.addEqualTo("versionHistory.sequenceOwnerClassName", (Object)sequenceOwnerClass.getName());
        ArrayList<String> statuses = new ArrayList<String>(2);
        statuses.add("ACTIVE");
        statuses.add("PENDING");
        Criteria orCriteria = new Criteria();
        orCriteria.addIn("versionHistory.statusForOjb", statuses);
        retval.addAndCriteria(orCriteria);
        return retval;
    }

    private Criteria getCollectionCriteriaFromMap(PersistableBusinessObject businessObject, Map formProps) {
        Criteria criteria = new Criteria();
        Iterator propsIter = formProps.keySet().iterator();
        LookupDao lookupDao = KraServiceLocator.getService(LookupDao.class);
        while (propsIter.hasNext()) {
            String propertyName = (String)propsIter.next();
            if (formProps.get(propertyName) instanceof Collection) {
                Iterator iter = ((Collection)formProps.get(propertyName)).iterator();
                while (iter.hasNext()) {
                    if (lookupDao.createCriteria((Object)businessObject, (String)iter.next(), propertyName, this.isCaseSensitive(businessObject, propertyName), false, (Object)criteria)) continue;
                    throw new RuntimeException("Invalid value in Collection");
                }
                continue;
            }
            if (lookupDao.createCriteria((Object)businessObject, (String)formProps.get(propertyName), propertyName, this.isCaseSensitive(businessObject, propertyName), false, (Object)criteria)) continue;
        }
        return criteria;
    }

    private PersistableBusinessObject checkBusinessObjectClass(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("BusinessObject class passed to VersionHistoryLookupDaoOjb findCollectionBySearchHelper... method was null");
        }
        PersistableBusinessObject businessObject = null;
        try {
            businessObject = (PersistableBusinessObject)businessObjectClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("VersionHistoryLookupDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("VersionHistoryLookupDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        return businessObject;
    }

    private boolean isCaseSensitive(PersistableBusinessObject persistBo, String propertyName) {
        boolean caseInsensitive = false;
        DataDictionaryService dataDictionaryService = KraServiceLocator.getService(DataDictionaryService.class);
        if (dataDictionaryService.isAttributeDefined(persistBo.getClass(), propertyName).booleanValue()) {
            caseInsensitive = dataDictionaryService.getAttributeForceUppercase(persistBo.getClass(), propertyName) == false;
        }
        return caseInsensitive;
    }
}

