/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.document;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.CustomAttributeService;
import org.kuali.kra.workflow.KraDocumentXMLMaterializer;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.TransactionalDocumentBase;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.workflow.DocumentInitiator;
import org.kuali.rice.krad.workflow.KualiDocumentXmlMaterializer;
import org.kuali.rice.krad.workflow.KualiTransactionalDocumentInformation;

public abstract class ResearchDocumentBase
extends TransactionalDocumentBase {
    private static final long serialVersionUID = -1879382692835231633L;
    private static final Log LOG = LogFactory.getLog(ResearchDocumentBase.class);
    private String updateUser;
    private Timestamp updateTimestamp;
    private List<DocumentNextvalue> documentNextvalues = new ArrayList<DocumentNextvalue>();
    private Map<String, CustomAttributeDocument> customAttributeDocuments;
    private boolean viewOnly = false;
    private transient PersonService personService;

    public void initialize() {
    }

    public void prepareForSave() {
        DocumentHeader dbDocHeader;
        super.prepareForSave();
        String updateUser = GlobalVariables.getUserSession().getPrincipalName();
        if (updateUser.length() > 60) {
            updateUser = updateUser.substring(0, 60);
        }
        this.setUpdateTimestamp(this.getService(DateTimeService.class).getCurrentTimestamp());
        this.setUpdateUser(updateUser);
        if (this.getVersionNumber() == null) {
            this.setVersionNumber(new Long(0L));
        }
        if ((dbDocHeader = (DocumentHeader)this.getService(BusinessObjectService.class).retrieve((PersistableBusinessObject)this.getDocumentHeader())) != null) {
            this.getDocumentHeader().setVersionNumber(dbDocHeader.getVersionNumber());
        }
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
    }

    public void validateBusinessRules(KualiDocumentEvent event) {
        try {
            super.validateBusinessRules(event);
        }
        catch (ValidationException e) {
            LOG.error((Object)String.format("ValidationException when validating event: %s. Check log entries preceding this error for details.", event.getName()));
            throw e;
        }
    }

    public void updateDocumentDescriptions(List<BudgetDocumentVersion> budgetVersionOverviews) {
        BudgetService budgetService = this.getService(BudgetService.class);
        for (BudgetDocumentVersion budgetDocumentVersion : budgetVersionOverviews) {
            BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
            if (!budgetVersion.isDescriptionUpdatable() || StringUtils.isBlank((String)budgetVersion.getDocumentDescription())) continue;
            budgetService.updateDocumentDescription(budgetVersion);
            budgetVersion.setDescriptionUpdatable(false);
        }
    }

    public Map<String, CustomAttributeDocument> getCustomAttributeDocuments() {
        if (this.customAttributeDocuments == null) {
            CustomAttributeService customAttributeService = KraServiceLocator.getService(CustomAttributeService.class);
            this.customAttributeDocuments = customAttributeService.getDefaultCustomAttributeDocuments(this.getDocumentTypeCode(), this.getDocumentCustomData());
        }
        return this.customAttributeDocuments;
    }

    public abstract List<? extends DocumentCustomData> getDocumentCustomData();

    public Timestamp getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public void setDocumentNextvalues(List<DocumentNextvalue> documentNextvalues) {
        this.documentNextvalues = documentNextvalues;
    }

    public List<DocumentNextvalue> getDocumentNextvalues() {
        return this.documentNextvalues;
    }

    public Integer getDocumentNextValue(String propertyName) {
        Integer propNextValue = 1;
        for (DocumentNextvalue documentNextvalue : this.documentNextvalues) {
            if (!documentNextvalue.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            propNextValue = documentNextvalue.getNextValue();
            documentNextvalue.setNextValue(propNextValue + 1);
        }
        if (propNextValue == 1) {
            DocumentNextvalue documentNextvalue = new DocumentNextvalue();
            documentNextvalue.setNextValue(propNextValue + 1);
            documentNextvalue.setPropertyName(propertyName);
            documentNextvalue.setDocumentKey(this.documentNumber);
            this.documentNextvalues.add(documentNextvalue);
        }
        this.setDocumentNextvalues(this.documentNextvalues);
        return propNextValue;
    }

    public DocumentNextvalue getDocumentNextvalueBo(String propertyName) {
        for (DocumentNextvalue documentNextvalue : this.documentNextvalues) {
            if (!documentNextvalue.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return documentNextvalue;
        }
        DocumentNextvalue documentNextvalue = new DocumentNextvalue();
        documentNextvalue.setNextValue(1);
        documentNextvalue.setPropertyName(propertyName);
        return documentNextvalue;
    }

    public void setCustomAttributeDocuments(Map<String, CustomAttributeDocument> customAttributeDocuments) {
        this.customAttributeDocuments = customAttributeDocuments;
    }

    public CustomAttributeDocument getCustomAttributeDocument(String key) {
        return this.customAttributeDocuments.get(key);
    }

    public KualiDocumentXmlMaterializer wrapDocumentWithMetadataForXmlSerialization() {
        KualiTransactionalDocumentInformation transInfo = new KualiTransactionalDocumentInformation();
        DocumentInitiator initiatior = new DocumentInitiator();
        String initiatorNetworkId = this.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        Person initiatorUser = this.getPersonService().getPersonByPrincipalName(initiatorNetworkId);
        initiatior.setPerson(initiatorUser);
        transInfo.setDocumentInitiator(initiatior);
        KraDocumentXMLMaterializer xmlWrapper = new KraDocumentXMLMaterializer();
        xmlWrapper.setDocument((Document)this);
        xmlWrapper.setKualiTransactionalDocumentInformation(transInfo);
        return xmlWrapper;
    }

    protected List<RolePersons> getAllRolePersons() {
        return new ArrayList<RolePersons>();
    }

    protected <T> T getService(Class<T> serviceClass) {
        return KraServiceLocator.getService(serviceClass);
    }

    public abstract String getDocumentTypeCode();

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    public boolean answerSplitNodeQuestion(String routeNodeName) throws Exception {
        throw new UnsupportedOperationException("Document does not support answerSplitNodeQuestion for routeNodeName:" + routeNodeName);
    }

    private PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KraServiceLocator.getService(PersonService.class);
        }
        return this.personService;
    }

    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
    }

    public void toCopy() throws WorkflowException, IllegalStateException {
        super.toCopy();
        for (Note note : this.getNotes()) {
            note.setNoteIdentifier(null);
            note.setObjectId(null);
        }
    }

    public abstract boolean isProcessComplete();
}

