/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.Cfda;

import java.io.IOException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.common.util.StringUtils;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.external.Cfda.CfdaService;
import org.kuali.kra.external.Cfda.CfdaUpdateResults;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class CfdaBatchJob
extends QuartzJobBean {
    private static final String BREAK = "<BR>";
    private static final String CONTEXT_NAME = "CFDA Batch Job";
    private static final String SUBJECT = "CFDA batch job result";
    private static final Log LOG = LogFactory.getLog(CfdaBatchJob.class);
    private String user;
    private CfdaService cfdaService;
    private ParameterService parameterService;
    private KcNotificationService kcNotificationService;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        StringBuilder builder = new StringBuilder();
        UserSession userSession = new UserSession(this.user);
        GlobalVariables.setUserSession((UserSession)userSession);
        CfdaUpdateResults updateResults = new CfdaUpdateResults();
        try {
            updateResults = this.cfdaService.updateCfda();
        }
        catch (IOException e) {
            updateResults.setMessage("Error occured while updating " + e.getMessage());
        }
        builder.append("Message: " + updateResults.getMessage() + BREAK);
        builder.append("NumberOfRecordsDeactivatedBecauseNoLongerOnWebSite: " + updateResults.getNumberOfRecordsDeactivatedBecauseNoLongerOnWebSite() + BREAK);
        builder.append("NumberOfRecordsInKcDatabase: " + updateResults.getNumberOfRecordsInKcDatabase() + BREAK);
        builder.append("NumberOfRecordsNewlyAddedFromWebSite: " + updateResults.getNumberOfRecordsNewlyAddedFromWebSite() + BREAK);
        builder.append("NumberOfRecordsNotUpdatedBecauseManual: " + updateResults.getNumberOfRecordsNotUpdatedBecauseManual() + BREAK);
        builder.append("NumberOfRecordsNotUpdatedForHistoricalPurposes: " + updateResults.getNumberOfRecordsNotUpdatedForHistoricalPurposes() + BREAK);
        builder.append("NumberOfRecordsReActivated: " + updateResults.getNumberOfRecordsReActivated() + BREAK);
        builder.append("NumberOfRecordsRetrievedFromWebSite: " + updateResults.getNumberOfRecordsRetrievedFromWebSite() + BREAK);
        builder.append("NumberOfRecordsUpdatedBecauseAutomatic: " + updateResults.getNumberOfRecordsUpdatedBecauseAutomatic() + BREAK);
        String message = builder.toString();
        LOG.info((Object)message);
        String recipient = this.getRecipient();
        if (ObjectUtils.isNotNull((Object)recipient) && !StringUtils.isEmpty((String)recipient)) {
            this.kcNotificationService.sendNotification(CONTEXT_NAME, SUBJECT, message, Collections.singletonList(recipient));
        }
    }

    protected String getRecipient() {
        String recipient = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "CFDA_BATCH_NOTIFICATION_RECIPIENT");
        return recipient;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setCfdaService(CfdaService cfdaService) {
        this.cfdaService = cfdaService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }
}

