/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.budget.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.integration.cg.dto.BudgetAdjustmentCreationStatusDTO;
import org.kuali.kfs.integration.cg.dto.BudgetAdjustmentParametersDTO;
import org.kuali.kfs.integration.cg.dto.Details;
import org.kuali.kfs.module.external.kc.service.BudgetAdjustmentService;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetVersionOverviewExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.external.budget.BudgetAdjustmentClient;
import org.kuali.kra.external.budget.BudgetAdjustmentServiceHelper;
import org.kuali.kra.external.budget.FinancialObjectCodeMapping;
import org.kuali.kra.external.budget.RateClassRateType;
import org.kuali.kra.external.unit.service.InstitutionalUnitService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class BudgetAdjustmentClientBase
implements BudgetAdjustmentClient {
    protected static final String SOAP_SERVICE_NAME = "budgetAdjustmentServiceSOAP";
    protected static final QName SERVICE_NAME = new QName("http://kfs.kuali.org/kc-kfs/v2_0", "budgetAdjustmentServiceSOAP");
    private static final Log LOG = LogFactory.getLog(BudgetAdjustmentClientBase.class);
    private DocumentService documentService;
    private ParameterService parameterService;
    private BudgetCalculationService budgetCalculationService;
    private BusinessObjectService businessObjectService;
    private InstitutionalUnitService institutionalUnitService;
    private BudgetAdjustmentServiceHelper budgetAdjustmentServiceHelper;

    protected abstract BudgetAdjustmentService getServiceHandle();

    @Override
    public void createBudgetAdjustmentDocument(AwardBudgetDocument awardBudgetDocument) throws Exception {
        BudgetAdjustmentParametersDTO parametersDTO = new BudgetAdjustmentParametersDTO();
        boolean complete = this.setBudgetAdjustmentParameters(awardBudgetDocument, parametersDTO);
        if (complete) {
            try {
                BudgetAdjustmentService port = this.getServiceHandle();
                LOG.info((Object)"Invoking createBudgetAdjustment...");
                BudgetAdjustmentCreationStatusDTO budgetAdjustmentStatus = port.createBudgetAdjustment(parametersDTO);
                if (budgetAdjustmentStatus.getStatus().equalsIgnoreCase("success")) {
                    String completeErrorMessage;
                    if (budgetAdjustmentStatus.getDocumentNumber() == null) {
                        GlobalVariables.getMessageMap().putError("GlobalMessages", "error.award.createAccount.nullDocumentNumber", new String[0]);
                        awardBudgetDocument.refresh();
                        completeErrorMessage = "Document number returned from KFS budget adjustment service is null.";
                        GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.document.not.created", new String[]{completeErrorMessage});
                        LOG.warn((Object)completeErrorMessage);
                    } else {
                        awardBudgetDocument.getBudget().setBudgetAdjustmentDocumentNumber(budgetAdjustmentStatus.getDocumentNumber());
                        this.documentService.saveDocument((Document)awardBudgetDocument);
                    }
                    if (ObjectUtils.isNotNull(budgetAdjustmentStatus.getErrorMessages()) && !budgetAdjustmentStatus.getErrorMessages().isEmpty()) {
                        completeErrorMessage = "";
                        List<String> errorMessages = budgetAdjustmentStatus.getErrorMessages();
                        for (String errorMessage : errorMessages) {
                            completeErrorMessage = completeErrorMessage + errorMessage;
                        }
                        GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.budget.adjustment.saved.with.errors", new String[]{completeErrorMessage});
                    }
                } else {
                    String completeErrorMessage = "";
                    List<String> errorMessages = budgetAdjustmentStatus.getErrorMessages();
                    for (String errorMessage : errorMessages) {
                        completeErrorMessage = completeErrorMessage + errorMessage;
                    }
                    GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.document.not.created", new String[]{completeErrorMessage});
                }
            }
            catch (WebServiceException e) {
                String errorMessage = "Cannot connect to the service. The service may be down, please try again later.";
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.createAccount.cannotConnect", new String[0]);
                LOG.error((Object)(errorMessage + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean setBudgetAdjustmentParameters(AwardBudgetDocument awardBudgetDocument, BudgetAdjustmentParametersDTO parametersDTO) throws Exception {
        boolean complete = true;
        complete &= this.createBudgetAdjustmentDocumentHeader(awardBudgetDocument, parametersDTO);
        this.budgetCalculationService.calculateBudgetSummaryTotals(awardBudgetDocument.getAwardBudget());
        HashMap<String, BudgetDecimal> accountingLines = new HashMap<String, BudgetDecimal>();
        complete &= this.setNonPersonnelAccountingLines(awardBudgetDocument, accountingLines);
        complete &= this.setNonPersonnelCalculatedDirectCostAccountingLines(awardBudgetDocument, accountingLines);
        complete &= this.setPersonnelSalaryAccountingLines(awardBudgetDocument, accountingLines);
        complete &= this.setPersonnnelCalculatedDirectCost(awardBudgetDocument, accountingLines);
        complete &= this.setIndirectCostAccountingLine(awardBudgetDocument, accountingLines);
        complete &= this.setPersonnelFringeAccountingLines(awardBudgetDocument, accountingLines);
        this.createAccountingLines(accountingLines, awardBudgetDocument, parametersDTO);
        if (accountingLines.isEmpty()) {
            int period = awardBudgetDocument.getBudget().getBudgetPeriods().size();
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.empty.accounting.lines", new String[]{period + ""});
            complete &= false;
        }
        return complete;
    }

    protected boolean setPersonnnelCalculatedDirectCost(AwardBudgetDocument awardBudgetDocument, Map<String, BudgetDecimal> accountingLines) {
        Budget currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        boolean complete = true;
        Map<RateClassRateType, BudgetDecimal> netPersonnelCalculatedDirectCost = this.getBudgetAdjustmentServiceHelper().getPersonnelCalculatedDirectCost(currentBudget, previousBudget);
        for (RateClassRateType rate : netPersonnelCalculatedDirectCost.keySet()) {
            LOG.info((Object)("Personnel calculated direct cost: " + rate.getRateType() + "-" + rate.getRateClass() + " = " + (Object)((Object)netPersonnelCalculatedDirectCost.get(rate))));
            String financialObjectCode = this.getFinancialObjectCode(awardBudgetDocument, rate.getRateClass(), rate.getRateType());
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, netPersonnelCalculatedDirectCost.get(rate));
                continue;
            }
            accountingLines.put(financialObjectCode, (BudgetDecimal)accountingLines.get(financialObjectCode).add(netPersonnelCalculatedDirectCost.get(rate)));
        }
        return complete;
    }

    protected boolean setIndirectCostAccountingLine(AwardBudgetDocument awardBudgetDocument, Map<String, BudgetDecimal> accountingLines) {
        Budget currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        boolean complete = true;
        Map<RateClassRateType, BudgetDecimal> netIndirectCost = this.getBudgetAdjustmentServiceHelper().getIndirectCost(currentBudget, previousBudget);
        for (RateClassRateType rate : netIndirectCost.keySet()) {
            Details details = new Details();
            details.setCurrentAmount(netIndirectCost.get(rate).toString());
            LOG.info((Object)("Indirect cost: " + rate.getRateType() + "-" + rate.getRateClass() + " = " + (Object)((Object)netIndirectCost.get(rate))));
            String financialObjectCode = this.getFinancialObjectCode(awardBudgetDocument, rate.getRateClass(), rate.getRateType());
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, netIndirectCost.get(rate));
                continue;
            }
            accountingLines.put(financialObjectCode, (BudgetDecimal)accountingLines.get(financialObjectCode).add(netIndirectCost.get(rate)));
        }
        return complete;
    }

    protected boolean setPersonnelFringeAccountingLines(AwardBudgetDocument awardBudgetDocument, Map<String, BudgetDecimal> accountingLines) {
        Budget currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        boolean complete = true;
        Map<RateClassRateType, BudgetDecimal> netFringeCost = this.getBudgetAdjustmentServiceHelper().getPersonnelFringeCost(currentBudget, previousBudget);
        for (RateClassRateType rate : netFringeCost.keySet()) {
            LOG.info((Object)("Personnel fringe cost: " + rate.getRateType() + "-" + rate.getRateClass() + " = " + (Object)((Object)netFringeCost.get(rate))));
            String financialObjectCode = this.getFinancialObjectCode(awardBudgetDocument, rate.getRateClass(), rate.getRateType());
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, netFringeCost.get(rate));
                continue;
            }
            accountingLines.put(financialObjectCode, (BudgetDecimal)accountingLines.get(financialObjectCode).add(netFringeCost.get(rate)));
        }
        return complete;
    }

    protected boolean setPersonnelSalaryAccountingLines(AwardBudgetDocument awardBudgetDocument, Map<String, BudgetDecimal> accountingLines) throws Exception {
        Budget currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        boolean complete = true;
        SortedMap<String, BudgetDecimal> netCost = this.getBudgetAdjustmentServiceHelper().getPersonnelSalaryCost(currentBudget, previousBudget);
        for (String name : netCost.keySet()) {
            String financialObjectCode = this.getFinancialObjectCode(name);
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, (BudgetDecimal)((Object)netCost.get(name)));
                continue;
            }
            accountingLines.put(financialObjectCode, (BudgetDecimal)accountingLines.get(financialObjectCode).add((AbstractKualiDecimal)netCost.get(name)));
        }
        return complete;
    }

    protected String[] getElements(String person) throws Exception {
        if (person.contains(",")) {
            String[] personElements = person.split(",");
            return personElements;
        }
        LOG.error((Object)"The string is not in the format objectCode,personId  . Unable to retrieve object code.");
        throw new Exception("The string " + person + "is not in the format objectCode,personId  . Unable to retrieve object code.");
    }

    protected boolean setNonPersonnelCalculatedDirectCostAccountingLines(AwardBudgetDocument awardBudgetDocument, Map<String, BudgetDecimal> accountingLines) {
        boolean complete = true;
        Budget currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        SortedMap<RateType, BudgetDecimal> netExpense = this.getBudgetAdjustmentServiceHelper().getNonPersonnelCalculatedDirectCost(currentBudget, previousBudget);
        SortedMap<RateType, List<BudgetDecimal>> currentNonPersonnelCalcDirectCost = awardBudgetDocument.getAwardBudget().getNonPersonnelCalculatedExpenseTotals();
        for (RateType rateType : netExpense.keySet()) {
            LOG.info((Object)("NonPersonnel calculated direct cost: " + rateType.getRateTypeCode() + "-" + rateType.getRateClassCode() + " = " + netExpense.get(rateType)));
            if (rateType.getRateClass().getRateClassType().equalsIgnoreCase("O")) continue;
            List expenses = (List)currentNonPersonnelCalcDirectCost.get(rateType);
            Details details = new Details();
            details.setCurrentAmount(((BudgetDecimal)((Object)netExpense.get(rateType))).toString());
            String financialObjectCode = this.getFinancialObjectCode(awardBudgetDocument, rateType.getRateClassCode(), rateType.getRateTypeCode());
            if (ObjectUtils.isNull((Object)financialObjectCode)) {
                complete &= false;
                continue;
            }
            if (!accountingLines.containsKey(financialObjectCode)) {
                accountingLines.put(financialObjectCode, (BudgetDecimal)((Object)netExpense.get(rateType)));
                continue;
            }
            accountingLines.put(financialObjectCode, (BudgetDecimal)accountingLines.get(financialObjectCode).add((AbstractKualiDecimal)netExpense.get(rateType)));
        }
        return complete;
    }

    protected boolean setNonPersonnelAccountingLines(AwardBudgetDocument awardBudgetDocument, Map<String, BudgetDecimal> accountingLines) {
        Budget currentBudget = awardBudgetDocument.getBudget();
        AwardBudgetExt previousBudget = this.getPrevBudget(awardBudgetDocument);
        HashMap<String, BudgetDecimal> nonPersonnelCost = this.getBudgetAdjustmentServiceHelper().getNonPersonnelCost(currentBudget, previousBudget);
        boolean complete = true;
        for (String costElement : nonPersonnelCost.keySet()) {
            if (ObjectUtils.isNotNull((Object)this.getFinancialObjectCode(costElement))) {
                BudgetDecimal currentAmount = (BudgetDecimal)nonPersonnelCost.get(costElement).abs();
                if (!currentAmount.isNonZero()) continue;
                String financialObjectCode = this.getFinancialObjectCode(costElement);
                if (!accountingLines.containsKey(financialObjectCode)) {
                    accountingLines.put(financialObjectCode, nonPersonnelCost.get(costElement));
                } else {
                    accountingLines.put(financialObjectCode, (BudgetDecimal)accountingLines.get(financialObjectCode).add(nonPersonnelCost.get(costElement)));
                }
                LOG.info((Object)("NonPersonnelCalculatedDirectCost OC: " + financialObjectCode + " = " + (Object)((Object)accountingLines.get(financialObjectCode))));
                continue;
            }
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.financial.objectCode.mapping.not.found", new String[]{"Object Code: " + costElement});
            complete &= false;
        }
        return complete;
    }

    protected AwardBudgetExt getPrevBudget(AwardBudgetDocument awardBudgetDocument) {
        int currentVersionNumber = awardBudgetDocument.getBudget().getBudgetVersionNumber();
        AwardBudgetExt prevBudget = this.getPrevBudget(awardBudgetDocument.getParentDocument().getBudgetParent().getAwardDocument());
        if (ObjectUtils.isNotNull((Object)prevBudget.getBudgetVersionNumber()) && prevBudget.getBudgetVersionNumber() < currentVersionNumber) {
            this.budgetCalculationService.calculateBudgetSummaryTotals(prevBudget);
            return prevBudget;
        }
        return null;
    }

    protected String getParameterValue(String awardBudgetParameter) {
        return this.parameterService.getParameterValueAsString(AwardBudgetDocument.class, awardBudgetParameter);
    }

    protected String getPostedBudgetStatus() {
        return this.getParameterValue("awardBudgetStatusPosted");
    }

    protected AwardBudgetExt getPrevBudget(AwardDocument awardDocument) {
        return this.getNewestBudgetByStatus(awardDocument, Arrays.asList(this.getPostedBudgetStatus()));
    }

    protected AwardBudgetExt getNewestBudgetByStatus(AwardDocument awardDocument, List<String> statuses) {
        BudgetVersionOverview budgetVersion = null;
        List awardBudgetDocuments = awardDocument.getBudgetDocumentVersions();
        for (BudgetDocumentVersion version : awardBudgetDocuments) {
            AwardBudgetVersionOverviewExt curVersion = (AwardBudgetVersionOverviewExt)version.getBudgetVersionOverview();
            if (!statuses.contains(curVersion.getAwardBudgetStatusCode()) || budgetVersion != null && curVersion.getBudgetVersionNumber() <= budgetVersion.getBudgetVersionNumber()) continue;
            budgetVersion = curVersion;
        }
        AwardBudgetExt result = null;
        if (budgetVersion != null) {
            result = (AwardBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)budgetVersion.getBudgetId());
        }
        if (result == null) {
            result = new AwardBudgetExt();
        }
        return result;
    }

    protected boolean createBudgetAdjustmentDocumentHeader(AwardBudgetDocument awardBudgetDocument, BudgetAdjustmentParametersDTO parametersDTO) {
        parametersDTO.setOrgDocNumber("");
        Award award = awardBudgetDocument.getParentDocument().getBudgetParent();
        parametersDTO.setSponsorType(award.getSponsor().getSponsorTypeCode());
        String COMMENT = "Generated from award budget -" + awardBudgetDocument.getDocumentNumber();
        parametersDTO.setDescription(COMMENT);
        parametersDTO.setPrincipalId(GlobalVariables.getUserSession().getPrincipalId());
        return true;
    }

    protected void createAccountingLines(Map<String, BudgetDecimal> accountingLines, AwardBudgetDocument awardBudgetDocument, BudgetAdjustmentParametersDTO parametersDTO) {
        for (String objectCode : accountingLines.keySet()) {
            if (!accountingLines.get(objectCode).isNonZero()) continue;
            Details details = new Details();
            details.setCurrentAmount(accountingLines.get(objectCode).toString());
            details.setObjectCode(objectCode);
            details.setChart(this.getAwardChart(awardBudgetDocument));
            details.setAccount(this.getAwardAccount(awardBudgetDocument));
            details.setProjectCode("");
            details.setSubAccount("");
            parametersDTO.getDetails().add(details);
            LOG.info((Object)("ObjectCode: " + objectCode + "Amount: " + (Object)((Object)accountingLines.get(objectCode))));
        }
    }

    protected String getParameterValue(String parameterName, String key) {
        Collection parameterValues = this.parameterService.getParameterValuesAsString("KC-AWARD", "Document", parameterName);
        String REGEX = "(.+)\\s*=\\s*(.+)";
        String parameterValue = "";
        Pattern pattern = Pattern.compile(REGEX);
        for (String value : parameterValues) {
            Matcher matcher = pattern.matcher(value);
            if (matcher.find()) {
                if (!matcher.group(1).equalsIgnoreCase(key)) continue;
                parameterValue = matcher.group(2);
                continue;
            }
            LOG.error((Object)"Did not find = in the parameter values. Invalid parameter values.");
        }
        return parameterValue;
    }

    protected String getAwardChart(AwardBudgetDocument awardBudgetDocument) {
        Award award = awardBudgetDocument.getParentDocument().getBudgetParent();
        return award.getFinancialChartOfAccountsCode();
    }

    protected String getProjectCode() {
        return "";
    }

    protected String getFinancialObjectCode(AwardBudgetDocument awardBudgetDocument, String rateClassCode, String rateTypeCode) {
        Award award = awardBudgetDocument.getParentDocument().getBudgetParent();
        String activityTypeCode = award.getActivityTypeCode();
        String awardUnitNumber = award.getUnitNumber();
        List<FinancialObjectCodeMapping> results = this.getFinancialObjectCodesFromMappingTable(rateClassCode, rateTypeCode, awardUnitNumber);
        if (results.isEmpty()) {
            List<String> parentUnits = this.institutionalUnitService.getParentUnits(awardUnitNumber);
            for (String currentUnitNumber : parentUnits) {
                List<FinancialObjectCodeMapping> parentUnitResults = this.getFinancialObjectCodesFromMappingTable(rateClassCode, rateTypeCode, currentUnitNumber);
                if (parentUnitResults.isEmpty()) continue;
                return parentUnitResults.get(0).getFinancialObjectCode();
            }
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.financial.objectCode.mapping.not.found", new String[]{" Rate Class Code: " + rateClassCode + " Rate Type Code: " + rateTypeCode + " Unit: " + award.getUnitNumber() + " Activity Type: " + award.getActivityTypeCode()});
            LOG.error((Object)("Mapping not found for rateClasssCode: " + rateClassCode + "rateTypeCode: " + rateTypeCode + "unitnumber: "));
            return null;
        }
        for (FinancialObjectCodeMapping result : results) {
            if (!ObjectUtils.isNotNull((Object)result.getActivityTypeCode()) || !result.getActivityTypeCode().equalsIgnoreCase(activityTypeCode)) continue;
            return result.getFinancialObjectCode();
        }
        LOG.info((Object)("Returning" + results.get(0).getFinancialObjectCode()));
        return results.get(0).getFinancialObjectCode();
    }

    protected String getFinancialObjectCode(String costElementName) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("costElement", costElementName);
        CostElement costElement = (CostElement)this.getBusinessObjectService().findByPrimaryKey(CostElement.class, criteria);
        if (ObjectUtils.isNull((Object)costElement.getFinancialObjectCode())) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.financial.objectCode.mapping.not.found", new String[]{"Object Code: " + costElementName});
            LOG.error((Object)("No financial system object code mapped to object code " + costElementName + " ."));
        }
        return costElement.getFinancialObjectCode();
    }

    protected List<FinancialObjectCodeMapping> getFinancialObjectCodesFromMappingTable(String rateClassCode, String rateTypeCode, String unitNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("rateClassCode", rateClassCode);
        criteria.put("rateTypeCode", rateTypeCode);
        criteria.put("unitNumber", unitNumber);
        ArrayList<FinancialObjectCodeMapping> results = new ArrayList<FinancialObjectCodeMapping>(this.businessObjectService.findMatching(FinancialObjectCodeMapping.class, criteria));
        return results;
    }

    protected String getAwardAccount(AwardBudgetDocument awardBudgetDocument) {
        Award award = awardBudgetDocument.getParentDocument().getBudgetParent();
        return award.getAccountNumber();
    }

    protected BudgetAdjustmentServiceHelper getBudgetAdjustmentServiceHelper() {
        return this.budgetAdjustmentServiceHelper;
    }

    @Override
    public void setBudgetAdjustmentServiceHelper(BudgetAdjustmentServiceHelper budgetAdjustmentServiceHelper) {
        this.budgetAdjustmentServiceHelper = budgetAdjustmentServiceHelper;
    }

    @Override
    public void setInstitutionalUnitService(InstitutionalUnitService institutionalUnitService) {
        this.institutionalUnitService = institutionalUnitService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

