/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.unit.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.external.HashMapElement;
import org.kuali.kra.external.unit.UnitDTO;
import org.kuali.kra.external.unit.service.InstitutionalUnitService;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class InstitutionalUnitServiceImpl
implements InstitutionalUnitService {
    private UnitService unitService;
    private BusinessObjectService businessObjectService;
    private static final Log LOG = LogFactory.getLog(InstitutionalUnitServiceImpl.class);

    @Override
    public UnitDTO getUnit(String unitNumber) {
        Unit unit = this.unitService.getUnit(unitNumber);
        if (ObjectUtils.isNull((Object)((Object)unit))) {
            return null;
        }
        return this.unitBoToDto(unit);
    }

    @Override
    public List<UnitDTO> lookupUnits(List<HashMapElement> criteria) {
        ArrayList units;
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        ArrayList<UnitDTO> unitDTO = new ArrayList<UnitDTO>();
        if (ObjectUtils.isNull(criteria)) {
            units = new ArrayList(this.businessObjectService.findAll(Unit.class));
        } else {
            for (HashMapElement element : criteria) {
                searchCriteria.put(element.getKey(), element.getValue());
            }
            units = new ArrayList(this.businessObjectService.findMatching(Unit.class, searchCriteria));
        }
        for (Unit unit : units) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("unit in service is " + unit.getUnitName()));
            }
            unitDTO.add(this.unitBoToDto(unit));
        }
        return unitDTO;
    }

    @Override
    public List<String> getParentUnits(String unitNumber) {
        ArrayList<String> parentUnits = new ArrayList<String>();
        Unit unit = this.unitService.getUnit(unitNumber);
        if (ObjectUtils.isNull((Object)((Object)unit))) {
            LOG.warn((Object)("Cannot get parent units for unit " + unitNumber + ": unit does not exist"));
        } else {
            while (ObjectUtils.isNotNull((Object)((Object)unit.getParentUnit()))) {
                parentUnits.add(unit.getParentUnitNumber());
                unit = unit.getParentUnit();
            }
        }
        return parentUnits;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected UnitDTO unitBoToDto(Unit unit) {
        UnitDTO unitDTO = new UnitDTO();
        unitDTO.setUnitNumber(unit.getUnitNumber());
        unitDTO.setUnitName(unit.getUnitName());
        unitDTO.setOrganizationId(unit.getOrganizationId());
        for (UnitAdministrator unitAdmin : unit.getUnitAdministrators()) {
            unitDTO.getUnitAdministrators().add(unitAdmin.getPersonId());
        }
        return unitDTO;
    }
}

