/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.hierarchyrouting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.hierarchyrouting.UnitStop;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeConfigParam;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.hierarchyrouting.HierarchyProvider;
import org.kuali.rice.kew.util.Utilities;

public class KraHierarchyProvider
implements HierarchyProvider {
    private static final Log LOG = LogFactory.getLog(KraHierarchyProvider.class);
    private static final String DOCUMENT_XML_ELEMENT = "document";
    private static final String UNIT_XML_ELEMENT = "ownedByUnitNumber";
    private String unitNumber;
    private UnitStop root;
    private Map<String, UnitStop> stops = new HashMap<String, UnitStop>();

    public void configureRequestNode(RouteNodeInstance hiearchyNodeInstance, RouteNode node) {
        Map hierarchyCfgMap;
        Map cfgMap = Utilities.getKeyValueCollectionAsMap((List)node.getConfigParams());
        if (!cfgMap.containsKey("ruleSelector")) {
            hierarchyCfgMap = Utilities.getKeyValueCollectionAsMap((List)hiearchyNodeInstance.getRouteNode().getConfigParams());
            node.getConfigParams().add(new RouteNodeConfigParam(node, "ruleSelector", (String)hierarchyCfgMap.get("ruleSelector")));
        }
        if (!cfgMap.containsKey("ruleName")) {
            hierarchyCfgMap = Utilities.getKeyValueCollectionAsMap((List)hiearchyNodeInstance.getRouteNode().getConfigParams());
            node.getConfigParams().add(new RouteNodeConfigParam(node, "ruleName", (String)hierarchyCfgMap.get("ruleName")));
        }
    }

    public boolean equals(HierarchyProvider.Stop a, HierarchyProvider.Stop b) {
        return ObjectUtils.equals((Object)a, (Object)b);
    }

    public List<HierarchyProvider.Stop> getLeafStops(RouteContext context) {
        ArrayList<HierarchyProvider.Stop> leafStops = new ArrayList<HierarchyProvider.Stop>();
        for (UnitStop stop : this.stops.values()) {
            if (stop.children.size() != 0) continue;
            leafStops.add(stop);
        }
        return leafStops;
    }

    public HierarchyProvider.Stop getParent(HierarchyProvider.Stop stop) {
        return ((UnitStop)stop).parent;
    }

    public boolean isRoot(HierarchyProvider.Stop stop) {
        return this.equals(stop, this.root);
    }

    public HierarchyProvider.Stop getStop(RouteNodeInstance nodeInstance) {
        NodeState state = nodeInstance.getNodeState("id");
        if (state == null) {
            throw new RuntimeException();
        }
        LOG.warn((Object)("id Node state on nodeinstance " + nodeInstance + ": " + state));
        return this.stops.get(state.getValue());
    }

    public HierarchyProvider.Stop getStopByIdentifier(String stopId) {
        return this.stops.get(stopId);
    }

    public String getStopIdentifier(HierarchyProvider.Stop stop) {
        return ((UnitStop)stop).id;
    }

    public boolean hasStop(RouteNodeInstance nodeInstance) {
        return nodeInstance.getNodeState("id") != null;
    }

    private String retrieveDocumentUnitNumber(RouteContext context) {
        Document document = XmlHelper.buildJDocument((org.w3c.dom.Document)context.getDocumentContent().getDocument());
        String ownedByUnitNumber = null;
        try {
            List documentElements = (List)XmlHelper.findElements((Element)document.getRootElement(), (String)DOCUMENT_XML_ELEMENT);
            if (documentElements != null) {
                ownedByUnitNumber = ((Element)documentElements.get(0)).getChildText(UNIT_XML_ELEMENT);
            }
        }
        catch (XmlException e) {
            LOG.debug((Object)"XmlException Occurred while retrieving UnitNumber");
        }
        return ownedByUnitNumber;
    }

    public void init(RouteNodeInstance nodeInstance, RouteContext context) {
        if (StringUtils.isEmpty((String)this.unitNumber)) {
            this.unitNumber = this.retrieveDocumentUnitNumber(context);
        }
        Unit ownedByUnit = null;
        if (StringUtils.isNotEmpty((String)this.unitNumber) && (ownedByUnit = KraServiceLocator.getService(UnitService.class).getUnit(this.unitNumber)) != null) {
            List<Unit> units = KraServiceLocator.getService(UnitService.class).getAllSubUnits(this.unitNumber);
            for (Unit unit : units) {
                UnitStop simpleStop = (UnitStop)this.getStopByIdentifier(unit.getUnitNumber());
                if (simpleStop == null) {
                    simpleStop = new UnitStop();
                    simpleStop.id = unit.getUnitNumber();
                    this.stops.put(simpleStop.id, simpleStop);
                }
                if (StringUtils.isNotBlank((String)unit.getParentUnitNumber())) {
                    UnitStop parent = (UnitStop)this.getStopByIdentifier(unit.getParentUnitNumber());
                    if (parent == null) {
                        parent = new UnitStop();
                        parent.id = unit.getParentUnitNumber();
                        parent.children = new ArrayList<UnitStop>();
                        this.stops.put(parent.id, parent);
                    }
                    parent.children.add(simpleStop);
                    simpleStop.parent = parent;
                    continue;
                }
                this.root = simpleStop;
                simpleStop.parent = null;
            }
            if (this.root == null) {
                this.root = (UnitStop)this.getStopByIdentifier(this.unitNumber);
            }
        }
    }

    public void setStop(RouteNodeInstance requestNodeInstance, HierarchyProvider.Stop stop) {
        requestNodeInstance.addNodeState(new NodeState("id", this.getStopIdentifier(stop)));
    }
}

