/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucProtocolStatus;
import org.kuali.kra.iacuc.actions.copy.IacucProtocolCopyService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionStatus;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionType;
import org.kuali.kra.iacuc.customdata.IacucProtocolCustomData;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentFilter;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentProtocol;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonnelService;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupDetailBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.kra.iacuc.protocol.IacucProtocolProjectType;
import org.kuali.kra.iacuc.protocol.research.IacucProtocolResearchArea;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.iacuc.summary.IacucAlternateSearchSummary;
import org.kuali.kra.iacuc.summary.IacucProcedureSummary;
import org.kuali.kra.iacuc.summary.IacucProtocolExceptionSummary;
import org.kuali.kra.iacuc.summary.IacucProtocolSpeciesSummary;
import org.kuali.kra.iacuc.summary.IacucProtocolSummary;
import org.kuali.kra.iacuc.summary.IacucThreeRsSummary;
import org.kuali.kra.iacuc.threers.IacucAlternateSearch;
import org.kuali.kra.iacuc.threers.IacucPrinciples;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.protocol.summary.ProtocolSummary;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocol
extends ProtocolBase {
    private static final long serialVersionUID = 7380281405644745576L;
    private boolean isBillable;
    private String layStatement1;
    private String layStatement2;
    private String protocolProjectTypeCode;
    private String overviewTimeline;
    private String speciesStudyGroupIndicator;
    private String alternativeSearchIndicator;
    private String scientificJustifIndicator;
    private Timestamp createTimestamp;
    private String createUser;
    private IacucProtocolProjectType protocolProjectType;
    private List<IacucProtocolCustomData> iacucProtocolCustomDataList;
    private List<IacucPrinciples> iacucPrinciples;
    private List<IacucAlternateSearch> iacucAlternateSearches;
    private List<IacucProtocolSpecies> iacucProtocolSpeciesList;
    private List<IacucProtocolException> iacucProtocolExceptions;
    private List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroups;
    private List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroupBeans;
    private Integer speciesCode;
    private Integer exceptionCategoryCode;
    private static final CharSequence CONTINUATION_LETTER = "C";

    public IacucProtocol() {
        this.setCreateTimestamp(new Timestamp(new Date().getTime()));
        this.setCreateUser(GlobalVariables.getUserSession().getPrincipalId());
        this.setScientificJustifIndicator("no");
        this.setSpecialReviewIndicator("no");
        this.setSpeciesStudyGroupIndicator("no");
        this.setKeyStudyPersonIndicator("no");
        this.setFundingSourceIndicator("no");
        this.setCorrespondentIndicator("no");
        this.setReferenceIndicator("no");
        this.setAlternativeSearchIndicator("no");
        this.setIacucProtocolSpeciesList(new ArrayList<IacucProtocolSpecies>());
        this.setIacucAlternateSearches(new ArrayList<IacucAlternateSearch>());
        this.setIacucProtocolCustomDataList(new ArrayList<IacucProtocolCustomData>());
        this.setIacucProtocolExceptions(new ArrayList<IacucProtocolException>());
        this.setIacucProtocolStudyGroups(new ArrayList<IacucProtocolStudyGroupBean>());
        this.setIacucProtocolStudyGroupBeans(new ArrayList<IacucProtocolStudyGroupBean>());
        this.initIacucPrinciples();
    }

    @Override
    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getIacucProtocolCustomDataList());
        managedLists.add(this.getIacucPrinciples());
        managedLists.add(this.getIacucAlternateSearches());
        ArrayList<IacucProtocolStudyGroupDetailBean> studyGroupDetails = new ArrayList<IacucProtocolStudyGroupDetailBean>();
        ArrayList<IacucProtocolStudyGroupLocation> studyGroupLocations = new ArrayList<IacucProtocolStudyGroupLocation>();
        ArrayList<IacucProcedurePersonResponsible> personsResponsible = new ArrayList<IacucProcedurePersonResponsible>();
        for (IacucProtocolStudyGroupBean studyGroupBean : this.getIacucProtocolStudyGroups()) {
            studyGroupDetails.addAll(studyGroupBean.getIacucProtocolStudyGroupDetailBeans());
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : studyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                for (IacucProtocolStudyGroup studyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    studyGroupLocations.addAll(studyGroup.getIacucProtocolStudyGroupLocations());
                    personsResponsible.addAll(studyGroup.getIacucProcedurePersonsResponsible());
                }
            }
        }
        managedLists.add(studyGroupLocations);
        managedLists.add(personsResponsible);
        managedLists.add(studyGroupDetails);
        managedLists.add(this.getIacucProtocolStudyGroups());
        managedLists.add(this.getIacucProtocolExceptions());
        managedLists.add(this.getIacucProtocolSpeciesList());
        return managedLists;
    }

    public IacucProtocolSubmission getIacucProtocolSubmission() {
        return (IacucProtocolSubmission)this.getProtocolSubmission();
    }

    public boolean getIsBillable() {
        return this.isBillable;
    }

    public void setIsBillable(boolean isBillable) {
        this.isBillable = isBillable;
    }

    public String getLayStatement1() {
        return this.layStatement1;
    }

    public void setLayStatement1(String layStatement1) {
        this.layStatement1 = layStatement1;
    }

    public String getLayStatement2() {
        return this.layStatement2;
    }

    public void setLayStatement2(String layStatement2) {
        this.layStatement2 = layStatement2;
    }

    public String getOverviewTimeline() {
        return this.overviewTimeline;
    }

    public void setOverviewTimeline(String overviewTimeline) {
        this.overviewTimeline = overviewTimeline;
    }

    public String getSpeciesStudyGroupIndicator() {
        return this.speciesStudyGroupIndicator;
    }

    public void setSpeciesStudyGroupIndicator(String speciesStudyGroupIndicator) {
        this.speciesStudyGroupIndicator = speciesStudyGroupIndicator;
    }

    public String getAlternativeSearchIndicator() {
        return this.alternativeSearchIndicator;
    }

    public void setAlternativeSearchIndicator(String alternativeSearchIndicator) {
        this.alternativeSearchIndicator = alternativeSearchIndicator;
    }

    public String getScientificJustifIndicator() {
        return this.scientificJustifIndicator;
    }

    public void setScientificJustifIndicator(String scientificJustifIndicator) {
        this.scientificJustifIndicator = scientificJustifIndicator;
    }

    public void setIacucProtocolDocument(IacucProtocolDocument iacucProtocolDocument) {
        this.setProtocolDocument(iacucProtocolDocument);
    }

    public IacucProtocolDocument getIacucProtocolDocument() {
        return (IacucProtocolDocument)this.getProtocolDocument();
    }

    public void setBillable(boolean isBillable) {
        this.isBillable = isBillable;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    @Override
    protected IacucProtocolPersonnelService getProtocolPersonnelService() {
        return (IacucProtocolPersonnelService)KraServiceLocator.getService("iacucProtocolPersonnelService");
    }

    @Override
    public String getNamespace() {
        return "KC-IACUC";
    }

    @Override
    protected String getDefaultProtocolStatusCodeHook() {
        return "100";
    }

    @Override
    protected String getDefaultProtocolTypeCodeHook() {
        return null;
    }

    @Override
    protected ProtocolSubmissionStatusBase getProtocolSubmissionStatusNewInstanceHook() {
        return new IacucProtocolSubmissionStatus();
    }

    @Override
    protected ProtocolSubmissionTypeBase getProtocolSubmissionTypeNewInstanceHook() {
        return new IacucProtocolSubmissionType();
    }

    @Override
    protected ProtocolSubmissionBase getProtocolSubmissionNewInstanceHook() {
        return new IacucProtocolSubmission();
    }

    @Override
    protected ProtocolStatusBase getProtocolStatusNewInstanceHook() {
        return new IacucProtocolStatus();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-IACUC";
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roleNames = new ArrayList<String>();
        roleNames.add("IACUC Protocol Aggregator");
        roleNames.add("IACUC Protocol Viewer");
        return roleNames;
    }

    public List<IacucPrinciples> getIacucPrinciples() {
        return this.iacucPrinciples;
    }

    public void setIacucPrinciples(List<IacucPrinciples> iacucPrinciples) {
        this.iacucPrinciples = iacucPrinciples;
    }

    public List<IacucProtocolSpecies> getIacucProtocolSpeciesList() {
        return this.iacucProtocolSpeciesList;
    }

    public void setIacucProtocolSpeciesList(List<IacucProtocolSpecies> iacucProtocolSpeciesList) {
        this.iacucProtocolSpeciesList = iacucProtocolSpeciesList;
    }

    @Override
    protected ProtocolResearchAreaBase getNewProtocolResearchAreaInstance() {
        return new IacucProtocolResearchArea();
    }

    public List<IacucAlternateSearch> getIacucAlternateSearches() {
        return this.iacucAlternateSearches;
    }

    public void setIacucAlternateSearches(List<IacucAlternateSearch> iacucAlternateSearches) {
        this.iacucAlternateSearches = iacucAlternateSearches;
    }

    public void setProtocolProjectTypeCode(String protocolProjectTypeCode) {
        this.protocolProjectTypeCode = protocolProjectTypeCode;
    }

    public String getProtocolProjectTypeCode() {
        return this.protocolProjectTypeCode;
    }

    public void setProtocolProjectType(IacucProtocolProjectType protocolProjectType) {
        this.protocolProjectType = protocolProjectType;
    }

    public IacucProtocolProjectType getProtocolProjectType() {
        return this.protocolProjectType;
    }

    public List<IacucProtocolCustomData> getIacucProtocolCustomDataList() {
        return this.iacucProtocolCustomDataList;
    }

    public void setIacucProtocolCustomDataList(List<IacucProtocolCustomData> iacucProtocolCustomDataList) {
        this.iacucProtocolCustomDataList = iacucProtocolCustomDataList;
    }

    public List<IacucProtocolException> getIacucProtocolExceptions() {
        return this.iacucProtocolExceptions;
    }

    public void setIacucProtocolExceptions(List<IacucProtocolException> iacucProtocolExceptions) {
        this.iacucProtocolExceptions = iacucProtocolExceptions;
    }

    private void initIacucPrinciples() {
        ArrayList<IacucPrinciples> newPrinciples = new ArrayList<IacucPrinciples>();
        IacucPrinciples iPrinciples = new IacucPrinciples();
        newPrinciples.add(iPrinciples);
        this.setIacucPrinciples(newPrinciples);
    }

    public Integer getSpeciesCode() {
        return this.speciesCode;
    }

    public void setSpeciesCode(Integer speciesCode) {
        this.speciesCode = speciesCode;
    }

    public Integer getExceptionCategoryCode() {
        return this.exceptionCategoryCode;
    }

    public void setExceptionCategoryCode(Integer exceptionCategoryCode) {
        this.exceptionCategoryCode = exceptionCategoryCode;
    }

    @Override
    protected List<AnswerHeader> getAnswerHeaderForProtocol(ProtocolBase protocol) {
        IacucProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new IacucProtocolModuleQuestionnaireBean((IacucProtocol)protocol);
        moduleQuestionnaireBean.setModuleSubItemCode("0");
        ArrayList<AnswerHeader> answerHeaders = new ArrayList();
        answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
        return answerHeaders;
    }

    @Override
    public void initializeProtocolAttachmentFilter() {
        IacucProtocolAttachmentFilter protocolAttachmentFilter = new IacucProtocolAttachmentFilter();
        try {
            String defaultSortBy = this.getParameterService().getParameterValueAsString(IacucProtocolDocument.class, "IACUC_PROTOCOL_ATTACHMENT_DEFAULT_SORT");
            if (StringUtils.isNotBlank((String)defaultSortBy)) {
                protocolAttachmentFilter.setSortBy(defaultSortBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProtocolAttachmentFilter(protocolAttachmentFilter);
    }

    @Override
    public String getDocumentKey() {
        return "protocol";
    }

    @Override
    public ProtocolSummary getProtocolSummary() {
        ProtocolSummary protocolSummary = this.createProtocolSummary();
        this.addPersonnelSummaries(protocolSummary);
        this.addResearchAreaSummaries(protocolSummary);
        this.addAttachmentSummaries(protocolSummary);
        this.addFundingSourceSummaries(protocolSummary);
        this.addOrganizationSummaries(protocolSummary);
        this.addSpecialReviewSummaries(protocolSummary);
        this.addAdditionalInfoSummary(protocolSummary);
        this.addThreeRsSummary((IacucProtocolSummary)protocolSummary);
        this.addSpeciesAndGroupsSummaries((IacucProtocolSummary)protocolSummary);
        this.addExceptionsSummaries((IacucProtocolSummary)protocolSummary);
        this.addProceduresSummaries((IacucProtocolSummary)protocolSummary);
        return protocolSummary;
    }

    @Override
    protected ProtocolSummary createProtocolSummary() {
        IacucProtocolSummary summary = new IacucProtocolSummary();
        summary.setLastProtocolAction(this.getLastProtocolAction());
        summary.setProtocolNumber(this.getProtocolNumber().toString());
        summary.setPiName(this.getPrincipalInvestigator().getPersonName());
        summary.setPiProtocolPersonId(this.getPrincipalInvestigator().getProtocolPersonId());
        summary.setInitialSubmissionDate(this.getInitialSubmissionDate());
        summary.setApprovalDate(this.getApprovalDate());
        summary.setLastApprovalDate(this.getLastApprovalDate());
        summary.setExpirationDate(this.getExpirationDate());
        if (this.getProtocolType() == null) {
            this.refreshReferenceObject("protocolType");
        }
        summary.setType(this.getProtocolType().getDescription());
        if (this.getProtocolStatus() == null) {
            this.refreshReferenceObject("protocolStatus");
        }
        summary.setStatus(this.getProtocolStatus().getDescription());
        summary.setTitle(this.getTitle());
        summary.setLayStmt1(this.getLayStatement1());
        summary.setLayStmt2(this.getLayStatement2());
        if (this.getProtocolProjectType() == null) {
            this.refreshReferenceObject("protocolProjectType");
        }
        summary.setProjectType(this.protocolProjectType != null ? this.protocolProjectType.getDescription() : "N/A");
        return summary;
    }

    protected void addThreeRsSummary(IacucProtocolSummary protocolSummary) {
        IacucThreeRsSummary threeRsSummary = new IacucThreeRsSummary();
        if (this.getIacucPrinciples().size() > 0) {
            IacucPrinciples principles = this.getIacucPrinciples().get(0);
            threeRsSummary.setReduction(principles.getReduction());
            threeRsSummary.setRefinement(principles.getRefinement());
            threeRsSummary.setReplacement(principles.getReplacement());
            for (IacucAlternateSearch alternateSearch : this.iacucAlternateSearches) {
                threeRsSummary.getAlternateSearchSummaries().add(new IacucAlternateSearchSummary(alternateSearch));
                threeRsSummary.setSearchRequired("Y".equals(principles.getSearchRequired()));
            }
        }
        protocolSummary.setThreeRsInfo(threeRsSummary);
    }

    protected void addSpeciesAndGroupsSummaries(IacucProtocolSummary protocolSummary) {
        for (IacucProtocolSpecies species : this.iacucProtocolSpeciesList) {
            IacucProtocolSpeciesSummary newSummary = new IacucProtocolSpeciesSummary(species);
            protocolSummary.getSpeciesSummaries().add(newSummary);
        }
    }

    protected void addExceptionsSummaries(IacucProtocolSummary protocolSummary) {
        for (IacucProtocolException exception : this.iacucProtocolExceptions) {
            IacucProtocolExceptionSummary newSummary = new IacucProtocolExceptionSummary(exception);
            protocolSummary.getExceptionSummaries().add(newSummary);
        }
    }

    protected void addProceduresSummaries(IacucProtocolSummary protocolSummary) {
        protocolSummary.setProcedureOverviewSummary(this.overviewTimeline);
        for (IacucProtocolStudyGroupBean studyGroupBean : this.getIacucProtocolStudyGroups()) {
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : studyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                for (IacucProtocolStudyGroup studyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    IacucProcedureSummary newSummary = new IacucProcedureSummary(studyGroup, studyGroupBean.getIacucProcedureCategory(), studyGroupBean.getIacucProcedure());
                    protocolSummary.getProcedureSummaries().add(newSummary);
                }
            }
        }
    }

    public List<IacucProtocolStudyGroupBean> getIacucProtocolStudyGroups() {
        return this.iacucProtocolStudyGroups;
    }

    public void setIacucProtocolStudyGroups(List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroups) {
        this.iacucProtocolStudyGroups = iacucProtocolStudyGroups;
    }

    public List<IacucProtocolStudyGroupBean> getIacucProtocolStudyGroupBeans() {
        return this.iacucProtocolStudyGroupBeans;
    }

    public void setIacucProtocolStudyGroupBeans(List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroupBeans) {
        this.iacucProtocolStudyGroupBeans = iacucProtocolStudyGroupBeans;
    }

    @Override
    protected String getProtocolModuleAddModifyAttachmentCodeHook() {
        return "008";
    }

    @Override
    public void merge(ProtocolBase amendment, String protocolModuleTypeCode) {
        if (StringUtils.equals((String)protocolModuleTypeCode, (String)"001")) {
            this.mergeGeneralInfo(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"004")) {
            this.mergeResearchAreas(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"024")) {
            this.mergeFundingSources(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"017")) {
            this.mergeOrganizations(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"002")) {
            this.mergePersonnel(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"008")) {
            if (amendment.isAmendment() || amendment.isRenewal() || !amendment.getAttachmentProtocols().isEmpty() && this.getAttachmentProtocols().isEmpty()) {
                this.mergeAttachments(amendment);
            } else {
                this.restoreAttachments(this);
            }
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"016")) {
            this.mergeReferences(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"007")) {
            this.mergeSpecialReview(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"023")) {
            this.mergeOthers(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"025")) {
            this.mergeProtocolPermissions(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"026")) {
            this.mergeProtocolQuestionnaire(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"036")) {
            this.mergeProtocolThreers(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"032")) {
            this.mergeProtocolSpeciesAndGroups(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"031")) {
            this.mergeProtocolProcedures(amendment);
        } else if (StringUtils.equals((String)protocolModuleTypeCode, (String)"033")) {
            this.mergeProtocolExceptions(amendment);
        }
    }

    @Override
    protected void mergeProtocolAction(ProtocolBase amendment) {
        List protocolActions = (List)this.deepCopy(amendment.getProtocolActions());
        Collections.sort(protocolActions, new Comparator<ProtocolActionBase>(){

            @Override
            public int compare(ProtocolActionBase action1, ProtocolActionBase action2) {
                return action1.getActionId().compareTo(action2.getActionId());
            }
        });
        protocolActions.remove(0);
        protocolActions.remove(protocolActions.size() - 1);
        for (ProtocolActionBase protocolAction : protocolActions) {
            protocolAction.setProtocolNumber(this.getProtocolNumber());
            protocolAction.setProtocolActionId(null);
            protocolAction.setSequenceNumber(this.getSequenceNumber());
            protocolAction.setProtocolId(this.getProtocolId());
            String index = amendment.getProtocolNumber().substring(11);
            protocolAction.setActionId(this.getNextValue("actionId"));
            String type = this.getProtocolMergeType(amendment);
            if (StringUtils.isNotBlank((String)protocolAction.getComments())) {
                protocolAction.setComments(type + "-" + index + ": " + protocolAction.getComments());
            } else {
                protocolAction.setComments(type + "-" + index + ": ");
            }
            for (KcNotification notification : protocolAction.getProtocolNotifications()) {
                notification.setDocumentNumber(this.getProtocolDocument().getDocumentNumber());
                notification.setNotificationId(null);
            }
            for (KcNotification notification : protocolAction.getProtocolNotifications()) {
                notification.setDocumentNumber(this.getProtocolDocument().getDocumentNumber());
                notification.setNotificationId(null);
            }
            this.getProtocolActions().add(protocolAction);
        }
    }

    @Override
    protected void mergeGeneralInfo(ProtocolBase amendment) {
        super.mergeGeneralInfo(amendment);
        this.layStatement1 = ((IacucProtocol)amendment).layStatement1;
        this.layStatement2 = ((IacucProtocol)amendment).layStatement2;
        this.overviewTimeline = ((IacucProtocol)amendment).overviewTimeline;
        this.protocolProjectTypeCode = ((IacucProtocol)amendment).protocolProjectTypeCode;
    }

    protected void mergeProtocolThreers(ProtocolBase amendment) {
        this.getProtocolCopyService().copyProtocolThreers((IacucProtocol)amendment, this);
    }

    protected void mergeProtocolSpeciesAndGroups(ProtocolBase amendment) {
        this.getProtocolCopyService().mergeProtocolSpeciesAndGroups((IacucProtocol)amendment, this);
    }

    protected void mergeProtocolProcedures(ProtocolBase amendment) {
        this.getProtocolCopyService().mergeProtocolProcedures((IacucProtocol)amendment, this);
    }

    protected void mergeProtocolExceptions(ProtocolBase amendment) {
        this.getProtocolCopyService().copyProtocolExceptions((IacucProtocol)amendment, this);
    }

    protected IacucProtocolCopyService getProtocolCopyService() {
        return (IacucProtocolCopyService)KraServiceLocator.getService("iacucProtocolCopyService");
    }

    public boolean isContinuation() {
        return this.getProtocolNumber().contains(CONTINUATION_LETTER);
    }

    protected String getProtocolMergeType(ProtocolBase amendment) {
        IacucProtocol protocolAmend = (IacucProtocol)amendment;
        String type = "Amendment";
        if (protocolAmend.isRenewal()) {
            type = "Renewal";
        } else if (protocolAmend.isContinuation()) {
            type = "Continuation";
        }
        return type;
    }

    @Override
    public boolean isNew() {
        return !this.isAmendment() && !this.isRenewal() && !this.isContinuation();
    }

    public boolean isContinuationWithoutAmendment() {
        return this.isContinuation() && CollectionUtils.isEmpty(this.getProtocolAmendRenewal().getModules());
    }

    @Override
    public String getAmendedProtocolNumber() {
        if (this.isAmendment()) {
            return StringUtils.substringBefore((String)this.getProtocolNumber(), (String)AMENDMENT_LETTER.toString());
        }
        if (this.isRenewal()) {
            return StringUtils.substringBefore((String)this.getProtocolNumber(), (String)RENEWAL_LETTER.toString());
        }
        if (this.isContinuation()) {
            return StringUtils.substringBefore((String)this.getProtocolNumber(), (String)CONTINUATION_LETTER.toString());
        }
        return null;
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        this.getProtocolProcedureService().setIacucProtocolStudyGroupReferences(this);
    }

    protected IacucProtocolProcedureService getProtocolProcedureService() {
        return KraServiceLocator.getService(IacucProtocolProcedureService.class);
    }

    @Override
    public KrmsRulesContext getKrmsRulesContext() {
        return this.getIacucProtocolDocument();
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        if (qualifiedRoleAttributes == null) {
            qualifiedRoleAttributes = new HashMap<String, String>();
        }
        String protocolNumber = this.getProtocolNumber() != null ? this.getProtocolNumber() : "*";
        qualifiedRoleAttributes.put("protocol", protocolNumber);
    }

    @Override
    protected Class<? extends ProtocolAttachmentProtocolBase> getProtocolAttachmentProtocolClassHook() {
        return IacucProtocolAttachmentProtocol.class;
    }
}

