/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolFinderDao;
import org.kuali.kra.iacuc.IacucProtocolVersionService;
import org.kuali.kra.iacuc.IacucResearchArea;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.notification.IacucProtocolNotification;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRenderer;
import org.kuali.kra.iacuc.protocol.location.IacucProtocolLocationService;
import org.kuali.kra.iacuc.protocol.research.IacucProtocolResearchAreaService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.service.KcKrmsFactBuilderService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.ProtocolVersionService;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationService;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-IACUC")
@ParameterConstants.COMPONENT(component="Document")
public class IacucProtocolDocument
extends ProtocolDocumentBase {
    private static final long serialVersionUID = -1014286912251147390L;
    private static final Log LOG = LogFactory.getLog(IacucProtocolDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "ICPR";
    private static final String CONTINUATION_KEY = "C";
    private static final String DISAPPROVED_CONTEXT_NAME = "Disapproved";

    @Override
    protected IacucProtocol createNewProtocolInstanceHook() {
        return new IacucProtocol();
    }

    public IacucProtocol getIacucProtocol() {
        return (IacucProtocol)this.getProtocol();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = true;
        if (this.getProtocol().getProtocolStatusCode().equals("101")) {
            if (this.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("Initiated")) {
                isComplete = false;
            }
            this.getProtocol().getProtocolSubmission().refreshReferenceObject("submissionStatus");
            String status = this.getProtocol().getProtocolSubmission().getSubmissionStatusCode();
            if ((this.isAmendment() || this.isRenewal() || this.isContinuation()) && status.equals("200") && this.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("IACUCReview")) {
                isComplete = false;
            }
        } else {
            if (this.getProtocol().getProtocolStatusCode().equals("400") || this.getProtocol().getProtocolStatusCode().equals("401") || this.getProtocol().getProtocolStatusCode().equals("402")) {
                String protocolId = this.getNewProtocolDocId();
                if (ObjectUtils.isNull((Object)protocolId)) {
                    isComplete = false;
                } else {
                    String oldLocation = (String)GlobalVariables.getUserSession().retrieveObject("holdingPageReturnLocation");
                    String oldDocNbr = this.getProtocol().getProtocolDocument().getDocumentNumber();
                    String returnLocation = oldLocation.replaceFirst(oldDocNbr, protocolId);
                    GlobalVariables.getUserSession().addObject("holdingPageReturnLocation", (Object)returnLocation);
                }
            }
            if (!this.getDocumentHeader().getWorkflowDocument().isFinal()) {
                isComplete = false;
            }
        }
        return isComplete;
    }

    @Override
    protected Class<? extends ProtocolLocationService> getProtocolLocationServiceClassHook() {
        return IacucProtocolLocationService.class;
    }

    @Override
    protected Class<? extends ProtocolResearchAreaService> getProtocolResearchAreaServiceClassHook() {
        return IacucProtocolResearchAreaService.class;
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-IACUC");
        qualifiers.put("name", "KC IACUC Context");
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        KcKrmsFactBuilderService fbService = (KcKrmsFactBuilderService)KraServiceLocator.getService("iacucProtocolFactBuilderService");
        fbService.addFacts(factsBuilder, this);
    }

    @Override
    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String protocolStatusCode) {
        String protocolActionTypeCode = "104";
        if (protocolStatusCode.equals("400")) {
            protocolActionTypeCode = "102";
        } else if (protocolStatusCode.equals("402")) {
            protocolActionTypeCode = "103";
        } else if (protocolStatusCode.equals("113")) {
            protocolActionTypeCode = "113";
        }
        return new IacucProtocolAction((IacucProtocol)protocol, (IacucProtocolSubmission)protocolSubmission, protocolActionTypeCode);
    }

    @Override
    protected Class<? extends ProtocolActionService> getProtocolActionServiceClassHook() {
        return IacucProtocolActionService.class;
    }

    @Override
    protected Class<? extends ProtocolBase> getProtocolBOClassHook() {
        return IacucProtocol.class;
    }

    protected ProtocolFinderDao getProtocolFinderDaoHook() {
        return KraServiceLocator.getService(IacucProtocolFinderDao.class);
    }

    protected ProtocolVersionService getProtocolVersionServiceHook() {
        return KraServiceLocator.getService(IacucProtocolVersionService.class);
    }

    protected String getProtocolActionTypeApprovedHook() {
        return "204";
    }

    protected String getProtocolStatusExemptHook() {
        return "203";
    }

    protected String getProtocolStatusActiveOpenToEnrollmentHook() {
        return "200";
    }

    protected String getListOfStatusEligibleForMergingHook() {
        StringBuffer listOfStatusEligibleForMerging = new StringBuffer();
        listOfStatusEligibleForMerging.append("101");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("104");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("103");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("107");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("205");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("206");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("207");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("304");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("301");
        listOfStatusEligibleForMerging.append(" ");
        listOfStatusEligibleForMerging.append("105");
        return listOfStatusEligibleForMerging.toString();
    }

    public boolean isContinuation() {
        return this.getProtocol().getProtocolNumber().contains(CONTINUATION_KEY);
    }

    protected String getProtocolMergedStatus() {
        String mergedStatus = "400";
        if (this.isRenewal()) {
            mergedStatus = "401";
        } else if (this.isContinuation()) {
            mergedStatus = "402";
        }
        return mergedStatus;
    }

    @Override
    public boolean isNormal() {
        return !this.isAmendment() && !this.isRenewal() && !this.isContinuation();
    }

    @Override
    protected void mergeProtocolAmendment() {
        if (this.isAmendment()) {
            this.mergeAmendment(this.getProtocolMergedStatus(), "Amendment");
        } else if (this.isRenewal()) {
            this.mergeAmendment(this.getProtocolMergedStatus(), "Renewal");
        } else if (this.isContinuation()) {
            this.mergeAmendment(this.getProtocolMergedStatus(), "Continuation");
        }
    }

    @Override
    protected Class<? extends ResearchAreaBase> getResearchAreaBoClassHook() {
        return IacucResearchArea.class;
    }

    protected void mergeAmendment(String protocolStatusCode, String type) {
        ProtocolDocumentBase newProtocolDocument;
        ProtocolBase currentProtocol = this.getProtocolFinderDaoHook().findCurrentProtocolByNumber(this.getOriginalProtocolNumber());
        try {
            currentProtocol.setProtocolDocument((ProtocolDocumentBase)this.getDocumentService().getByDocumentHeaderId(currentProtocol.getProtocolDocument().getDocumentNumber()));
            currentProtocol.setMergeAmendment(true);
            newProtocolDocument = this.getProtocolVersionServiceHook().versionProtocolDocument(currentProtocol.getProtocolDocument());
        }
        catch (Exception e) {
            throw new ProtocolDocumentBase.ProtocolMergeException(e);
        }
        newProtocolDocument.getProtocol().merge(this.getProtocol());
        this.getProtocol().setProtocolStatusCode(protocolStatusCode);
        ProtocolActionBase action = this.getNewProtocolActionInstanceHook(newProtocolDocument.getProtocol(), null, this.getProtocolActionTypeApprovedHook());
        action.setComments(type + "-" + this.getProtocolNumberIndex() + ": Approved");
        newProtocolDocument.setProtocolWorkflowType(ProtocolDocumentBase.ProtocolWorkflowType.APPROVED);
        newProtocolDocument.getProtocol().getProtocolActions().add(action);
        if (!currentProtocol.getProtocolStatusCode().equals(this.getProtocolStatusExemptHook())) {
            newProtocolDocument.getProtocol().setProtocolStatusCode(this.getProtocolStatusActiveOpenToEnrollmentHook());
        }
        try {
            this.getDocumentService().saveDocument((Document)newProtocolDocument);
            newProtocolDocument.getDocumentHeader().getWorkflowDocument().route(type + "-" + this.getProtocolNumberIndex() + ": merged");
        }
        catch (WorkflowException e) {
            throw new ProtocolDocumentBase.ProtocolMergeException(e);
        }
        this.getProtocol().setActive(false);
        for (ProtocolBase otherProtocol : this.getProtocolFinderDaoHook().findProtocols(this.getOriginalProtocolNumber())) {
            String status = otherProtocol.getProtocolStatus().getProtocolStatusCode();
            if (!this.isEligibleForMerging(status, otherProtocol)) continue;
            otherProtocol.merge(this.getProtocol(), false);
            action = this.getNewProtocolActionInstanceHook(otherProtocol, null, protocolStatusCode);
            action.setComments(type + "-" + this.getProtocolNumberIndex() + ": Merged");
            otherProtocol.getProtocolActions().add(action);
            this.getBusinessObjectService().save((PersistableBusinessObject)otherProtocol);
        }
        this.finalizeAttachmentProtocol(this.getProtocol());
        this.getBusinessObjectService().save((PersistableBusinessObject)this);
    }

    protected boolean isEligibleForMerging(String status, ProtocolBase otherProtocol) {
        return this.getListOfStatusEligibleForMergingHook().contains(status) && !StringUtils.equals((String)this.getProtocol().getProtocolNumber(), (String)otherProtocol.getProtocolNumber());
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getIacucProtocol().getIacucProtocolCustomDataList();
    }

    @Override
    protected Class<? extends ProtocolGenericActionService> getProtocolGenericActionServiceClassHook() {
        return IacucProtocolGenericActionService.class;
    }

    @Override
    protected ProtocolNotification getNewProtocolNotificationInstanceHook() {
        return new IacucProtocolNotification();
    }

    @Override
    protected ProtocolNotificationContextBase getDisapproveNotificationContextHook(ProtocolBase protocol) {
        return new IacucProtocolNotificationContext((IacucProtocol)protocol, "301", DISAPPROVED_CONTEXT_NAME, new IacucProtocolNotificationRenderer((IacucProtocol)protocol));
    }

    @Override
    protected String getCommitteeDisapprovedStatusCodeHook() {
        return "303";
    }
}

