/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtBean;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtRule;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtRuleImpl;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecision;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionAbstainerRule;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionRecuserRule;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionRule;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionBean;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionRule;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionRuleImpl;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitActionRule;
import org.kuali.kra.iacuc.noteattachment.SubmitIacucProtocolAttachmentProtocolRuleImpl;
import org.kuali.kra.iacuc.personnel.IacucProtocolAttachmentPersonnelRule;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonnelAuditRule;
import org.kuali.kra.iacuc.personnel.IacucProtocolUnitRule;
import org.kuali.kra.iacuc.personnel.SaveIacucProtocolPersonnelEvent;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupDetailBean;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolFundingSourceAuditRule;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolFundingSourceRule;
import org.kuali.kra.iacuc.protocol.location.IacucProtocolLocationRule;
import org.kuali.kra.iacuc.protocol.reference.IacucProtocolReferenceRule;
import org.kuali.kra.iacuc.protocol.research.IacucProtocolResearchAreaAuditRule;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.iacuc.species.exception.rule.AddProtocolExceptionEvent;
import org.kuali.kra.iacuc.species.exception.rule.AddProtocolExceptionRule;
import org.kuali.kra.iacuc.species.exception.rule.ProtocolExceptionRule;
import org.kuali.kra.iacuc.species.rule.AddProtocolSpeciesEvent;
import org.kuali.kra.iacuc.species.rule.AddProtocolSpeciesRule;
import org.kuali.kra.iacuc.species.rule.ProtocolSpeciesRule;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolDocumentRuleBase;
import org.kuali.kra.protocol.actions.decision.ExecuteCommitteeDecisionAbstainerRule;
import org.kuali.kra.protocol.actions.decision.ExecuteCommitteeDecisionRecuserRule;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitActionRuleBase;
import org.kuali.kra.protocol.noteattachment.SubmitProtocolAttachmentProtocolRuleImplBase;
import org.kuali.kra.protocol.personnel.ProtocolAttachmentPersonnelRuleBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelAuditRuleBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitRuleBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceAuditRuleBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceRuleBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationRuleBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaAuditRuleBase;
import org.kuali.kra.rule.event.KraDocumentEventBaseExtension;
import org.kuali.rice.krad.document.Document;

public class IacucProtocolDocumentRule
extends ProtocolDocumentRuleBase<IacucCommitteeDecision>
implements AddProtocolSpeciesRule,
AddProtocolExceptionRule,
IacucProtocolAssignCmtRule,
IacucProtocolModifySubmissionRule {
    private static final String NEW_PROTOCOL_SPECIES_PATH = "iacucProtocolSpeciesHelper.newIacucProtocolSpecies";
    private static final String PROTOCOL_EXCEPTION = "Exception";
    private static final String PROTOCOL_PROCEDURE = "Procedure";

    @Override
    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        boolean valid = super.processCustomSaveDocumentBusinessRules(document);
        if (valid) {
            valid &= this.processProtocolSpeciesRules((IacucProtocolDocument)document);
        }
        return valid;
    }

    public boolean processProtocolSpeciesRules(IacucProtocolDocument document) {
        boolean valid = true;
        List<IacucProtocolException> protocolExceptions = document.getIacucProtocol().getIacucProtocolExceptions();
        List<IacucProtocolSpecies> speciesList = document.getIacucProtocol().getIacucProtocolSpeciesList();
        List<IacucProtocolStudyGroupBean> protocolStudyGroups = document.getIacucProtocol().getIacucProtocolStudyGroups();
        Set<Integer> distinctProtocolSpecies = this.getDistinctSpeciesList(speciesList);
        Set<String> distinctProtocolSpeciesGroups = this.getDistinctSpeciesGroups(speciesList);
        if (!this.isProtocolExceptionValid(protocolExceptions, distinctProtocolSpecies)) {
            this.reportError(NEW_PROTOCOL_SPECIES_PATH, "error.iacuc.protocol.species.dependency.exists", PROTOCOL_EXCEPTION);
            valid = false;
        }
        if (!this.isProtocolProcedureValid(protocolStudyGroups, distinctProtocolSpecies) || !this.isProtocolProcedureSpeciesGroupValid(protocolStudyGroups, distinctProtocolSpeciesGroups)) {
            this.reportError(NEW_PROTOCOL_SPECIES_PATH, "error.iacuc.protocol.species.dependency.exists", PROTOCOL_PROCEDURE);
            valid = false;
        }
        return valid;
    }

    protected boolean isProtocolExceptionValid(List<IacucProtocolException> protocolExceptions, Set<Integer> protocolSpecies) {
        HashSet<Integer> exceptionSpecies = new HashSet<Integer>();
        for (IacucProtocolException protocolException : protocolExceptions) {
            exceptionSpecies.add(protocolException.getSpeciesCode());
        }
        exceptionSpecies.removeAll(protocolSpecies);
        return exceptionSpecies.size() == 0;
    }

    protected boolean isProtocolProcedureValid(List<IacucProtocolStudyGroupBean> protocolStudyGroups, Set<Integer> protocolSpecies) {
        HashSet<Integer> procedureSpecies = new HashSet<Integer>();
        for (IacucProtocolStudyGroupBean studyGroupBean : protocolStudyGroups) {
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : studyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                procedureSpecies.add(studyGroupDetailBean.getSpeciesCode());
            }
        }
        procedureSpecies.removeAll(protocolSpecies);
        return procedureSpecies.size() == 0;
    }

    protected Set<Integer> getDistinctSpeciesList(List<IacucProtocolSpecies> speciesList) {
        HashSet<Integer> distinctSpecies = new HashSet<Integer>();
        for (IacucProtocolSpecies protocolSpecies : speciesList) {
            distinctSpecies.add(protocolSpecies.getSpeciesCode());
        }
        return distinctSpecies;
    }

    protected Set<String> getDistinctSpeciesGroups(List<IacucProtocolSpecies> speciesList) {
        HashSet<String> distinctSpeciesGroups = new HashSet<String>();
        for (IacucProtocolSpecies protocolSpecies : speciesList) {
            distinctSpeciesGroups.add(protocolSpecies.getSpeciesGroup());
        }
        return distinctSpeciesGroups;
    }

    protected boolean isProtocolProcedureSpeciesGroupValid(List<IacucProtocolStudyGroupBean> protocolStudyGroups, Set<String> protocolSpeciesGroups) {
        ArrayList<String> speciesGroups = new ArrayList<String>();
        for (IacucProtocolStudyGroupBean studyGroupBean : protocolStudyGroups) {
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : studyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                for (IacucProtocolStudyGroup iacucProtocolStudyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    IacucProtocolSpecies protocolSpecies = iacucProtocolStudyGroup.getIacucProtocolSpecies();
                    speciesGroups.add(protocolSpecies.getSpeciesGroup());
                }
            }
        }
        boolean invalidSpeciesReference = false;
        for (String speciesGroup : speciesGroups) {
            if (protocolSpeciesGroups.contains(speciesGroup)) continue;
            invalidSpeciesReference = true;
            break;
        }
        return !invalidSpeciesReference;
    }

    @Override
    protected String getInProgressProtocolStatusCodeHook() {
        return "100";
    }

    @Override
    protected ProtocolResearchAreaAuditRuleBase getNewProtocolResearchAreaAuditRuleInstanceHook() {
        return new IacucProtocolResearchAreaAuditRule();
    }

    @Override
    public boolean processAddProtocolSpeciesBusinessRules(AddProtocolSpeciesEvent addProtocolSpeciesEvent) {
        return new ProtocolSpeciesRule().processAddProtocolSpeciesBusinessRules(addProtocolSpeciesEvent);
    }

    @Override
    public boolean processAddProtocolExceptionBusinessRules(AddProtocolExceptionEvent addProtocolExceptionEvent) {
        return new ProtocolExceptionRule().processAddProtocolExceptionBusinessRules(addProtocolExceptionEvent);
    }

    @Override
    protected IacucProtocolReferenceRule getNewProtocolReferenceRuleInstanceHook() {
        return new IacucProtocolReferenceRule();
    }

    @Override
    protected KraDocumentEventBaseExtension getSaveProtocolPersonnelEventHook(ProtocolDocumentBase document) {
        return new SaveIacucProtocolPersonnelEvent("", document);
    }

    @Override
    protected ProtocolPersonnelAuditRuleBase getNewProtocolPersonnelAuditRuleInstanceHook() {
        return new IacucProtocolPersonnelAuditRule();
    }

    @Override
    protected ProtocolUnitRuleBase getNewProtocolUnitRuleInstanceHook() {
        return new IacucProtocolUnitRule();
    }

    @Override
    protected ProtocolSubmitActionRuleBase newProtocolSubmitActionRuleInstanceHook() {
        return new IacucProtocolSubmitActionRule();
    }

    @Override
    protected ProtocolLocationRuleBase getNewProtocolLocationRuleInstanceHook() {
        return new IacucProtocolLocationRule();
    }

    @Override
    protected ProtocolFundingSourceAuditRuleBase getNewProtocolFundingSourceAuditRuleInstanceHook() {
        return new IacucProtocolFundingSourceAuditRule();
    }

    @Override
    protected ProtocolFundingSourceRuleBase getNewProtocolFundingSourceRuleInstanceHook() {
        return new IacucProtocolFundingSourceRule();
    }

    @Override
    public boolean processAssignToCommittee(ProtocolDocumentBase document, IacucProtocolAssignCmtBean actionBean) {
        return new IacucProtocolAssignCmtRuleImpl().processAssignToCommittee(document, actionBean);
    }

    @Override
    public ProtocolAttachmentPersonnelRuleBase getProtocolAttachmentPersonnelRuleInstanceHook() {
        return new IacucProtocolAttachmentPersonnelRule();
    }

    @Override
    protected SubmitProtocolAttachmentProtocolRuleImplBase newSubmitProtocolAttachmentProtocolRuleImplInstanceHook() {
        return new SubmitIacucProtocolAttachmentProtocolRuleImpl();
    }

    @Override
    public boolean processModifySubmissionRule(ProtocolDocumentBase document, IacucProtocolModifySubmissionBean actionBean) {
        return new IacucProtocolModifySubmissionRuleImpl().processModifySubmissionRule(document, actionBean);
    }

    protected IacucCommitteeDecisionRule newCommitteeDecisionRuleInstanceHook() {
        return new IacucCommitteeDecisionRule();
    }

    @Override
    protected ExecuteCommitteeDecisionAbstainerRule<IacucCommitteeDecision> newCommitteeDecisionAbstainerRuleInstanceHook() {
        return new IacucCommitteeDecisionAbstainerRule();
    }

    @Override
    protected ExecuteCommitteeDecisionRecuserRule<IacucCommitteeDecision> newCommitteeDecisionRecuserRuleInstanceHook() {
        return new IacucCommitteeDecisionRecuserRule();
    }
}

