/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.IacucProtocolActionBean;
import org.kuali.kra.iacuc.actions.IacucProtocolActionType;
import org.kuali.kra.iacuc.actions.IacucProtocolRequestAction;
import org.kuali.kra.iacuc.actions.IacucProtocolSubmissionBeanBase;
import org.kuali.kra.iacuc.actions.abandon.IacucProtocolAbandonService;
import org.kuali.kra.iacuc.actions.amendrenew.CreateIacucAmendmentEvent;
import org.kuali.kra.iacuc.actions.amendrenew.CreateIacucContinuationEvent;
import org.kuali.kra.iacuc.actions.amendrenew.CreateIacucRenewalEvent;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendRenewService;
import org.kuali.kra.iacuc.actions.amendrenew.IacucProtocolAmendmentBean;
import org.kuali.kra.iacuc.actions.amendrenew.ModifyIacucAmendmentSectionsEvent;
import org.kuali.kra.iacuc.actions.approve.IacucProtocolApproveBean;
import org.kuali.kra.iacuc.actions.approve.IacucProtocolApproveEvent;
import org.kuali.kra.iacuc.actions.approve.IacucProtocolApproveService;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtBean;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtEvent;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtService;
import org.kuali.kra.iacuc.actions.assignagenda.IacucProtocolAssignToAgendaBean;
import org.kuali.kra.iacuc.actions.assignagenda.IacucProtocolAssignToAgendaEvent;
import org.kuali.kra.iacuc.actions.assignagenda.IacucProtocolAssignToAgendaService;
import org.kuali.kra.iacuc.actions.copy.IacucProtocolCopyService;
import org.kuali.kra.iacuc.actions.correction.IacucAdminCorrectionBean;
import org.kuali.kra.iacuc.actions.correction.IacucProtocolAdminCorrectionEvent;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecision;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionAbstainerEvent;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionEvent;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionRecuserEvent;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteeDecisionService;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteePerson;
import org.kuali.kra.iacuc.actions.delete.IacucProtocolDeleteService;
import org.kuali.kra.iacuc.actions.followup.IacucFollowupActionService;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionBean;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionEvent;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionService;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionBean;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionEvent;
import org.kuali.kra.iacuc.actions.modifysubmission.IacucProtocolModifySubmissionService;
import org.kuali.kra.iacuc.actions.noreview.IacucProtocolReviewNotRequiredBean;
import org.kuali.kra.iacuc.actions.noreview.IacucProtocolReviewNotRequiredEvent;
import org.kuali.kra.iacuc.actions.noreview.IacucProtocolReviewNotRequiredService;
import org.kuali.kra.iacuc.actions.notifycommittee.IacucProtocolNotifyCommitteeService;
import org.kuali.kra.iacuc.actions.notifyiacuc.IacucProtocolNotifyIacucService;
import org.kuali.kra.iacuc.actions.notifyiacuc.NotifyIacucNotificationRenderer;
import org.kuali.kra.iacuc.actions.print.IacucProtocolPrintingService;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestBean;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestEvent;
import org.kuali.kra.iacuc.actions.request.IacucProtocolRequestService;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucProtocolAddReviewAttachmentEvent;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucProtocolAddReviewCommentEvent;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucProtocolManageReviewAttachmentEvent;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewAttachmentsBean;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsBean;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewerBean;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitActionEvent;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmitActionService;
import org.kuali.kra.iacuc.actions.submit.IacucValidProtocolActionAction;
import org.kuali.kra.iacuc.actions.table.IacucProtocolTableBean;
import org.kuali.kra.iacuc.actions.table.IacucProtocolTableService;
import org.kuali.kra.iacuc.actions.undo.IacucProtocolUndoLastActionService;
import org.kuali.kra.iacuc.actions.withdraw.IacucProtocolWithdrawService;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionsCorrespondence;
import org.kuali.kra.iacuc.correspondence.IacucProtocolCorrespondence;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentPersonnel;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentProtocol;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentService;
import org.kuali.kra.iacuc.notification.IacucProtocolAssignReviewerNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolGenericActionNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotification;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRequestBean;
import org.kuali.kra.iacuc.notification.IacucProtocolRequestActionNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolReviewDeterminationNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolWithReasonNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucRequestActionNotificationBean;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolReviewAttachment;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolQuestionnaireAuditRule;
import org.kuali.kra.iacuc.questionnaire.print.IacucQuestionnairePrintingService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.actions.history.ProtocolHistoryFilterDatesEvent;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.service.WatermarkService;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.ProtocolOnlineReviewCommentable;
import org.kuali.kra.protocol.actions.ProtocolSubmissionDocBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.protocol.actions.print.ProtocolActionPrintEvent;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.undo.UndoLastActionBean;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRequestBeanBase;
import org.kuali.kra.protocol.summary.AttachmentSummary;
import org.kuali.kra.protocol.summary.ProtocolSummary;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class IacucProtocolActionsAction
extends IacucProtocolAction {
    private static final Log LOG = LogFactory.getLog(IacucProtocolActionsAction.class);
    private static final String CONFIRM_NO_ACTION = "";
    private static final String CONFIRM_DELETE_ACTION_ATT = "confirmDeleteActionAttachment";
    private static final String CONFIRM_FOLLOWUP_ACTION = "confirmAddFollowupAction";
    private static final String PROTOCOL_TAB = "iacucProtocol";
    private static final String PROTOCOL_ACTIONS_TAB = "iacucProtocolActions";
    private static final String CONFIRM_SUBMIT_FOR_REVIEW_KEY = "confirmSubmitForReview";
    private static final String CONFIRM_ASSIGN_TO_AGENDA_KEY = "confirmAssignToAgenda";
    private static final String CONFIRM_ASSIGN_CMT_SCHED_KEY = "confirmAssignCmtSched";
    private static final String CONIFRM_REMOVE_REVIEWER_KEY = "confirmRemoveReviewer";
    private static final String NOT_FOUND_SELECTION = "The attachment was not found for selection ";
    private static final String CONFIRM_DELETE_PROTOCOL_KEY = "confirmDeleteProtocol";
    private static final String INVALID_ATTACHMENT = "this attachment version is invalid ";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String SUBMISSION_ID = "submissionId";
    private static final String CORRESPONDENCE = "correspondence";
    private static Map<String, String> motionTypeMap = new HashMap<String, String>(){
        {
            this.put("1", "Approve Action");
            this.put("2", "Disapprove");
            this.put("3", "Return for Specific Minor Revisions");
            this.put("4", "Return for Substantive Revisions Required");
        }
    };

    public ActionForward assignCommitteeSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        String callerString = "assignCommitteeSchedule";
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String currentTaskName;
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (request.getParameterMap().containsKey("doCopy")) {
            String docId = request.getParameter("docId");
            IacucProtocolDocument ipd = (IacucProtocolDocument)this.getDocumentService().getByDocumentHeaderId(docId);
            protocolForm.setDocument((Document)ipd);
            protocolForm.setDefaultOpenCopyTab(true);
        }
        if ((currentTaskName = this.getTaskName(request)) != null) {
            protocolForm.getActionHelper().setCurrentTask(currentTaskName);
        } else {
            protocolForm.getActionHelper().setCurrentTask(CONFIRM_NO_ACTION);
        }
        ActionForward actionForward = super.execute(mapping, form, request, response);
        protocolForm.getActionHelper().prepareView();
        protocolForm.getActionHelper().initFilterDatesView();
        ((IacucActionHelper)protocolForm.getActionHelper()).initSubmissionDetails();
        return actionForward;
    }

    public ActionForward copyProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ApplicationTask task = new ApplicationTask("createIacucProtocol");
        if (this.isAuthorized(task)) {
            String newDocId = this.getIacucProtocolCopyService().copyProtocol(protocolForm.getIacucProtocolDocument()).getDocumentNumber();
            protocolForm.setDocId(newDocId);
            protocolForm.setViewOnly(false);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getIacucProtocolDocument().setViewOnly(protocolForm.isViewOnly());
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            return mapping.findForward(PROTOCOL_TAB);
        }
        return mapping.findForward("basic");
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new AuditActionHelper().setAuditMode(mapping, (ProtocolFormBase)form, true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new AuditActionHelper().setAuditMode(mapping, (ProtocolFormBase)form, false);
    }

    public ActionForward refreshPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward submitForReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolSubmitAction submitAction;
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        protocolForm.setAuditActivated(true);
        IacucProtocolTask task = new IacucProtocolTask("submitIacucProtocol", protocolDocument.getIacucProtocol());
        if (this.isAuthorized(task) && this.applyRules(protocolForm, (KualiDocumentEvent)new IacucProtocolSubmitActionEvent(protocolDocument, submitAction = (IacucProtocolSubmitAction)protocolForm.getActionHelper().getProtocolSubmitAction()))) {
            AuditActionHelper auditActionHelper = new AuditActionHelper();
            if (auditActionHelper.auditUnconditionally((Document)protocolDocument)) {
                forward = this.isCommitteeMeetingAssignedMaxProtocols(submitAction.getNewCommitteeId(), submitAction.getNewScheduleId()) ? this.confirm(this.buildSubmitForReviewConfirmationQuestion(mapping, form, request, response), CONFIRM_SUBMIT_FOR_REVIEW_KEY, CONFIRM_NO_ACTION) : this.submitForReviewAndRedirect(mapping, form, request, response);
            } else {
                GlobalVariables.getMessageMap().clearErrorMessages();
                GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
            }
        }
        return forward;
    }

    public ActionForward assignCommittee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolAssignToCmt", protocol);
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task)) {
                IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
                IacucProtocolAssignCmtBean actionBean = actionHelper.getProtocolAssignCmtBean();
                if (this.applyRules((KualiDocumentEvent)new IacucProtocolAssignCmtEvent(protocolForm.getProtocolDocument(), actionBean)) && protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission() != null) {
                    this.getAssignToCmtService().assignToCommittee(protocolForm.getProtocolDocument().getProtocol(), actionBean);
                    this.recordProtocolActionSuccess("Assign to Committee");
                    protocolForm.setReinitializeModifySubmissionFields(true);
                }
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.iacuc.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    protected IacucProtocolAssignCmtService getAssignToCmtService() {
        return KraServiceLocator.getService(IacucProtocolAssignCmtService.class);
    }

    private boolean isCommitteeMeetingAssignedMaxProtocols(String committeeId, String scheduleId) {
        boolean isMax = false;
        return isMax;
    }

    private int activeSubmissionCount(List<IacucProtocolSubmission> submissions) {
        int count = 0;
        for (IacucProtocolSubmission submission : submissions) {
            if (!submission.getProtocol().isActive()) continue;
            ++count;
        }
        return count;
    }

    private StrutsConfirmation buildSubmitForReviewConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SUBMIT_FOR_REVIEW_KEY, "question.protocol.confirmExceedMaxProtocols", new String[0]);
    }

    public ActionForward confirmSubmitForReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SUBMIT_FOR_REVIEW_KEY.equals(question)) {
            forward = this.submitForReviewAndRedirect(mapping, form, request, response);
        }
        return forward;
    }

    private ActionForward submitForReviewAndRedirect(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolDocument.getIacucProtocol();
        IacucProtocolSubmitAction submitAction = (IacucProtocolSubmitAction)protocolForm.getActionHelper().getProtocolSubmitAction();
        this.getProtocolSubmitActionService().submitToIacucForReview(protocol, submitAction);
        super.route(mapping, (ActionForm)protocolForm, request, response);
        IacucProtocolNotificationRenderer submitRenderer = new IacucProtocolNotificationRenderer(protocol);
        IacucProtocolNotificationContext submitContext = new IacucProtocolNotificationContext(protocol, null, "101", "Submit", submitRenderer);
        this.getNotificationService().sendNotificationAndPersist(submitContext, new IacucProtocolNotification(), protocol);
        return this.routeProtocolToHoldingPage(mapping, protocolForm);
    }

    private ActionForward routeProtocolToHoldingPage(ActionMapping mapping, ProtocolFormBase protocolForm) {
        String routeHeaderId = protocolForm.getProtocolDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, PROTOCOL_ACTIONS_TAB, "IacucProtocolDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation);
    }

    public ActionForward administrativelyMarkIncompleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("adminMarkIncompleteProtocol", protocol);
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task)) {
                ProtocolDocumentBase pd = this.getProtocolWithdrawService().administrativelyMarkIncomplete(protocol, protocolForm.getActionHelper().getProtocolAdminIncompleteBean());
                protocolForm.setDocId(pd.getDocumentNumber());
                this.loadDocument((KualiDocumentFormBase)protocolForm);
                protocolForm.getProtocolHelper().prepareView();
                IacucProtocolNotificationRequestBean newNotificationBean = new IacucProtocolNotificationRequestBean(protocol, "216", "Administratively Marked Incomplete");
                IacucProtocolCorrespondence newProtocolCorrespondence = this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, newNotificationBean, false);
                protocolForm.getActionHelper().setProtocolCorrespondence(newProtocolCorrespondence);
                this.recordProtocolActionSuccess("Administratively Mark Incomplete");
                if (newProtocolCorrespondence != null) {
                    return mapping.findForward(CORRESPONDENCE);
                }
                return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, newNotificationBean);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward administrativelyWithdrawProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("adminWithdrawProtocol", protocol);
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task)) {
                ProtocolDocumentBase pd = this.getProtocolWithdrawService().administrativelyWithdraw(protocol, protocolForm.getActionHelper().getProtocolAdminWithdrawBean());
                protocolForm.setDocId(pd.getDocumentNumber());
                this.loadDocument((KualiDocumentFormBase)protocolForm);
                protocolForm.getProtocolHelper().prepareView();
                IacucProtocolNotificationRequestBean newNotificationBean = new IacucProtocolNotificationRequestBean(protocol, "300", "Administratively Withdrawn");
                IacucProtocolCorrespondence newProtocolCorrespondence = this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, newNotificationBean, false);
                protocolForm.getActionHelper().setProtocolCorrespondence(newProtocolCorrespondence);
                this.recordProtocolActionSuccess("Administratively Withdraw");
                if (newProtocolCorrespondence != null) {
                    return mapping.findForward(CORRESPONDENCE);
                }
                return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, newNotificationBean);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward withdrawProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("protocolWithdraw", protocol);
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task)) {
                ProtocolDocumentBase pd = this.getProtocolWithdrawService().withdraw(protocol, protocolForm.getActionHelper().getProtocolWithdrawBean());
                protocolForm.setDocId(pd.getDocumentNumber());
                this.loadDocument((KualiDocumentFormBase)protocolForm);
                protocolForm.getProtocolHelper().prepareView();
                IacucProtocolNotificationRequestBean newNotificationBean = new IacucProtocolNotificationRequestBean(protocol, "115", "Withdrawn");
                IacucProtocolCorrespondence newProtocolCorrespondence = this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, newNotificationBean, false);
                protocolForm.getActionHelper().setProtocolCorrespondence(newProtocolCorrespondence);
                this.recordProtocolActionSuccess("Withdraw");
                if (newProtocolCorrespondence != null) {
                    return mapping.findForward(CORRESPONDENCE);
                }
                return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, newNotificationBean);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private IacucProtocolCorrespondence getProtocolCorrespondence(ProtocolFormBase protocolForm, String forwardName, ProtocolNotificationRequestBeanBase notificationRequestBean, boolean holdingPage) {
        boolean result = false;
        HashMap<String, Long> keyValues = new HashMap<String, Long>();
        keyValues.put("actionIdFk", protocolForm.getProtocolDocument().getProtocol().getLastProtocolAction().getProtocolActionId());
        List correspondences = (List)this.getBusinessObjectService().findMatching(IacucProtocolCorrespondence.class, keyValues);
        if (correspondences.isEmpty()) {
            return null;
        }
        IacucProtocolCorrespondence correspondence = (IacucProtocolCorrespondence)((Object)correspondences.get(0));
        correspondence.setForwardName(forwardName);
        correspondence.setNotificationRequestBean(notificationRequestBean);
        correspondence.setHoldingPage(holdingPage);
        return correspondence;
    }

    public ActionForward notifyIacucProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.getIacucProtocolNotifyIacucBean().setAnswerHeaders(this.getAnswerHeaders(form, "114"));
        if (this.isMandatoryQuestionnaireComplete(actionHelper.getIacucProtocolNotifyIacucBean(), "actionHelper.protocolNotifyIacucBean.datavalidation")) {
            this.getIacucProtocolNotifyIacucService().submitIacucNotification((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), actionHelper.getIacucProtocolNotifyIacucBean());
            protocolForm.getQuestionnaireHelper().setAnswerHeaders(new ArrayList<AnswerHeader>());
            LOG.info((Object)("notifyIacucProtocol " + protocolForm.getProtocolDocument().getDocumentNumber()));
            this.recordProtocolActionSuccess("Notify IACUC");
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "114", "Notify IACUC"));
        }
        return mapping.findForward("basic");
    }

    private IacucProtocolNotifyIacucService getIacucProtocolNotifyIacucService() {
        return KraServiceLocator.getService(IacucProtocolNotifyIacucService.class);
    }

    private List<AnswerHeader> getAnswerHeaders(ActionForm form, String actionTypeCode) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucProtocolModuleQuestionnaireBean moduleQuestionnaireBean = new IacucProtocolModuleQuestionnaireBean("9", protocolForm.getProtocolDocument().getProtocol().getProtocolNumber() + "T", "2", actionTypeCode, false);
        return this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
    }

    private boolean isMandatoryQuestionnaireComplete(IacucProtocolSubmissionBeanBase submissionBean, String errorKey) {
        boolean valid = true;
        IacucProtocolQuestionnaireAuditRule auditRule = new IacucProtocolQuestionnaireAuditRule();
        if (!auditRule.isMandatorySubmissionQuestionnaireComplete(submissionBean.getAnswerHeaders())) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError(errorKey, "error.mandatory.questionnaire", new String[0]);
            valid = false;
        }
        return valid;
    }

    public ActionForward createAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("createIacucAmendment", protocol);
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new CreateIacucAmendmentEvent(protocolDocument, "actionHelper.protocolCreateAmendment", actionHelper.getProtocolAmendmentBean()))) {
                return mapping.findForward("basic");
            }
            String newDocId = this.getProtocolAmendRenewService().createAmendment(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolAmendmentBean());
            protocolForm.setDocId(newDocId);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Create Amendment");
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "323", "Amendment Created");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward modifyAmendmentSections(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolDocument.getIacucProtocol();
        protocolForm.getActionHelper().setCurrentTask("modifyAmendmentSections");
        IacucProtocolTask task = new IacucProtocolTask("modifyAmendmentSections", protocol);
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new ModifyIacucAmendmentSectionsEvent(protocolDocument, "actionHelper.protocolModifyAmendment", protocolForm.getActionHelper().getProtocolAmendmentBean()))) {
                return mapping.findForward("basic");
            }
            this.getProtocolAmendRenewService().updateAmendmentRenewal(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolAmendmentBean());
            return this.save(mapping, (ActionForm)protocolForm, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createRenewal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("createIacucRenewal", protocol);
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new CreateIacucRenewalEvent(protocolDocument, "actionHelper.renewalSummary", protocolForm.getActionHelper().getRenewalSummary()))) {
                return mapping.findForward("basic");
            }
            String newDocId = this.getProtocolAmendRenewService().createRenewal(protocolForm.getProtocolDocument(), ((ProtocolFormBase)form).getActionHelper().getRenewalSummary());
            protocolForm.setDocId(newDocId);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Create Renewal without Amendment");
            protocolForm.getActionHelper().getProtocolAmendmentBean().setSummary(protocolForm.getActionHelper().getRenewalSummary());
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "322", "Renewal Created");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createRenewalWithAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("createIacucRenewal", protocol);
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolAmendmentBean renewAmendmentBean = (IacucProtocolAmendmentBean)actionHelper.getProtocolRenewAmendmentBean();
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new CreateIacucAmendmentEvent(protocolDocument, "actionHelper.protocolCreateRenewalWithAmendment", (ProtocolAmendmentBean)renewAmendmentBean))) {
                return mapping.findForward("basic");
            }
            String newDocId = this.getProtocolAmendRenewService().createRenewalWithAmendment(protocolDocument, renewAmendmentBean);
            protocolForm.setDocId(newDocId);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Create Renewal with Amendment");
            protocolForm.getActionHelper().setProtocolAmendmentBean(renewAmendmentBean);
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "909", "Renewal With Amendment Created");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createContinuation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("createIacucContinuation", protocol);
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new CreateIacucContinuationEvent(protocolDocument, "actionHelper.continuationSummary", actionHelper.getContinuationSummary()))) {
                return mapping.findForward("basic");
            }
            String newDocId = this.getProtocolAmendRenewService().createContinuation(protocolDocument, actionHelper.getContinuationSummary());
            protocolForm.setDocId(newDocId);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Create Continuation without Amendment");
            protocolForm.getActionHelper().getProtocolAmendmentBean().setSummary(actionHelper.getContinuationSummary());
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "322", "Continuation Created");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createContinuationWithAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolTask task = new IacucProtocolTask("createIacucContinuation", protocol);
        IacucProtocolAmendmentBean continuationAmendmentBean = (IacucProtocolAmendmentBean)actionHelper.getProtocolContinuationAmendmentBean();
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new CreateIacucAmendmentEvent(protocolDocument, "actionHelper.protocolCreateContinuationWithAmendment", (ProtocolAmendmentBean)continuationAmendmentBean))) {
                return mapping.findForward("basic");
            }
            String newDocId = this.getProtocolAmendRenewService().createContinuationWithAmendment(protocolDocument, continuationAmendmentBean);
            protocolForm.setDocId(newDocId);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Create Continuation with Amendment");
            protocolForm.getActionHelper().setProtocolAmendmentBean(continuationAmendmentBean);
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "105", "Continuation With Amendment Created");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucProtocolTask task = new IacucProtocolTask("protocolAmendRenewDelete", (IacucProtocol)protocolForm.getProtocolDocument().getProtocol());
        if (this.isAuthorized(task)) {
            return this.confirm(this.buildDeleteProtocolConfirmationQuestion(mapping, form, request, response), CONFIRM_DELETE_PROTOCOL_KEY, CONFIRM_NO_ACTION);
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROTOCOL_KEY.equals(question)) {
            ProtocolFormBase protocolForm = (ProtocolFormBase)form;
            IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
            this.getProtocolDeleteService().delete(protocol, protocolForm.getActionHelper().getProtocolDeleteBean());
            IacucProtocolNotificationRequestBean newNotificationBean = new IacucProtocolNotificationRequestBean(protocol, "906", "Deleted");
            IacucProtocolCorrespondence newProtocolCorrespondence = this.getProtocolCorrespondence(protocolForm, PROTOCOL_ACTIONS_TAB, newNotificationBean, false);
            protocolForm.getActionHelper().setProtocolCorrespondence(newProtocolCorrespondence);
            this.recordProtocolActionSuccess("Delete ProtocolBase, Amendment, or Renewal");
            if (newProtocolCorrespondence != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, newNotificationBean);
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDeleteProtocolConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocumentBase doc = ((ProtocolFormBase)form).getProtocolDocument();
        String protocolNumber = doc.getProtocol().getProtocolNumber();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROTOCOL_KEY, "document.question.deleteProtocol.text", protocolNumber);
    }

    public ActionForward viewProtocolAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        int selected = this.getSelectedLine(request);
        IacucProtocolAttachmentProtocol attachment = (IacucProtocolAttachmentProtocol)protocol.getActiveAttachmentProtocolsNoDelete().get(selected);
        return this.printAttachmentProtocol(mapping, response, attachment, protocolForm);
    }

    public ActionForward viewProtocolPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        int selected = this.getSelectedLine(request);
        IacucProtocolAttachmentPersonnel personAttach = (IacucProtocolAttachmentPersonnel)protocolForm.getProtocolDocument().getProtocol().getAttachmentPersonnels().get(selected);
        return this.printPersonnelAttachmentProtocol(mapping, response, personAttach, protocolForm);
    }

    public ActionForward printProtocolQuestionnaires(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        ActionForward forward = mapping.findForward("basic");
        String fileName = "Protocol_questionnaire_Report.pdf";
        String reportName = protocol.getProtocolNumber() + "-" + "ProtocolQuestionnaires";
        AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getIacucQuestionnairePrintingService().getQuestionnairePrintable(protocol, protocolForm.getActionHelper().getQuestionnairesToPrints()));
        if (dataStream.getContent() != null) {
            dataStream.setFileName(fileName.toString());
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    protected IacucQuestionnairePrintingService getIacucQuestionnairePrintingService() {
        return KraServiceLocator.getService(IacucQuestionnairePrintingService.class);
    }

    private ActionForward printAttachmentProtocol(ActionMapping mapping, HttpServletResponse response, IacucProtocolAttachmentProtocol attachment, ProtocolFormBase form) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        byte[] attachmentFile = null;
        String attachmentFileType = file.getType().replace("\"", CONFIRM_NO_ACTION);
        if ((attachmentFileType = attachmentFileType.replace("\\", CONFIRM_NO_ACTION)).equalsIgnoreCase("application/pdf")) {
            attachmentFile = this.getProtocolAttachmentFile(form, attachment);
            if (attachmentFile != null) {
                this.streamToResponse(attachmentFile, IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
            } else {
                this.streamToResponse(file.getData(), IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
            }
            return RESPONSE_ALREADY_HANDLED;
        }
        this.streamToResponse(file.getData(), IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private ActionForward printPersonnelAttachmentProtocol(ActionMapping mapping, HttpServletResponse response, ProtocolAttachmentBase attachment, IacucProtocolForm form) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private byte[] getProtocolAttachmentFile(ProtocolFormBase form, ProtocolAttachmentProtocolBase attachment) {
        byte[] attachmentFile = null;
        AttachmentFile file = attachment.getFile();
        Printable printableArtifacts = this.getProtocolPrintingService().getProtocolPrintArtifacts(form.getProtocolDocument().getProtocol());
        ProtocolBase protocolCurrent = form.getProtocolDocument().getProtocol();
        int currentProtoSeqNumber = protocolCurrent.getSequenceNumber();
        try {
            if (printableArtifacts.isWatermarkEnabled()) {
                int currentAttachmentSequence = attachment.getSequenceNumber();
                String docStatusCode = attachment.getDocumentStatusCode();
                String statusCode = attachment.getStatusCode();
                if (this.getProtocolAttachmentService().isAttachmentActive(attachment) && currentProtoSeqNumber == currentAttachmentSequence || docStatusCode.equals("1")) {
                    if ("1".equals(statusCode)) {
                        attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                    }
                } else {
                    attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getInvalidWatermark());
                    LOG.info((Object)(INVALID_ATTACHMENT + attachment.getDocumentId()));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Occured in ProtocolNoteAndAttachmentAction. : ", (Throwable)e);
        }
        return attachmentFile;
    }

    public ActionForward filterHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        Date startDate = protocolForm.getActionHelper().getFilteredHistoryStartDate();
        Date endDate = protocolForm.getActionHelper().getFilteredHistoryEndDate();
        if (this.applyRules((KualiDocumentEvent)new ProtocolHistoryFilterDatesEvent((Document)protocolForm.getProtocolDocument(), startDate, endDate))) {
            protocolForm.getActionHelper().initFilterDatesView();
        }
        return mapping.findForward("basic");
    }

    public ActionForward resetHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getActionHelper().setFilteredHistoryStartDate(null);
        protocolForm.getActionHelper().setFilteredHistoryEndDate(null);
        protocolForm.getActionHelper().initFilterDatesView();
        return mapping.findForward("basic");
    }

    public ActionForward loadProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        org.kuali.kra.iacuc.actions.IacucProtocolAction action = (org.kuali.kra.iacuc.actions.IacucProtocolAction)protocolForm.getActionHelper().getSelectedProtocolAction();
        if (action != null) {
            protocolForm.getActionHelper().setCurrentSequenceNumber(action.getSequenceNumber());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachmentProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.viewAttachment(mapping, (ProtocolFormBase)form, request, response);
    }

    private ActionForward viewAttachment(ActionMapping mapping, ProtocolFormBase form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolSummary protocolSummary = form.getActionHelper().getProtocolSummary();
        int selectedIndex = this.getSelectedLine(request);
        AttachmentSummary attachmentSummary = protocolSummary.getAttachments().get(selectedIndex);
        if (attachmentSummary.getAttachmentType().startsWith("ProtocolBase: ")) {
            IacucProtocolAttachmentProtocol attachment = this.getProtocolAttachmentService().getAttachment(IacucProtocolAttachmentProtocol.class, attachmentSummary.getAttachmentId());
            return this.printAttachmentProtocol(mapping, response, attachment, form);
        }
        IacucProtocolAttachmentPersonnel personnelAttachment = this.getProtocolAttachmentService().getAttachment(IacucProtocolAttachmentPersonnel.class, attachmentSummary.getAttachmentId());
        return this.printPersonnelAttachmentProtocol(mapping, response, personnelAttachment, (IacucProtocolForm)form);
    }

    public ActionForward viewPreviousProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.setCurrentSequenceNumber(actionHelper.getCurrentSequenceNumber() - 1);
        ((ProtocolFormBase)form).getActionHelper().initSummaryDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewNextProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.setCurrentSequenceNumber(actionHelper.getCurrentSequenceNumber() + 1);
        ((ProtocolFormBase)form).getActionHelper().initSummaryDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewPreviousSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.setCurrentSubmissionNumber(actionHelper.getPrevSubmissionNumber());
        actionHelper.setAmendmentDetails();
        protocolForm.getActionHelper().initSubmissionDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewNextSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        actionHelper.setCurrentSubmissionNumber(actionHelper.getNextSubmissionNumber());
        actionHelper.setAmendmentDetails();
        protocolForm.getActionHelper().initSubmissionDetails();
        return mapping.findForward("basic");
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SUBMISSION_ID, request.getParameter(SUBMISSION_ID));
        IacucProtocolSubmission protocolSubmission = (IacucProtocolSubmission)this.getBusinessObjectService().findByPrimaryKey(IacucProtocolSubmission.class, fieldValues);
        protocolSubmission.getProtocol().setProtocolSubmission(protocolSubmission);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.setDocId(protocolSubmission.getProtocol().getProtocolDocument().getDocumentNumber());
        this.loadDocument((KualiDocumentFormBase)protocolForm);
        protocolForm.initialize();
        return mapping.findForward("basic");
    }

    public ActionForward assignToAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.getActionHelper().setCurrentTask("protocolAssignToAgenda");
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            IacucProtocolTask task = new IacucProtocolTask("protocolAssignToAgenda", protocol);
            if (this.isAuthorized(task)) {
                IacucProtocolAssignToAgendaBean actionBean = (IacucProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
                if (this.applyRules((KualiDocumentEvent)new IacucProtocolAssignToAgendaEvent((IacucProtocolDocument)protocolForm.getProtocolDocument(), actionBean))) {
                    this.getProtocolAssignToAgendaService().assignToAgenda(protocol, actionBean);
                    this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
                    this.recordProtocolActionSuccess("Assign to Agenda");
                    ProtocolActionBase lastAction = protocolForm.getProtocolDocument().getProtocol().getLastProtocolAction();
                    ProtocolActionTypeBase lastActionType = lastAction.getProtocolActionType();
                    String description = lastActionType.getDescription();
                    IacucProtocolNotificationRenderer renderer = new IacucProtocolNotificationRenderer(protocol);
                    IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, "200", description, renderer);
                    if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                        protocolForm.getNotificationHelper().initializeDefaultValues(context);
                        forward = mapping.findForward("iacucProtocolNotificationEditor");
                    } else {
                        this.getNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocol);
                    }
                }
                actionBean.prepareView();
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return forward;
    }

    public ActionForward removeFromAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            IacucProtocolTask task = new IacucProtocolTask("protocolRemoveFromAgenda", protocol);
            if (this.isAuthorized(task)) {
                IacucProtocolGenericActionBean actionBean = actionHelper.getIacucProtocolRemoveFromAgendaBean();
                this.getProtocolAssignToAgendaService().removeFromAgenda(protocol, actionBean);
                this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
                this.recordProtocolActionSuccess("Removed Agenda");
                IacucProtocolGenericActionNotificationRenderer renderer = new IacucProtocolGenericActionNotificationRenderer(protocol, actionBean.getActionDate());
                IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, "312", actionBean.getComments(), renderer);
                if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                    protocolForm.getNotificationHelper().initializeDefaultValues(context);
                    forward = mapping.findForward("iacucProtocolNotificationEditor");
                } else {
                    this.getNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocol);
                }
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return forward;
    }

    public ActionForward protocolReviewNotRequired(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucActionHelper actionHelper;
        IacucProtocolReviewNotRequiredBean actionBean;
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("reviewNotRequiredIacucProtocol", protocol);
        if (this.isAuthorized(task) && this.applyRules((KualiDocumentEvent)new IacucProtocolReviewNotRequiredEvent(document, actionBean = (IacucProtocolReviewNotRequiredBean)(actionHelper = (IacucActionHelper)protocolForm.getActionHelper()).getProtocolReviewNotRequiredBean()))) {
            KraServiceLocator.getService(IacucProtocolReviewNotRequiredService.class).reviewNotRequired(document, actionBean);
            this.recordProtocolActionSuccess("Review Not Required");
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(document.getIacucProtocol(), "207", "Review Not Required");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward grantFullApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        IacucProtocolApproveBean actionBean = (IacucProtocolApproveBean)protocolForm.getActionHelper().getProtocolFullApprovalBean();
        if (this.hasPermission("protocolApprove", (IacucProtocol)document.getProtocol()) && this.applyRules((KualiDocumentEvent)new IacucProtocolApproveEvent(document, actionBean))) {
            String actionDescription2;
            String actionDescription;
            String actionType;
            forward = super.approve(mapping, (ActionForm)protocolForm, request, response);
            this.getProtocolApproveService().grantFullApproval(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            IacucProtocolSubmission submission = (IacucProtocolSubmission)protocol.getProtocolSubmission();
            if (StringUtils.equals((String)submission.getProtocolReviewTypeCode(), (String)"2")) {
                actionType = "212";
                actionDescription = "Designated Member Approval";
                actionDescription2 = "Designated Member Approved";
            } else {
                actionType = "204";
                actionDescription = "Full Approval";
                actionDescription2 = "Approved";
            }
            this.recordProtocolActionSuccess(actionDescription);
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), actionType, actionDescription);
            protocolForm.getProtocolHelper().prepareView();
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                GlobalVariables.getUserSession().addObject("approvalComplCorrespondence", GlobalVariables.getUserSession().retrieveObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY"));
                GlobalVariables.getUserSession().removeObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY");
                return mapping.findForward(CORRESPONDENCE);
            }
            IacucProtocolNotificationRenderer renderer = new IacucProtocolNotificationRenderer((IacucProtocol)document.getProtocol());
            IacucProtocolNotificationContext context = new IacucProtocolNotificationContext((IacucProtocol)document.getProtocol(), actionType, actionDescription2, renderer);
            this.getNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocol);
            forward = this.routeProtocolToHoldingPage(mapping, protocolForm);
        }
        return forward;
    }

    public ActionForward grantAdminApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocolApproveBean actionBean = (IacucProtocolApproveBean)protocolForm.getActionHelper().getProtocolAdminApprovalBean();
        if (this.hasPermission("adminApproveProtocol", (IacucProtocol)document.getProtocol()) && this.applyRules((KualiDocumentEvent)new IacucProtocolApproveEvent(document, actionBean))) {
            this.getProtocolApproveService().grantAdminApproval(document.getProtocol(), actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Administrative Approval");
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)document.getProtocol(), "215", "Admin Approval");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            forward = protocolForm.getActionHelper().getProtocolCorrespondence() != null ? mapping.findForward(CORRESPONDENCE) : this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return forward;
    }

    public ActionForward requestAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        String taskName = this.getTaskName(request);
        if (StringUtils.isNotBlank((String)taskName) && this.isAuthorized(new IacucProtocolTask(taskName, protocol))) {
            IacucProtocolRequestAction requestAction = IacucProtocolRequestAction.valueOfTaskName(taskName);
            IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            if (requestBean != null) {
                boolean valid = this.applyRules((KualiDocumentEvent)new IacucProtocolRequestEvent(document, requestAction.getErrorPath(), requestBean));
                requestBean.setAnswerHeaders(this.getAnswerHeaders(form, requestAction.getActionTypeCode()));
                if (valid &= this.isMandatoryQuestionnaireComplete(requestBean, "actionHelper." + requestAction.getBeanName() + ".datavalidation")) {
                    this.getProtocolRequestService().submitRequest(protocolForm.getIacucProtocolDocument().getIacucProtocol(), requestBean);
                    this.recordProtocolActionSuccess(requestAction.getActionName());
                    return this.sendRequestNotification(mapping, form, protocol, requestBean);
                }
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward addRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        System.err.println("addRequestAttachment");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        String taskName = this.getTaskName(request);
        if (StringUtils.isNotBlank((String)taskName) && this.isAuthorized(new IacucProtocolTask(taskName, protocol))) {
            IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            if (requestBean.getNewActionAttachment().getFile() != null && requestBean.getNewActionAttachment().getFile().getFileData().length > 0) {
                requestBean.getNewActionAttachment().setFileName(requestBean.getNewActionAttachment().getFile().getFileName());
                requestBean.getActionAttachments().add(requestBean.getNewActionAttachment());
                requestBean.setNewActionAttachment(new ProtocolActionAttachment());
            } else {
                GlobalVariables.getMessageMap().putError("actionHelper.iacucProtocolSuspendRequestBean.newActionAttachment.file", "error.awardNotesAndAttachments.attachment.fileRequired", new String[0]);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        String taskName = this.getTaskName(request);
        if (StringUtils.isNotBlank((String)taskName) && this.isAuthorized(new IacucProtocolTask(taskName, protocol))) {
            IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            int lineNumber = this.getSelectedLine(request);
            ProtocolActionAttachment actionAttachment = requestBean.getActionAttachments().get(lineNumber);
            if (actionAttachment.getFile() != null) {
                System.err.println("actionAttachment.getFile().getContentType(): " + actionAttachment.getFile().getContentType());
                this.streamToResponse(actionAttachment.getFile().getFileData(), actionAttachment.getFileName(), actionAttachment.getFile().getContentType(), response);
                return RESPONSE_ALREADY_HANDLED;
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        String taskName = this.getTaskName(request);
        if (StringUtils.isNotBlank((String)taskName) && this.isAuthorized(new IacucProtocolTask(taskName, protocol))) {
            IacucProtocolRequestAction requestAction = IacucProtocolRequestAction.valueOfTaskName(taskName);
            IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            int lineNumber = this.getSelectedLine(request);
            requestBean.getActionAttachments().remove(lineNumber);
        }
        return mapping.findForward("basic");
    }

    private ActionForward sendRequestNotification(ActionMapping mapping, ActionForm form, IacucProtocol protocol, IacucProtocolRequestBean requestBean) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolActionType protocolActionType = (IacucProtocolActionType)this.getBusinessObjectService().findBySinglePrimaryKey(IacucProtocolActionType.class, (Object)requestBean.getProtocolActionTypeCode());
        String protocolActionTypeCode = protocolActionType.getProtocolActionTypeCode();
        String description = protocolActionType.getDescription();
        IacucRequestActionNotificationBean newNotificationBean = new IacucRequestActionNotificationBean(protocolForm.getIacucProtocolDocument().getIacucProtocol(), protocolActionTypeCode, description, requestBean.getReason());
        return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, newNotificationBean);
    }

    private IacucProtocolRequestBean getProtocolRequestBean(ActionForm form, HttpServletRequest request) {
        IacucProtocolRequestBean protocolRequestBean = null;
        IacucProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof IacucProtocolRequestBean) {
            protocolRequestBean = (IacucProtocolRequestBean)protocolActionBean;
        }
        return protocolRequestBean;
    }

    public ActionForward disapproveProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolDisapproveBean();
        if (this.hasPermission("protocolDisapprove", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().disapprove(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Disapprove");
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "301", "Disapproved");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward expire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolExpireBean();
        if (this.hasGenericPermission("iacucProtocolExpire", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().expire(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Expire");
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "302", "Expired");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward terminate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolTerminateBean();
        if (this.hasGenericPermission("iacucProtocolTerminate", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().terminate(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Terminate");
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "306", "Terminated");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward suspend(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSuspendBean();
        if (this.hasGenericPermission("iacucProtocolSuspend", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().suspend(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Suspended");
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "307", "Suspended");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward iacucAcknowledgement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucAcknowledgeBean();
        if (this.hasPermission("iacucAcknowledgement", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().iacucAcknowledgement(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("IACUC Acknowledgement");
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, new IacucProtocolNotificationRequestBean(protocol, "206", "IACUC Acknowledgement"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward iacucHold(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolHoldBean();
        if (this.hasPermission("iacucProtocolHold", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().iacucHold(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("IACUC Hold");
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean((IacucProtocol)protocolForm.getProtocolDocument().getProtocol(), "305", "IACUC Hold");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward iacucLiftHold(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolLiftHoldBean();
        if (this.hasPermission("iacucProtocolLiftHold", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().iacucLiftHold(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("IACUC Lift Hold");
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, new IacucProtocolNotificationRequestBean(protocol, "208", "IACUC Lift Hold"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward returnForSMR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSMRBean();
        if (this.hasPermission("protocolReturnForSMR", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            ProtocolDocumentBase newDocument = this.getProtocolGenericActionService().returnForSMR(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            protocolForm.setDocId(newDocument.getDocumentNumber());
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Return for Specific Minor Revisions");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, new IacucProtocolNotificationRequestBean(protocol, "209", "Minor Revisions Required"), false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, new IacucProtocolNotificationRequestBean(protocol, "209", "Minor Revisions Required"));
        }
        return forward;
    }

    public ActionForward returnForSRR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSRRBean();
        if (this.hasPermission("protocolReturnForSRR", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            ProtocolDocumentBase newDocument = this.getProtocolGenericActionService().returnForSRR(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            protocolForm.setDocId(newDocument.getDocumentNumber());
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Return for Substantive Revisions Required");
            IacucProtocolNotificationRequestBean newNotificationBean = new IacucProtocolNotificationRequestBean(protocol, "211", "Major Revisions Required");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, newNotificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, newNotificationBean);
        }
        return forward;
    }

    public ActionForward returnToPI(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = (IacucProtocol)document.getProtocol();
        IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolReturnToPIBean();
        if (this.hasPermission("protocolReturnToPI", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
            ProtocolDocumentBase newDocument = this.getProtocolGenericActionService().returnToPI(protocol, actionBean);
            this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
            protocolForm.setDocId(newDocument.getDocumentNumber());
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Return To PI");
            IacucProtocolNotificationRequestBean newNotificationBean = new IacucProtocolNotificationRequestBean(protocol, "210", "Return To PI");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, newNotificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, newNotificationBean);
        }
        return forward;
    }

    public ActionForward iacucDeactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = document.getIacucProtocol();
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocolGenericActionBean actionBean = actionHelper.getIacucProtocolDeactivateBean();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("iacucProtocolDeactivate", protocol) && this.applyRules((KualiDocumentEvent)new IacucProtocolGenericActionEvent(document, actionBean))) {
                this.getProtocolGenericActionService().iacucDeactivate(protocol, actionBean);
                this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
                this.recordProtocolActionSuccess("Deactivated");
                IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "303", "Deactivated");
                protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
                if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                    return mapping.findForward(CORRESPONDENCE);
                }
                return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return forward;
    }

    public ActionForward manageComments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolManageReviewComments", (IacucProtocol)protocolForm.getProtocolDocument().getProtocol())) {
                IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean();
                this.saveReviewComments(protocolForm, (IacucReviewCommentsBean)actionBean.getReviewCommentsBean());
                this.recordProtocolActionSuccess("Manage Review Comments");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward openProtocolForAdminCorrection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = protocolForm.getIacucProtocolDocument();
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolAdminCorrection", protocol);
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task) && this.applyRules((KualiDocumentEvent)new IacucProtocolAdminCorrectionEvent(protocolDocument, "actionHelper.protocolAdminCorrectionBean", protocolForm.getActionHelper().getProtocolAdminCorrectionBean()))) {
                protocolDocument.getProtocol().setCorrectionMode(true);
                protocolForm.getProtocolHelper().prepareView();
                IacucAdminCorrectionBean adminCorrectionBean = (IacucAdminCorrectionBean)protocolForm.getActionHelper().getProtocolAdminCorrectionBean();
                protocolDocument.updateProtocolStatus("113", adminCorrectionBean.getComments());
                this.recordProtocolActionSuccess("Make Administrative Correction");
                IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, "113", "Administrative Correction");
                protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
                if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                    return mapping.findForward(CORRESPONDENCE);
                }
                return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return forward;
    }

    public ActionForward submitCommitteeDecision(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            IacucCommitteeDecision actionBean = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
            if (this.applyRules((KualiDocumentEvent)new IacucCommitteeDecisionEvent((IacucProtocolDocument)protocolForm.getProtocolDocument(), actionBean))) {
                this.getCommitteeDecisionService().processCommitteeDecision(protocolForm.getProtocolDocument().getProtocol(), actionBean);
                this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
                this.confirmFollowupAction(mapping, form, request, response, "basic");
                protocolForm.getTabStates().put(":" + WebUtils.generateTabKey((String)motionTypeMap.get(actionBean.getMotionTypeCode())), "OPEN");
                this.recordProtocolActionSuccess("Record Committee Decision");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addAbstainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucCommitteeDecision decision = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        if (this.applyRules((KualiDocumentEvent)new IacucCommitteeDecisionAbstainerEvent((IacucProtocolDocument)protocolForm.getProtocolDocument(), decision))) {
            decision.getAbstainers().add(decision.getNewAbstainer());
            decision.setNewAbstainer(new IacucCommitteePerson());
            decision.setAbstainCount(decision.getAbstainCount() + 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAbstainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucCommitteeDecision decision = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        IacucCommitteePerson person = decision.getAbstainers().get(this.getLineToDelete(request));
        if (person != null) {
            decision.getAbstainersToDelete().add(person);
            decision.getAbstainers().remove(this.getLineToDelete(request));
            decision.setAbstainCount(decision.getAbstainCount() - 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addRecused(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucCommitteeDecision decision = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        if (this.applyRules((KualiDocumentEvent)new IacucCommitteeDecisionRecuserEvent((IacucProtocolDocument)protocolForm.getProtocolDocument(), decision))) {
            decision.getRecused().add(decision.getNewRecused());
            decision.setNewRecused(new IacucCommitteePerson());
            decision.setRecusedCount(decision.getRecusedCount() + 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRecused(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucCommitteeDecision decision = (IacucCommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        IacucCommitteePerson person = decision.getRecused().get(this.getLineToDelete(request));
        if (person != null) {
            decision.getRecusedToDelete().add(person);
            decision.getRecused().remove(this.getLineToDelete(request));
            decision.setRecusedCount(decision.getRecusedCount() - 1);
        }
        return mapping.findForward("basic");
    }

    private IacucProtocolPrintingService getProtocolPrintingService() {
        return KraServiceLocator.getService(IacucProtocolPrintingService.class);
    }

    public ActionForward addReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase document = protocolForm.getProtocolDocument();
        IacucReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            String errorPropertyName = reviewCommentsBean.getErrorPropertyName();
            CommitteeScheduleMinuteBase newReviewComment = reviewCommentsBean.getNewReviewComment();
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            IacucProtocol protocol = (IacucProtocol)document.getProtocol();
            if (this.applyRules((KualiDocumentEvent)new IacucProtocolAddReviewCommentEvent((IacucProtocolDocument)document, errorPropertyName, newReviewComment))) {
                this.getReviewCommentsService().addReviewComment(newReviewComment, reviewComments, protocol);
                reviewCommentsBean.setNewReviewComment(new IacucCommitteeScheduleMinute("3"));
            }
            reviewCommentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewCommentsBean.getReviewComments()));
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveUpReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase document = protocolForm.getProtocolDocument();
        IacucReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            int lineNumber = this.getSelectedLine(request);
            this.getReviewCommentsService().moveUpReviewComment(reviewComments, document.getProtocol(), lineNumber);
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveDownReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase document = protocolForm.getProtocolDocument();
        IacucReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            int lineNumber = this.getSelectedLine(request);
            this.getReviewCommentsService().moveDownReviewComment(reviewComments, document.getProtocol(), lineNumber);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IacucReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            int lineNumber = this.getLineToDelete(request);
            List<CommitteeScheduleMinuteBase> deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().deleteReviewComment(reviewComments, lineNumber, deletedReviewComments);
            if (reviewComments.isEmpty()) {
                reviewCommentsBean.setHideReviewerName(true);
            } else {
                reviewCommentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewCommentsBean.getReviewComments()));
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward abandon(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument protocolDocument = (IacucProtocolDocument)protocolForm.getProtocolDocument();
        IacucProtocol protocol = protocolDocument.getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolAbandon", protocol);
        if (this.isAuthorized(task)) {
            this.getProtocolAbandonService().abandonProtocol(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getProtocolAbandonBean());
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Abandon");
            ProtocolActionBase lastAction = protocol.getLastProtocolAction();
            protocolForm.getProtocolHelper().prepareView();
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocolForm.getIacucProtocolDocument().getIacucProtocol(), "117", "Abandon");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_ACTIONS_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    private void saveReviewComments(IacucProtocolForm protocolForm, IacucReviewCommentsBean actionBean) throws Exception {
        this.getReviewCommentsService().saveReviewComments(actionBean.getReviewComments(), actionBean.getDeletedReviewComments());
        actionBean.setDeletedReviewComments(new ArrayList<CommitteeScheduleMinuteBase>());
        protocolForm.getActionHelper().prepareCommentsView();
    }

    private IacucReviewCommentsBean getReviewCommentsBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IacucReviewCommentsBean reviewCommentsBean = null;
        IacucProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolOnlineReviewCommentable) {
            reviewCommentsBean = (IacucReviewCommentsBean)((ProtocolOnlineReviewCommentable)((Object)protocolActionBean)).getReviewCommentsBean();
        }
        return reviewCommentsBean;
    }

    private IacucProtocolActionBean getActionBean(ActionForm form, HttpServletRequest request) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        String taskName = this.getTaskName(request);
        IacucProtocolActionBean protocolActionBean = null;
        if (StringUtils.isNotBlank((String)taskName)) {
            protocolActionBean = (IacucProtocolActionBean)protocolForm.getActionHelper().getActionBean(taskName);
        }
        return protocolActionBean;
    }

    private String getTaskName(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String taskName = CONFIRM_NO_ACTION;
        if (StringUtils.isNotBlank((String)parameterName)) {
            taskName = StringUtils.substringBetween((String)parameterName, (String)".taskName", (String)".");
        }
        return taskName;
    }

    private boolean hasPermission(String taskName, IacucProtocol protocol) {
        IacucProtocolTask task = new IacucProtocolTask(taskName, protocol);
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    private boolean hasGenericPermission(String genericActionName, IacucProtocol protocol) {
        IacucProtocolTask task = new IacucProtocolTask("iacucGenericProtocolAction", protocol, genericActionName);
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    private IacucProtocolAttachmentService getProtocolAttachmentService() {
        return KraServiceLocator.getService(IacucProtocolAttachmentService.class);
    }

    private TaskAuthorizationService getTaskAuthorizationService() {
        return KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    private IacucProtocolGenericActionService getProtocolGenericActionService() {
        return KraServiceLocator.getService(IacucProtocolGenericActionService.class);
    }

    private IacucProtocolAbandonService getProtocolAbandonService() {
        return KraServiceLocator.getService(IacucProtocolAbandonService.class);
    }

    public IacucProtocolCopyService getIacucProtocolCopyService() {
        return KraServiceLocator.getService(IacucProtocolCopyService.class);
    }

    private IacucProtocolSubmitActionService getProtocolSubmitActionService() {
        return KraServiceLocator.getService(IacucProtocolSubmitActionService.class);
    }

    private IacucProtocolWithdrawService getProtocolWithdrawService() {
        return KraServiceLocator.getService(IacucProtocolWithdrawService.class);
    }

    private IacucProtocolRequestService getProtocolRequestService() {
        return KraServiceLocator.getService(IacucProtocolRequestService.class);
    }

    private IacucProtocolNotifyCommitteeService getProtocolNotifyCommitteeService() {
        return KraServiceLocator.getService(IacucProtocolNotifyCommitteeService.class);
    }

    private IacucProtocolAmendRenewService getProtocolAmendRenewService() {
        return KraServiceLocator.getService(IacucProtocolAmendRenewService.class);
    }

    private IacucProtocolDeleteService getProtocolDeleteService() {
        return KraServiceLocator.getService(IacucProtocolDeleteService.class);
    }

    private IacucProtocolAssignCmtService getProtocolAssignCmtService() {
        return KraServiceLocator.getService(IacucProtocolAssignCmtService.class);
    }

    private IacucProtocolAssignToAgendaService getProtocolAssignToAgendaService() {
        return KraServiceLocator.getService(IacucProtocolAssignToAgendaService.class);
    }

    private IacucProtocolApproveService getProtocolApproveService() {
        return KraServiceLocator.getService(IacucProtocolApproveService.class);
    }

    private CommitteeServiceBase getCommitteeService() {
        return KraServiceLocator.getService(IacucCommitteeService.class);
    }

    private IacucCommitteeDecisionService getCommitteeDecisionService() {
        return KraServiceLocator.getService(IacucCommitteeDecisionService.class);
    }

    private IacucReviewCommentsService getReviewCommentsService() {
        return KraServiceLocator.getService(IacucReviewCommentsService.class);
    }

    public ActionForward addNotifyIacucAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        if (actionHelper.validFile(actionHelper.getIacucProtocolNotifyIacucBean().getNewActionAttachment(), "iacucProtocolNotifyIacucBean")) {
            LOG.info((Object)("addNotifyIacucAttachment " + actionHelper.getIacucProtocolNotifyIacucBean().getNewActionAttachment().getFile().getFileName() + ((ProtocolFormBase)form).getProtocolDocument().getDocumentNumber()));
            actionHelper.addNotifyIacucAttachment();
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewNotifyIacucAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.viewAttachment(mapping, (IacucProtocolForm)form, request, response);
    }

    private ActionForward viewAttachment(ActionMapping mapping, IacucProtocolForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        IacucActionHelper actionHelper = (IacucActionHelper)form.getActionHelper();
        ProtocolActionAttachment attachment = actionHelper.getIacucProtocolNotifyIacucBean().getActionAttachments().get(selection);
        if (attachment == null) {
            LOG.info((Object)(NOT_FOUND_SELECTION + selection));
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getFile().getFileData(), IacucProtocolActionsAction.getValidHeaderString(attachment.getFile().getFileName()), IacucProtocolActionsAction.getValidHeaderString(attachment.getFile().getContentType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteNotifyIacucAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        return this.confirmDeleteAttachment(mapping, protocolForm, request, response, actionHelper.getIacucProtocolNotifyIacucBean().getActionAttachments());
    }

    private ActionForward confirmDeleteAttachment(ActionMapping mapping, ProtocolFormBase form, HttpServletRequest request, HttpServletResponse response, List<ProtocolActionAttachment> attachments) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolActionAttachment attachment = attachments.get(selection);
        if (attachment == null) {
            LOG.info((Object)(NOT_FOUND_SELECTION + selection));
            return mapping.findForward("basic");
        }
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, CONFIRM_DELETE_ACTION_ATT, "document.question.deleteAttachment.text", CONFIRM_NO_ACTION, attachment.getFile().getFileName());
        return this.confirm(confirm, CONFIRM_DELETE_ACTION_ATT, CONFIRM_NO_ACTION);
    }

    public ActionForward confirmDeleteActionAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String taskName = this.getTaskName(request);
        int selection = this.getSelectedLine(request);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        if (StringUtils.isBlank((String)taskName)) {
            actionHelper.getIacucProtocolNotifyIacucBean().getActionAttachments().remove(selection);
        } else {
            IacucProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            requestBean.getActionAttachments().remove(selection);
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewSubmissionDoc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolActionBase protocolAction = protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolSubmissionDocBase attachment = protocolAction.getProtocolSubmissionDocs().get(attachmentIndex);
        if (attachment == null) {
            LOG.info((Object)("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolSubmissionDoc: " + attachmentIndex));
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getDocument(), IacucProtocolActionsAction.getValidHeaderString(attachment.getFileName()), IacucProtocolActionsAction.getValidHeaderString(attachment.getContentType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward viewActionCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolActionBase protocolAction = protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolCorrespondence attachment = protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (attachment == null) {
            LOG.info((Object)("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex));
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getCorrespondence(), StringUtils.replace((String)attachment.getProtocolCorrespondenceType().getDescription(), (String)" ", (String)CONFIRM_NO_ACTION) + ".pdf", "application/pdf", response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private int getSelectedAttachment(HttpServletRequest request) {
        int selectedAttachment = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String attachmentNumber = StringUtils.substringBetween((String)parameterName, (String)".attachment", (String)".");
            selectedAttachment = Integer.parseInt(attachmentNumber);
        }
        return selectedAttachment;
    }

    private void recordProtocolActionSuccess(String protocolActionName) {
        KNSGlobalVariables.getMessageList().add("message.protocol.action.successfully.completed", new String[]{protocolActionName});
    }

    private ActionForward confirmFollowupAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String forward) throws Exception {
        List validFollowupActions = this.getFollowupActionService().getFollowupsForProtocol(((ProtocolFormBase)form).getProtocolDocument().getProtocol());
        if (validFollowupActions.isEmpty()) {
            LOG.info((Object)"No followup action");
            return mapping.findForward(forward);
        }
        if (!((IacucValidProtocolActionAction)((Object)validFollowupActions.get(0))).getUserPromptFlag()) {
            this.addFollowupAction(((ProtocolFormBase)form).getProtocolDocument().getProtocol());
            return mapping.findForward(forward);
        }
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_FOLLOWUP_ACTION, "question.protocol.confirmFollowupAction", ((IacucValidProtocolActionAction)((Object)validFollowupActions.get(0))).getUserPrompt());
        LOG.info((Object)("followup action " + ((IacucValidProtocolActionAction)((Object)validFollowupActions.get(0))).getUserPrompt()));
        return this.confirm(confirm, CONFIRM_FOLLOWUP_ACTION, CONFIRM_NO_ACTION);
    }

    public ActionForward confirmAddFollowupAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addFollowupAction(((ProtocolFormBase)form).getProtocolDocument().getProtocol());
        return mapping.findForward("basic");
    }

    private void addFollowupAction(ProtocolBase protocol) throws Exception {
        List validFollowupActions = this.getFollowupActionService().getFollowupsForProtocol(protocol);
        protocol.getLastProtocolAction().setFollowupActionCode(((IacucValidProtocolActionAction)((Object)validFollowupActions.get(0))).getFollowupActionCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)protocol.getLastProtocolAction());
    }

    private QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    private IacucFollowupActionService getFollowupActionService() {
        return KraServiceLocator.getService(IacucFollowupActionService.class);
    }

    private WatermarkService getWatermarkService() {
        return KraServiceLocator.getService(WatermarkService.class);
    }

    public ActionForward viewReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            return this.streamReviewAttachment(mapping, request, response, reviewAttachmentsBean.getReviewAttachments());
        }
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward viewSubmissionReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.streamReviewAttachment(mapping, request, response, ((IacucProtocolForm)form).getActionHelper().getReviewAttachments());
    }

    private ActionForward streamReviewAttachment(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, List<IacucProtocolReviewAttachment> reviewAttachments) throws Exception {
        int lineNumber = this.getLineToDelete(request);
        IacucProtocolReviewAttachment attachment = reviewAttachments.get(lineNumber);
        if (attachment == null) {
            LOG.info((Object)(NOT_FOUND_SELECTION + lineNumber));
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), IacucProtocolActionsAction.getValidHeaderString(file.getName()), IacucProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IacucReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            int lineNumber = this.getLineToDelete(request);
            List deletedReviewAttachments = reviewAttachmentsBean.getDeletedReviewAttachments();
            this.getReviewCommentsService().deleteReviewAttachment(reviewAttachments, lineNumber, deletedReviewAttachments);
            if (reviewAttachments.isEmpty()) {
                reviewAttachmentsBean.setHideReviewerName(true);
            } else {
                reviewAttachmentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewAttachmentsBean.getReviewAttachments()));
            }
        }
        return mapping.findForward("basic");
    }

    private IacucReviewAttachmentsBean getReviewAttachmentsBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IacucReviewAttachmentsBean reviewAttachmentsBean = null;
        IacucProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolOnlineReviewCommentable) {
            reviewAttachmentsBean = (IacucReviewAttachmentsBean)((ProtocolOnlineReviewCommentable)((Object)protocolActionBean)).getReviewAttachmentsBean();
        }
        return reviewAttachmentsBean;
    }

    public ActionForward manageAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolManageReviewComments", (IacucProtocol)protocolForm.getProtocolDocument().getProtocol()) && this.applyRules((KualiDocumentEvent)new IacucProtocolManageReviewAttachmentEvent((IacucProtocolDocument)protocolForm.getProtocolDocument(), "actionHelper.protocolManageReviewCommentsBean.reviewAttachmentsBean.", ((IacucReviewAttachmentsBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean().getReviewAttachmentsBean()).getReviewAttachments()))) {
                IacucProtocolGenericActionBean actionBean = (IacucProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean();
                this.saveReviewAttachments(protocolForm, (IacucReviewAttachmentsBean)actionBean.getReviewAttachmentsBean());
                this.recordProtocolActionSuccess("Manage Review Attachments");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private void saveReviewAttachments(IacucProtocolForm protocolForm, IacucReviewAttachmentsBean actionBean) throws Exception {
        this.getReviewCommentsService().saveReviewAttachments(actionBean.getReviewAttachments(), actionBean.getDeletedReviewAttachments());
        actionBean.setDeletedReviewAttachments(new ArrayList());
        protocolForm.getActionHelper().prepareCommentsView();
    }

    public ActionForward addReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase document = protocolForm.getProtocolDocument();
        IacucReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            String errorPropertyName = reviewAttachmentsBean.getErrorPropertyName();
            IacucProtocolReviewAttachment newReviewAttachment = (IacucProtocolReviewAttachment)((Object)reviewAttachmentsBean.getNewReviewAttachment());
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            ProtocolBase protocol = document.getProtocol();
            if (this.applyRules((KualiDocumentEvent)new IacucProtocolAddReviewAttachmentEvent((IacucProtocolDocument)document, errorPropertyName, newReviewAttachment))) {
                this.getReviewCommentsService().addReviewAttachment(newReviewAttachment, reviewAttachments, protocol);
                reviewAttachmentsBean.setNewReviewAttachment(new IacucProtocolReviewAttachment());
            }
            reviewAttachmentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewAttachmentsBean.getReviewAttachments()));
        }
        return mapping.findForward("basic");
    }

    private boolean hasDocumentStateChanged(IacucProtocolForm protocolForm) {
        boolean result = false;
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("protocolId", protocolForm.getProtocolDocument().getProtocol().getProtocolId());
        IacucProtocol dbProtocol = (IacucProtocol)this.getBusinessObjectService().findByPrimaryKey(IacucProtocol.class, primaryKeys);
        if (dbProtocol != null) {
            if (!StringUtils.equals((String)dbProtocol.getProtocolStatusCode(), (String)protocolForm.getProtocolDocument().getProtocol().getProtocolStatusCode())) {
                result = true;
            }
            if (dbProtocol.getProtocolSubmission() != null && protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission().getSubmissionStatusCode() != null && !StringUtils.equals((String)dbProtocol.getProtocolSubmission().getSubmissionStatusCode(), (String)protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission().getSubmissionStatusCode())) {
                result = true;
            }
        }
        if (!result) {
            result = !this.isDocumentPostprocessingComplete(protocolForm.getIacucProtocolDocument());
        }
        return result;
    }

    private boolean isDocumentPostprocessingComplete(IacucProtocolDocument document) {
        return document.getDocumentHeader().hasWorkflowDocument() && !this.isPessimisticallyLocked((Document)document);
    }

    private boolean isPessimisticallyLocked(Document document) {
        boolean isPessimisticallyLocked = false;
        Person pessimisticLockHolder = this.getPersonService().getPersonByPrincipalName("kr");
        for (PessimisticLock pessimisticLock : document.getPessimisticLocks()) {
            if (!pessimisticLock.isOwnedByUser(pessimisticLockHolder)) continue;
            isPessimisticallyLocked = true;
            break;
        }
        return isPessimisticallyLocked;
    }

    private ActionForward checkToSendNotification(ActionMapping mapping, ActionForward forward, ProtocolFormBase form, IacucProtocolNotificationRequestBean notificationRequestBean) {
        IacucProtocolNotificationRenderer renderer = null;
        IacucProtocol protocol = (IacucProtocol)notificationRequestBean.getProtocol();
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (StringUtils.equals((String)"114", (String)notificationRequestBean.getActionType())) {
            renderer = new NotifyIacucNotificationRenderer(protocol, ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolNotifyIacucBean().getComment());
        } else if (StringUtils.equals((String)"906", (String)notificationRequestBean.getActionType()) || StringUtils.equals((String)"115", (String)notificationRequestBean.getActionType())) {
            renderer = new IacucProtocolWithReasonNotificationRenderer(protocol, protocolForm.getActionHelper().getProtocolDeleteBean());
        } else if (StringUtils.equals((String)"107", (String)notificationRequestBean.getActionType()) || StringUtils.equals((String)"108", (String)notificationRequestBean.getActionType())) {
            IacucRequestActionNotificationBean requestNotificationRequestBean = (IacucRequestActionNotificationBean)notificationRequestBean;
            renderer = new IacucProtocolRequestActionNotificationRenderer(protocol, requestNotificationRequestBean.getReason());
        } else if (StringUtils.equals((String)"311", (String)notificationRequestBean.getActionType())) {
            IacucProtocolRequestBean iacucProtocolSuspendRequestBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolSuspendRequestBean();
            renderer = new NotifyIacucNotificationRenderer(protocol, iacucProtocolSuspendRequestBean.getReason());
        } else {
            renderer = new IacucProtocolNotificationRenderer(protocol);
        }
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, notificationRequestBean.getActionType(), notificationRequestBean.getDescription(), renderer);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            context.setForwardName(forward.getName());
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            return mapping.findForward("iacucProtocolNotificationEditor");
        }
        this.getNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocol);
        return forward;
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        IacucProtocolNotificationRenderer renderer = new IacucProtocolNotificationRenderer(protocol);
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, "999", "Ad-Hoc Notification", renderer);
        protocolForm.getNotificationHelper().initializeDefaultValues(context);
        return mapping.findForward("iacucProtocolNotificationEditor");
    }

    protected PersonService getPersonService() {
        return KraServiceLocator.getService(PersonService.class);
    }

    @Override
    protected KcNotificationService getNotificationService() {
        return KraServiceLocator.getService(KcNotificationService.class);
    }

    public ActionForward viewCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucActionHelper actionHelper = (IacucActionHelper)((ProtocolFormBase)form).getActionHelper();
        PrintableAttachment source = new PrintableAttachment();
        ProtocolCorrespondence correspondence = actionHelper.getProtocolCorrespondence();
        source.setContent(correspondence.getCorrespondence());
        source.setContentType("application/pdf");
        source.setFileName("Correspondence-" + correspondence.getProtocolCorrespondenceType().getDescription() + ".pdf");
        PrintingUtils.streamToResponse(source, response);
        return null;
    }

    public ActionForward saveCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, true);
    }

    public ActionForward closeCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, false);
    }

    private ActionForward correspondenceAction(ActionMapping mapping, ActionForm form, boolean saveAction) {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        ProtocolCorrespondence correspondence = actionHelper.getProtocolCorrespondence();
        if (saveAction) {
            if (correspondence.getFinalFlag()) {
                correspondence.setFinalFlagTimestamp(KraServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)correspondence);
        }
        if (GlobalVariables.getUserSession().retrieveObject("approvalComplCorrespondence") != null) {
            GlobalVariables.getUserSession().addObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY", GlobalVariables.getUserSession().retrieveObject("approvalComplCorrespondence"));
            GlobalVariables.getUserSession().removeObject("approvalComplCorrespondence");
        }
        if (correspondence.getNotificationRequestBean() != null) {
            return this.checkToSendNotification(mapping, mapping.findForward(correspondence.getForwardName()), protocolForm, (IacucProtocolNotificationRequestBean)correspondence.getNotificationRequestBean());
        }
        if (correspondence.isHoldingPage()) {
            return this.routeProtocolToHoldingPage(mapping, protocolForm);
        }
        return mapping.findForward(correspondence.getForwardName());
    }

    public ActionForward regenerateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolBase protocol = protocolForm.getActionHelper().getProtocol();
        ProtocolActionBase protocolAction = protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolCorrespondence protocolCorrespondence = protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (protocolCorrespondence == null) {
            LOG.info((Object)("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex));
            return mapping.findForward("basic");
        }
        AttachmentDataSource dataSource = this.generateCorrespondenceDocument(protocol, protocolCorrespondence);
        PrintableAttachment source = new PrintableAttachment();
        if (dataSource != null) {
            protocolCorrespondence.setCorrespondence(dataSource.getContent());
            protocolCorrespondence.setFinalFlag(false);
            protocolCorrespondence.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
            protocolCorrespondence.setCreateTimestamp(KraServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            protocolCorrespondence.setForwardName(PROTOCOL_ACTIONS_TAB);
            protocolForm.getActionHelper().setProtocolCorrespondence(protocolCorrespondence);
            this.getBusinessObjectService().save((PersistableBusinessObject)protocolCorrespondence);
            return mapping.findForward(CORRESPONDENCE);
        }
        return mapping.findForward("basic");
    }

    protected AttachmentDataSource generateCorrespondenceDocument(ProtocolBase protocol, ProtocolCorrespondence oldCorrespondence) throws PrintingException {
        IacucProtocolActionsCorrespondence correspondence = new IacucProtocolActionsCorrespondence(oldCorrespondence.getProtocolAction().getProtocolActionTypeCode());
        correspondence.setProtocol(protocol);
        return this.getProtocolActionCorrespondenceGenerationService().reGenerateCorrespondenceDocument(correspondence);
    }

    private IacucProtocolActionCorrespondenceGenerationService getProtocolActionCorrespondenceGenerationService() {
        return KraServiceLocator.getService(IacucProtocolActionCorrespondenceGenerationService.class);
    }

    public ActionForward updateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolActionBase protocolAction = protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        protocolAction.refreshReferenceObject("protocolCorrespondences");
        ProtocolCorrespondence protocolCorrespondence = protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (protocolCorrespondence == null) {
            LOG.info((Object)("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex));
            return mapping.findForward("basic");
        }
        protocolCorrespondence.setForwardName(PROTOCOL_ACTIONS_TAB);
        protocolForm.getActionHelper().setProtocolCorrespondence(protocolCorrespondence);
        return mapping.findForward(CORRESPONDENCE);
    }

    public ActionForward printProtocolSelectedItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument ipd = (IacucProtocolDocument)this.getDocumentService().getByDocumentHeaderId(protocolForm.getDocId());
        protocolForm.setDocument((Document)ipd);
        ActionForward forward = mapping.findForward("basic");
        AttachmentDataSource dataStream = this.getIacucProtocolPrintingService().printProtocolSelectedItems(protocolForm);
        if (dataStream.getContent() != null) {
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward printProtocolDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AttachmentDataSource dataStream;
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ActionForward forward = mapping.findForward("basic");
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        if (this.applyRules((KualiDocumentEvent)new ProtocolActionPrintEvent(protocolForm.getProtocolDocument(), actionHelper.getSummaryReport(), actionHelper.getFullReport(), actionHelper.getHistoryReport(), actionHelper.getReviewCommentsReport())) && (dataStream = this.getIacucProtocolPrintingService().printProtocolDocument(protocolForm)).getContent() != null) {
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    private IacucProtocolPrintingService getIacucProtocolPrintingService() {
        return KraServiceLocator.getService(IacucProtocolPrintingService.class);
    }

    public ActionForward sendReviewDeterminationNotificationAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucActionHelper actionHelper = (IacucActionHelper)protocolForm.getActionHelper();
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        IacucProtocolModifySubmissionBean bean = actionHelper.getIacucProtocolModifySubmissionBean();
        Date dueDate = bean.getDueDate();
        IacucProtocolReviewDeterminationNotificationRenderer renderer = new IacucProtocolReviewDeterminationNotificationRenderer(protocol, dueDate);
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, "908", "Review Type Determination", renderer);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            forward = mapping.findForward("iacucProtocolNotificationEditor");
        } else {
            this.getNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocol);
        }
        this.recordProtocolActionSuccess("Send Review Type Determination Notification");
        return forward;
    }

    protected IdentityService getIdentityService() {
        return KraServiceLocator.getService(IdentityService.class);
    }

    public ActionForward modifySubmissionAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String callerString = String.format("assignReviewers", new Object[0]);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("modifyIacucProtocolSubmission", protocol);
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task)) {
                IacucProtocolModifySubmissionBean bean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolModifySubmissionBean();
                this.setReviewers(form, request, bean);
                if (this.applyRules((KualiDocumentEvent)new IacucProtocolModifySubmissionEvent(protocolForm.getProtocolDocument(), bean))) {
                    List<ProtocolReviewerBeanBase> beans = bean.getReviewers();
                    this.getModifySubmissionService().modifySubmission(protocolForm.getProtocolDocument(), bean, beans);
                    GlobalVariables.getMessageMap().getWarningMessages().clear();
                    this.recordProtocolActionSuccess("Modify Submission");
                    forward = this.performNotificationRendering(mapping, protocolForm, beans);
                    IacucProtocolNotificationRenderer assignRenderer = new IacucProtocolNotificationRenderer(protocol);
                    IacucProtocolNotificationContext assignContext = new IacucProtocolNotificationContext(protocol, null, "309", "Modified", assignRenderer);
                    this.getNotificationService().sendNotificationAndPersist(assignContext, new IacucProtocolNotification(), protocol);
                    protocolForm.setReinitializeModifySubmissionFields(true);
                }
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.iacuc.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    protected void setReviewers(ActionForm form, HttpServletRequest request, IacucProtocolModifySubmissionBean submissionBean) {
        int number = Integer.parseInt(request.getParameter("actionHelper.iacucProtocolModifySubmissionBean.numberOfReviewers"));
        ArrayList<ProtocolReviewerBeanBase> beans = new ArrayList<ProtocolReviewerBeanBase>();
        for (int i = 0; i < number; ++i) {
            String reviewerTypeCode = request.getParameter("actionHelper.iacucProtocolModifySubmissionBean.reviewer[" + i + "].reviewerTypeCode");
            String personId = request.getParameter("actionHelper.iacucProtocolModifySubmissionBean.reviewer[" + i + "].personId");
            String fullName = request.getParameter("actionHelper.iacucProtocolModifySubmissionBean.reviewer[" + i + "].fullName");
            String nonEmployeeFlag = request.getParameter("actionHelper.iacucProtocolModifySubmissionBean.reviewer[" + i + "].nonEmployeeFlag");
            if (!ObjectUtils.isNotNull((Object)personId)) continue;
            IacucProtocolReviewerBean bean = new IacucProtocolReviewerBean();
            bean.setFullName(fullName);
            bean.setPersonId(personId);
            bean.setReviewerTypeCode(reviewerTypeCode);
            bean.setActionFlag("create");
            beans.add(bean);
        }
        submissionBean.setReviewers(beans);
    }

    protected IacucProtocolModifySubmissionService getModifySubmissionService() {
        return KraServiceLocator.getService(IacucProtocolModifySubmissionService.class);
    }

    protected ActionForward performNotificationRendering(ActionMapping mapping, IacucProtocolForm protocolForm, List<ProtocolReviewerBeanBase> beans) {
        IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
        ActionForward forward = mapping.findForward("basic");
        IacucProtocolAssignReviewerNotificationRenderer renderer = new IacucProtocolAssignReviewerNotificationRenderer(protocol, "added");
        List<ProtocolNotificationRequestBeanBase> addReviewerNotificationBeans = this.getNotificationRequestBeans(beans, "create", true);
        List<ProtocolNotificationRequestBeanBase> removeReviewerNotificationBeans = this.getNotificationRequestBeans(beans, "remove", false);
        if (!CollectionUtils.isEmpty(addReviewerNotificationBeans)) {
            ProtocolNotificationRequestBeanBase notificationBean = addReviewerNotificationBeans.get(0);
            IacucProtocolNotificationContext context = new IacucProtocolNotificationContext((IacucProtocol)notificationBean.getProtocol(), (IacucProtocolOnlineReview)notificationBean.getProtocolOnlineReview(), notificationBean.getActionType(), notificationBean.getDescription(), renderer);
            if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, renderer, addReviewerNotificationBeans);
                if (!CollectionUtils.isEmpty(removeReviewerNotificationBeans)) {
                    GlobalVariables.getUserSession().addObject("removeReviewer", removeReviewerNotificationBeans);
                }
            }
        } else if (!CollectionUtils.isEmpty(removeReviewerNotificationBeans)) {
            renderer = new IacucProtocolAssignReviewerNotificationRenderer(protocol, "removed");
            ProtocolNotificationRequestBeanBase notificationBean = removeReviewerNotificationBeans.get(0);
            IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(protocol, (IacucProtocolOnlineReview)notificationBean.getProtocolOnlineReview(), notificationBean.getActionType(), notificationBean.getDescription(), renderer);
            if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, renderer, removeReviewerNotificationBeans);
            }
        }
        return forward;
    }

    private ActionForward checkToSendNotification(ActionMapping mapping, ActionForward forward, ProtocolFormBase protocolForm, IacucProtocolNotificationRenderer renderer, List<ProtocolNotificationRequestBeanBase> notificationRequestBeans) {
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext((IacucProtocol)notificationRequestBeans.get(0).getProtocol(), (IacucProtocolOnlineReview)notificationRequestBeans.get(0).getProtocolOnlineReview(), notificationRequestBeans.get(0).getActionType(), notificationRequestBeans.get(0).getDescription(), renderer);
        context.setPopulateRole(true);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            List<NotificationTypeRecipient> notificationRecipients = protocolForm.getNotificationHelper().getNotificationRecipients();
            ArrayList<NotificationTypeRecipient> allRecipients = new ArrayList<NotificationTypeRecipient>();
            for (NotificationTypeRecipient recipient : notificationRecipients) {
                try {
                    NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)((Object)ObjectUtils.deepCopy((Serializable)((Object)recipient)));
                    context.populateRoleQualifiers(copiedRecipient);
                    allRecipients.add(copiedRecipient);
                }
                catch (Exception e) {}
            }
            for (int i = 1; notificationRequestBeans.size() > i; ++i) {
                context = new IacucProtocolNotificationContext((IacucProtocol)notificationRequestBeans.get(i).getProtocol(), (IacucProtocolOnlineReview)notificationRequestBeans.get(i).getProtocolOnlineReview(), notificationRequestBeans.get(i).getActionType(), notificationRequestBeans.get(i).getDescription(), renderer);
                context.setPopulateRole(true);
                protocolForm.getNotificationHelper().initializeDefaultValues(context);
                List<NotificationTypeRecipient> recipients = protocolForm.getNotificationHelper().getNotificationRecipients();
                for (NotificationTypeRecipient recipient : recipients) {
                    try {
                        NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)((Object)ObjectUtils.deepCopy((Serializable)((Object)recipient)));
                        context.populateRoleQualifiers(copiedRecipient);
                        allRecipients.add(copiedRecipient);
                    }
                    catch (Exception e) {}
                }
            }
            protocolForm.getNotificationHelper().setNotificationRecipients(allRecipients);
            if (forward == null) {
                context.setForwardName("holdingPage");
            } else {
                context.setForwardName(forward.getName());
            }
            return mapping.findForward("iacucProtocolNotificationEditor");
        }
        return forward;
    }

    private List<ProtocolNotificationRequestBeanBase> getNotificationRequestBeans(List<ProtocolReviewerBeanBase> beans, String actionFlag, boolean notNullFlag) {
        ArrayList<ProtocolNotificationRequestBeanBase> notificationRequestBeans = new ArrayList<ProtocolNotificationRequestBeanBase>();
        for (ProtocolReviewerBeanBase bean : beans) {
            if (!StringUtils.equals((String)actionFlag, (String)bean.getActionFlag()) || notNullFlag != !StringUtils.isEmpty((String)bean.getReviewerTypeCode())) continue;
            notificationRequestBeans.add(bean.getNotificationRequestBean());
        }
        return notificationRequestBeans;
    }

    public ActionForward tableProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocol protocol = protocolForm.getIacucProtocolDocument().getIacucProtocol();
        IacucProtocolTask task = new IacucProtocolTask("iacucProtocolTable", protocol);
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task)) {
                IacucProtocolTableBean actionBean = ((IacucActionHelper)protocolForm.getActionHelper()).getIacucProtocolTableBean();
                this.getIacucProtocolTableService().tableProtocol(protocol, actionBean);
                this.recordProtocolActionSuccess("Table ProtocolBase");
                IacucProtocolNotificationRequestBean notificationRequestBean = new IacucProtocolNotificationRequestBean(protocol, "203", "Tabled");
                protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_ACTIONS_TAB, notificationRequestBean, false));
                if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                    return mapping.findForward(CORRESPONDENCE);
                }
                return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, notificationRequestBean);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private IacucProtocolTableService getIacucProtocolTableService() {
        return KraServiceLocator.getService(IacucProtocolTableService.class);
    }

    public ActionForward undoLastAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            IacucProtocolDocument protocolDocument = (IacucProtocolDocument)protocolForm.getProtocolDocument();
            UndoLastActionBean undoLastActionBean = protocolForm.getActionHelper().getUndoLastActionBean();
            String lastActionType = undoLastActionBean.getLastAction().getProtocolActionTypeCode();
            IacucProtocolUndoLastActionService undoLastActionService = KraServiceLocator.getService(IacucProtocolUndoLastActionService.class);
            ProtocolDocumentBase updatedDocument = undoLastActionService.undoLastAction(protocolDocument, undoLastActionBean);
            this.recordProtocolActionSuccess("Undo Last Action");
            if (!updatedDocument.getDocumentNumber().equals(protocolForm.getDocId())) {
                protocolForm.setDocId(updatedDocument.getDocumentNumber());
                this.loadDocument((KualiDocumentFormBase)protocolForm);
                protocolForm.getProtocolHelper().prepareView();
                return mapping.findForward(PROTOCOL_TAB);
            }
            if ("211".equals(lastActionType) || "209".equals(lastActionType)) {
                return this.routeProtocolToHoldingPage(mapping, protocolForm);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private class PrintableAttachment
    extends AttachmentDataSource {
        private byte[] streamData;

        private PrintableAttachment() {
        }

        @Override
        public byte[] getContent() {
            return this.streamData;
        }

        public void setContent(byte[] streamData) {
            this.streamData = streamData;
        }
    }
}

