/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.assignCmt;

import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtBean;
import org.kuali.kra.iacuc.actions.assignCmt.IacucProtocolAssignCmtService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IacucProtocolAssignCmtServiceImpl
implements IacucProtocolAssignCmtService {
    private BusinessObjectService businessObjectService;
    private CommitteeServiceBase committeeService;
    private static final String NEXT_ACTION_ID_KEY = "actionId";

    @Override
    public void assignToCommittee(ProtocolBase protocol, IacucProtocolAssignCmtBean actionBean) throws Exception {
        ProtocolSubmissionBase submission = this.findSubmission(protocol);
        String prevSubmissionStatusCode = null;
        if (submission != null) {
            prevSubmissionStatusCode = submission.getSubmissionStatusCode();
            submission.setSubmissionStatusCode("102");
            this.setCommittee(submission, actionBean.getCommitteeId());
        }
        this.addNewAction(protocol, actionBean, prevSubmissionStatusCode);
        this.getBusinessObjectService().save((PersistableBusinessObject)protocol);
    }

    public boolean setCommittee(ProtocolSubmissionBase submission, String committeeId) {
        Object committee = this.committeeService.getCommitteeById(committeeId);
        if (committee == null) {
            submission.setCommitteeId(null);
            submission.setCommitteeIdFk(null);
            submission.setCommittee(null);
            return false;
        }
        submission.setCommitteeId(((CommitteeBase)committee).getCommitteeId());
        submission.setCommitteeIdFk(((CommitteeBase)committee).getId());
        submission.setCommittee((CommitteeBase)committee);
        return true;
    }

    protected void addNewAction(ProtocolBase protocol, IacucProtocolAssignCmtBean actionBean, String prevSubmissionStatusCode) {
        ProtocolActionBase lastAction = protocol.getLastProtocolAction();
        IacucProtocolAction newAction = new IacucProtocolAction();
        newAction.setComments("AssignedToCommittee");
        newAction.setActionId(protocol.getNextValue(NEXT_ACTION_ID_KEY));
        newAction.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        newAction.setActionDate(new Timestamp(System.currentTimeMillis()));
        newAction.setProtocolActionTypeCode("313");
        newAction.setSubmissionIdFk(lastAction.getSubmissionIdFk());
        newAction.setSubmissionNumber(lastAction.getSubmissionNumber());
        newAction.setProtocolNumber(protocol.getProtocolNumber());
        newAction.setProtocolId(protocol.getProtocolId());
        newAction.setSequenceNumber(protocol.getSequenceNumber());
        newAction.setPrevSubmissionStatusCode(prevSubmissionStatusCode);
        protocol.getProtocolActions().add(newAction);
    }

    @Override
    public String getAssignedCommitteeId(ProtocolBase protocol) {
        String retVal = null;
        ProtocolSubmissionBase submission = this.findSubmission(protocol);
        if (submission != null && (StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102") || StringUtils.equals((String)protocol.getProtocolStatusCode(), (String)"103") && StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"206"))) {
            retVal = submission.getCommitteeId();
        }
        return retVal;
    }

    @Override
    public String getAssignedScheduleId(ProtocolBase protocol) {
        String retVal = null;
        ProtocolSubmissionBase submission = this.findSubmission(protocol);
        if (submission != null && StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102") || StringUtils.equals((String)protocol.getProtocolStatusCode(), (String)"103") && StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"206")) {
            retVal = submission.getScheduleId();
        }
        return retVal;
    }

    public void setCommitteeService(CommitteeServiceBase committeeService) {
        this.committeeService = committeeService;
    }

    public CommitteeServiceBase getCommitteeService() {
        return this.committeeService;
    }

    protected ProtocolSubmissionBase findSubmission(ProtocolBase protocol) {
        ProtocolSubmissionBase protocolSubmission = null;
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"101") && !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102") && (!StringUtils.equals((String)protocol.getProtocolStatusCode(), (String)"103") || !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"206"))) continue;
            protocolSubmission = submission;
        }
        return protocolSubmission;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

