/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.assignagenda;

import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.assignagenda.IacucProtocolAssignToAgendaService;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionBean;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionsCorrespondence;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaBean;

public class IacucProtocolAssignToAgendaBean
extends IacucProtocolGenericActionBean
implements ProtocolAssignToAgendaBean {
    private static final long serialVersionUID = -1671485882883282877L;
    private String committeeId = "";
    private String committeName = "";
    private String scheduleDate = "";
    private boolean protocolAssigned;
    private transient IacucProtocolAssignToAgendaService agendaService;

    public IacucProtocolAssignToAgendaBean(IacucActionHelper actionHelper) {
        super(actionHelper, "actionHelper.assignToAgendaBean");
    }

    @Override
    public void setCommitteeId(String committeeId) {
        this.committeeId = committeeId;
    }

    @Override
    public void setCommitteName(String committeName) {
        this.committeName = committeName;
    }

    @Override
    public void setScheduleDate(String scheduleDate) {
        this.scheduleDate = scheduleDate;
    }

    @Override
    public void setProtocolAssigned(boolean protocolAssigned) {
        this.protocolAssigned = protocolAssigned;
    }

    private IacucProtocolAssignToAgendaService getProtocolAssignToAgendaService() {
        if (this.agendaService == null) {
            this.agendaService = KraServiceLocator.getService(IacucProtocolAssignToAgendaService.class);
        }
        return this.agendaService;
    }

    @Override
    public String getCommitteeId() {
        return this.committeeId;
    }

    @Override
    public String getCommitteName() {
        return this.committeName;
    }

    @Override
    public String getScheduleDate() {
        return this.scheduleDate;
    }

    @Override
    public boolean isProtocolAssigned() {
        return this.protocolAssigned;
    }

    @Override
    public void prepareView() {
        if (this.getProtocol() != null && this.getProtocol().getProtocolNumber() != null && !"protocolAssignToAgenda".equalsIgnoreCase(this.getActionHelper().getCurrentTask())) {
            String assignedCommitteeId = this.getProtocolAssignToAgendaService().getAssignedCommitteeId(this.getProtocol());
            if (assignedCommitteeId != null) {
                this.committeeId = assignedCommitteeId;
                this.committeName = this.getProtocolAssignToAgendaService().getAssignedCommitteeName(this.getProtocol());
                this.setComments(this.getProtocolAssignToAgendaService().getAssignToAgendaComments(this.getProtocol()));
                this.protocolAssigned = this.getProtocolAssignToAgendaService().isAssignedToAgenda(this.getProtocol());
                this.scheduleDate = this.getProtocolAssignToAgendaService().getAssignedScheduleDate(this.getProtocol());
            }
            if (this.getComments() == null) {
                this.setComments("");
            }
        }
        if (this.getActionHelper().getProtocolForm().isJavaScriptEnabled()) {
            // empty if block
        }
    }

    @Override
    public Printable getCorrespondence() {
        IacucProtocolActionsCorrespondence correspondence = new IacucProtocolActionsCorrespondence("200");
        return correspondence;
    }
}

