/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.copy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.copy.IacucProtocolCopyService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyCustomData;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupDetailBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.kra.iacuc.protocol.IacucProtocolNumberService;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.IacucProtocolSpeciesService;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.iacuc.species.exception.IacucProtocolExceptionService;
import org.kuali.kra.iacuc.threers.IacucAlternateSearch;
import org.kuali.kra.iacuc.threers.IacucPrinciples;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.copy.ProtocolCopyServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucProtocolCopyServiceImpl
extends ProtocolCopyServiceImplBase<IacucProtocolDocument>
implements IacucProtocolCopyService {
    private IacucProtocolSpeciesService iacucProtocolSpeciesService;
    private IacucProtocolExceptionService iacucProtocolExceptionService;
    private IacucProtocolProcedureService iacucProtocolProcedureService;

    @Override
    public void copyIacucProtocolModules(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.copyIacucProtocolLists(srcProtocol, destProtocol);
    }

    @Override
    protected Class<? extends ProtocolActionBase> getProtocolActionBOClassHook() {
        return IacucProtocolAction.class;
    }

    @Override
    protected String getProtocolActionProtocolCreatedCodeHook() {
        return "100";
    }

    @Override
    protected String getSequenceNumberNameHook() {
        return "SEQ_IACUC_PROTOCOL_ID";
    }

    @Override
    protected void copyRequiredProperties(IacucProtocolDocument srcDoc, IacucProtocolDocument destDoc) {
        super.copyRequiredProperties(srcDoc, destDoc);
        destDoc.getIacucProtocol().setLayStatement1(srcDoc.getIacucProtocol().getLayStatement1());
        destDoc.getIacucProtocol().setLayStatement2(srcDoc.getIacucProtocol().getLayStatement2());
        destDoc.getIacucProtocol().setProtocolProjectTypeCode(srcDoc.getIacucProtocol().getProtocolProjectTypeCode());
        destDoc.getIacucProtocol().setOverviewTimeline(srcDoc.getIacucProtocol().getOverviewTimeline());
        destDoc.getIacucProtocol().setSpeciesStudyGroupIndicator(srcDoc.getIacucProtocol().getSpeciesStudyGroupIndicator());
        destDoc.getIacucProtocol().setAlternativeSearchIndicator(srcDoc.getIacucProtocol().getAlternativeSearchIndicator());
        destDoc.getIacucProtocol().setScientificJustifIndicator(srcDoc.getIacucProtocol().getScientificJustifIndicator());
    }

    @Override
    protected void copyProtocolLists(IacucProtocolDocument srcDoc, IacucProtocolDocument destDoc) {
        super.copyProtocolLists(srcDoc, destDoc);
        IacucProtocol srcProtocol = srcDoc.getIacucProtocol();
        IacucProtocol destProtocol = destDoc.getIacucProtocol();
        this.copyIacucProtocolLists(srcProtocol, destProtocol);
    }

    protected void copyIacucProtocolLists(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.addThreeRs(srcProtocol, destProtocol);
        this.addProtocolSpecies(srcProtocol, destProtocol);
        this.addProtocolExceptions(srcProtocol, destProtocol);
        this.addProtocolProcedures(srcProtocol, destProtocol);
        destProtocol.setIacucProtocolCustomDataList((List)this.deepCopy(srcProtocol.getIacucProtocolCustomDataList()));
    }

    protected void addThreeRs(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        IacucPrinciples newIacucPrinciple = (IacucPrinciples)this.deepCopy(srcProtocol.getIacucPrinciples().get(0));
        newIacucPrinciple.setIacucPrinciplesId(null);
        destProtocol.getIacucPrinciples().clear();
        destProtocol.getIacucPrinciples().add(newIacucPrinciple);
        List newIacucAlternateSearches = (List)this.deepCopy(srcProtocol.getIacucAlternateSearches());
        for (IacucAlternateSearch iacucAlternateSearch : newIacucAlternateSearches) {
            iacucAlternateSearch.setIacucAltSearchId(null);
        }
        destProtocol.setIacucAlternateSearches(newIacucAlternateSearches);
    }

    @Override
    public void copyProtocolThreers(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.addThreeRs(srcProtocol, destProtocol);
    }

    @Override
    public void copyProtocolSpeciesAndGroups(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.addProtocolSpecies(srcProtocol, destProtocol);
    }

    @Override
    public void copyProtocolProcedures(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.addProtocolProcedures(srcProtocol, destProtocol);
    }

    @Override
    public void copyProtocolExceptions(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        this.addProtocolExceptions(srcProtocol, destProtocol);
    }

    protected void addProtocolSpecies(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        List<IacucProtocolSpecies> sourceProtocolSpecies = srcProtocol.getIacucProtocolSpeciesList();
        destProtocol.setIacucProtocolSpeciesList(new ArrayList<IacucProtocolSpecies>());
        for (IacucProtocolSpecies protocolSpecies : sourceProtocolSpecies) {
            destProtocol.getIacucProtocolSpeciesList().add(this.getNewProtocolSpecies(protocolSpecies, destProtocol));
        }
    }

    private IacucProtocolSpecies getNewProtocolSpecies(IacucProtocolSpecies srcProtocolSpecies, IacucProtocol destProtocol) {
        IacucProtocolSpecies newProtocolSpecies = (IacucProtocolSpecies)this.deepCopy(srcProtocolSpecies);
        newProtocolSpecies = this.getIacucProtocolSpeciesService().getNewProtocolSpecies(destProtocol, newProtocolSpecies);
        newProtocolSpecies.setOldProtocolSpeciesId(srcProtocolSpecies.getIacucProtocolSpeciesId());
        return newProtocolSpecies;
    }

    private void mergeProtocolProcedureSpecies(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        for (IacucProtocolStudyGroupBean studyGroupBean : destProtocol.getIacucProtocolStudyGroups()) {
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : studyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                for (IacucProtocolStudyGroup studyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    this.setNewProtocolSpeciesForStudyGroup(studyGroup, destProtocol.getIacucProtocolSpeciesList());
                }
            }
        }
    }

    private void setNewProtocolSpeciesForStudyGroup(IacucProtocolStudyGroup studyGroup, List<IacucProtocolSpecies> newIacucProtocolSpeciesList) {
        String destUniqueSpeciesKey = this.getUniqueSpecies(studyGroup.getIacucProtocolSpecies());
        IacucProtocolSpecies newProtocolSpecies = this.getNewProtocolSpeciesIdBasedOnUniqueKey(newIacucProtocolSpeciesList, destUniqueSpeciesKey);
        Integer newProtocolSpeciesId = newProtocolSpecies.getIacucProtocolSpeciesId();
        studyGroup.setIacucProtocolSpeciesId(newProtocolSpeciesId);
        studyGroup.setIacucProtocolSpecies(newProtocolSpecies);
    }

    private IacucProtocolSpecies getNewProtocolSpeciesIdBasedOnUniqueKey(List<IacucProtocolSpecies> newIacucProtocolSpeciesList, String uniqueSpeciesKey) {
        IacucProtocolSpecies newProtocolSpecies = null;
        for (IacucProtocolSpecies protocolSpecies : newIacucProtocolSpeciesList) {
            String destUniqueSpecies = this.getUniqueSpecies(protocolSpecies);
            if (!destUniqueSpecies.equals(uniqueSpeciesKey)) continue;
            newProtocolSpecies = protocolSpecies;
            break;
        }
        return newProtocolSpecies;
    }

    @Override
    public void mergeProtocolSpeciesAndGroups(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        HashMap<String, IacucProtocolSpecies> currentProtocolSpeciesList = this.getSpeciesMapWithUniqueKey(destProtocol.getIacucProtocolSpeciesList());
        HashMap<String, IacucProtocolSpecies> amendedProtocolSpeciesList = this.getSpeciesMapWithUniqueKey(srcProtocol.getIacucProtocolSpeciesList());
        ArrayList<IacucProtocolSpecies> deletedProtocolSpeciesList = new ArrayList<IacucProtocolSpecies>();
        for (IacucProtocolSpecies currentProtocolSpecies : destProtocol.getIacucProtocolSpeciesList()) {
            String speciesKey = this.getUniqueSpecies(currentProtocolSpecies);
            IacucProtocolSpecies amendedProtocolSpecies = amendedProtocolSpeciesList.get(speciesKey);
            if (ObjectUtils.isNotNull((Object)amendedProtocolSpecies)) {
                this.mergeProtocolSpecies(amendedProtocolSpecies, currentProtocolSpecies);
                continue;
            }
            deletedProtocolSpeciesList.add(currentProtocolSpecies);
        }
        this.verifyAndAddNewProtocolSpecies(destProtocol, currentProtocolSpeciesList, amendedProtocolSpeciesList);
        destProtocol.getIacucProtocolSpeciesList().removeAll(deletedProtocolSpeciesList);
        this.mergeProtocolProcedureSpecies(srcProtocol, destProtocol);
    }

    private void verifyAndAddNewProtocolSpecies(IacucProtocol destProtocol, HashMap<String, IacucProtocolSpecies> currentProtocolSpeciesList, HashMap<String, IacucProtocolSpecies> amendedProtocolSpeciesList) {
        for (Map.Entry<String, IacucProtocolSpecies> entry : amendedProtocolSpeciesList.entrySet()) {
            String speciesKey = entry.getKey();
            IacucProtocolSpecies amendedProtocolSpecies = entry.getValue();
            IacucProtocolSpecies currentProtocolSpecies = currentProtocolSpeciesList.get(speciesKey);
            if (!ObjectUtils.isNull((Object)currentProtocolSpecies)) continue;
            IacucProtocolSpecies newProtocolSpecies = this.getNewProtocolSpecies(amendedProtocolSpecies, destProtocol);
            destProtocol.getIacucProtocolSpeciesList().add(newProtocolSpecies);
        }
    }

    private HashMap<String, IacucProtocolSpecies> getSpeciesMapWithUniqueKey(List<IacucProtocolSpecies> protocolSpeciesList) {
        HashMap<String, IacucProtocolSpecies> speciesMap = new HashMap<String, IacucProtocolSpecies>();
        for (IacucProtocolSpecies iacucProtocolSpecies : protocolSpeciesList) {
            String uniqueSpeciesKey = this.getUniqueSpecies(iacucProtocolSpecies);
            speciesMap.put(uniqueSpeciesKey, iacucProtocolSpecies);
        }
        return speciesMap;
    }

    protected void mergeProtocolSpecies(IacucProtocolSpecies srcProtocolSpecies, IacucProtocolSpecies dstProtocolSpecies) {
        dstProtocolSpecies.setUsdaCovered(srcProtocolSpecies.getUsdaCovered());
        dstProtocolSpecies.setStrain(srcProtocolSpecies.getStrain());
        dstProtocolSpecies.setSpeciesCount(srcProtocolSpecies.getSpeciesCount());
        dstProtocolSpecies.setPainCategoryCode(srcProtocolSpecies.getPainCategoryCode());
        dstProtocolSpecies.setSpeciesCountCode(srcProtocolSpecies.getSpeciesCountCode());
        dstProtocolSpecies.setExceptionsPresent(srcProtocolSpecies.getExceptionsPresent());
        dstProtocolSpecies.setProcedureSummary(srcProtocolSpecies.getProcedureSummary());
    }

    private String getUniqueSpecies(IacucProtocolSpecies protocolSpecies) {
        return protocolSpecies.getSpeciesCode().toString().concat(protocolSpecies.getSpeciesGroup());
    }

    protected HashMap<Integer, Integer> getNewProtocolSpeciesMap(IacucProtocol protocol) {
        return this.getIacucProtocolSpeciesService().getNewProtocolSpeciesMap(protocol);
    }

    protected void addProtocolExceptions(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        destProtocol.setIacucProtocolExceptions(new ArrayList<IacucProtocolException>());
        List<IacucProtocolException> sourceProtocolExceptions = srcProtocol.getIacucProtocolExceptions();
        for (IacucProtocolException protocolException : sourceProtocolExceptions) {
            IacucProtocolException newProtocolException = (IacucProtocolException)this.deepCopy(protocolException);
            newProtocolException = this.getIacucProtocolExceptionService().getNewProtocolException(destProtocol, newProtocolException);
            destProtocol.getIacucProtocolExceptions().add(newProtocolException);
        }
    }

    @Override
    public void mergeProtocolProcedures(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        destProtocol.setIacucProtocolStudyGroups((List)this.deepCopy(srcProtocol.getIacucProtocolStudyGroups()));
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : destProtocol.getIacucProtocolStudyGroups()) {
            iacucProtocolStudyGroupBean.setIacucProtocolStudyGroupHeaderId(null);
            iacucProtocolStudyGroupBean.setProtocolId(destProtocol.getProtocolId());
            iacucProtocolStudyGroupBean.setProtocolNumber(destProtocol.getProtocolNumber());
            iacucProtocolStudyGroupBean.setSequenceNumber(destProtocol.getSequenceNumber());
            for (IacucProtocolStudyGroupDetailBean iacucProtocolStudyGroupDetailBean : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                iacucProtocolStudyGroupDetailBean.setIacucProtocolStudyGroupDetailId(null);
                iacucProtocolStudyGroupDetailBean.setIacucProtocolStudyGroupHeaderId(null);
                for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    iacucProtocolStudyGroup.setIacucProtocolStudyGroupId(null);
                    iacucProtocolStudyGroup.setIacucProtocolStudyGroupDetailId(null);
                    this.setNewProtocolSpeciesForStudyGroup(iacucProtocolStudyGroup, destProtocol.getIacucProtocolSpeciesList());
                    for (IacucProcedurePersonResponsible iacucProcedurePersonResponsible : iacucProtocolStudyGroup.getIacucProcedurePersonsResponsible()) {
                        iacucProcedurePersonResponsible.setIacucProcedurePersonResponsibleId(null);
                        iacucProcedurePersonResponsible.setIacucProtocolStudyGroupId(null);
                    }
                    for (IacucProtocolStudyGroupLocation iacucProtocolStudyGroupLocation : iacucProtocolStudyGroup.getIacucProtocolStudyGroupLocations()) {
                        iacucProtocolStudyGroupLocation.setIacucProtocolStudyGroupLocationId(null);
                        iacucProtocolStudyGroupLocation.setIacucProtocolStudyGroupId(null);
                        iacucProtocolStudyGroupLocation.setProtocolId(destProtocol.getProtocolId());
                        iacucProtocolStudyGroupLocation.setProtocolNumber(destProtocol.getProtocolNumber());
                        iacucProtocolStudyGroupLocation.setSequenceNumber(destProtocol.getSequenceNumber());
                    }
                    for (IacucProtocolStudyCustomData iacucProtocolStudyCustomData : iacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList()) {
                        iacucProtocolStudyCustomData.setIacucProtocolStudyCustomDataId(null);
                        iacucProtocolStudyCustomData.setIacucProtocolStudyGroupId(null);
                        iacucProtocolStudyCustomData.setProtocolId(destProtocol.getProtocolId());
                        iacucProtocolStudyCustomData.setProtocolNumber(destProtocol.getProtocolNumber());
                        iacucProtocolStudyCustomData.setSequenceNumber(destProtocol.getSequenceNumber());
                    }
                }
            }
        }
    }

    protected void addProtocolProcedures(IacucProtocol srcProtocol, IacucProtocol destProtocol) {
        destProtocol.setIacucProtocolStudyGroupBeans(new ArrayList<IacucProtocolStudyGroupBean>());
        destProtocol.setIacucProtocolStudyGroups(new ArrayList<IacucProtocolStudyGroupBean>());
        HashMap<Integer, Integer> newSpeciesIdMapping = this.getNewProtocolSpeciesMap(destProtocol);
        List<IacucProtocolStudyGroupBean> sourceProtocolProcedures = srcProtocol.getIacucProtocolStudyGroups();
        this.getIacucProtocolProcedureService().createNewStudyGroups(destProtocol, sourceProtocolProcedures, newSpeciesIdMapping);
    }

    @Override
    protected IacucProtocolNumberService getProtocolNumberServiceHook() {
        return (IacucProtocolNumberService)KraServiceLocator.getService("iacucProtocolNumberService");
    }

    @Override
    protected IacucProtocolAction getProtocolActionNewInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String protocolActionTypeCode) {
        return new IacucProtocolAction((IacucProtocol)protocol, (IacucProtocolSubmission)protocolSubmission, protocolActionTypeCode);
    }

    @Override
    protected String getProtocolAggregatorHook() {
        return "IACUC Protocol Aggregator";
    }

    @Override
    protected String getProtocolApproverHook() {
        return "IACUC ProtocolApprover";
    }

    @Override
    protected String getProtocolRoleTypeHook() {
        return "KC-IACUC";
    }

    public IacucProtocolSpeciesService getIacucProtocolSpeciesService() {
        return this.iacucProtocolSpeciesService;
    }

    public void setIacucProtocolSpeciesService(IacucProtocolSpeciesService iacucProtocolSpeciesService) {
        this.iacucProtocolSpeciesService = iacucProtocolSpeciesService;
    }

    public IacucProtocolExceptionService getIacucProtocolExceptionService() {
        return this.iacucProtocolExceptionService;
    }

    public void setIacucProtocolExceptionService(IacucProtocolExceptionService iacucProtocolExceptionService) {
        this.iacucProtocolExceptionService = iacucProtocolExceptionService;
    }

    public IacucProtocolProcedureService getIacucProtocolProcedureService() {
        return this.iacucProtocolProcedureService;
    }

    public void setIacucProtocolProcedureService(IacucProtocolProcedureService iacucProtocolProcedureService) {
        this.iacucProtocolProcedureService = iacucProtocolProcedureService;
    }
}

