/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.decision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.common.committee.bo.CommitteeDecisionMotionType;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.meeting.ProtocolVoteAbstaineeBase;
import org.kuali.kra.common.committee.meeting.ProtocolVoteRecusedBase;
import org.kuali.kra.iacuc.actions.IacucActionHelper;
import org.kuali.kra.iacuc.actions.IacucProtocolActionBean;
import org.kuali.kra.iacuc.actions.decision.IacucCommitteePerson;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsBean;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.committee.meeting.IacucProtocolVoteAbstainee;
import org.kuali.kra.iacuc.committee.meeting.IacucProtocolVoteRecused;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.actions.decision.CommitteeDecision;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewAttachmentsBeanBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsBeanBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IacucCommitteeDecision
extends IacucProtocolActionBean
implements CommitteeDecision<IacucCommitteePerson> {
    private static final long serialVersionUID = -8052093280852074307L;
    private String motionTypeCode;
    private Integer noCount;
    private Integer yesCount;
    private Integer abstainCount;
    private Integer recusedCount;
    private String votingComments;
    private CommitteeDecisionMotionType motionType;
    private IacucCommitteePerson newAbstainer = new IacucCommitteePerson();
    private IacucCommitteePerson newRecused = new IacucCommitteePerson();
    private List<IacucCommitteePerson> abstainers = new ArrayList<IacucCommitteePerson>();
    private List<IacucCommitteePerson> recused = new ArrayList<IacucCommitteePerson>();
    private List<IacucCommitteePerson> abstainersToDelete = new ArrayList<IacucCommitteePerson>();
    private List<IacucCommitteePerson> recusedToDelete = new ArrayList<IacucCommitteePerson>();
    private IacucReviewCommentsBean reviewCommentsBean = new IacucReviewCommentsBean("actionHelper.committeeDecision");

    public IacucCommitteeDecision(IacucActionHelper actionHelper) {
        super(actionHelper);
    }

    @Override
    public void init() {
        IacucProtocolSubmission submission = (IacucProtocolSubmission)this.getProtocol().getProtocolSubmission();
        if (submission != null) {
            this.motionTypeCode = submission.getCommitteeDecisionMotionTypeCode();
            this.noCount = submission.getNoVoteCount();
            this.yesCount = submission.getYesVoteCount();
            this.abstainCount = submission.getAbstainerCount();
            this.recusedCount = submission.getRecusedCount();
            this.votingComments = submission.getVotingComments();
            this.setMotionType(submission.getCommitteeDecisionMotionType());
            if (submission.getScheduleIdFk() != null) {
                this.initializeAbstainees(submission);
                this.initializeRecused(submission);
            }
        }
    }

    @Override
    public Integer getRecusedCount() {
        return this.getRecused().size();
    }

    @Override
    public void setRecusedCount(Integer recusedCount) {
        this.recusedCount = recusedCount;
    }

    private Map<String, Long> getLookUpFields(Long protocolId, Long submissionIdFk) {
        HashMap<String, Long> lookUpFields = new HashMap<String, Long>();
        lookUpFields.put("protocolIdFk", protocolId);
        lookUpFields.put("submissionIdFk", submissionIdFk);
        return lookUpFields;
    }

    private List<CommitteeMembershipBase> getCommitteeMemberships() {
        String committeeId = this.getProtocol().getProtocolSubmission().getCommittee().getCommitteeId();
        String scheduleId = this.getProtocol().getProtocolSubmission().getScheduleId();
        List<CommitteeMembershipBase> committeeMemberships = KraServiceLocator.getService(IacucCommitteeService.class).getAvailableMembers(committeeId, scheduleId);
        return committeeMemberships;
    }

    private void initializeAbstainees(IacucProtocolSubmission submission) {
        Map<String, Long> absenteeLookFields = this.getLookUpFields(this.getProtocol().getProtocolId(), submission.getSubmissionId());
        Collection protocolVoteAbstainees = KraServiceLocator.getService(BusinessObjectService.class).findMatching(IacucProtocolVoteAbstainee.class, absenteeLookFields);
        List<CommitteeMembershipBase> committeeMemberships = this.getCommitteeMemberships();
        block0: for (ProtocolVoteAbstaineeBase abstainee : protocolVoteAbstainees) {
            for (CommitteeMembershipBase membership : committeeMemberships) {
                if (!abstainee.isProtocolReviewerFromCommitteeMembership(membership)) continue;
                IacucCommitteePerson person = new IacucCommitteePerson();
                person.setMembershipId(membership.getCommitteeMembershipId());
                this.abstainers.add(person);
                continue block0;
            }
        }
    }

    private void initializeRecused(IacucProtocolSubmission submission) {
        Map<String, Long> absenteeLookFields = this.getLookUpFields(this.getProtocol().getProtocolId(), submission.getSubmissionId());
        Collection protocolVoteRecused = KraServiceLocator.getService(BusinessObjectService.class).findMatching(IacucProtocolVoteRecused.class, absenteeLookFields);
        List<CommitteeMembershipBase> committeeMemberships = this.getCommitteeMemberships();
        block0: for (ProtocolVoteRecusedBase recusee : protocolVoteRecused) {
            for (CommitteeMembershipBase membership : committeeMemberships) {
                if (!recusee.isProtocolReviewerFromCommitteeMembership(membership)) continue;
                IacucCommitteePerson person = new IacucCommitteePerson();
                person.setMembershipId(membership.getCommitteeMembershipId());
                this.recused.add(person);
                continue block0;
            }
        }
    }

    @Override
    public String getMotionTypeCode() {
        return this.motionTypeCode;
    }

    @Override
    public void setMotionTypeCode(String commDecisionMotionTypeCode) {
        this.motionTypeCode = commDecisionMotionTypeCode;
    }

    @Override
    public Integer getNoCount() {
        return this.noCount;
    }

    @Override
    public void setNoCount(Integer noCount) {
        this.noCount = noCount;
    }

    @Override
    public Integer getYesCount() {
        return this.yesCount;
    }

    @Override
    public void setYesCount(Integer yesCount) {
        this.yesCount = yesCount;
    }

    @Override
    public Integer getAbstainCount() {
        return this.getAbstainers().size();
    }

    @Override
    public void setAbstainCount(Integer abstainCount) {
        this.abstainCount = abstainCount;
    }

    @Override
    public String getVotingComments() {
        return this.votingComments;
    }

    @Override
    public void setVotingComments(String votingComments) {
        this.votingComments = votingComments;
    }

    @Override
    public CommitteeDecisionMotionType getMotionType() {
        return this.motionType;
    }

    @Override
    public void setMotionType(CommitteeDecisionMotionType motionType) {
        this.motionType = motionType;
    }

    @Override
    public List<IacucCommitteePerson> getAbstainers() {
        return this.abstainers;
    }

    @Override
    public void setAbstainers(List<IacucCommitteePerson> abstainers) {
        this.abstainers = abstainers;
    }

    @Override
    public List<IacucCommitteePerson> getAbstainersToDelete() {
        return this.abstainersToDelete;
    }

    @Override
    public List<IacucCommitteePerson> getRecused() {
        return this.recused;
    }

    @Override
    public void setRecused(List<IacucCommitteePerson> recused) {
        this.recused = recused;
    }

    @Override
    public List<IacucCommitteePerson> getRecusedToDelete() {
        return this.recusedToDelete;
    }

    @Override
    public IacucCommitteePerson getNewAbstainer() {
        return this.newAbstainer;
    }

    @Override
    public void setNewAbstainer(IacucCommitteePerson newAbstainer) {
        this.newAbstainer = newAbstainer;
    }

    @Override
    public IacucCommitteePerson getNewRecused() {
        return this.newRecused;
    }

    @Override
    public void setNewRecused(IacucCommitteePerson newRecused) {
        this.newRecused = newRecused;
    }

    @Override
    public int getTotalVoteCount() {
        return (this.getYesCount() != null ? this.getYesCount() : 0) + (this.getNoCount() != null ? this.getNoCount() : 0) + (this.getAbstainCount() != null ? this.getAbstainCount() : 0) + (this.getRecusedCount() != null ? this.getRecusedCount() : 0);
    }

    @Override
    public IacucReviewCommentsBean getReviewCommentsBean() {
        return this.reviewCommentsBean;
    }

    @Override
    public void setReviewCommentsBean(ReviewCommentsBeanBase reviewCommentsBean) {
        this.reviewCommentsBean = (IacucReviewCommentsBean)reviewCommentsBean;
    }

    @Override
    public ReviewAttachmentsBeanBase getReviewAttachmentsBean() {
        return null;
    }

    @Override
    public int getYesCountValue() {
        return this.getYesCount() != null ? this.getYesCount() : 0;
    }

    @Override
    public int getNoCountValue() {
        return this.getNoCount() != null ? this.getNoCount() : 0;
    }
}

